/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.NodeMonitor;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeMonitorFactory {
    private static final Log logger = LogFactory.getLog(NodeMonitorFactory.class);
    private PolicyComponent m_policyComponent;
    private NodeService m_nodeService;
    private FileFolderService m_fileFolderService;
    private PermissionService m_permissionService;
    private TransactionService m_transService;

    public NodeMonitor createNodeMonitor(final ContentContext filesysCtx) {
        RetryingTransactionHelper tran = this.m_transService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<NodeMonitor> initialiseCB = new RetryingTransactionHelper.RetryingTransactionCallback<NodeMonitor>(){

            @Override
            public NodeMonitor execute() throws Throwable {
                NodeMonitor nodeMonitor = new NodeMonitor(filesysCtx, NodeMonitorFactory.this.m_nodeService, NodeMonitorFactory.this.m_policyComponent, NodeMonitorFactory.this.m_fileFolderService, NodeMonitorFactory.this.m_permissionService, NodeMonitorFactory.this.m_transService);
                return nodeMonitor;
            }
        };
        return tran.doInTransaction(initialiseCB, true);
    }

    public void setNodeService(NodeService nodeService) {
        this.m_nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.m_permissionService = permissionService;
    }

    public void setFileFolderService(FileFolderService fileService) {
        this.m_fileFolderService = fileService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.m_policyComponent = policyComponent;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.m_transService = transactionService;
    }
}

