/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.Scenario;
import org.alfresco.filesys.repo.rules.ScenarioCreateShuffleInstance;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.operations.CreateFileOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioCreateShuffle
implements Scenario {
    private static Log logger = LogFactory.getLog(ScenarioCreateShuffle.class);
    private Pattern pattern;
    private String strPattern;
    private long timeout = 30000L;
    private ScenarioInstance.Ranking ranking = ScenarioInstance.Ranking.HIGH;

    @Override
    public ScenarioInstance createInstance(List<ScenarioInstance> currentInstances, Operation operation) {
        CreateFileOperation c;
        Matcher m;
        if (operation instanceof CreateFileOperation && (m = this.pattern.matcher((c = (CreateFileOperation)operation).getName())).matches()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("New Scenario Create Shuffle Instance pattern:" + this.strPattern));
            }
            ScenarioCreateShuffleInstance instance = new ScenarioCreateShuffleInstance();
            instance.setTimeout(this.timeout);
            instance.setRanking(this.ranking);
            return instance;
        }
        return null;
    }

    public void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern, 2);
        this.strPattern = pattern;
    }

    public String getPattern() {
        return this.strPattern;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }
}

