/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.commands.CompoundCommand;
import org.alfresco.filesys.repo.rules.commands.CopyContentCommand;
import org.alfresco.filesys.repo.rules.commands.RenameFileCommand;
import org.alfresco.filesys.repo.rules.operations.CreateFileOperation;
import org.alfresco.filesys.repo.rules.operations.DeleteFileOperation;
import org.alfresco.filesys.repo.rules.operations.RenameFileOperation;
import org.alfresco.jlan.server.filesys.FileName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScenarioCreateShuffleInstance
implements ScenarioInstance {
    private static Log logger = LogFactory.getLog(ScenarioCreateShuffleInstance.class);
    InternalState internalState = InternalState.NONE;
    private Date startTime = new Date();
    private String createName;
    private String move1;
    private String move2;
    private ScenarioInstance.Ranking ranking;
    private long timeout = 30000L;
    private boolean isComplete;
    private Map<String, String> renames = new HashMap<String, String>();

    public Command evaluate(Operation operation) {
        Date now = new Date();
        if (now.getTime() > this.startTime.getTime() + this.getTimeout() && logger.isDebugEnabled()) {
            logger.debug((Object)"Instance timed out");
        }
        switch (this.internalState) {
            case NONE: {
                if (operation instanceof CreateFileOperation) {
                    CreateFileOperation c = (CreateFileOperation)operation;
                    this.createName = c.getName();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("entering RENAME state: " + this.createName));
                    }
                    this.internalState = InternalState.RENAME;
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"State error, expected a CREATE");
                }
                this.isComplete = true;
                break;
            }
            case RENAME: {
                String end;
                if (!(operation instanceof RenameFileOperation)) break;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Tracking rename: " + operation));
                }
                RenameFileOperation r = (RenameFileOperation)operation;
                this.renames.put(r.getFrom(), r.getTo());
                String middle = this.renames.get(this.createName);
                if (middle == null) break;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Got second rename");
                }
                if ((end = this.renames.get(middle)) == null) break;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Got two renames ");
                }
                this.move1 = middle;
                this.move2 = end;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"entering DELETE state");
                }
                this.internalState = InternalState.DELETE;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Go and shuffle! createName:" + this.createName + " move1 " + this.move1 + " move2 " + this.move2));
                }
                String[] paths = FileName.splitPath((String)r.getFromPath());
                String oldFolder = paths[0];
                ArrayList<Command> commands = new ArrayList<Command>();
                RenameFileCommand r1 = new RenameFileCommand(end, middle, r.getRootNodeRef(), oldFolder + "\\" + end, oldFolder + "\\" + middle);
                CopyContentCommand copyContent = new CopyContentCommand(this.createName, this.move1, r.getRootNodeRef(), oldFolder + "\\" + this.createName, oldFolder + "\\" + middle);
                RenameFileCommand r2 = new RenameFileCommand(this.createName, end, r.getRootNodeRef(), oldFolder + "\\" + this.createName, oldFolder + "\\" + end);
                commands.add(r1);
                commands.add(copyContent);
                commands.add(r2);
                return new CompoundCommand(commands);
            }
            case DELETE: {
                DeleteFileOperation d;
                if (!(operation instanceof DeleteFileOperation) || !(d = (DeleteFileOperation)operation).getName().equals(this.move2)) break;
                logger.debug((Object)"Scenario complete");
                this.isComplete = true;
            }
        }
        return null;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    public String toString() {
        return "ScenarioShuffleInstance:" + this.createName;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InternalState {
        NONE,
        RENAME,
        DELETE;

    }
}

