/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.ArrayList;
import java.util.Date;
import org.alfresco.filesys.repo.OpenFileMode;
import org.alfresco.filesys.repo.ResultCallback;
import org.alfresco.filesys.repo.TempNetworkFile;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.commands.CloseFileCommand;
import org.alfresco.filesys.repo.rules.commands.CompoundCommand;
import org.alfresco.filesys.repo.rules.commands.CreateFileCommand;
import org.alfresco.filesys.repo.rules.commands.DoNothingCommand;
import org.alfresco.filesys.repo.rules.commands.OpenFileCommand;
import org.alfresco.filesys.repo.rules.commands.ReduceQuotaCommand;
import org.alfresco.filesys.repo.rules.commands.RemoveTempFileCommand;
import org.alfresco.filesys.repo.rules.commands.ReturnValueCommand;
import org.alfresco.filesys.repo.rules.operations.CloseFileOperation;
import org.alfresco.filesys.repo.rules.operations.CreateFileOperation;
import org.alfresco.filesys.repo.rules.operations.DeleteFileOperation;
import org.alfresco.filesys.repo.rules.operations.OpenFileOperation;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ScenarioOpenFileInstance
implements ScenarioInstance {
    private static Log logger = LogFactory.getLog(ScenarioOpenFileInstance.class);
    private Date startTime = new Date();
    private String name;
    InternalState state = InternalState.NONE;
    private NetworkFile fileHandleReadOnly;
    private int openReadOnlyCount = 0;
    private NetworkFile fileHandleReadWrite;
    private int openReadWriteCount = 0;
    private long timeout = 30000L;
    private boolean isComplete = false;
    private ScenarioInstance.Ranking ranking = ScenarioInstance.Ranking.HIGH;

    ScenarioOpenFileInstance() {
    }

    public Command evaluate(Operation operation) {
        if (operation instanceof DeleteFileOperation) {
            DeleteFileOperation d = (DeleteFileOperation)operation;
            if (d.getName() == null) {
                return null;
            }
            if (this.name.equalsIgnoreCase(d.getName())) {
                logger.debug((Object)("Anti-Pattern - delete of the open file, scenario:" + this));
                this.isComplete = true;
                return null;
            }
        }
        switch (this.state) {
            case NONE: {
                OpenFileOperation o;
                Operation c;
                if (operation instanceof CreateFileOperation) {
                    c = (CreateFileOperation)operation;
                    this.name = ((CreateFileOperation)c).getName();
                    if (this.name != null) {
                        ArrayList<Command> commands = new ArrayList<Command>();
                        ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                        commands.add(new CreateFileCommand(((CreateFileOperation)c).getName(), ((CreateFileOperation)c).getRootNodeRef(), ((CreateFileOperation)c).getPath(), ((CreateFileOperation)c).getAllocationSize()));
                        postCommitCommands.add(this.newOpenFileCallbackCommand());
                        return new CompoundCommand(commands, postCommitCommands);
                    }
                } else if (operation instanceof OpenFileOperation) {
                    o = (OpenFileOperation)operation;
                    this.name = o.getName();
                    if (this.name != null) {
                        ArrayList<Command> commands = new ArrayList<Command>();
                        commands.add(new OpenFileCommand(o.getName(), o.getMode(), o.isTruncate(), o.getRootNodeRef(), o.getPath()));
                        ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                        postCommitCommands.add(this.newOpenFileCallbackCommand());
                        return new CompoundCommand(commands, postCommitCommands);
                    }
                }
                this.isComplete = true;
                return null;
            }
            case OPEN: {
                Operation c;
                if (operation instanceof CloseFileOperation) {
                    c = (CloseFileOperation)operation;
                    if (((CloseFileOperation)c).getName() == null) {
                        return null;
                    }
                    if (!this.name.equalsIgnoreCase(((CloseFileOperation)c).getName())) break;
                    NetworkFile file = ((CloseFileOperation)c).getNetworkFile();
                    if (this.isReadOnly(file)) {
                        if (this.openReadOnlyCount == 1) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Close of last read only file handle:" + this));
                            }
                            this.openReadOnlyCount = 0;
                            if (this.openReadWriteCount <= 0) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Scenario is complete:" + this));
                                }
                                this.isComplete = true;
                            }
                            if (file instanceof TempNetworkFile) {
                                logger.debug((Object)"this is the last close of a temp read only file");
                                ArrayList<Command> commands = new ArrayList<Command>();
                                ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                                commands.add(new CloseFileCommand(((CloseFileOperation)c).getName(), file, ((CloseFileOperation)c).getRootNodeRef(), ((CloseFileOperation)c).getPath()));
                                postCommitCommands.add(new RemoveTempFileCommand((TempNetworkFile)file));
                                return new CompoundCommand(commands, postCommitCommands);
                            }
                            return new CloseFileCommand(((CloseFileOperation)c).getName(), file, ((CloseFileOperation)c).getRootNodeRef(), ((CloseFileOperation)c).getPath());
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Only decrement count of read only file handle:" + this));
                        }
                        --this.openReadOnlyCount;
                        return new DoNothingCommand();
                    }
                    if (this.openReadWriteCount == 1) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Close of last read write file handle:" + this));
                        }
                        this.openReadWriteCount = 0;
                        if (this.openReadOnlyCount <= 0) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Scenario is complete:" + this));
                            }
                            this.isComplete = true;
                        }
                        ArrayList<Command> commands = new ArrayList<Command>();
                        ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                        ArrayList<Command> postErrorCommands = new ArrayList<Command>();
                        commands.add(new CloseFileCommand(((CloseFileOperation)c).getName(), file, ((CloseFileOperation)c).getRootNodeRef(), ((CloseFileOperation)c).getPath()));
                        if (((CloseFileOperation)c).isDeleteOnClose()) {
                            postCommitCommands.add(new ReduceQuotaCommand(((CloseFileOperation)c).getName(), file, ((CloseFileOperation)c).getRootNodeRef(), ((CloseFileOperation)c).getPath()));
                        }
                        if (file instanceof TempNetworkFile) {
                            postCommitCommands.add(new RemoveTempFileCommand((TempNetworkFile)file));
                        }
                        return new CompoundCommand(commands, postCommitCommands, postErrorCommands);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Only decrement count of read write file handle:" + this));
                    }
                    --this.openReadWriteCount;
                    return new DoNothingCommand();
                }
                if (!(operation instanceof OpenFileOperation)) break;
                OpenFileOperation o = (OpenFileOperation)operation;
                if (o.getName() == null) {
                    return null;
                }
                if (this.name == null || !this.name.equalsIgnoreCase(o.getName())) break;
                if (o.getMode() == OpenFileMode.READ_WRITE) {
                    if (this.openReadWriteCount == 0) {
                        logger.debug((Object)("Open first read/write from scenario:" + this));
                        ArrayList<Command> commands = new ArrayList<Command>();
                        commands.add(new OpenFileCommand(o.getName(), o.getMode(), o.isTruncate(), o.getRootNodeRef(), o.getPath()));
                        ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                        postCommitCommands.add(this.newOpenFileCallbackCommand());
                        return new CompoundCommand(commands, postCommitCommands);
                    }
                    ++this.openReadWriteCount;
                    logger.debug((Object)("Return already open read/write file handle from scenario:" + this));
                    return new ReturnValueCommand(this.fileHandleReadWrite);
                }
                if (this.openReadOnlyCount == 0) {
                    logger.debug((Object)("Open first read only from scenario:" + this));
                    ArrayList<Command> commands = new ArrayList<Command>();
                    commands.add(new OpenFileCommand(o.getName(), o.getMode(), o.isTruncate(), o.getRootNodeRef(), o.getPath()));
                    ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                    postCommitCommands.add(this.newOpenFileCallbackCommand());
                    return new CompoundCommand(commands, postCommitCommands);
                }
                ++this.openReadOnlyCount;
                logger.debug((Object)("Return already open only file handle from scenario:" + this));
                return new ReturnValueCommand(this.fileHandleReadOnly);
            }
        }
        return null;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public String toString() {
        return "ScenarioOpenFileInstance name:" + this.name;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    public String getName() {
        return this.name;
    }

    private ResultCallback newOpenFileCallbackCommand() {
        return new ResultCallback(){

            public void execute(Object result) {
                if (result instanceof NetworkFile) {
                    NetworkFile fileHandle = (NetworkFile)result;
                    ScenarioOpenFileInstance.this.state = InternalState.OPEN;
                    if (ScenarioOpenFileInstance.this.isReadOnly(fileHandle)) {
                        ScenarioOpenFileInstance.this.openReadOnlyCount++;
                        ScenarioOpenFileInstance.this.fileHandleReadOnly = fileHandle;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("file opened read only:" + result + ", name:" + ScenarioOpenFileInstance.this.name));
                        }
                    } else {
                        ScenarioOpenFileInstance.this.openReadWriteCount++;
                        ScenarioOpenFileInstance.this.fileHandleReadWrite = fileHandle;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("file opened read write :" + result + ", name:" + ScenarioOpenFileInstance.this.name));
                        }
                    }
                }
            }

            public AlfrescoTransactionSupport.TxnReadState getTransactionRequired() {
                return AlfrescoTransactionSupport.TxnReadState.TXN_NONE;
            }
        };
    }

    private boolean isReadOnly(NetworkFile file) {
        return file.getGrantedAccess() == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum InternalState {
        NONE,
        OPEN;

    }
}

