/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules.commands;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundCommand
implements Command {
    List<Command> commands;
    List<Command> postCommitCommands;
    List<Command> postErrorCommands;

    public CompoundCommand(List<Command> commands) {
        this.commands = new ArrayList<Command>(commands);
    }

    public CompoundCommand(List<Command> commands, List<Command> postCommitCommands) {
        this.commands = new ArrayList<Command>(commands);
        this.postCommitCommands = new ArrayList<Command>(postCommitCommands);
    }

    public CompoundCommand(List<Command> commands, List<Command> postCommitCommands, List<Command> postErrorCommands) {
        this.commands = new ArrayList<Command>(commands);
        this.postCommitCommands = new ArrayList<Command>(postCommitCommands);
        this.postErrorCommands = new ArrayList<Command>(postErrorCommands);
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public List<Command> getPostCommitCommands() {
        return this.postCommitCommands;
    }

    public List<Command> getPostErrorCommands() {
        return this.postErrorCommands;
    }

    @Override
    public AlfrescoTransactionSupport.TxnReadState getTransactionRequired() {
        AlfrescoTransactionSupport.TxnReadState readState = AlfrescoTransactionSupport.TxnReadState.TXN_NONE;
        for (Command command : this.commands) {
            AlfrescoTransactionSupport.TxnReadState x = command.getTransactionRequired();
            if (x == null || x.compareTo(readState) <= 0) continue;
            readState = x;
        }
        return readState;
    }
}

