/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jcr.repository;

import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.alfresco.jcr.test.BaseJCRTest;

public class RepositoryImplTest
extends BaseJCRTest {
    public void testDescriptors() {
        String[] keys = this.repository.getDescriptorKeys();
        RepositoryImplTest.assertEquals((int)11, (int)keys.length);
        for (String key : keys) {
            String value = this.repository.getDescriptor(key);
            RepositoryImplTest.assertNotNull((Object)value);
        }
        RepositoryImplTest.assertNotNull((Object)this.repository.getDescriptor("jcr.repository.name"));
        System.out.println(this.repository.getDescriptor("jcr.repository.name"));
        RepositoryImplTest.assertNotNull((Object)this.repository.getDescriptor("jcr.repository.vendor"));
        RepositoryImplTest.assertNotNull((Object)this.repository.getDescriptor("jcr.repository.vendor.url"));
        RepositoryImplTest.assertNotNull((Object)this.repository.getDescriptor("jcr.repository.version"));
        System.out.println(this.repository.getDescriptor("jcr.repository.version"));
        RepositoryImplTest.assertNotNull((Object)this.repository.getDescriptor("jcr.specification.name"));
        RepositoryImplTest.assertNotNull((Object)this.repository.getDescriptor("jcr.specification.version"));
        RepositoryImplTest.assertEquals((String)"true", (String)this.repository.getDescriptor("level.1.supported"));
        RepositoryImplTest.assertEquals((String)"true", (String)this.repository.getDescriptor("level.2.supported"));
        RepositoryImplTest.assertEquals((String)"true", (String)this.repository.getDescriptor("option.transactions.supported"));
        RepositoryImplTest.assertEquals((String)"true", (String)this.repository.getDescriptor("query.xpath.doc.order"));
        RepositoryImplTest.assertEquals((String)"true", (String)this.repository.getDescriptor("query.xpath.pos.index"));
    }

    public void testBadUsernameLogin() throws Exception {
        SimpleCredentials badUser = new SimpleCredentials("baduser", "".toCharArray());
        try {
            this.repository.login((Credentials)badUser);
            RepositoryImplTest.fail((String)"Failed to catch bad username - username should not exist.");
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }

    public void testBadPwdLogin() throws Exception {
        SimpleCredentials badPwd = new SimpleCredentials("superuser", "badpwd".toCharArray());
        try {
            this.repository.login((Credentials)badPwd);
            RepositoryImplTest.fail((String)"Failed to catch bad password - password is invalid.");
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }

    public void testNoCredentialsLogin() throws Exception {
        try {
            this.repository.login();
            RepositoryImplTest.fail((String)"Failed to catch no credentials.");
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }

    public void testLogin() throws RepositoryException {
        Session session;
        SimpleCredentials good = new SimpleCredentials("superuser", "".toCharArray());
        try {
            session = this.repository.login((Credentials)good, this.getWorkspace());
            RepositoryImplTest.assertNotNull((Object)session);
            session.logout();
        }
        catch (LoginException e) {
            RepositoryImplTest.fail((String)"Failed to login.");
        }
        try {
            session = this.repository.login((Credentials)good, null);
            session.logout();
        }
        catch (NoSuchWorkspaceException e) {
            RepositoryImplTest.fail((String)"Failed to detect default workspace");
        }
    }
}

