/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.util.Date;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.opencmis.CMISConnector;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.opencmis.search.CMISQueryService;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.NamespaceDAOImpl;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public abstract class BaseCMISTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    protected CMISMapping cmisMapping;
    protected CMISConnector cmisConnector;
    protected CMISDictionaryService cmisDictionaryService;
    protected DictionaryService dictionaryService;
    protected TransactionService transactionService;
    protected AuthenticationComponent authenticationComponent;
    protected UserTransaction testTX;
    protected NodeService nodeService;
    protected NodeRef rootNodeRef;
    protected FileFolderService fileFolderService;
    protected ServiceRegistry serviceRegistry;
    protected NamespaceService namespaceService;
    protected CMISQueryService cmisQueryService;
    private MutableAuthenticationService authenticationService;
    private MutableAuthenticationDao authenticationDAO;
    protected SearchService searchService;
    protected ContentService contentService;
    protected PermissionService permissionService;
    protected ThumbnailService thumbnailService;
    protected ModelDAO permissionModelDao;
    protected DictionaryDAO dictionaryDAO;
    protected NamespaceDAOImpl namespaceDao;
    protected VersionService versionService;
    protected FullTextSearchIndexer luceneFTS;

    public void setUp() throws Exception {
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.cmisDictionaryService = (CMISDictionaryService)ctx.getBean("OpenCMISDictionaryService");
        this.cmisMapping = (CMISMapping)ctx.getBean("OpenCMISMapping");
        this.cmisQueryService = (CMISQueryService)ctx.getBean("OpenCMISQueryService");
        this.cmisConnector = (CMISConnector)ctx.getBean("CMISConnector");
        this.dictionaryService = (DictionaryService)ctx.getBean("dictionaryService");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.fileFolderService = (FileFolderService)ctx.getBean("fileFolderService");
        this.namespaceService = (NamespaceService)ctx.getBean("namespaceService");
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.searchService = (SearchService)ctx.getBean("searchService");
        this.contentService = (ContentService)ctx.getBean("contentService");
        this.permissionService = (PermissionService)ctx.getBean("permissionService");
        this.versionService = (VersionService)ctx.getBean("versionService");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("authenticationService");
        this.authenticationDAO = (MutableAuthenticationDao)ctx.getBean("authenticationDao");
        this.thumbnailService = (ThumbnailService)ctx.getBean("thumbnailService");
        this.permissionModelDao = (ModelDAO)ctx.getBean("permissionsModelDAO");
        this.dictionaryDAO = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        this.namespaceDao = (NamespaceDAOImpl)ctx.getBean("namespaceDAO");
        this.luceneFTS = (FullTextSearchIndexer)ctx.getBean("LuceneFullTextSearchIndexer");
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        String storeName = "CMISTest-" + this.getStoreName() + "-" + new Date().getTime();
        StoreRef storeRef = this.nodeService.createStore("workspace", storeName);
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        if (this.authenticationDAO.userExists("cmis")) {
            this.authenticationService.deleteAuthentication("cmis");
        }
        this.authenticationService.createAuthentication("cmis", "cmis".toCharArray());
    }

    private String getStoreName() {
        String testName = this.getName();
        testName = testName.replace("_", "-");
        testName = testName.replace("%", "-");
        return testName;
    }

    protected void runAs(String userName) {
        this.authenticationService.authenticate(userName, userName.toCharArray());
        BaseCMISTest.assertNotNull((Object)this.authenticationService.getCurrentUserName());
    }

    protected void tearDown() throws Exception {
        if (this.testTX.getStatus() == 0) {
            this.testTX.rollback();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }
}

