/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.opencmis.AlfrescoCmisServiceFactory;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.springframework.context.ApplicationContext;

public class OpenCmisLocalTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();

    private Repository getRepository(String user, String password) {
        SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.user", "admin");
        parameters.put("org.apache.chemistry.opencmis.password", "admin");
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.LOCAL.value());
        parameters.put("org.apache.chemistry.opencmis.binding.local.classname", "org.alfresco.opencmis.OpenCmisLocalTest$TestCmisServiceFactory");
        List repositories = sessionFactory.getRepositories(parameters);
        return repositories.size() > 0 ? (Repository)repositories.get(0) : null;
    }

    public void setUp() throws Exception {
    }

    public void testVoid() {
    }

    public void DISABLED_testSetUp() throws Exception {
        Repository repository = this.getRepository("admin", "admin");
        OpenCmisLocalTest.assertNotNull((String)"No repository available for testing", (Object)repository);
    }

    public void DISABLED_testBasicFileOps() {
        Repository repository = this.getRepository("admin", "admin");
        Session session = repository.createSession();
        Folder rootFolder = session.getRootFolder();
        HashMap<String, String> folderProps = new HashMap<String, String>();
        folderProps.put("cmis:objectTypeId", "cmis:folder");
        folderProps.put("cmis:name", this.getName() + "-" + GUID.generate());
        Folder folder = rootFolder.createFolder(folderProps, null, null, null, session.getDefaultContext());
        HashMap<String, String> fileProps = new HashMap<String, String>();
        fileProps.put("cmis:objectTypeId", "cmis:document");
        fileProps.put("cmis:name", "mydoc-" + GUID.generate() + ".txt");
        ContentStreamImpl fileContent = new ContentStreamImpl();
        FileContentWriter writer = new FileContentWriter(TempFileProvider.createTempFile((String)this.getName(), (String)".txt"));
        writer.putContent("Ipsum and so on");
        ContentReader reader = writer.getReader();
        fileContent.setMimeType("text/plain");
        fileContent.setStream(reader.getContentInputStream());
        folder.createDocument(fileProps, (ContentStream)fileContent, VersioningState.MAJOR);
    }

    static /* synthetic */ ApplicationContext access$000() {
        return ctx;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestCmisServiceFactory
    implements CmisServiceFactory {
        private static AlfrescoCmisServiceFactory serviceFactory = (AlfrescoCmisServiceFactory)((Object)OpenCmisLocalTest.access$000().getBean("CMISServiceFactory"));

        public void init(Map<String, String> parameters) {
        }

        public void destroy() {
        }

        public CmisService getService(CallContext context) {
            return serviceFactory.getService(context);
        }
    }
}

