/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis;

import java.io.IOException;
import java.io.InputStream;

public class RangeInputStream
extends InputStream {
    private InputStream inputStream;
    private long bytesRead;
    private long length;

    public RangeInputStream(InputStream inputStream, long offset, long length) throws IOException {
        this.inputStream = inputStream;
        this.length = length;
        this.bytesRead = 0L;
        long l = this.inputStream.skip(offset);
        if (l < offset) {
            this.inputStream.skip(offset);
        }
    }

    public int read() throws IOException {
        if (this.bytesRead < this.length) {
            ++this.bytesRead;
            return this.inputStream.read();
        }
        return -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if ((long)len > this.length - this.bytesRead) {
            len = (int)(this.length - this.bytesRead);
        }
        int readed = this.inputStream.read(b, off, len);
        this.bytesRead += (long)readed;
        return readed;
    }

    public int available() throws IOException {
        return (int)(this.length - this.bytesRead + 1L);
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public long skip(long n) throws IOException {
        if (this.bytesRead + n > this.length) {
            n = this.length - n > 0L ? this.length - n : this.length - this.bytesRead;
        }
        n = this.inputStream.skip(n);
        this.bytesRead += n;
        return n;
    }
}

