/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.search;

import java.util.LinkedHashMap;
import java.util.Map;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.search.CMISQueryOptions;
import org.alfresco.opencmis.search.CMISResultSetColumn;
import org.alfresco.opencmis.search.CMISResultSetSelector;
import org.alfresco.repo.search.impl.querymodel.Column;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.repo.search.impl.querymodel.Selector;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetType;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.QName;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;

public class CMISResultSetMetaData
implements ResultSetMetaData {
    private CMISQueryOptions options;
    private SearchParameters searchParams;
    private LimitBy limitBy;
    private Map<String, CMISResultSetColumn> columnMetaData;
    private Map<String, CMISResultSetSelector> selectorMetaData;

    public CMISResultSetMetaData(CMISQueryOptions options, Query query, LimitBy limitBy, CMISDictionaryService cmisDictionaryService, DictionaryService alfrescoDictionaryService) {
        this.options = options;
        this.searchParams = new SearchParameters((QueryOptions)options);
        this.limitBy = limitBy;
        Map selectors = query.getSource().getSelectors();
        this.selectorMetaData = new LinkedHashMap<String, CMISResultSetSelector>();
        for (Selector selector : selectors.values()) {
            TypeDefinitionWrapper type = cmisDictionaryService.findTypeForClass(selector.getType(), new BaseTypeId[0]);
            CMISResultSetSelector smd = new CMISResultSetSelector(selector.getAlias(), type);
            this.selectorMetaData.put(smd.getName(), smd);
        }
        this.columnMetaData = new LinkedHashMap<String, CMISResultSetColumn>();
        for (Column column : query.getColumns()) {
            PropertyDefinitionWrapper propertyDefinition = null;
            PropertyType type = null;
            QName alfrescoPropertyQName = null;
            QName alfrescoDataTypeQName = null;
            if (column.getFunction().getName().equals("PropertyAccessor")) {
                PropertyArgument arg = (PropertyArgument)column.getFunctionArguments().get("Property");
                String propertyName = arg.getPropertyName();
                alfrescoPropertyQName = QName.createQName((String)propertyName);
                PropertyDefinition alfPropDef = alfrescoDictionaryService.getProperty(alfrescoPropertyQName);
                if (alfPropDef == null) {
                    alfrescoPropertyQName = null;
                } else {
                    alfrescoDataTypeQName = alfPropDef.getDataType().getName();
                }
                propertyDefinition = cmisDictionaryService.findProperty(propertyName);
                type = propertyDefinition.getPropertyDefinition().getPropertyType();
            }
            if (type == null) {
                type = cmisDictionaryService.findDataType(column.getFunction().getReturnType());
            }
            if (alfrescoDataTypeQName == null) {
                alfrescoDataTypeQName = cmisDictionaryService.findAlfrescoDataType(type);
            }
            CMISResultSetColumn cmd = new CMISResultSetColumn(column.getAlias(), propertyDefinition, type, alfrescoPropertyQName, alfrescoDataTypeQName);
            this.columnMetaData.put(cmd.getName(), cmd);
        }
    }

    public String[] getColumnNames() {
        return this.columnMetaData.keySet().toArray(new String[0]);
    }

    public CMISResultSetColumn[] getColumns() {
        return this.columnMetaData.values().toArray(new CMISResultSetColumn[0]);
    }

    public CMISResultSetColumn getColumn(String name) {
        return this.columnMetaData.get(name);
    }

    public CMISQueryOptions getQueryOptions() {
        return this.options;
    }

    public CMISResultSetSelector getSelector(String name) {
        return this.selectorMetaData.get(name);
    }

    public String[] getSelectorNames() {
        return this.selectorMetaData.keySet().toArray(new String[0]);
    }

    public CMISResultSetSelector[] getSelectors() {
        return this.selectorMetaData.values().toArray(new CMISResultSetSelector[0]);
    }

    public LimitBy getLimitedBy() {
        return this.limitBy;
    }

    public PermissionEvaluationMode getPermissionEvaluationMode() {
        throw new UnsupportedOperationException();
    }

    public ResultSetType getResultSetType() {
        return ResultSetType.COLUMN_AND_NODE_REF;
    }

    public SearchParameters getSearchParameters() {
        return this.searchParams;
    }
}

