/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.evaluator;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionConditionImpl;
import org.alfresco.repo.action.evaluator.ComparePropertyValueEvaluator;
import org.alfresco.repo.action.evaluator.compare.ComparePropertyValueOperation;
import org.alfresco.repo.action.evaluator.compare.ContentPropertyName;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.service.cmr.action.ActionConditionDefinition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionServiceException;
import org.alfresco.service.cmr.action.ParameterConstraint;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;

public class ComparePropertyValueEvaluatorTest
extends BaseSpringTest {
    private static final String TEST_TYPE_NAMESPACE = "testNamespace";
    private static final QName TEST_TYPE_QNAME = QName.createQName((String)"testNamespace", (String)"testType");
    private static final QName PROP_TEXT = QName.createQName((String)"testNamespace", (String)"propText");
    private static final QName PROP_INT = QName.createQName((String)"testNamespace", (String)"propInt");
    private static final QName PROP_DATETIME = QName.createQName((String)"testNamespace", (String)"propDatetime");
    private static final QName PROP_NODEREF = QName.createQName((String)"testNamespace", (String)"propNodeRef");
    private static final String TEXT_VALUE = "myDocument.doc";
    private static final int INT_VALUE = 100;
    private Date beforeDateValue;
    private Date dateValue;
    private Date afterDateValue;
    private NodeRef nodeValue;
    private DictionaryDAO dictionaryDAO;
    private NodeService nodeService;
    private ContentService contentService;
    private ActionService actionService;
    private StoreRef testStoreRef;
    private NodeRef rootNodeRef;
    private NodeRef nodeRef;
    private ComparePropertyValueEvaluator evaluator;

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    protected void onSetUpInTransaction() throws Exception {
        this.createTestModel();
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.testStoreRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.nodeValue = this.rootNodeRef = this.nodeService.getRootNode(this.testStoreRef);
        this.beforeDateValue = new Date();
        Thread.sleep(2000L);
        this.dateValue = new Date();
        Thread.sleep(2000L);
        this.afterDateValue = new Date();
        HashMap<QName, Object> props = new HashMap<QName, Object>();
        props.put(PROP_TEXT, TEXT_VALUE);
        props.put(PROP_INT, 100);
        props.put(PROP_DATETIME, this.dateValue);
        props.put(PROP_NODEREF, this.nodeValue);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testnode"), TEST_TYPE_QNAME, props).getChildRef();
        this.evaluator = (ComparePropertyValueEvaluator)this.applicationContext.getBean("compare-property-value");
    }

    public void testCheckParamDefintionWithConstraint() {
        ActionConditionDefinition def = this.evaluator.getActionConditionDefintion();
        ComparePropertyValueEvaluatorTest.assertEquals((String)"compare-property-value", (String)def.getName());
        ParameterDefinition paramDef = def.getParameterDefintion("operation");
        ComparePropertyValueEvaluatorTest.assertNotNull((Object)paramDef);
        ComparePropertyValueEvaluatorTest.assertEquals((String)"operation", (String)paramDef.getName());
        String constraintName = paramDef.getParameterConstraintName();
        ComparePropertyValueEvaluatorTest.assertNotNull((Object)constraintName);
        ParameterConstraint paramConstraint = this.actionService.getParameterConstraint(constraintName);
        ComparePropertyValueEvaluatorTest.assertNotNull((Object)paramConstraint);
        ComparePropertyValueEvaluatorTest.assertEquals((String)"ac-compare-operations", (String)paramConstraint.getName());
    }

    public void testNumericComparison() {
        ActionConditionImpl condition = new ActionConditionImpl(GUID.generate(), "compare-property-value");
        condition.setParameterValue("property", (Serializable)PROP_INT);
        condition.setParameterValue("value", Integer.valueOf(100));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", Integer.valueOf(101));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.EQUALS.toString()));
        condition.setParameterValue("value", Integer.valueOf(100));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", Integer.valueOf(101));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.GREATER_THAN.toString()));
        condition.setParameterValue("value", Integer.valueOf(99));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", Integer.valueOf(101));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.GREATER_THAN_EQUAL.toString()));
        condition.setParameterValue("value", Integer.valueOf(99));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", Integer.valueOf(100));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", Integer.valueOf(101));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.LESS_THAN.toString()));
        condition.setParameterValue("value", Integer.valueOf(101));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", Integer.valueOf(99));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.LESS_THAN_EQUAL.toString()));
        condition.setParameterValue("value", Integer.valueOf(101));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", Integer.valueOf(100));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", Integer.valueOf(99));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.BEGINS.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException exception) {
            exception.printStackTrace();
        }
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.ENDS.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException exception) {
            // empty catch block
        }
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.CONTAINS.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException actionServiceException) {
            // empty catch block
        }
    }

    public void testDateComparison() {
        ActionConditionImpl condition = new ActionConditionImpl(GUID.generate(), "compare-property-value");
        condition.setParameterValue("property", (Serializable)PROP_DATETIME);
        condition.setParameterValue("value", this.dateValue);
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", new Date());
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.EQUALS.toString()));
        condition.setParameterValue("value", this.dateValue);
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", new Date());
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.GREATER_THAN.toString()));
        condition.setParameterValue("value", this.beforeDateValue);
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", this.afterDateValue);
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.GREATER_THAN_EQUAL.toString()));
        condition.setParameterValue("value", this.beforeDateValue);
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", this.dateValue);
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", this.afterDateValue);
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.LESS_THAN.toString()));
        condition.setParameterValue("value", this.afterDateValue);
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", this.beforeDateValue);
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.LESS_THAN_EQUAL.toString()));
        condition.setParameterValue("value", this.afterDateValue);
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", this.dateValue);
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", this.beforeDateValue);
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.BEGINS.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException exception) {
            exception.printStackTrace();
        }
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.ENDS.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException exception) {
            // empty catch block
        }
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.CONTAINS.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException actionServiceException) {
            // empty catch block
        }
    }

    public void testTextComparison() {
        ActionConditionImpl condition = new ActionConditionImpl(GUID.generate(), "compare-property-value");
        condition.setParameterValue("property", (Serializable)PROP_TEXT);
        condition.setParameterValue("value", (Serializable)((Object)"*.doc"));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", (Serializable)((Object)"*.xls"));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", (Serializable)((Object)"my*"));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", (Serializable)((Object)"bad*"));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", (Serializable)((Object)"Document"));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", (Serializable)((Object)"bobbins"));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.EQUALS.toString()));
        condition.setParameterValue("value", (Serializable)((Object)TEXT_VALUE));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", (Serializable)((Object)"bobbins"));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.CONTAINS.toString()));
        condition.setParameterValue("value", (Serializable)((Object)"Document"));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", (Serializable)((Object)"bobbins"));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.BEGINS.toString()));
        condition.setParameterValue("value", (Serializable)((Object)"my"));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", (Serializable)((Object)"bobbins"));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.ENDS.toString()));
        condition.setParameterValue("value", (Serializable)((Object)"doc"));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", (Serializable)((Object)"bobbins"));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.GREATER_THAN.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException exception) {
            exception.printStackTrace();
        }
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.GREATER_THAN_EQUAL.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException exception) {
            // empty catch block
        }
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.LESS_THAN.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException exception) {
            // empty catch block
        }
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.LESS_THAN_EQUAL.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException actionServiceException) {
            // empty catch block
        }
    }

    public void testTempFileNames() {
        ActionConditionImpl condition = new ActionConditionImpl(GUID.generate(), "compare-property-value");
        condition.setParameterValue("property", (Serializable)PROP_TEXT);
        condition.setParameterValue("value", (Serializable)((Object)"~*.doc"));
        this.nodeService.setProperty(this.nodeRef, PROP_TEXT, (Serializable)((Object)"~1234.doc"));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
    }

    public void testOtherComparison() {
        NodeRef badNodeRef = new NodeRef(this.testStoreRef, "badId");
        ActionConditionImpl condition = new ActionConditionImpl(GUID.generate(), "compare-property-value");
        condition.setParameterValue("property", (Serializable)PROP_NODEREF);
        condition.setParameterValue("value", (Serializable)this.nodeValue);
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", (Serializable)badNodeRef);
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", (Serializable)((Object)"this isn't even the correct type!"));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.EQUALS.toString()));
        condition.setParameterValue("value", (Serializable)this.nodeValue);
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", (Serializable)badNodeRef);
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.BEGINS.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException exception) {
            exception.printStackTrace();
        }
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.ENDS.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException exception) {
            // empty catch block
        }
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.CONTAINS.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException exception) {
            // empty catch block
        }
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.GREATER_THAN.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException exception) {
            // empty catch block
        }
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.GREATER_THAN_EQUAL.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException exception) {
            // empty catch block
        }
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.LESS_THAN.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException exception) {
            // empty catch block
        }
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.LESS_THAN_EQUAL.toString()));
        try {
            this.evaluator.evaluate(condition, this.nodeRef);
            ComparePropertyValueEvaluatorTest.fail((String)"An exception should have been raised here.");
        }
        catch (ActionServiceException actionServiceException) {
            // empty catch block
        }
    }

    public void testContentPropertyComparisons() {
        ActionConditionImpl condition = new ActionConditionImpl(GUID.generate(), "compare-property-value");
        condition.setParameterValue("property", (Serializable)ContentModel.PROP_CONTENT);
        ContentWriter contentWriter = this.contentService.getWriter(this.nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype("text/plain");
        contentWriter.putContent("This is some test content.");
        condition.setParameterValue("content-property", (Serializable)((Object)ContentPropertyName.MIME_TYPE.toString()));
        condition.setParameterValue("value", (Serializable)((Object)"text/plain"));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", (Serializable)((Object)"text/html"));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("content-property", (Serializable)((Object)ContentPropertyName.ENCODING.toString()));
        condition.setParameterValue("value", (Serializable)((Object)"UTF-8"));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", (Serializable)((Object)"UTF-16"));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("content-property", (Serializable)((Object)ContentPropertyName.SIZE.toString()));
        condition.setParameterValue("operation", (Serializable)((Object)ComparePropertyValueOperation.LESS_THAN.toString()));
        condition.setParameterValue("value", Integer.valueOf(50));
        ComparePropertyValueEvaluatorTest.assertTrue((boolean)this.evaluator.evaluate(condition, this.nodeRef));
        condition.setParameterValue("value", Integer.valueOf(2));
        ComparePropertyValueEvaluatorTest.assertFalse((boolean)this.evaluator.evaluate(condition, this.nodeRef));
    }

    private void createTestModel() {
        M2Model model = M2Model.createModel((String)"test:comparepropertyvalueevaluatortest");
        model.createNamespace(TEST_TYPE_NAMESPACE, "test");
        model.createImport("http://www.alfresco.org/model/dictionary/1.0", "d");
        model.createImport("http://www.alfresco.org/model/system/1.0", "sys");
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        M2Type testType = model.createType("test:" + TEST_TYPE_QNAME.getLocalName());
        testType.setParentName("cm:" + ContentModel.TYPE_CONTENT.getLocalName());
        M2Property prop1 = testType.createProperty("test:" + PROP_TEXT.getLocalName());
        prop1.setMandatory(false);
        prop1.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop1.setMultiValued(false);
        M2Property prop2 = testType.createProperty("test:" + PROP_INT.getLocalName());
        prop2.setMandatory(false);
        prop2.setType("d:" + DataTypeDefinition.INT.getLocalName());
        prop2.setMultiValued(false);
        M2Property prop3 = testType.createProperty("test:" + PROP_DATETIME.getLocalName());
        prop3.setMandatory(false);
        prop3.setType("d:" + DataTypeDefinition.DATETIME.getLocalName());
        prop3.setMultiValued(false);
        M2Property prop4 = testType.createProperty("test:" + PROP_NODEREF.getLocalName());
        prop4.setMandatory(false);
        prop4.setType("d:" + DataTypeDefinition.NODE_REF.getLocalName());
        prop4.setMultiValued(false);
        this.dictionaryDAO.putModel(model);
    }
}

