/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.FeedGenerator;
import org.alfresco.repo.activities.feed.local.LocalFeedTaskProcessor;
import org.alfresco.repo.activities.post.lookup.PostLookup;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.activities.FeedControl;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SiteActivityTest
extends TestCase {
    private static Log logger = LogFactory.getLog(SiteActivityTest.class);
    private static final String[] CONFIG_LOCATIONS = new String[]{"classpath:alfresco/application-context.xml"};
    private static ApplicationContext applicationContext = new ClassPathXmlApplicationContext(CONFIG_LOCATIONS);
    private SiteService siteService;
    private ActivityService activityService;
    private MutableAuthenticationService authenticationService;
    private PersonService personService;
    private PostLookup postLookup;
    private FeedGenerator feedGenerator;
    private static final String TEST_TEMPLATES_LOCATION = "activities";
    private static final String ADMIN_USER = "admin";
    private static final String ADMIN_PW = "admin";
    private static String user1 = null;
    private static String user2 = null;
    private static String user3 = null;
    private static String user4 = null;
    private static final String USER_PW = "password";
    private static String site1 = null;
    private static String site2 = null;
    private static String site3 = null;
    private static String appToolId = "siteService";
    private static boolean membersAddedUpdated = false;
    private static boolean membersRemoved = false;
    private static boolean controlsCreated = false;

    protected void setUp() throws Exception {
        super.setUp();
        String testid = "" + System.currentTimeMillis();
        Scheduler scheduler = (Scheduler)applicationContext.getBean("schedulerFactory");
        scheduler.shutdown();
        this.activityService = (ActivityService)applicationContext.getBean("activityService");
        this.siteService = (SiteService)applicationContext.getBean("SiteService");
        this.authenticationService = (MutableAuthenticationService)applicationContext.getBean("AuthenticationService");
        this.personService = (PersonService)applicationContext.getBean("PersonService");
        LocalFeedTaskProcessor feedProcessor = null;
        ChildApplicationContextFactory activitiesFeed = (ChildApplicationContextFactory)applicationContext.getBean("ActivitiesFeed");
        ApplicationContext activitiesFeedCtx = activitiesFeed.getApplicationContext();
        this.postLookup = (PostLookup)activitiesFeedCtx.getBean("postLookup");
        this.feedGenerator = (FeedGenerator)activitiesFeedCtx.getBean("feedGenerator");
        feedProcessor = (LocalFeedTaskProcessor)activitiesFeedCtx.getBean("feedTaskProcessor");
        ArrayList<String> templateSearchPaths = new ArrayList<String>(1);
        templateSearchPaths.add(TEST_TEMPLATES_LOCATION);
        feedProcessor.setTemplateSearchPaths(templateSearchPaths);
        feedProcessor.setUseRemoteCallbacks(false);
        site1 = "test_site1_" + testid;
        site2 = "test_site2_" + testid;
        site3 = "test_site3_" + testid;
        user1 = "test_user1_" + testid;
        user2 = "test_user2_" + testid;
        user3 = "test_user3_" + testid;
        user4 = "test_user4_" + testid;
        this.login("admin", "admin");
        this.createUser(user1, USER_PW);
        this.createUser(user2, USER_PW);
        this.createUser(user3, USER_PW);
        this.createUser(user4, USER_PW);
        this.createSite(site1, true);
        this.createSite(site2, false);
        this.createSite(site3, false);
    }

    protected void tearDown() throws Exception {
        this.login("admin", "admin");
        this.deleteUser(user1);
        this.deleteUser(user2);
        this.deleteUser(user3);
        this.deleteUser(user4);
        this.deleteSite(site1);
        this.deleteSite(site2);
        this.deleteSite(site3);
        membersAddedUpdated = false;
        membersRemoved = false;
        controlsCreated = false;
        super.tearDown();
    }

    protected void createSite(String siteId, boolean isPublic) throws Exception {
        this.siteService.createSite("myPreset", siteId, "myTitle", "myDescription", isPublic ? SiteVisibility.PUBLIC : SiteVisibility.PRIVATE);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("createdSite: " + siteId));
        }
    }

    protected void deleteSite(String siteId) throws Exception {
        this.siteService.deleteSite(siteId);
    }

    public void testGetSiteFeedsBefore() throws Exception {
        this.login("admin", "admin");
        this.getSiteFeed(site1, 0);
        this.getSiteFeed(site2, 0);
        this.getSiteFeed(site3, 0);
        this.login(user4, USER_PW);
        this.getSiteFeed(site1, 0);
        try {
            this.getSiteFeed(site2, 0);
            SiteActivityTest.fail((String)"Site feed for private site should not be accessible to non-admin / non-member");
        }
        catch (AccessDeniedException ade) {
            // empty catch block
        }
        try {
            this.getSiteFeed(site3, 0);
            SiteActivityTest.fail((String)"Site feed for private site should not be accessible to non-admin / non-member");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    protected void getSiteFeed(String siteId, int expectedCount) throws Exception {
        SiteActivityTest.assertEquals((int)expectedCount, (int)this.activityService.getSiteFeedEntries(siteId, "json").size());
    }

    public void testGetUserFeedsBefore() throws Exception {
        this.login("admin", "admin");
        this.getUserFeed(user1, true, 0);
        this.getUserFeed(user2, true, 0);
        this.getUserFeed(user3, true, 0);
        this.getUserFeed(user4, true, 0);
        this.login(user1, USER_PW);
        this.getUserFeed(user1, false, 0);
        this.login(user2, USER_PW);
        try {
            this.getUserFeed(user1, true, 0);
            SiteActivityTest.fail((String)"User feed should only be accessible to user or an admin");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        this.login(user1, USER_PW);
        this.getUserFeed(null, site1, false, false, false, 0);
        this.getUserFeed(null, site2, false, false, false, 0);
        this.getUserFeed(null, site3, false, false, false, 0);
        this.getUserFeed(null, null, false, true, false, 0);
        this.getUserFeed(null, null, false, false, true, 0);
        this.getUserFeed(null, null, false, true, true, 0);
    }

    protected void getUserFeed(String userId, boolean isAdmin, int expectedCount) throws Exception {
        this.getUserFeed(userId, null, isAdmin, false, false, expectedCount);
    }

    protected void getUserFeed(String userId, String siteId, boolean isAdmin, boolean excludeThisUser, boolean excludeOtherUsers, int expectedCount) throws Exception {
        if (userId == null) {
            userId = AuthenticationUtil.getFullyAuthenticatedUser();
        }
        SiteActivityTest.assertEquals((int)expectedCount, (int)this.activityService.getUserFeedEntries(userId, "json", siteId, excludeThisUser, excludeOtherUsers, null, null).size());
    }

    public void testUserFeedControls() throws Exception {
        if (!controlsCreated) {
            this.login(user1, USER_PW);
            this.addFeedControl(site1, null);
            this.login(user2, USER_PW);
            this.addFeedControl(null, appToolId);
            this.login(user3, USER_PW);
            this.addFeedControl(site1, appToolId);
            controlsCreated = true;
        }
    }

    public void testAddAndUpdateMemberships() throws Exception {
        if (!membersAddedUpdated) {
            this.login("admin", "admin");
            this.addAndUpdateMemberships(site1, true);
            this.addAndUpdateMemberships(site2, true);
            this.addAndUpdateMemberships(site3, false);
            this.generateFeed();
            membersAddedUpdated = true;
        }
    }

    public void testGetSiteFeedsAfterAddAndUpdateMemberships() throws Exception {
        this.testAddAndUpdateMemberships();
        this.login("admin", "admin");
        this.getSiteFeed(site1, 8);
        this.getSiteFeed(site2, 8);
        this.getSiteFeed(site3, 6);
        this.login(user4, USER_PW);
        this.getSiteFeed(site1, 8);
        this.getSiteFeed(site2, 8);
        try {
            this.getSiteFeed(site3, 0);
            SiteActivityTest.fail((String)"Site feed for private site should not be accessible to non-admin / non-member");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testRemoveMemberships() throws Exception {
        if (!membersRemoved) {
            this.testAddAndUpdateMemberships();
            this.login("admin", "admin");
            this.removeMemberships(site1, true);
            this.removeMemberships(site2, true);
            this.removeMemberships(site3, false);
            this.generateFeed();
            membersRemoved = true;
        }
    }

    protected void addAndUpdateMemberships(String siteId, boolean includeUser4) throws Exception {
        this.addMembership(siteId, user1, "SiteConsumer");
        this.addMembership(siteId, user2, "SiteManager");
        this.addMembership(siteId, user3, "SiteCollaborator");
        if (includeUser4) {
            this.addMembership(siteId, user4, "SiteConsumer");
        }
        this.updateMembership(siteId, user1, "SiteManager");
        this.updateMembership(siteId, user2, "SiteCollaborator");
        this.updateMembership(siteId, user3, "SiteConsumer");
        if (includeUser4) {
            this.updateMembership(siteId, user4, "SiteCollaborator");
        }
    }

    protected void removeMemberships(String siteId, boolean includeUser4) throws Exception {
        this.removeMembership(siteId, user1);
        this.removeMembership(siteId, user2);
        this.removeMembership(siteId, user3);
        if (includeUser4) {
            this.removeMembership(siteId, user4);
        }
    }

    private void addFeedControl(String siteId, String appToolId) throws Exception {
        this.activityService.setFeedControl(new FeedControl(siteId, appToolId));
    }

    public void testGetSiteFeedsAfterRemoveMemberships() throws Exception {
        this.testAddAndUpdateMemberships();
        this.testRemoveMemberships();
        this.login("admin", "admin");
        this.getSiteFeed(site1, 12);
        this.getSiteFeed(site2, 12);
        this.getSiteFeed(site3, 9);
        this.login(user4, USER_PW);
        this.getSiteFeed(site1, 12);
        try {
            this.getSiteFeed(site2, 0);
            SiteActivityTest.fail((String)"Site feed for private site should not be accessible to non-admin / non-member");
        }
        catch (AccessDeniedException ade) {
            // empty catch block
        }
        try {
            this.getSiteFeed(site3, 0);
            SiteActivityTest.fail((String)"Site feed for private site should not be accessible to non-admin / non-member");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testGetUserFeedsAfter() throws Exception {
        this.testUserFeedControls();
        this.testAddAndUpdateMemberships();
        this.testRemoveMemberships();
        this.login("admin", "admin");
        this.getUserFeed(user1, true, 14);
        this.getUserFeed(user2, true, 0);
        this.getUserFeed(user3, true, 14);
        this.getUserFeed(user4, true, 16);
        this.login(user1, USER_PW);
        this.getUserFeed(user1, false, 14);
        this.login(user2, USER_PW);
        try {
            this.getUserFeed(user1, true, 14);
            SiteActivityTest.fail((String)"User feed should only be accessible to user or an admin");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        this.login(user1, USER_PW);
        this.getUserFeed(null, site1, false, false, false, 0);
        this.getUserFeed(null, site2, false, false, false, 8);
        this.getUserFeed(null, site3, false, false, false, 6);
        this.getUserFeed(null, null, false, false, false, 14);
        this.getUserFeed(null, null, false, true, false, 14);
        this.getUserFeed(null, null, false, false, true, 0);
        this.getUserFeed(null, null, false, true, true, 0);
    }

    private void addMembership(String siteId, String userName, String role) throws Exception {
        this.updateMembership(siteId, userName, role);
    }

    private void updateMembership(String siteId, String userName, String role) throws Exception {
        this.siteService.setMembership(siteId, userName, role);
    }

    private void removeMembership(String siteId, String userName) throws Exception {
        this.siteService.removeMembership(siteId, userName);
    }

    protected void createUser(String userName, String password) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, password.toCharArray());
            PropertyMap ppOne = new PropertyMap(4);
            ppOne.put(ContentModel.PROP_USERNAME, userName);
            ppOne.put(ContentModel.PROP_FIRSTNAME, "firstName");
            ppOne.put(ContentModel.PROP_LASTNAME, "lastName");
            ppOne.put(ContentModel.PROP_EMAIL, "email@email.com");
            ppOne.put(ContentModel.PROP_JOBTITLE, "jobTitle");
            this.personService.createPerson(ppOne);
        }
    }

    protected void deleteUser(String userName) {
        this.personService.deletePerson(userName);
    }

    private void login(String username, String password) {
        AuthenticationUtil.setFullyAuthenticatedUser((String)username);
    }

    private void generateFeed() throws Exception {
        this.postLookup.execute();
        this.feedGenerator.execute();
    }
}

