/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed;

import org.alfresco.repo.activities.ActivityPostServiceImpl;
import org.alfresco.repo.activities.feed.FeedGenerator;
import org.alfresco.repo.activities.feed.RepoCtx;
import org.alfresco.repo.domain.activities.ActivityPostDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;

public abstract class AbstractFeedGenerator
implements FeedGenerator {
    private static Log logger = LogFactory.getLog(AbstractFeedGenerator.class);
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"ActivityFeedGenerator");
    private static final long LOCK_TTL = 30000L;
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener(AbstractFeedGenerator.class.getName());
    private int maxItemsPerCycle = 100;
    private ActivityPostDAO postDAO;
    private ActivityPostServiceImpl activityPostServiceImpl;
    private AuthenticationService authenticationService;
    private TransactionService transactionService;
    private JobLockService jobLockService;
    private String repoEndPoint;
    private boolean userNamesAreCaseSensitive = false;
    private RepoCtx ctx = null;
    private LockTracker lockTracker = new LockTracker();

    public void setActivityPostServiceImpl(ActivityPostServiceImpl activityPostServiceImpl) {
        this.activityPostServiceImpl = activityPostServiceImpl;
    }

    public void setPostDAO(ActivityPostDAO postDAO) {
        this.postDAO = postDAO;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setRepoEndPoint(String repoEndPoint) {
        this.repoEndPoint = repoEndPoint;
    }

    public void setUserNamesAreCaseSensitive(boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
    }

    public void setMaxItemsPerCycle(int maxItemsPerCycle) {
        this.maxItemsPerCycle = maxItemsPerCycle;
    }

    public int getMaxItemsPerCycle() {
        return this.maxItemsPerCycle;
    }

    public ActivityPostDAO getPostDaoService() {
        return this.postDAO;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public RepoCtx getWebScriptsCtx() {
        return this.ctx;
    }

    public void init() throws Exception {
        this.ctx = new RepoCtx(this.repoEndPoint);
        this.ctx.setUserNamesAreCaseSensitive(this.userNamesAreCaseSensitive);
    }

    private void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"postDAO", (Object)this.postDAO);
        this.activityPostServiceImpl.setEstimatedGridSize(this.getEstimatedGridSize());
    }

    public abstract int getEstimatedGridSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws JobExecutionException {
        block11: {
            this.checkProperties();
            if (!this.transactionService.getAllowWrite()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Activities feed generator not running due to read-only server");
                }
                return;
            }
            try {
                block10: {
                    try {
                        this.acquireLock();
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)"Activities feed generator started");
                        }
                        this.generate();
                        if (!logger.isTraceEnabled()) break block10;
                        logger.trace((Object)"Activities feed generator completed");
                    }
                    catch (LockAcquisitionException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Activities feed generator already underway");
                        }
                        Object var3_2 = null;
                        this.releaseLock();
                        break block11;
                    }
                    catch (Throwable e) {
                        if (!vmShutdownListener.isVmShuttingDown()) {
                            logger.error((Object)"Exception during generation of feeds", e);
                        }
                        Object var3_3 = null;
                        this.releaseLock();
                    }
                }
                Object var3_1 = null;
                this.releaseLock();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.releaseLock();
                throw throwable;
            }
        }
    }

    protected abstract boolean generate() throws Exception;

    private void acquireLock() throws LockAcquisitionException {
        String lockToken = this.jobLockService.getLock(LOCK_QNAME, 30000L);
        this.lockTracker.refreshLock(lockToken);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("lock aquired:  " + lockToken));
        }
    }

    private void releaseLock() {
        this.lockTracker.releaseLock();
    }

    private class LockTracker
    implements JobLockService.JobLockRefreshCallback {
        private String lockToken = null;

        private LockTracker() {
        }

        void refreshLock(String lockToken) {
            if (this.lockToken != null) {
                throw new IllegalStateException("lockToken is not null");
            }
            this.lockToken = lockToken;
            AbstractFeedGenerator.this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 30000L, this);
        }

        void releaseLock() {
            if (this.isActive()) {
                AbstractFeedGenerator.this.jobLockService.releaseLock(this.lockToken, LOCK_QNAME);
                this.lockToken = null;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Lock released: " + LOCK_QNAME + ", lock token " + this.lockToken));
                }
            }
        }

        public boolean isActive() {
            return this.lockToken != null;
        }

        public void lockReleased() {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Lock released (refresh failed): " + LOCK_QNAME + ", lock token " + this.lockToken));
            }
            this.lockToken = null;
        }
    }
}

