/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed.cleanup;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.activities.ActivityFeedDAO;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;

public class FeedCleaner
implements NodeServicePolicies.BeforeDeleteNodePolicy {
    private static Log logger = LogFactory.getLog(FeedCleaner.class);
    private static String KEY_DELETED_SITE_IDS = "feedCleaner.deletedSites";
    private static String KEY_DELETED_USER_IDS = "feedCleaner.deletedUsers";
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener(FeedCleaner.class.getName());
    private int maxAgeMins = 0;
    private int maxFeedSize = -1;
    private ActivityFeedDAO feedDAO;
    private SiteService siteService;
    private NodeService nodeService;
    private PolicyComponent policyComponent;
    private FeedCleanerDeleteSiteTransactionListener deleteSiteTransactionListener;
    private FeedCleanerDeletePersonTransactionListener deletePersonTransactionListener;

    public void setFeedDAO(ActivityFeedDAO feedDAO) {
        this.feedDAO = feedDAO;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setMaxAgeMins(int mins) {
        this.maxAgeMins = mins;
    }

    public void setMaxFeedSize(int size) {
        this.maxFeedSize = size;
    }

    public int getMaxFeedSize() {
        return this.maxFeedSize;
    }

    private void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"feedDAO", (Object)this.feedDAO);
        if (this.maxAgeMins <= 0 && this.maxFeedSize <= 0) {
            logger.warn((Object)"Neither maxAgeMins or maxFeedSize set - feeds will not be cleaned");
        }
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "beforeDeleteNodePerson"));
        this.deletePersonTransactionListener = new FeedCleanerDeletePersonTransactionListener();
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, SiteModel.TYPE_SITE, (Behaviour)new JavaBehaviour(this, "beforeDeleteNodeSite"));
        this.deleteSiteTransactionListener = new FeedCleanerDeleteSiteTransactionListener();
    }

    public int execute() throws JobExecutionException {
        int maxSizeDeletedCount;
        int maxAgeDeletedCount;
        block17: {
            this.checkProperties();
            maxAgeDeletedCount = 0;
            maxSizeDeletedCount = 0;
            try {
                if (this.maxAgeMins > 0) {
                    long nowTimeOffset = new Date().getTime();
                    long keepTimeOffset = nowTimeOffset - (long)this.maxAgeMins * 60000L;
                    Date keepDate = new Date(keepTimeOffset);
                    maxAgeDeletedCount = this.feedDAO.deleteFeedEntries(keepDate);
                    if (maxAgeDeletedCount > 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Cleaned " + maxAgeDeletedCount + " entries (upto " + keepDate + ", max age " + this.maxAgeMins + " mins)"));
                        }
                    } else if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Cleaned " + maxAgeDeletedCount + " entries (upto " + keepDate + ", max age " + this.maxAgeMins + " mins)"));
                    }
                }
                if (this.maxFeedSize > 0) {
                    List<ActivityFeedEntity> feeds = this.feedDAO.selectFeedsToClean(this.maxFeedSize);
                    int feedCount = 0;
                    for (ActivityFeedEntity feed : feeds) {
                        List<ActivityFeedEntity> feedToClean;
                        String siteId = feed.getSiteNetwork();
                        final String feedUserId = feed.getFeedUserId();
                        String format = feed.getActivitySummaryFormat();
                        int feedUserSiteCount = 0;
                        if (feedUserId == null || feedUserId.length() == 0) {
                            feedToClean = this.feedDAO.selectSiteFeedEntries(siteId, format, -1);
                        } else {
                            feedToClean = this.feedDAO.selectUserFeedEntries(feedUserId, format, null, false, false, -1L, -1);
                            if (this.siteService != null) {
                                feedUserSiteCount = (Integer)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Integer>(){

                                    public Integer doWork() throws Exception {
                                        return FeedCleaner.this.siteService.listSites(feedUserId).size();
                                    }
                                }, (String)"System");
                            }
                        }
                        if ((feedUserSiteCount != 0 || feedToClean.size() <= this.maxFeedSize) && feedToClean.size() <= this.maxFeedSize * feedUserSiteCount) continue;
                        Date oldestFeedEntry = feedToClean.get(this.maxFeedSize - 1).getPostDate();
                        int deletedCount = 0;
                        deletedCount = feedUserId == null || feedUserId.length() == 0 ? this.feedDAO.deleteSiteFeedEntries(siteId, format, oldestFeedEntry) : this.feedDAO.deleteUserFeedEntries(feedUserId, format, oldestFeedEntry);
                        if (deletedCount <= 0) continue;
                        maxSizeDeletedCount += deletedCount;
                        ++feedCount;
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)("Cleaned " + deletedCount + " entries for [" + feed.getSiteNetwork() + ", " + feed.getFeedUserId() + ", " + feed.getActivitySummaryFormat() + "] (upto " + oldestFeedEntry + ")"));
                    }
                    if (maxSizeDeletedCount > 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Cleaned " + maxSizeDeletedCount + " entries across " + feedCount + " feeds (max feed size " + this.maxFeedSize + " entries)"));
                        }
                    } else if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Cleaned " + maxSizeDeletedCount + " entries across " + feedCount + " feeds (max feed size " + this.maxFeedSize + " entries)"));
                    }
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Exception during cleanup of feeds", (Throwable)e);
                throw new JobExecutionException((Throwable)e);
            }
            catch (Throwable e) {
                if (vmShutdownListener.isVmShuttingDown()) break block17;
                logger.error((Object)"Exception during cleanup of feeds", e);
            }
        }
        return maxAgeDeletedCount + maxSizeDeletedCount;
    }

    public void beforeDeleteNode(NodeRef nodeRef) {
    }

    public void beforeDeleteNodePerson(NodeRef personNodeRef) {
        String userId = (String)((Object)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_USERNAME));
        Set deletedUserIds = (Set)AlfrescoTransactionSupport.getResource(KEY_DELETED_USER_IDS);
        if (deletedUserIds == null) {
            deletedUserIds = Collections.newSetFromMap(new ConcurrentHashMap());
            AlfrescoTransactionSupport.bindResource(KEY_DELETED_USER_IDS, deletedUserIds);
        }
        deletedUserIds.add(userId);
        AlfrescoTransactionSupport.bindListener(this.deletePersonTransactionListener);
    }

    public void beforeDeleteNodeSite(NodeRef siteNodeRef) {
        String siteId = (String)((Object)this.nodeService.getProperty(siteNodeRef, ContentModel.PROP_NAME));
        Set deletedSiteIds = (Set)AlfrescoTransactionSupport.getResource(KEY_DELETED_SITE_IDS);
        if (deletedSiteIds == null) {
            deletedSiteIds = Collections.newSetFromMap(new ConcurrentHashMap());
            AlfrescoTransactionSupport.bindResource(KEY_DELETED_SITE_IDS, deletedSiteIds);
        }
        deletedSiteIds.add(siteId);
        AlfrescoTransactionSupport.bindListener(this.deleteSiteTransactionListener);
    }

    class FeedCleanerDeletePersonTransactionListener
    extends TransactionListenerAdapter {
        FeedCleanerDeletePersonTransactionListener() {
        }

        public void afterCommit() {
            Set deletedUserIds = (Set)AlfrescoTransactionSupport.getResource(KEY_DELETED_USER_IDS);
            if (deletedUserIds != null) {
                for (String userId : deletedUserIds) {
                    try {
                        FeedCleaner.this.feedDAO.deleteUserFeedEntries(userId);
                    }
                    catch (SQLException e) {
                        logger.error((Object)("Activities feed cleanup for user '" + userId + "' failed: "), (Throwable)e);
                    }
                }
            }
        }
    }

    class FeedCleanerDeleteSiteTransactionListener
    extends TransactionListenerAdapter {
        FeedCleanerDeleteSiteTransactionListener() {
        }

        public void afterCommit() {
            Set deletedSiteIds = (Set)AlfrescoTransactionSupport.getResource(KEY_DELETED_SITE_IDS);
            if (deletedSiteIds != null) {
                for (String siteId : deletedSiteIds) {
                    try {
                        FeedCleaner.this.feedDAO.deleteSiteFeedEntries(siteId);
                    }
                    catch (SQLException e) {
                        logger.error((Object)("Activities feed cleanup for site '" + siteId + "' failed: "), (Throwable)e);
                    }
                }
            }
        }
    }
}

