/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed.cleanup;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.activities.feed.cleanup.FeedCleaner;
import org.alfresco.repo.domain.activities.ActivityFeedDAO;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.springframework.context.ApplicationContext;

public class FeedCleanerTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private ActivityFeedDAO feedDAO;
    private FeedCleaner cleaner;
    private SiteService siteService;
    private PersonService personService;
    protected RetryingTransactionHelper transactionHelper;
    private static final String TEST_SITE = "testSite";
    private static final String TEST_SITE_1 = "testSite1";
    private static final String TEST_SITE_2 = "testSite2";
    private static final String TEST_SITE_3 = "testSite3";
    private static final String TEST_SITE_4 = "testSite4";
    private static final String TEST_SITE_5 = "testSite5";
    private static final String TEST_SITE_6 = "testSite6";
    private static final String TEST_SITE_7 = "testSite7";
    private static final String TEST_USER_A = "testUserA";
    private static final String TEST_USER_B = "testUserB";
    private static final String TEST_USER_C = "testUserC";
    private static final String TEST_USER_D = "testUserD";
    private static final String TEST_USER_E = "testUserE";
    private static final String TEST_USER_F = "testUserF";

    public void setUp() throws Exception {
        this.siteService = (SiteService)ctx.getBean("SiteService");
        this.personService = (PersonService)ctx.getBean("PersonService");
        this.feedDAO = (ActivityFeedDAO)ctx.getBean("feedDAO");
        this.transactionHelper = (RetryingTransactionHelper)ctx.getBean("retryingTransactionHelper");
        this.tearDown();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        for (int i = 1; i <= 7; ++i) {
            this.siteService.createSite("myPreset", TEST_SITE + i, null, null, SiteVisibility.PUBLIC);
        }
        AuthenticationUtil.setRunAsUserSystem();
        this.cleaner = new FeedCleaner();
        this.cleaner.setFeedDAO(this.feedDAO);
    }

    public void tearDown() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.feedDAO.deleteFeedEntries(new Date(System.currentTimeMillis() + 120000L));
        for (int i = 1; i <= 7; ++i) {
            if (this.siteService.getSite(TEST_SITE + i) == null) continue;
            this.siteService.deleteSite(TEST_SITE + i);
        }
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testSetup() throws Exception {
    }

    public void testMaxAge() throws Exception {
        this.cleaner.setMaxFeedSize(0);
        ActivityFeedEntity feedEntry = new ActivityFeedEntity();
        feedEntry.setPostDate(new Date(System.currentTimeMillis() - 1200000L));
        feedEntry.setActivitySummaryFormat("json");
        feedEntry.setSiteNetwork(TEST_SITE_1);
        feedEntry.setActivityType("testActivityType");
        feedEntry.setPostUserId(TEST_USER_A);
        feedEntry.setFeedUserId("");
        feedEntry.setFeedDate(new Date());
        this.feedDAO.insertFeedEntry(feedEntry);
        feedEntry = new ActivityFeedEntity();
        feedEntry.setPostDate(new Date());
        feedEntry.setActivitySummaryFormat("json");
        feedEntry.setSiteNetwork(TEST_SITE_1);
        feedEntry.setActivityType("testActivityType");
        feedEntry.setPostUserId(TEST_USER_A);
        feedEntry.setFeedUserId("");
        feedEntry.setFeedDate(new Date());
        this.feedDAO.insertFeedEntry(feedEntry);
        feedEntry = new ActivityFeedEntity();
        feedEntry.setPostDate(new Date(System.currentTimeMillis() - 1200000L));
        feedEntry.setActivitySummaryFormat("json");
        feedEntry.setSiteNetwork(TEST_SITE_2);
        feedEntry.setActivityType("testActivityType");
        feedEntry.setPostUserId(TEST_USER_A);
        feedEntry.setFeedUserId(TEST_USER_B);
        feedEntry.setFeedDate(new Date());
        this.feedDAO.insertFeedEntry(feedEntry);
        feedEntry = new ActivityFeedEntity();
        feedEntry.setPostDate(new Date());
        feedEntry.setActivitySummaryFormat("json");
        feedEntry.setSiteNetwork(TEST_SITE_3);
        feedEntry.setActivityType("testActivityType");
        feedEntry.setPostUserId(TEST_USER_A);
        feedEntry.setFeedUserId(TEST_USER_B);
        feedEntry.setFeedDate(new Date());
        this.feedDAO.insertFeedEntry(feedEntry);
        FeedCleanerTest.assertEquals((int)2, (int)this.feedDAO.selectSiteFeedEntries(TEST_SITE_1, "json", -1).size());
        FeedCleanerTest.assertEquals((int)2, (int)this.feedDAO.selectUserFeedEntries(TEST_USER_B, "json", null, false, false, -1L, -1).size());
        this.cleaner.setMaxAgeMins(10);
        this.cleaner.execute();
        FeedCleanerTest.assertEquals((int)1, (int)this.feedDAO.selectSiteFeedEntries(TEST_SITE_1, "json", -1).size());
        FeedCleanerTest.assertEquals((int)1, (int)this.feedDAO.selectUserFeedEntries(TEST_USER_B, "json", null, false, false, -1L, -1).size());
    }

    public void testMaxSize() throws Exception {
        ActivityFeedEntity feedEntry;
        int i;
        ActivityFeedEntity feedEntry2;
        int i2;
        this.cleaner.setMaxAgeMins(0);
        for (i2 = 0; i2 < 10; ++i2) {
            feedEntry2 = new ActivityFeedEntity();
            feedEntry2.setPostDate(new Date(System.currentTimeMillis() - (long)(i2 * 60) * 1000L));
            feedEntry2.setActivitySummaryFormat("json");
            feedEntry2.setSiteNetwork(TEST_SITE_4);
            feedEntry2.setActivityType("testActivityType");
            feedEntry2.setPostUserId(TEST_USER_C);
            feedEntry2.setFeedUserId("");
            feedEntry2.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry2);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            feedEntry2 = new ActivityFeedEntity();
            feedEntry2.setPostDate(new Date(System.currentTimeMillis() - (long)(i2 * 60) * 1000L));
            feedEntry2.setActivitySummaryFormat("json");
            feedEntry2.setSiteNetwork(TEST_SITE_5);
            feedEntry2.setActivityType("testActivityType");
            feedEntry2.setPostUserId(TEST_USER_A);
            feedEntry2.setFeedUserId(TEST_USER_D);
            feedEntry2.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry2);
        }
        FeedCleanerTest.assertEquals((int)10, (int)this.feedDAO.selectSiteFeedEntries(TEST_SITE_4, "json", -1).size());
        FeedCleanerTest.assertEquals((int)10, (int)this.feedDAO.selectUserFeedEntries(TEST_USER_D, "json", null, false, false, -1L, -1).size());
        this.cleaner.setMaxFeedSize(2);
        this.cleaner.execute();
        FeedCleanerTest.assertEquals((int)2, (int)this.feedDAO.selectSiteFeedEntries(TEST_SITE_4, "json", -1).size());
        FeedCleanerTest.assertEquals((int)2, (int)this.feedDAO.selectUserFeedEntries(TEST_USER_D, "json", null, false, false, -1L, -1).size());
        Date sameTime = new Date();
        for (i = 0; i < 10; ++i) {
            feedEntry = new ActivityFeedEntity();
            feedEntry.setPostDate(sameTime);
            feedEntry.setActivitySummaryFormat("json");
            feedEntry.setSiteNetwork(TEST_SITE_6);
            feedEntry.setActivityType("testActivityType");
            feedEntry.setPostUserId(TEST_USER_E);
            feedEntry.setFeedUserId("");
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
        }
        for (i = 0; i < 10; ++i) {
            feedEntry = new ActivityFeedEntity();
            feedEntry.setPostDate(sameTime);
            feedEntry.setActivitySummaryFormat("json");
            feedEntry.setSiteNetwork(TEST_SITE_7);
            feedEntry.setActivityType("testActivityType");
            feedEntry.setPostUserId(TEST_USER_A);
            feedEntry.setFeedUserId(TEST_USER_F);
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
        }
        FeedCleanerTest.assertEquals((int)10, (int)this.feedDAO.selectSiteFeedEntries(TEST_SITE_6, "json", -1).size());
        FeedCleanerTest.assertEquals((int)10, (int)this.feedDAO.selectUserFeedEntries(TEST_USER_F, "json", null, false, false, -1L, -1).size());
        this.cleaner.setMaxFeedSize(2);
        this.cleaner.execute();
        FeedCleanerTest.assertEquals((int)10, (int)this.feedDAO.selectSiteFeedEntries(TEST_SITE_6, "json", -1).size());
        FeedCleanerTest.assertEquals((int)10, (int)this.feedDAO.selectUserFeedEntries(TEST_USER_F, "json", null, false, false, -1L, -1).size());
    }

    public void testSiteDelete() throws Exception {
        this.cleaner.setMaxAgeMins(100);
        FeedCleanerTest.assertEquals((int)0, (int)this.feedDAO.selectSiteFeedEntries(TEST_SITE_4, "json", -1).size());
        FeedCleanerTest.assertEquals((int)0, (int)this.feedDAO.selectUserFeedEntries(TEST_USER_D, "json", null, false, false, -1L, -1).size());
        int site4FeedCnt = 10;
        for (int i = 0; i < site4FeedCnt; ++i) {
            ActivityFeedEntity feedEntry = new ActivityFeedEntity();
            feedEntry.setPostDate(new Date(System.currentTimeMillis() - (long)(i * 60) * 1000L));
            feedEntry.setActivitySummaryFormat("json");
            feedEntry.setSiteNetwork(TEST_SITE_4);
            feedEntry.setActivityType("testActivityType");
            feedEntry.setPostUserId(TEST_USER_C);
            feedEntry.setFeedUserId("");
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
            feedEntry.setFeedUserId(TEST_USER_D);
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
        }
        int site5FeedCnt = 5;
        for (int i = 0; i < site5FeedCnt; ++i) {
            ActivityFeedEntity feedEntry = new ActivityFeedEntity();
            feedEntry.setPostDate(new Date(System.currentTimeMillis() - (long)(i * 60) * 1000L));
            feedEntry.setActivitySummaryFormat("json");
            feedEntry.setSiteNetwork(TEST_SITE_5);
            feedEntry.setActivityType("testActivityType");
            feedEntry.setPostUserId(TEST_USER_C);
            feedEntry.setFeedUserId(TEST_USER_D);
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
        }
        FeedCleanerTest.assertEquals((int)site4FeedCnt, (int)this.feedDAO.selectSiteFeedEntries(TEST_SITE_4, "json", -1).size());
        FeedCleanerTest.assertEquals((int)(site4FeedCnt + site5FeedCnt), (int)this.feedDAO.selectUserFeedEntries(TEST_USER_D, "json", null, false, false, -1L, -1).size());
        this.siteService.deleteSite(TEST_SITE_4);
        FeedCleanerTest.assertEquals((int)0, (int)this.feedDAO.selectSiteFeedEntries(TEST_SITE_4, "json", -1).size());
        FeedCleanerTest.assertEquals((int)site5FeedCnt, (int)this.feedDAO.selectUserFeedEntries(TEST_USER_D, "json", null, false, false, -1L, -1).size());
        this.siteService.createSite("mypreset", TEST_SITE_4, TEST_SITE_4, TEST_SITE_4, SiteVisibility.PUBLIC);
        FeedCleanerTest.assertEquals((int)0, (int)this.feedDAO.selectSiteFeedEntries(TEST_SITE_4, "json", -1).size());
    }

    public void testPersonDelete() throws Exception {
        this.cleaner.setMaxAgeMins(100);
        this.createPerson(TEST_USER_E);
        FeedCleanerTest.assertEquals((int)0, (int)this.feedDAO.selectSiteFeedEntries(TEST_SITE_6, "json", -1).size());
        FeedCleanerTest.assertEquals((int)0, (int)this.feedDAO.selectUserFeedEntries(TEST_USER_E, "json", null, false, false, -1L, -1).size());
        int site6FeedCnt = 10;
        for (int i = 0; i < site6FeedCnt; ++i) {
            ActivityFeedEntity feedEntry = new ActivityFeedEntity();
            feedEntry.setPostDate(new Date(System.currentTimeMillis() - (long)(i * 60) * 1000L));
            feedEntry.setActivitySummaryFormat("json");
            feedEntry.setSiteNetwork(TEST_SITE_6);
            feedEntry.setActivityType("testActivityType");
            feedEntry.setPostUserId(TEST_USER_E);
            feedEntry.setFeedUserId("");
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
            feedEntry.setFeedUserId(TEST_USER_E);
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
        }
        int site7FeedCnt = 5;
        for (int i = 0; i < site7FeedCnt; ++i) {
            ActivityFeedEntity feedEntry = new ActivityFeedEntity();
            feedEntry.setPostDate(new Date(System.currentTimeMillis() - (long)(i * 60) * 1000L));
            feedEntry.setActivitySummaryFormat("json");
            feedEntry.setSiteNetwork(TEST_SITE_7);
            feedEntry.setActivityType("testActivityType");
            feedEntry.setPostUserId(TEST_USER_E);
            feedEntry.setFeedUserId("");
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
            feedEntry.setFeedUserId(TEST_USER_E);
            feedEntry.setFeedDate(new Date());
            this.feedDAO.insertFeedEntry(feedEntry);
        }
        FeedCleanerTest.assertEquals((int)site6FeedCnt, (int)this.feedDAO.selectSiteFeedEntries(TEST_SITE_6, "json", -1).size());
        FeedCleanerTest.assertEquals((int)site7FeedCnt, (int)this.feedDAO.selectSiteFeedEntries(TEST_SITE_7, "json", -1).size());
        FeedCleanerTest.assertEquals((int)(site6FeedCnt + site7FeedCnt), (int)this.feedDAO.selectUserFeedEntries(TEST_USER_E, "json", null, false, false, -1L, -1).size());
        this.personService.deletePerson(TEST_USER_E);
        FeedCleanerTest.assertEquals((int)site6FeedCnt, (int)this.feedDAO.selectSiteFeedEntries(TEST_SITE_6, "json", -1).size());
        FeedCleanerTest.assertEquals((int)site7FeedCnt, (int)this.feedDAO.selectSiteFeedEntries(TEST_SITE_7, "json", -1).size());
        FeedCleanerTest.assertEquals((int)0, (int)this.feedDAO.selectUserFeedEntries(TEST_USER_E, "json", null, false, false, -1L, -1).size());
        FeedCleanerTest.assertTrue((boolean)this.createPerson(TEST_USER_E));
        FeedCleanerTest.assertEquals((int)0, (int)this.feedDAO.selectUserFeedEntries(TEST_USER_E, "json", null, false, false, -1L, -1).size());
    }

    private boolean createPerson(String userName) {
        if (!this.personService.personExists(userName)) {
            PropertyMap personProps = new PropertyMap();
            personProps.put(ContentModel.PROP_USERNAME, userName);
            personProps.put(ContentModel.PROP_FIRSTNAME, userName);
            personProps.put(ContentModel.PROP_LASTNAME, userName);
            personProps.put(ContentModel.PROP_EMAIL, userName + "@email.com");
            this.personService.createPerson(personProps);
            return true;
        }
        return false;
    }

    public void testConcurrentAccessAndRemoval() throws Exception {
        int i;
        this.cleaner.setMaxAgeMins(1);
        this.cleaner.setMaxFeedSize(1);
        int typeCount = 3;
        int n = typeCount * 10;
        Thread[] threads = new Thread[n];
        Tester[] testers = new Tester[n];
        for (i = 0; i < n; ++i) {
            Tester tester;
            testers[i] = tester = new Tester(i, typeCount);
            threads[i] = new Thread(tester);
            threads[i].start();
        }
        for (i = 0; i < n; ++i) {
            threads[i].join();
            if (testers[i].getErrorStackTrace() == null) continue;
            FeedCleanerTest.fail((String)testers[i].getErrorStackTrace());
        }
    }

    private class Tester
    implements Runnable {
        private int i;
        private int typeCount;
        private String errorStackTrace = null;

        public Tester(int i, int typeCount) {
            this.i = i;
            this.typeCount = typeCount;
        }

        public String getErrorStackTrace() {
            return this.errorStackTrace;
        }

        public void run() {
            try {
                int type = this.i % this.typeCount;
                if (type == 0) {
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                    int insertCount = 10;
                    for (int i = 0; i < insertCount; ++i) {
                        final ActivityFeedEntity feedEntry = new ActivityFeedEntity();
                        feedEntry.setPostDate(new Date(System.currentTimeMillis() - (long)(i * 60) * 1000L));
                        feedEntry.setActivitySummaryFormat("json");
                        feedEntry.setSiteNetwork(FeedCleanerTest.TEST_SITE_4);
                        feedEntry.setActivityType("testActivityType");
                        feedEntry.setPostUserId(FeedCleanerTest.TEST_USER_C);
                        feedEntry.setFeedUserId("");
                        feedEntry.setFeedDate(new Date());
                        FeedCleanerTest.this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            @Override
                            public Object execute() throws Throwable {
                                FeedCleanerTest.this.feedDAO.insertFeedEntry(feedEntry);
                                return null;
                            }
                        });
                    }
                    System.out.println("[" + this.i + "] Inserted " + insertCount + " entries");
                }
                if (type == 1) {
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                    int selectCount = FeedCleanerTest.this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

                        @Override
                        public Integer execute() throws Throwable {
                            int selectCount = FeedCleanerTest.this.feedDAO.selectSiteFeedEntries(FeedCleanerTest.TEST_SITE_4, "json", -1).size();
                            return selectCount;
                        }
                    });
                    System.out.println("[" + this.i + "] Selected " + selectCount + " entries");
                }
                if (type == 2) {
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                    int deleteCount = FeedCleanerTest.this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

                        @Override
                        public Integer execute() throws Throwable {
                            int deleteCount = FeedCleanerTest.this.cleaner.execute();
                            return deleteCount;
                        }
                    });
                    System.out.println("[" + this.i + "] Deleted " + deleteCount + " entries");
                }
            }
            catch (Throwable t) {
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                this.errorStackTrace = sw.toString();
                Assert.fail((String)t.getMessage());
            }
        }
    }
}

