/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed.local;

import java.util.Collection;
import org.alfresco.repo.activities.feed.AbstractFeedGenerator;
import org.alfresco.repo.activities.feed.FeedGridJob;
import org.alfresco.repo.activities.feed.FeedTaskProcessor;
import org.alfresco.repo.activities.feed.JobSettings;
import org.alfresco.repo.activities.feed.local.LocalFeedTaskSplitter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalFeedGenerator
extends AbstractFeedGenerator {
    private static Log logger = LogFactory.getLog(LocalFeedGenerator.class);
    private FeedTaskProcessor feedTaskProcessor;

    public void setFeedTaskProcessor(FeedTaskProcessor feedTaskProcessor) {
        this.feedTaskProcessor = feedTaskProcessor;
    }

    public int getEstimatedGridSize() {
        return 1;
    }

    public void init() throws Exception {
        super.init();
    }

    protected boolean generate() throws Exception {
        Long maxSequence = this.getPostDaoService().getMaxActivitySeq();
        Integer maxNodeHash = this.getPostDaoService().getMaxNodeHash();
        String gridName = "local";
        if (maxSequence != null && maxNodeHash != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(">>> Execute job cycle: " + gridName + " (maxSeq: " + maxSequence + ")"));
            }
            long startTime = System.currentTimeMillis();
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() {
                    LocalFeedGenerator.this.getWebScriptsCtx().setTicket(LocalFeedGenerator.this.getAuthenticationService().getCurrentTicket());
                    return null;
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            JobSettings js = new JobSettings();
            js.setMaxSeq(maxSequence);
            js.setJobTaskNode(maxNodeHash);
            js.setWebScriptsCtx(this.getWebScriptsCtx());
            js.setMaxItemsPerCycle(this.getMaxItemsPerCycle());
            LocalFeedTaskSplitter splitter = new LocalFeedTaskSplitter();
            splitter.setFeedTaskProcessor(this.feedTaskProcessor);
            Collection<FeedGridJob> jobs = splitter.split(this.getEstimatedGridSize(), js);
            for (FeedGridJob job : jobs) {
                job.execute();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(">>> Finish job cycle: " + gridName + " (in " + (System.currentTimeMillis() - startTime) + " msecs)"));
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(">>> No work to be done for this job cycle: " + gridName));
        }
        return false;
    }
}

