/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin;

import java.util.Set;
import java.util.TreeSet;
import org.alfresco.repo.admin.RepoServerMgmtMBean;
import org.alfresco.repo.security.authentication.AbstractAuthenticationService;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepoServerMgmt
implements RepoServerMgmtMBean {
    private static final Log log = LogFactory.getLog(RepoServerMgmt.class);
    private TransactionServiceImpl transactionService;
    private AbstractAuthenticationService authenticationService;

    public void setTransactionService(TransactionServiceImpl transactionService) {
        this.transactionService = transactionService;
    }

    public void setAuthenticationService(AbstractAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public boolean isReadOnly() {
        return this.transactionService.isReadOnly();
    }

    public int getTicketCountNonExpired() {
        return this.authenticationService.countTickets(true);
    }

    public int getTicketCountAll() {
        return this.authenticationService.countTickets(false);
    }

    public int getUserCountNonExpired() {
        return this.authenticationService.getUsersWithTickets(true).size();
    }

    public int getUserCountAll() {
        return this.authenticationService.getUsersWithTickets(false).size();
    }

    public String[] listUserNamesNonExpired() {
        Set<String> userSet = this.authenticationService.getUsersWithTickets(true);
        TreeSet<String> sorted = new TreeSet<String>(userSet);
        return sorted.toArray(new String[0]);
    }

    public String[] listUserNamesAll() {
        Set<String> userSet = this.authenticationService.getUsersWithTickets(false);
        TreeSet<String> sorted = new TreeSet<String>(userSet);
        return sorted.toArray(new String[0]);
    }

    public int invalidateTicketsExpired() {
        int count = this.authenticationService.invalidateTickets(true);
        log.info((Object)("Expired tickets invalidated: " + count));
        return count;
    }

    public int invalidateTicketsAll() {
        int count = this.authenticationService.invalidateTickets(false);
        log.info((Object)("All tickets invalidated: " + count));
        return count;
    }

    public void invalidateUser(String username) {
        this.authenticationService.invalidateUserSession(username);
        log.info((Object)("User invalidated: " + username));
    }

    public int getMaxUsers() {
        return this.authenticationService.getMaxUsers();
    }
}

