/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.patch.AppliedPatch;
import org.alfresco.repo.admin.patch.Patch;
import org.alfresco.repo.admin.patch.PatchExecuter;
import org.alfresco.repo.admin.patch.PatchService;
import org.alfresco.repo.domain.patch.AppliedPatchDAO;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.descriptor.Descriptor;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatchServiceImpl
implements PatchService {
    private static final String MSG_NOT_RELEVANT = "patch.service.not_relevant";
    private static final String MSG_PRECEEDED_BY_ALTERNATIVE = "patch.service.preceeded_by_alternative";
    private static final String MSG_APPLYING_PATCH = "patch.service.applying_patch";
    private static final String MSG_VALIDATION_FAILED = "patch.validation.failed";
    private static final Date ZERO_DATE = new Date(0L);
    private static final Date INFINITE_DATE = new Date(Long.MAX_VALUE);
    private static Log logger = LogFactory.getLog(PatchExecuter.class);
    private DescriptorService descriptorService;
    private TransactionServiceImpl transactionService;
    private RuleService ruleService;
    private AppliedPatchDAO appliedPatchDAO;
    private List<Patch> patches;
    private final QName vetoName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"PatchServiceImpl");

    public PatchServiceImpl() {
        this.patches = new ArrayList<Patch>(10);
    }

    public void setDescriptorService(DescriptorService descriptorService) {
        this.descriptorService = descriptorService;
    }

    public void setTransactionService(TransactionServiceImpl transactionService) {
        this.transactionService = transactionService;
    }

    public void setAppliedPatchDAO(AppliedPatchDAO appliedPatchDAO) {
        this.appliedPatchDAO = appliedPatchDAO;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    @Override
    public void registerPatch(Patch patch) {
        this.patches.add(patch);
    }

    @Override
    public boolean validatePatches() {
        boolean success = true;
        int serverSchemaVersion = this.descriptorService.getServerDescriptor().getSchema();
        for (Patch patch : this.patches) {
            if (patch.getFixesToSchema() <= serverSchemaVersion) continue;
            logger.error((Object)I18NUtil.getMessage((String)MSG_VALIDATION_FAILED, (Object[])new Object[]{patch.getId(), serverSchemaVersion, patch.getFixesToSchema(), patch.getTargetSchema()}));
            success = false;
        }
        if (!success) {
            this.transactionService.setAllowWrite(false, this.vetoName);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean applyOutstandingPatches() {
        boolean success = true;
        try {
            this.ruleService.disableRules();
            try {
                Patch patch;
                ArrayList<Patch> sortedPatches = new ArrayList<Patch>(this.patches);
                PatchTargetSchemaComparator comparator = new PatchTargetSchemaComparator();
                Collections.sort(sortedPatches, comparator);
                HashMap<String, AppliedPatch> appliedPatchesById = new HashMap<String, AppliedPatch>(23);
                List<AppliedPatch> appliedPatches = this.appliedPatchDAO.getAppliedPatches();
                for (final AppliedPatch appliedPatch : appliedPatches) {
                    appliedPatchesById.put(appliedPatch.getId(), appliedPatch);
                    if (appliedPatch.getAppliedOnDate() != null) continue;
                    RetryingTransactionHelper.RetryingTransactionCallback<Date> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Date>(){

                        @Override
                        public Date execute() throws Throwable {
                            Date now = new Date();
                            appliedPatch.setAppliedOnDate(now);
                            PatchServiceImpl.this.appliedPatchDAO.updateAppliedPatch(appliedPatch);
                            return now;
                        }
                    };
                    this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, false, true);
                }
                Iterator<AppliedPatch> i$ = sortedPatches.iterator();
                while (i$.hasNext() && (success = this.applyPatchAndDependencies(patch = (Patch)((Object)i$.next()), appliedPatchesById))) {
                }
                Object var10_10 = null;
                this.ruleService.enableRules();
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.ruleService.enableRules();
                throw throwable;
            }
        }
        catch (Throwable exception) {
            exception.printStackTrace();
            success = false;
        }
        return success;
    }

    private boolean applyPatchAndDependencies(Patch patch, Map<String, AppliedPatch> appliedPatchesById) {
        String id = patch.getId();
        List<Patch> dependencies = patch.getDependsOn();
        for (Patch dependencyPatch : dependencies) {
            boolean success = this.applyPatchAndDependencies(dependencyPatch, appliedPatchesById);
            if (success) continue;
            return false;
        }
        AppliedPatch appliedPatch = appliedPatchesById.get(id);
        if (appliedPatch != null && appliedPatch.getSucceeded() && appliedPatch.getWasExecuted() && appliedPatch.getSucceeded()) {
            return true;
        }
        appliedPatch = this.applyPatch(patch);
        if (!appliedPatch.getSucceeded()) {
            return false;
        }
        appliedPatchesById.put(id, appliedPatch);
        return true;
    }

    private AppliedPatch applyPatch(Patch patch) {
        PatchWork work = new PatchWork(patch);
        work.setAppliedPatchDAO(this.appliedPatchDAO);
        work.setTransactionService(this.transactionService);
        work.setAppliedPatchDAO(this.appliedPatchDAO);
        work.setDescriptorService(this.descriptorService);
        work.setLogger(logger);
        work.execute();
        return work.getAppliedPatch();
    }

    @Override
    public List<AppliedPatch> getPatches(Date fromDate, Date toDate) {
        if (fromDate == null) {
            fromDate = ZERO_DATE;
        }
        if (toDate == null) {
            toDate = INFINITE_DATE;
        }
        List<AppliedPatch> appliedPatches = this.appliedPatchDAO.getAppliedPatches(fromDate, toDate);
        return appliedPatches;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PatchTargetSchemaComparator
    implements Comparator<Patch> {
        private PatchTargetSchemaComparator() {
        }

        @Override
        public int compare(Patch p1, Patch p2) {
            Integer i1 = new Integer(p1.getTargetSchema());
            Integer i2 = new Integer(p2.getTargetSchema());
            return i1.compareTo(i2);
        }
    }

    private static class PatchWork {
        private Log logger;
        private AppliedPatchDAO appliedPatchDAO;
        private DescriptorService descriptorService;
        private TransactionService transactionService;
        private STATE state = STATE.START;
        private Patch patch;
        private AppliedPatch appliedPatch;
        private Descriptor repoDescriptor;
        private String preceededByAlternative;
        private boolean applies = false;
        private String report = null;

        public PatchWork(Patch patch) {
            this.patch = patch;
        }

        public void setLogger(Log logger) {
            this.logger = logger;
        }

        public void setAppliedPatchDAO(AppliedPatchDAO appliedPatchDAO) {
            this.appliedPatchDAO = appliedPatchDAO;
        }

        public void setDescriptorService(DescriptorService descriptorService) {
            this.descriptorService = descriptorService;
        }

        public void setTransactionService(TransactionService transactionService) {
            this.transactionService = transactionService;
        }

        private String preceededByAlternative(Patch patch) {
            List<Patch> alternatives = patch.getAlternatives();
            for (Patch alternative : alternatives) {
                AppliedPatch appliedAlternative = this.appliedPatchDAO.getAppliedPatch(alternative.getId());
                if (appliedAlternative == null || !appliedAlternative.getWasExecuted() || !appliedAlternative.getSucceeded()) continue;
                return alternative.getId();
            }
            return null;
        }

        private boolean applies(Descriptor repoDescriptor, Patch patch) {
            int repoSchema = repoDescriptor.getSchema();
            boolean apply = patch.applies(repoSchema);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Patch schema version number check against repo version: \n   repo schema version: " + repoDescriptor.getVersion() + "\n" + "   patch: " + patch));
            }
            return apply;
        }

        private boolean patchSucceeded() {
            return this.state == STATE.ALREADY_APPLIED || this.state == STATE.DOES_NOT_APPLY || this.state == STATE.APPLIED || this.state == STATE.PRECEEDED;
        }

        private boolean savePatch() {
            return this.state == STATE.DOES_NOT_APPLY || this.state == STATE.APPLIED || this.state == STATE.PRECEEDED || this.state == STATE.FAILED;
        }

        public void execute() {
            if (this.state != STATE.START) {
                throw new IllegalStateException("Patch is already being applied");
            }
            if (!this.patch.requiresTransaction() && AlfrescoTransactionSupport.isActualTransactionActive()) {
                throw new AlfrescoRuntimeException("Patch " + this.patch.getId() + " has been configured with requiresTransaction set to false but is being called in a transaction");
            }
            this.setup();
            this.applyPatch();
            this.save();
        }

        private void setup() {
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Throwable {
                    boolean forcePatch = PatchWork.this.patch.isForce();
                    if (forcePatch) {
                        PatchWork.this.logger.warn((Object)("Patch will be forcefully executed: \n   Patch: " + PatchWork.this.patch));
                    }
                    PatchWork.this.appliedPatch = PatchWork.this.appliedPatchDAO.getAppliedPatch(PatchWork.this.patch.getId());
                    if (PatchWork.this.appliedPatch != null && !forcePatch && PatchWork.this.appliedPatch.getSucceeded()) {
                        if (PatchWork.this.logger.isDebugEnabled()) {
                            PatchWork.this.logger.debug((Object)("Patch was already successfully applied: \n   Patch: " + PatchWork.this.appliedPatch));
                        }
                        PatchWork.this.state = STATE.ALREADY_APPLIED;
                        return null;
                    }
                    PatchWork.this.repoDescriptor = PatchWork.this.descriptorService.getInstalledRepositoryDescriptor();
                    PatchWork.this.applies = forcePatch || PatchWork.this.applies(PatchWork.this.repoDescriptor, PatchWork.this.patch);
                    PatchWork.this.preceededByAlternative = forcePatch ? null : PatchWork.this.preceededByAlternative(PatchWork.this.patch);
                    if (PatchWork.this.preceededByAlternative != null) {
                        PatchWork.this.report = I18NUtil.getMessage((String)PatchServiceImpl.MSG_PRECEEDED_BY_ALTERNATIVE, (Object[])new Object[]{PatchWork.this.preceededByAlternative});
                        PatchWork.this.state = STATE.PRECEEDED;
                    } else if (PatchWork.this.applies) {
                        PatchWork.this.state = STATE.APPLYING;
                    } else {
                        PatchWork.this.report = I18NUtil.getMessage((String)PatchServiceImpl.MSG_NOT_RELEVANT, (Object[])new Object[]{PatchWork.this.repoDescriptor.getSchema()});
                        PatchWork.this.state = STATE.DOES_NOT_APPLY;
                    }
                    return null;
                }
            }, false, true);
        }

        private void applyPatch() {
            if (this.state != STATE.APPLYING) {
                return;
            }
            try {
                String msg = I18NUtil.getMessage((String)PatchServiceImpl.MSG_APPLYING_PATCH, (Object[])new Object[]{this.patch.getId(), I18NUtil.getMessage((String)this.patch.getDescription())});
                this.logger.info((Object)msg);
                this.report = this.patch.apply();
                this.state = STATE.APPLIED;
            }
            catch (PatchException e) {
                this.report = e.getMessage();
                this.state = STATE.FAILED;
                this.logger.error((Object)this.report);
            }
        }

        private void save() {
            if (!this.savePatch()) {
                return;
            }
            this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Throwable {
                    Descriptor serverDescriptor = PatchWork.this.descriptorService.getServerDescriptor();
                    String server = serverDescriptor.getVersion() + " - " + serverDescriptor.getEdition();
                    boolean create = true;
                    if (PatchWork.this.appliedPatch == null) {
                        PatchWork.this.appliedPatch = new AppliedPatch();
                        PatchWork.this.appliedPatch.setId(PatchWork.this.patch.getId());
                        create = true;
                    } else {
                        create = false;
                    }
                    String patchDescription = I18NUtil.getMessage((String)PatchWork.this.patch.getDescription());
                    if (patchDescription == null) {
                        PatchWork.this.logger.warn((Object)("Patch description is not available: " + PatchWork.this.patch));
                        patchDescription = "No patch description available";
                    }
                    PatchWork.this.appliedPatch.setDescription(patchDescription);
                    PatchWork.this.appliedPatch.setFixesFromSchema(PatchWork.this.patch.getFixesFromSchema());
                    PatchWork.this.appliedPatch.setFixesToSchema(PatchWork.this.patch.getFixesToSchema());
                    PatchWork.this.appliedPatch.setTargetSchema(PatchWork.this.patch.getTargetSchema());
                    PatchWork.this.appliedPatch.setAppliedToSchema(PatchWork.this.repoDescriptor.getSchema());
                    PatchWork.this.appliedPatch.setAppliedToServer(server);
                    PatchWork.this.appliedPatch.setAppliedOnDate(new Date());
                    PatchWork.this.appliedPatch.setSucceeded(PatchWork.this.patchSucceeded());
                    PatchWork.this.appliedPatch.setWasExecuted(PatchWork.this.applies);
                    PatchWork.this.appliedPatch.setReport(PatchWork.this.report);
                    if (create) {
                        PatchWork.this.appliedPatchDAO.createAppliedPatch(PatchWork.this.appliedPatch);
                    } else {
                        PatchWork.this.appliedPatchDAO.updateAppliedPatch(PatchWork.this.appliedPatch);
                    }
                    if (PatchWork.this.logger.isDebugEnabled()) {
                        PatchWork.this.logger.debug((Object)("Applied patch: \n" + PatchWork.this.appliedPatch));
                    }
                    return null;
                }
            }, false, true);
        }

        public AppliedPatch getAppliedPatch() {
            return this.appliedPatch;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum STATE {
            START,
            PRECEEDED,
            ALREADY_APPLIED,
            DOES_NOT_APPLY,
            APPLYING,
            NOT_APPLIED,
            APPLIED,
            FAILED;

        }
    }
}

