/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.admin.patch.PatchExecuter;
import org.alfresco.repo.admin.registry.RegistryKey;
import org.alfresco.repo.admin.registry.RegistryService;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.PlainFileNode;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.control.ControlDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.extensions.surf.util.I18NUtil;

public class ContentUrlConverterPatch
extends AbstractPatch {
    private static final RegistryKey KEY_ADM_MAX_ID = new RegistryKey("http://www.alfresco.org/model/system/1.0", "ContentUrlConverter", "adm", "max-id");
    private static final RegistryKey KEY_ADM_RANGE_START_ID = new RegistryKey("http://www.alfresco.org/model/system/1.0", "ContentUrlConverter", "adm", "range-start-id");
    private static final RegistryKey KEY_ADM_DONE = new RegistryKey("http://www.alfresco.org/model/system/1.0", "ContentUrlConverter", "adm", "done");
    private static final RegistryKey KEY_AVM_MAX_ID = new RegistryKey("http://www.alfresco.org/model/system/1.0", "ContentUrlConverter", "avm", "max-id");
    private static final RegistryKey KEY_AVM_RANGE_START_ID = new RegistryKey("http://www.alfresco.org/model/system/1.0", "ContentUrlConverter", "avm", "range-start-id");
    private static final RegistryKey KEY_AVM_DONE = new RegistryKey("http://www.alfresco.org/model/system/1.0", "ContentUrlConverter", "avm", "done");
    private static final RegistryKey KEY_STORE_DONE = new RegistryKey("http://www.alfresco.org/model/system/1.0", "ContentUrlConverter", "store", "done");
    private static final QName LOCK = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"ContentUrlConverter");
    private static Log logger = LogFactory.getLog(PatchExecuter.class);
    private RegistryService registryService;
    private JobLockService jobLockService;
    private PatchDAO patchDAO;
    private ControlDAO controlDAO;
    private ContentStore contentStore;
    private ContentDataDAO contentDataDAO;
    private int threadCount;
    private int batchSize;
    private boolean runAsScheduledJob;
    private ThreadLocal<Boolean> runningAsJob = new ThreadLocal();

    public ContentUrlConverterPatch() {
        this.runningAsJob.set(Boolean.FALSE);
        this.threadCount = 2;
        this.batchSize = 500;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setControlDAO(ControlDAO controlDAO) {
        this.controlDAO = controlDAO;
    }

    public void setContentStore(ContentStore contentStore) {
        this.contentStore = contentStore;
    }

    public void setContentDataDAO(ContentDataDAO contentDataDAO) {
        this.contentDataDAO = contentDataDAO;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setRunAsScheduledJob(boolean runAsScheduledJob) {
        this.runAsScheduledJob = runAsScheduledJob;
    }

    protected void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"registryService", (Object)this.registryService);
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.jobLockService);
        PropertyCheck.mandatory((Object)this, (String)"patchDAO", (Object)this.patchDAO);
        super.checkProperties();
    }

    private void executeViaJob() {
        AuthenticationUtil.RunAsWork<String> patchRunAs = new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                RetryingTransactionHelper.RetryingTransactionCallback<String> patchTxn = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public String execute() throws Exception {
                        try {
                            String report;
                            ContentUrlConverterPatch.this.runningAsJob.set(Boolean.TRUE);
                            String string = report = ContentUrlConverterPatch.this.applyInternal();
                            Object var4_3 = null;
                            ContentUrlConverterPatch.this.runningAsJob.set(Boolean.FALSE);
                            return string;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            ContentUrlConverterPatch.this.runningAsJob.set(Boolean.FALSE);
                            throw throwable;
                        }
                    }
                };
                return ContentUrlConverterPatch.this.transactionHelper.doInTransaction(patchTxn);
            }
        };
        String report = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)patchRunAs, (String)AuthenticationUtil.getSystemUserName());
        if (report != null) {
            logger.info((Object)report);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String applyInternal() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) {
            return null;
        }
        boolean isRunningAsJob = this.runningAsJob.get();
        if (this.runAsScheduledJob && !isRunningAsJob) {
            return I18NUtil.getMessage((String)"patch.convertContentUrls.bypassingPatch");
        }
        String lockToken = this.getLock((long)this.batchSize * 100L);
        if (lockToken == null) {
            if (isRunningAsJob) {
                return null;
            }
            throw new RuntimeException("Unable to get job lock during patch execution.  Only one server should perform the upgrade.");
        }
        final AtomicBoolean running = new AtomicBoolean(true);
        this.jobLockService.refreshLock(lockToken, LOCK, this.batchSize * 100, new JobLockService.JobLockRefreshCallback(){

            public boolean isActive() {
                return running.get();
            }

            public void lockReleased() {
                running.set(false);
            }
        });
        boolean completed = false;
        try {
            try {
                logger.info((Object)I18NUtil.getMessage((String)"patch.convertContentUrls.start"));
                logger.info((Object)I18NUtil.getMessage((String)"patch.convertContentUrls.adm.start"));
                boolean admCompleted = this.applyADMLooping(running);
                logger.info((Object)I18NUtil.getMessage((String)"patch.convertContentUrls.avm.start"));
                boolean avmCompleted = this.applyAVMLooping(running);
                logger.info((Object)I18NUtil.getMessage((String)"patch.convertContentUrls.store.start", (Object[])new Object[]{this.contentStore}));
                boolean urlLiftingCompleted = this.applyUrlLifting(running);
                completed = admCompleted && avmCompleted && urlLiftingCompleted;
            }
            catch (RuntimeException e) {
                logger.error((Object)I18NUtil.getMessage((String)"patch.convertContentUrls.error", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                String string = I18NUtil.getMessage((String)"patch.convertContentUrls.error", (Object[])new Object[]{e.getMessage()});
                Object var9_11 = null;
                running.set(false);
                return string;
            }
            Object var9_10 = null;
            running.set(false);
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            running.set(false);
            throw throwable;
        }
        if (completed) {
            return I18NUtil.getMessage((String)"patch.convertContentUrls.done");
        }
        return I18NUtil.getMessage((String)"patch.convertContentUrls.inProgress");
    }

    private String getLock(long time) {
        try {
            return this.jobLockService.getLock(LOCK, time);
        }
        catch (LockAcquisitionException e) {
            return null;
        }
    }

    private boolean applyADMLooping(AtomicBoolean running) {
        RetryingTransactionHelper.RetryingTransactionCallback<Boolean> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

            @Override
            public Boolean execute() throws Throwable {
                return ContentUrlConverterPatch.this.applyADM();
            }
        };
        boolean done = false;
        while (running.get() && !(done = this.transactionHelper.doInTransaction(callback, false, true).booleanValue())) {
        }
        return done;
    }

    private boolean applyADM() throws Exception {
        Long startId;
        Long maxId = (Long)this.registryService.getProperty(KEY_ADM_MAX_ID);
        Boolean done = (Boolean)this.registryService.getProperty(KEY_ADM_DONE);
        if (done != null && done.booleanValue()) {
            logger.info((Object)I18NUtil.getMessage((String)"patch.convertContentUrls.adm.done", (Object[])new Object[]{maxId}));
            return true;
        }
        if (maxId == null) {
            maxId = this.patchDAO.getMaxAdmNodeID();
            this.registryService.addProperty(KEY_ADM_MAX_ID, maxId);
        }
        if ((startId = (Long)this.registryService.getProperty(KEY_ADM_RANGE_START_ID)) == null) {
            startId = 1L;
            this.registryService.addProperty(KEY_ADM_RANGE_START_ID, startId);
        }
        Long endId = startId;
        ArrayList<Pair> batchProcessorWork = new ArrayList<Pair>(2);
        for (long i = 0L; i < (long)(this.threadCount * 10); ++i) {
            endId = startId + (i + 1L) * (long)this.batchSize;
            Pair batchEntry = new Pair((Object)(startId + i * (long)this.batchSize), (Object)endId);
            batchProcessorWork.add(batchEntry);
        }
        BatchProcessor.BatchProcessWorkerAdaptor<Pair<Long, Long>> batchProcessorWorker = new BatchProcessor.BatchProcessWorkerAdaptor<Pair<Long, Long>>(){

            @Override
            public void process(Pair<Long, Long> range) throws Throwable {
                Long startId = (Long)range.getFirst();
                Long endId = (Long)range.getSecond();
                ContentUrlConverterPatch.this.patchDAO.updateAdmV31ContentProperties(startId, endId);
            }
        };
        BatchProcessor batchProcessor = new BatchProcessor("ContentUrlConverter.ADM (" + maxId + ")", this.transactionHelper, batchProcessorWork, this.threadCount, 1, this.applicationEventPublisher, null, 1);
        batchProcessor.process(batchProcessorWorker, true);
        if (batchProcessor.getTotalErrors() > 0) {
            throw AlfrescoRuntimeException.create((String)"patch.convertContentUrls.error", (Object[])new Object[]{batchProcessor.getLastError()});
        }
        startId = endId;
        if (startId > maxId) {
            startId = maxId + 1L;
            done = Boolean.TRUE;
            this.registryService.addProperty(KEY_ADM_DONE, done);
            logger.info((Object)I18NUtil.getMessage((String)"patch.convertContentUrls.adm.done", (Object[])new Object[]{maxId}));
            return true;
        }
        super.reportProgress(maxId, startId);
        this.registryService.addProperty(KEY_ADM_RANGE_START_ID, startId);
        return false;
    }

    private boolean applyAVMLooping(AtomicBoolean running) {
        RetryingTransactionHelper.RetryingTransactionCallback<Boolean> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

            @Override
            public Boolean execute() throws Throwable {
                return ContentUrlConverterPatch.this.applyAVM();
            }
        };
        boolean done = false;
        while (running.get() && !(done = this.transactionHelper.doInTransaction(callback, false, true).booleanValue())) {
        }
        return done;
    }

    private boolean applyAVM() throws Exception {
        Long startId;
        Long maxId = (Long)this.registryService.getProperty(KEY_AVM_MAX_ID);
        Boolean done = (Boolean)this.registryService.getProperty(KEY_AVM_DONE);
        if (done != null && done.booleanValue()) {
            logger.info((Object)I18NUtil.getMessage((String)"patch.convertContentUrls.avm.done", (Object[])new Object[]{maxId}));
            return true;
        }
        if (maxId == null) {
            maxId = this.patchDAO.getMaxAvmNodeID();
            this.registryService.addProperty(KEY_AVM_MAX_ID, maxId);
        }
        if ((startId = (Long)this.registryService.getProperty(KEY_AVM_RANGE_START_ID)) == null) {
            startId = 1L;
            this.registryService.addProperty(KEY_AVM_RANGE_START_ID, startId);
        }
        Long endId = startId + (long)this.batchSize * (long)this.threadCount * 10L;
        List<Long> nodeIds = this.patchDAO.getAvmNodesWithOldContentProperties(startId, endId);
        BatchProcessor.BatchProcessWorkerAdaptor<Long> batchProcessorWorker = new BatchProcessor.BatchProcessWorkerAdaptor<Long>(){

            @Override
            public void process(Long nodeId) throws Throwable {
                PlainFileNode node = (PlainFileNode)AVMDAOs.Instance().fAVMNodeDAO.getByID(nodeId);
                ContentData contentData = node.getContentData();
                node.setContentData(contentData);
                AVMDAOs.Instance().fAVMNodeDAO.update(node);
            }
        };
        BatchProcessor<Long> batchProcessor = new BatchProcessor<Long>("ContentUrlConverter.AVM (" + maxId + ")", this.transactionHelper, nodeIds, this.threadCount, this.batchSize, this.applicationEventPublisher, null, 1);
        batchProcessor.process((BatchProcessor.BatchProcessWorker<Long>)batchProcessorWorker, true);
        if (batchProcessor.getTotalErrors() > 0) {
            throw AlfrescoRuntimeException.create((String)"patch.convertContentUrls.error", (Object[])new Object[]{batchProcessor.getLastError()});
        }
        startId = endId;
        if (startId > maxId) {
            startId = maxId + 1L;
            done = Boolean.TRUE;
            this.registryService.addProperty(KEY_AVM_DONE, done);
            logger.info((Object)I18NUtil.getMessage((String)"patch.convertContentUrls.avm.done", (Object[])new Object[]{maxId}));
            return true;
        }
        super.reportProgress(maxId, startId);
        this.registryService.addProperty(KEY_AVM_RANGE_START_ID, startId);
        return false;
    }

    private boolean applyUrlLifting(final AtomicBoolean running) throws Exception {
        RetryingTransactionHelper.RetryingTransactionCallback<Boolean> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

            @Override
            public Boolean execute() throws Throwable {
                return ContentUrlConverterPatch.this.applyUrlLiftingInTxn(running);
            }
        };
        return this.transactionHelper.doInTransaction(callback, false, true);
    }

    private boolean applyUrlLiftingInTxn(final AtomicBoolean running) throws Exception {
        if (!this.contentStore.isWriteSupported()) {
            logger.info((Object)I18NUtil.getMessage((String)"patch.convertContentUrls.store.readOnly"));
            return true;
        }
        Boolean admDone = (Boolean)this.registryService.getProperty(KEY_ADM_DONE);
        Boolean avmDone = (Boolean)this.registryService.getProperty(KEY_AVM_DONE);
        if (admDone == null || !admDone.booleanValue() || avmDone == null || !avmDone.booleanValue()) {
            logger.info((Object)I18NUtil.getMessage((String)"patch.convertContentUrls.store.pending"));
            return false;
        }
        Boolean done = (Boolean)this.registryService.getProperty(KEY_STORE_DONE);
        if (done != null && done.booleanValue()) {
            logger.info((Object)I18NUtil.getMessage((String)"patch.convertContentUrls.store.done"));
            return true;
        }
        final long totalSize = this.contentStore.getSpaceUsed();
        final MutableLong currentSize = new MutableLong(0L);
        final MutableInt count = new MutableInt();
        count.setValue(0);
        ContentStore.ContentUrlHandler handler = new ContentStore.ContentUrlHandler(){
            private int allCount = 0;

            public void handle(String contentUrl) {
                if (!running.get()) {
                    throw new VmShutdownListener.VmShutdownException();
                }
                ContentReader reader = ContentUrlConverterPatch.this.contentStore.getReader(contentUrl);
                if (!reader.exists()) {
                    return;
                }
                currentSize.setValue(currentSize.longValue() + reader.getSize());
                String savepointName = new Long(System.nanoTime()).toString();
                Savepoint savepoint = ContentUrlConverterPatch.this.controlDAO.createSavepoint(savepointName);
                try {
                    ContentUrlConverterPatch.this.contentDataDAO.createContentUrlOrphaned(contentUrl, null);
                    ContentUrlConverterPatch.this.controlDAO.releaseSavepoint(savepoint);
                    count.setValue(count.intValue() + 1);
                }
                catch (DataIntegrityViolationException e) {
                    ContentUrlConverterPatch.this.controlDAO.rollbackToSavepoint(savepoint);
                }
                ++this.allCount;
                if (this.allCount % ContentUrlConverterPatch.this.batchSize == 0) {
                    if (totalSize < 0L) {
                        logger.info((Object)I18NUtil.getMessage((String)"patch.convertContentUrls.store.progress", (Object[])new Object[]{this.allCount}));
                    } else {
                        ContentUrlConverterPatch.super.reportProgress(totalSize, currentSize.longValue());
                    }
                }
            }
        };
        try {
            this.contentStore.getUrls(handler);
        }
        catch (UnsupportedOperationException e) {
            logger.info((Object)I18NUtil.getMessage((String)"patch.convertContentUrls.store.noSupport"));
        }
        catch (VmShutdownListener.VmShutdownException e) {
            return false;
        }
        done = Boolean.TRUE;
        this.registryService.addProperty(KEY_STORE_DONE, done);
        logger.info((Object)I18NUtil.getMessage((String)"patch.convertContentUrls.store.scheduled", (Object[])new Object[]{count.intValue(), this.contentStore}));
        return true;
    }

    public static class ContentUrlConverterJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap jobData = context.getJobDetail().getJobDataMap();
            Object contentUrlConverterObj = jobData.get((Object)"contentUrlConverter");
            if (contentUrlConverterObj == null || !(contentUrlConverterObj instanceof ContentUrlConverterPatch)) {
                throw new AlfrescoRuntimeException("'contentUrlConverter' data must contain valid 'ContentUrlConverter' reference");
            }
            ContentUrlConverterPatch contentUrlConverter = (ContentUrlConverterPatch)contentUrlConverterObj;
            contentUrlConverter.executeViaJob();
        }
    }
}

