/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.admin.patch.PatchExecuter;
import org.alfresco.repo.batch.BatchProcessWorkProvider;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.Pair;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopiedFromAspectPatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.copiedFromAspect.result";
    private PatchDAO patchDAO;
    private NodeDAO nodeDAO;
    private DictionaryService dictionaryService;
    private BehaviourFilter behaviourFilter;
    private RuleService ruleService;
    private int batchThreads = 2;
    private int batchSize = 1000;
    private int batchMaxQueryRange = 10000;
    private static Log logger = LogFactory.getLog(CopiedFromAspectPatch.class);
    private static Log progress_logger = LogFactory.getLog(PatchExecuter.class);
    private static final QName PROP_SOURCE = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"source");
    private static final StoreRef VERSION_STORE = new StoreRef("workspace://version2Store");

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setBatchThreads(int batchThreads) {
        this.batchThreads = batchThreads;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchMaxQueryRange(int batchMaxQueryRange) {
        this.batchMaxQueryRange = batchMaxQueryRange;
    }

    @Override
    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull(this.patchDAO, "patchDAO");
        this.checkPropertyNotNull(this.nodeDAO, "nodeDAO");
        this.checkPropertyNotNull(this.dictionaryService, "dictionaryService");
        this.checkPropertyNotNull(this.applicationEventPublisher, "applicationEventPublisher");
    }

    private CopiedFromAspectPatch write(FileChannel file, Object obj) {
        try {
            file.write(ByteBuffer.wrap(obj.toString().getBytes("UTF-8")));
        }
        catch (IOException e) {
            logger.error((Object)("Failed to write object to file: " + obj.toString()));
        }
        return this;
    }

    private CopiedFromAspectPatch writeLine(FileChannel file, Object obj) {
        this.write(file, obj);
        this.write(file, "\n");
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String applyInternal() throws Exception {
        String string;
        File tempDir = TempFileProvider.getLongLifeTempDir((String)"patches");
        File logFile = new File(tempDir, "CopiedFromAspectPatch.log");
        RandomAccessFile outputFile = new RandomAccessFile(logFile, "rw");
        FileChannel file = outputFile.getChannel();
        try {
            String msg;
            file.position(file.size());
            this.writeLine(file, "").writeLine(file, "");
            this.writeLine(file, "CopiedFromAspectPatch.log executing on " + new Date());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Starting CopiedFromAspectPatch.  [Q=Query; P=Process]");
            }
            int updated = this.process(file);
            string = msg = I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{updated, logFile});
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                file.close();
            }
            catch (IOException e) {}
            throw throwable;
        }
        try {
            file.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return string;
    }

    private int process(final FileChannel file) {
        final String user = AuthenticationUtil.getRunAsUser();
        HashSet<QName> qnames = new HashSet<QName>();
        qnames.add(ContentModel.ASPECT_COPIEDFROM);
        qnames.add(ContentModel.ASPECT_WORKING_COPY);
        WorkProvider workProvider = new WorkProvider(qnames);
        BatchProcessor.BatchProcessWorkerAdaptor<Pair<Long, NodeRef>> worker = new BatchProcessor.BatchProcessWorkerAdaptor<Pair<Long, NodeRef>>(){

            @Override
            public void beforeProcess() throws Throwable {
                AuthenticationUtil.setRunAsUser((String)user);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(Pair<Long, NodeRef> entry) throws Throwable {
                CopiedFromAspectPatch.this.behaviourFilter.disableBehaviour();
                CopiedFromAspectPatch.this.ruleService.disableRules();
                try {
                    CopiedFromAspectPatch.this.process(file, (Pair<Long, NodeRef>)entry);
                    Object var3_2 = null;
                    CopiedFromAspectPatch.this.ruleService.enableRules();
                    CopiedFromAspectPatch.this.behaviourFilter.enableBehaviour();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    CopiedFromAspectPatch.this.ruleService.enableRules();
                    CopiedFromAspectPatch.this.behaviourFilter.enableBehaviour();
                    throw throwable;
                }
            }

            @Override
            public void afterProcess() throws Throwable {
                AuthenticationUtil.clearCurrentSecurityContext();
            }
        };
        BatchProcessor<Pair<Long, NodeRef>> batchProcessor = new BatchProcessor<Pair<Long, NodeRef>>("CopiedFromAspectPatch", this.transactionService.getRetryingTransactionHelper(), workProvider, this.batchThreads, this.batchSize, null, progress_logger, 1000);
        int updated = batchProcessor.process((BatchProcessor.BatchProcessWorker<Pair<Long, NodeRef>>)worker, true);
        return updated;
    }

    private void process(FileChannel file, Pair<Long, NodeRef> nodePair) {
        NodeRef nodeRef;
        NodeRef sourceNodeRef;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\tP: Processing node: " + nodePair));
        }
        if ((sourceNodeRef = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)this.nodeService.getProperty(nodeRef = (NodeRef)nodePair.getSecond(), PROP_SOURCE))) == null || !this.nodeService.exists(sourceNodeRef)) {
            boolean isNewModel = true;
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_COPIEDFROM) && this.nodeService.getSourceAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_ORIGINAL).size() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\tP: Removing cm:copiedfrom: " + nodePair));
                }
                this.writeLine(file, "Removing cm:copiedfrom from node: " + nodePair);
                this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_COPIEDFROM);
                isNewModel = false;
            }
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY) && this.nodeService.getSourceAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_WORKING_COPY_LINK).size() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\tP: Removing cm:workingcopy: " + nodePair));
                }
                this.writeLine(file, "Removing cm:workingcopy from node: " + nodePair);
                this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY);
                isNewModel = false;
            }
            if (isNewModel) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\tP: Ignoring data with new model: " + nodePair));
                }
                this.writeLine(file, "Ignoring data with new model: " + nodePair);
            }
        } else {
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_COPIEDFROM) && this.nodeService.getSourceAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_ORIGINAL).size() <= 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\tP: Adding association cm:original: " + nodePair));
                }
                this.writeLine(file, "Adding association cm:original: " + nodePair);
                this.nodeService.createAssociation(nodeRef, sourceNodeRef, ContentModel.ASSOC_ORIGINAL);
            }
            if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY) && this.nodeService.getSourceAssocs(nodeRef, (QNamePattern)ContentModel.ASSOC_WORKING_COPY_LINK).size() <= 0) {
                if (this.nodeService.hasAspect(sourceNodeRef, ContentModel.ASPECT_CHECKED_OUT)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\tP: Found node with multiple working copies: " + sourceNodeRef));
                        logger.debug((Object)("\tP: Removing cm:workingcopy: " + nodePair));
                    }
                    this.writeLine(file, "Found node with multiple working copies: " + nodePair);
                    this.writeLine(file, "Removing cm:workingcopy from node: " + nodePair);
                    this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY);
                } else if (!VERSION_STORE.equals((Object)nodeRef.getStoreRef())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\tP: Adding aspect cm:checkedout: " + sourceNodeRef));
                        logger.debug((Object)("\tP: Adding association cm:workingcopylink: " + nodePair));
                    }
                    this.writeLine(file, "Adding aspect cm:checkedout: " + sourceNodeRef);
                    this.writeLine(file, "Adding association cm:workingcopylink to " + nodePair);
                    this.nodeService.addAspect(sourceNodeRef, ContentModel.ASPECT_CHECKED_OUT, null);
                    this.nodeService.createAssociation(sourceNodeRef, nodeRef, ContentModel.ASSOC_WORKING_COPY_LINK);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\tP: Found version of working copy marked as actual working copy: " + nodeRef));
                        logger.debug((Object)("\tP: Removing cm:workingcopy: " + nodePair));
                    }
                    this.writeLine(file, "Found version of working copy marked as actual working copy: " + nodePair);
                    this.writeLine(file, "Removing cm:workingcopy: " + nodePair);
                    this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_WORKING_COPY);
                }
            }
        }
        this.nodeService.removeProperty(nodeRef, PROP_SOURCE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WorkProvider
    implements BatchProcessWorkProvider<Pair<Long, NodeRef>> {
        private long maxId = Long.MAX_VALUE;
        private long workCount = Long.MAX_VALUE;
        private long currentId = 0L;
        private final Set<QName> aspectQNames;

        private WorkProvider(Set<QName> aspectQNames) {
            this.aspectQNames = aspectQNames;
        }

        @Override
        public synchronized int getTotalEstimatedWorkSize() {
            if (this.maxId == Long.MAX_VALUE) {
                this.maxId = CopiedFromAspectPatch.this.patchDAO.getMaxAdmNodeID();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\tQ: Max node id: " + this.maxId));
                }
            }
            if (this.workCount == Long.MAX_VALUE) {
                this.workCount = CopiedFromAspectPatch.this.patchDAO.getCountNodesWithAspects(this.aspectQNames);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\tQ: Work count: " + this.workCount));
                }
            }
            return (int)this.workCount;
        }

        @Override
        public synchronized Collection<Pair<Long, NodeRef>> getNextWork() {
            final HashSet<Pair<Long, NodeRef>> results = new HashSet<Pair<Long, NodeRef>>(CopiedFromAspectPatch.this.batchMaxQueryRange * 2);
            final ArrayList<Long> nodeIds = new ArrayList<Long>(CopiedFromAspectPatch.this.batchMaxQueryRange);
            NodeDAO.NodeRefQueryCallback callback = new NodeDAO.NodeRefQueryCallback(){

                @Override
                public boolean handle(Pair<Long, NodeRef> nodePair) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\tQ: Recording node work: " + nodePair));
                    }
                    results.add(nodePair);
                    nodeIds.add(nodePair.getFirst());
                    return true;
                }
            };
            while (this.currentId <= this.maxId) {
                CopiedFromAspectPatch.this.nodeDAO.getNodesWithAspects(this.aspectQNames, this.currentId, this.currentId + (long)CopiedFromAspectPatch.this.batchMaxQueryRange, callback);
                this.currentId += (long)CopiedFromAspectPatch.this.batchMaxQueryRange;
            }
            CopiedFromAspectPatch.this.nodeDAO.cacheNodesById(nodeIds);
            return results;
        }
    }
}

