/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.service.cmr.admin.PatchException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.springframework.context.MessageSource;
import org.springframework.extensions.surf.util.I18NUtil;

public class EmailTemplatesInviteAndNotifyFoldersPatch
extends AbstractPatch {
    public static final String PROPERTY_COMPANY_HOME_CHILDNAME = "spaces.company_home.childname";
    public static final String PROPERTY_DICTIONARY_CHILDNAME = "spaces.dictionary.childname";
    public static final String PROPERTY_EMAIL_TEMPLATES_FOLDER_CHILDNAME = "spaces.templates.email.childname";
    public static final String PROPERTY_EMAIL_NOTIFY_TEMPLATES_FOLDER_CHILDNAME = "spaces.templates.email.notify.childname";
    public static final String PROPERTY_EMAIL_INVITE_TEMPLATES_FOLDER_CHILDNAME = "spaces.templates.email.invite1.childname";
    private static final String PROPERTY_EMAIL_NOTIFY_TEMPLATES_FOLDER_NAME = "spaces.notify_templates.email.name";
    private static final String PROPERTY_EMAIL_NOTIFY_TEMPLATES_FOLDER_DESCRIPTION = "spaces.notify_templates.email.description";
    private static final String PROPERTY_EMAIL_INVITE_TEMPLATES_FOLDER_NAME = "spaces.invite_templates.email.name";
    private static final String PROPERTY_EMAIL_INVITE_TEMPLATES_FOLDER_DESCRIPTION = "spaces.invite_templates.email.description";
    private static final String SAMPLE_NOTIFY_TEMPLATE_NAME = "notify_user_email.ftl.sample";
    private static final String INVITE_TEMPLATE_NAME = "invite_user_email.ftl";
    private static final String MSG_EMAIL_INVITE_TEMPLATES_FOLDER_EXISTS = "patch.emailInviteTemplatesFolder.result.exists";
    private static final String MSG_EMAIL_INVITE_TEMPLATES_FOLDER_CREATED = "patch.emailInviteTemplatesFolder.result.created";
    private static final String MSG_EMAIL_NOTIFY_TEMPLATES_FOLDER_EXISTS = "patch.emailNotifyTemplatesFolder.result.exists";
    private static final String MSG_EMAIL_NOTIFY_TEMPLATES_FOLDER_CREATED = "patch.emailNotifyTemplatesFolder.result.created";
    private static final String PROPERTY_ICON = "space-icon-default";
    private ImporterBootstrap importerBootstrap;
    private MessageSource messageSource;
    protected NodeRef emailNotifyTemplatesFolderNodeRef;
    protected NodeRef emailInviteTemplatesFolderNodeRef;
    protected Properties configuration;
    protected NodeRef emailTemplatesFolderNodeRef;
    private String emailTemplatesFolderXPath;

    public void setImporterBootstrap(ImporterBootstrap importerBootstrap) {
        this.importerBootstrap = importerBootstrap;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    protected void checkCommonProperties() throws Exception {
        this.checkPropertyNotNull((Object)this.importerBootstrap, "importerBootstrap");
        this.checkPropertyNotNull(this.messageSource, "messageSource");
    }

    protected void setUp() throws Exception {
        StoreRef storeRef = this.importerBootstrap.getStoreRef();
        if (storeRef == null) {
            throw new PatchException("Bootstrap store has not been set");
        }
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        this.configuration = this.importerBootstrap.getConfiguration();
        String companyHomeChildName = this.configuration.getProperty(PROPERTY_COMPANY_HOME_CHILDNAME);
        if (companyHomeChildName == null || companyHomeChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.company_home.childname' is not present");
        }
        String dictionaryChildName = this.configuration.getProperty(PROPERTY_DICTIONARY_CHILDNAME);
        if (dictionaryChildName == null || dictionaryChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.dictionary.childname' is not present");
        }
        String emailTemplatesChildName = this.configuration.getProperty(PROPERTY_EMAIL_TEMPLATES_FOLDER_CHILDNAME);
        if (emailTemplatesChildName == null || emailTemplatesChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.templates.email.childname' is not present");
        }
        String emailNotifyTemplatesChildName = this.configuration.getProperty(PROPERTY_EMAIL_NOTIFY_TEMPLATES_FOLDER_CHILDNAME);
        if (emailNotifyTemplatesChildName == null || emailNotifyTemplatesChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.templates.email.notify.childname' is not present");
        }
        String emailInviteTemplatesChildName = this.configuration.getProperty(PROPERTY_EMAIL_INVITE_TEMPLATES_FOLDER_CHILDNAME);
        if (emailInviteTemplatesChildName == null || emailInviteTemplatesChildName.length() == 0) {
            throw new PatchException("Bootstrap property 'spaces.templates.email.invite1.childname' is not present");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/").append(companyHomeChildName).append("/").append(dictionaryChildName).append("/").append(emailTemplatesChildName);
        this.emailTemplatesFolderXPath = sb.toString();
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, this.emailTemplatesFolderXPath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() == 0) {
            throw new PatchException("XPath didn't return any results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + this.emailTemplatesFolderXPath);
        }
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   root: " + storeRootNodeRef + "\n" + "   xpath: " + this.emailTemplatesFolderXPath + "\n" + "   results: " + nodeRefs);
        }
        this.emailTemplatesFolderNodeRef = (NodeRef)nodeRefs.get(0);
        this.emailNotifyTemplatesFolderNodeRef = this.searchFolder(emailNotifyTemplatesChildName);
        this.emailInviteTemplatesFolderNodeRef = this.searchFolder(emailInviteTemplatesChildName);
    }

    protected String applyInternal() throws Exception {
        this.checkCommonProperties();
        if (this.messageSource == null) {
            throw new PatchException("'messageSource' property has not been set");
        }
        this.setUp();
        StringBuffer msg = new StringBuffer();
        if (this.emailNotifyTemplatesFolderNodeRef == null) {
            this.emailNotifyTemplatesFolderNodeRef = this.createFolderAndMoveTemplate(PROPERTY_EMAIL_NOTIFY_TEMPLATES_FOLDER_CHILDNAME, PROPERTY_EMAIL_NOTIFY_TEMPLATES_FOLDER_NAME, PROPERTY_EMAIL_NOTIFY_TEMPLATES_FOLDER_DESCRIPTION, SAMPLE_NOTIFY_TEMPLATE_NAME);
            msg.append(I18NUtil.getMessage((String)MSG_EMAIL_NOTIFY_TEMPLATES_FOLDER_CREATED, (Object[])new Object[]{this.emailNotifyTemplatesFolderNodeRef}));
        } else {
            msg.append(I18NUtil.getMessage((String)MSG_EMAIL_NOTIFY_TEMPLATES_FOLDER_EXISTS, (Object[])new Object[]{this.emailNotifyTemplatesFolderNodeRef}));
        }
        msg.append("; ");
        if (this.emailInviteTemplatesFolderNodeRef == null) {
            this.emailInviteTemplatesFolderNodeRef = this.createFolderAndMoveTemplate(PROPERTY_EMAIL_INVITE_TEMPLATES_FOLDER_CHILDNAME, PROPERTY_EMAIL_INVITE_TEMPLATES_FOLDER_NAME, PROPERTY_EMAIL_INVITE_TEMPLATES_FOLDER_DESCRIPTION, INVITE_TEMPLATE_NAME);
            msg.append(I18NUtil.getMessage((String)MSG_EMAIL_INVITE_TEMPLATES_FOLDER_CREATED, (Object[])new Object[]{this.emailNotifyTemplatesFolderNodeRef}));
        } else {
            msg.append(I18NUtil.getMessage((String)MSG_EMAIL_INVITE_TEMPLATES_FOLDER_EXISTS, (Object[])new Object[]{this.emailNotifyTemplatesFolderNodeRef}));
        }
        return msg.toString();
    }

    private NodeRef searchFolder(String xpath) {
        List nodeRefs = this.searchService.selectNodes(this.emailTemplatesFolderNodeRef, xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.size() > 1) {
            throw new PatchException("XPath returned too many results: \n   email templates node: " + this.emailTemplatesFolderNodeRef + "\n" + "   xpath: " + xpath + "\n" + "   results: " + nodeRefs);
        }
        if (nodeRefs.size() == 0) {
            return null;
        }
        return (NodeRef)nodeRefs.get(0);
    }

    private NodeRef createFolderAndMoveTemplate(String folderChildName, String folderName, String folderDescription, String templateName) {
        String emailTemplatesChildName = this.configuration.getProperty(folderChildName);
        if (emailTemplatesChildName == null) {
            throw new PatchException("Bootstrap property '" + folderChildName + "' is not present");
        }
        String emailTemplatesName = this.messageSource.getMessage(folderName, null, I18NUtil.getLocale());
        if (emailTemplatesName == null || emailTemplatesName.length() == 0) {
            throw new PatchException("Bootstrap property '" + folderName + "' is not present");
        }
        String emailTemplatesDescription = this.messageSource.getMessage(folderDescription, null, I18NUtil.getLocale());
        if (emailTemplatesDescription == null || emailTemplatesDescription.length() == 0) {
            throw new PatchException("Bootstrap property '" + folderDescription + "' is not present");
        }
        HashMap<QName, String> properties = new HashMap<QName, String>(7);
        properties.put(ContentModel.PROP_NAME, emailTemplatesName);
        properties.put(ContentModel.PROP_TITLE, emailTemplatesName);
        properties.put(ContentModel.PROP_DESCRIPTION, emailTemplatesDescription);
        properties.put(ApplicationModel.PROP_ICON, PROPERTY_ICON);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.emailTemplatesFolderNodeRef, ContentModel.ASSOC_CONTAINS, QName.resolveToQName((NamespacePrefixResolver)this.namespaceService, (String)emailTemplatesChildName), ContentModel.TYPE_FOLDER, properties);
        NodeRef createdFolderNodeRef = childAssocRef.getChildRef();
        this.nodeService.addAspect(createdFolderNodeRef, ApplicationModel.ASPECT_UIFACETS, null);
        String xpath = this.emailTemplatesFolderXPath + "/cm:" + templateName;
        List templateNodeRefs = this.searchService.selectNodes(this.emailTemplatesFolderNodeRef, xpath, null, (NamespacePrefixResolver)this.namespaceService, false);
        for (NodeRef templateNodeRef : templateNodeRefs) {
            QName qname = this.nodeService.getPrimaryParent(templateNodeRef).getQName();
            this.nodeService.moveNode(templateNodeRef, createdFolderNodeRef, ContentModel.ASSOC_CHILDREN, qname);
        }
        return createdFolderNodeRef;
    }
}

