/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.batch.BatchProcessor;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.extensions.surf.util.I18NUtil;

public class FixUserQNamesPatch
extends AbstractPatch
implements ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog(FixUserQNamesPatch.class);
    private static final String MSG_SUCCESS = "patch.fixUserQNames.result";
    private QNameDAO qnameDAO;
    private RuleService ruleService;
    private ImporterBootstrap userBootstrap;

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setUserBootstrap(ImporterBootstrap userBootstrap) {
        this.userBootstrap = userBootstrap;
    }

    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull(this.qnameDAO, "qnameDAO");
        this.checkPropertyNotNull((Object)this.userBootstrap, "userBootstrap");
    }

    protected String applyInternal() throws Exception {
        List toProcess = this.nodeService.getChildAssocs(this.getUserFolderLocation(), (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)ContentModel.TYPE_USER, false);
        BatchProcessor<ChildAssociationRef> batchProcessor = new BatchProcessor<ChildAssociationRef>("FixUserQNamesPatch", this.transactionHelper, toProcess, 2, 20, this.applicationEventPublisher, logger, 1000);
        final String runAsUser = AuthenticationUtil.getRunAsUser();
        int updated = batchProcessor.process(new BatchProcessor.BatchProcessWorker<ChildAssociationRef>(){

            @Override
            public void beforeProcess() throws Throwable {
                FixUserQNamesPatch.this.ruleService.disableRules();
                AuthenticationUtil.setRunAsUser((String)runAsUser);
            }

            @Override
            public void afterProcess() throws Throwable {
                FixUserQNamesPatch.this.ruleService.enableRules();
                AuthenticationUtil.clearCurrentSecurityContext();
            }

            @Override
            public String getIdentifier(ChildAssociationRef entry) {
                return entry.getChildRef().toString();
            }

            @Override
            public void process(ChildAssociationRef entry) throws Throwable {
                QName userQName = QName.createQName((String)"http://www.alfresco.org/model/user/1.0", (String)((String)((Object)FixUserQNamesPatch.this.nodeService.getProperty(entry.getChildRef(), ContentModel.PROP_USER_USERNAME))));
                if (!userQName.equals((Object)ContentModel.TYPE_USER)) {
                    FixUserQNamesPatch.this.nodeService.moveNode(entry.getChildRef(), entry.getParentRef(), entry.getTypeQName(), userQName);
                }
            }
        }, true);
        return I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{updated});
    }

    private NodeRef getUserFolderLocation() {
        NodeRef rootNode = this.nodeService.getRootNode(this.userBootstrap.getStoreRef());
        QName qnameAssocSystem = QName.createQName((String)"sys", (String)"system", (NamespacePrefixResolver)this.namespaceService);
        QName qnameAssocUsers = QName.createQName((String)"sys", (String)"people", (NamespacePrefixResolver)this.namespaceService);
        List results = this.nodeService.getChildAssocs(rootNode, RegexQNamePattern.MATCH_ALL, (QNamePattern)qnameAssocSystem);
        NodeRef sysNodeRef = null;
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Required authority system folder path not found: " + qnameAssocSystem);
        }
        sysNodeRef = ((ChildAssociationRef)results.get(0)).getChildRef();
        if ((results = this.nodeService.getChildAssocs(sysNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)qnameAssocUsers)).size() == 0) {
            throw new AlfrescoRuntimeException("Required user folder path not found: " + qnameAssocUsers);
        }
        return ((ChildAssociationRef)results.get(0)).getChildRef();
    }
}

