/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericEMailTemplateUpdatePatch
extends AbstractPatch {
    protected ContentService contentService;
    protected FileFolderService fileFolderService;
    private boolean updateBaseFile = true;
    private boolean createSiblingIfMissing = true;

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setCreateSiblingIfMissing(boolean createSiblingIfMissing) {
        this.createSiblingIfMissing = createSiblingIfMissing;
    }

    public void setUpdateBaseFile(boolean updateBaseFile) {
        this.updateBaseFile = updateBaseFile;
    }

    protected void updateTemplates() throws Exception {
        NodeRef baseTemplate = this.getBaseTemplate();
        if (this.nodeService.exists(baseTemplate)) {
            if (this.updateBaseFile) {
                this.updateContent(baseTemplate, this.getPath(), this.getBaseFileName(), false);
            }
            for (String siblingFile : this.getSiblingFiles()) {
                this.updateSiblingContent(baseTemplate, this.getPath(), siblingFile);
            }
        }
    }

    protected abstract NodeRef getBaseTemplate();

    protected abstract String getPath();

    protected abstract String getBaseFileName();

    protected abstract String[] getLocales();

    protected List<String> getSiblingFiles() {
        ArrayList<String> siblingFiles = new ArrayList<String>(this.getLocales().length);
        for (String locale : this.getLocales()) {
            siblingFiles.add(this.makeSiblingFileName(this.getBaseFileName(), locale));
        }
        return siblingFiles;
    }

    private String makeSiblingFileName(String baseFileName, String locale) {
        int index = baseFileName.lastIndexOf(".");
        StringBuilder builder = new StringBuilder();
        builder.append(baseFileName.substring(0, index)).append("_").append(locale).append(baseFileName.substring(index));
        return builder.toString();
    }

    private void updateSiblingContent(NodeRef nodeRef, String path, String fileName) {
        NodeRef parent = this.nodeService.getPrimaryParent(nodeRef).getParentRef();
        if (parent != null) {
            NodeRef sibling = this.fileFolderService.searchSimple(parent, fileName);
            if (sibling != null) {
                this.updateContent(sibling, path, fileName, false);
            } else if (this.createSiblingIfMissing) {
                sibling = this.fileFolderService.create(parent, fileName, ContentModel.TYPE_CONTENT).getNodeRef();
                this.updateContent(sibling, path, fileName, true);
            }
        }
    }

    private void updateContent(NodeRef nodeRef, String path, String fileName, boolean newFile) {
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path + fileName);
        if (is != null) {
            ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
            if (newFile) {
                contentWriter.setMimetype("text/plain");
                contentWriter.setEncoding("UTF-8");
            }
            contentWriter.putContent(is);
        }
    }
}

