/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiTFixAdminExistingTenantsPatch
extends AbstractPatch {
    private static final String MSG_RESULT = "patch.mtFixAdminExistingTenants.result";
    private TenantService tenantService;
    private BehaviourFilter policyBehaviourFilter;
    private NodeDAO nodeDAO;
    private List<String> pathsToNodes;

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
    }

    public void setPathsToNodes(List<String> pathsToNodes) {
        this.pathsToNodes = pathsToNodes;
    }

    @Override
    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull(this.tenantService, "tenantService");
        this.checkPropertyNotNull(this.nodeDAO, "nodeDAO");
        this.checkPropertyNotNull(this.pathsToNodes, "pathsToNodes");
    }

    @Override
    protected String applyInternal() throws Exception {
        String currentUserDomain = this.tenantService.getCurrentUserDomain();
        for (String xpathToNode : this.pathsToNodes) {
            this.fixAuditable(currentUserDomain, xpathToNode);
        }
        return I18NUtil.getMessage((String)MSG_RESULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixAuditable(String currentUserDomain, String xpathToNode) {
        NodeRef nodeRef;
        Pair<Long, NodeRef> nodePair;
        NodeRef rootNodeRef = this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        List nodeRefs = this.searchService.selectNodes(rootNodeRef, xpathToNode, null, (NamespacePrefixResolver)this.namespaceService, false, "xpath");
        if (nodeRefs.size() > 0 && (nodePair = this.nodeDAO.getNodePair(this.tenantService.getName(nodeRef = (NodeRef)nodeRefs.get(0)))) != null) {
            String tenantSystem = this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), currentUserDomain);
            HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(2);
            props.put(ContentModel.PROP_MODIFIER, (Serializable)((Object)tenantSystem));
            props.put(ContentModel.PROP_CREATOR, (Serializable)((Object)tenantSystem));
            try {
                this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                this.nodeDAO.addNodeProperties((Long)nodePair.getFirst(), props);
                Object var10_9 = null;
                this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                throw throwable;
            }
        }
    }
}

