/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.audit.BeanIdentifier;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;

public class BeanIdentifierImpl
implements BeanIdentifier,
BeanFactoryAware {
    private static Log s_logger = LogFactory.getLog(BeanIdentifierImpl.class);
    private static ThreadLocal<HashMap<Method, String>> methodToBeanMap = new ThreadLocal();
    private ListableBeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public String getBeanName(MethodInvocation mi) {
        return this.getName(mi);
    }

    private String getName(MethodInvocation mi) throws BeansException {
        if (methodToBeanMap.get() == null) {
            methodToBeanMap.set(new HashMap());
        }
        Method method = mi.getMethod();
        String name = methodToBeanMap.get().get(method);
        if (name == null) {
            name = this.getBeanNameImpl(mi);
            methodToBeanMap.get().put(method, name);
        } else if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Cached look up for " + name + "." + method.getName()));
        }
        return name;
    }

    private String getBeanNameImpl(MethodInvocation mi) throws BeansException {
        if (mi instanceof ProxyMethodInvocation) {
            Object proxy = ((ProxyMethodInvocation)mi).getProxy();
            Map beans = this.beanFactory.getBeansOfType(proxy.getClass());
            for (Map.Entry entry : beans.entrySet()) {
                String name = (String)entry.getKey();
                if (proxy != entry.getValue() || name.equals("DescriptorService")) continue;
                return name;
            }
        }
        return null;
    }
}

