/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit.access;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.audit.access.NodeChange;
import org.alfresco.repo.audit.access.NodeInfoFactory;
import org.alfresco.repo.audit.model.AuditApplication;
import org.alfresco.repo.coci.CheckOutCheckInServicePolicies;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.repo.version.VersionServicePolicies;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessAuditor
implements InitializingBean,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnMoveNodePolicy,
NodeServicePolicies.OnRemoveAspectPolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
ContentServicePolicies.OnContentReadPolicy,
ContentServicePolicies.OnContentUpdatePolicy,
VersionServicePolicies.OnCreateVersionPolicy,
CopyServicePolicies.OnCopyCompletePolicy,
CheckOutCheckInServicePolicies.OnCheckOut,
CheckOutCheckInServicePolicies.OnCheckIn,
CheckOutCheckInServicePolicies.OnCancelCheckOut {
    private static Log logger = LogFactory.getLog(AccessAuditor.class);
    private static final String ROOT_PATH = "/alfresco-access";
    private static final String TRANSACTION = "transaction";
    private static final String AUDIT_SUB_ACTIONS = "audit.alfresco-access.sub-actions.enabled";
    private Properties properties;
    private PolicyComponent policyComponent;
    private AuditComponent auditComponent;
    private TransactionService transactionService;
    private NodeInfoFactory nodeInfoFactory;
    private NamespaceService namespaceService;
    private TransactionListener transactionListener = new AccessTransactionListener();
    private boolean auditSubActions = false;

    public void setProperties(Properties properties) {
        this.properties = properties;
        this.auditSubActions = properties.getProperty(AUDIT_SUB_ACTIONS, "false").equalsIgnoreCase("true");
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setAuditComponent(AuditComponent auditComponent) {
        this.auditComponent = auditComponent;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeInfoFactory(NodeInfoFactory nodeInfoFactory) {
        this.nodeInfoFactory = nodeInfoFactory;
    }

    public void afterPropertiesSet() {
        PropertyCheck.mandatory((Object)this, (String)"properties", (Object)this.properties);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"auditComponent", (Object)this.auditComponent);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)this, (String)"nodeInfoFactory", (Object)this.nodeInfoFactory);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onMoveNode"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnAddAspectPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onAddAspect"));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnRemoveAspectPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onRemoveAspect"));
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onContentUpdate"));
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentReadPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onContentRead"));
        this.policyComponent.bindClassBehaviour(VersionServicePolicies.OnCreateVersionPolicy.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "onCreateVersion"));
        this.policyComponent.bindClassBehaviour(VersionServicePolicies.OnCreateVersionPolicy.QNAME, ContentModel.TYPE_FOLDER, (Behaviour)new JavaBehaviour(this, "onCreateVersion"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyCompletePolicy.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "onCopyComplete"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyCompletePolicy.QNAME, ContentModel.TYPE_FOLDER, (Behaviour)new JavaBehaviour(this, "onCopyComplete"));
        this.policyComponent.bindClassBehaviour(CheckOutCheckInServicePolicies.OnCheckOut.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "onCheckOut"));
        this.policyComponent.bindClassBehaviour(CheckOutCheckInServicePolicies.OnCheckIn.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "onCheckIn"));
        this.policyComponent.bindClassBehaviour(CheckOutCheckInServicePolicies.OnCancelCheckOut.QNAME, ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "onCancelCheckOut"));
    }

    private boolean auditEnabled() {
        return this.transactionService.getAllowWrite() && this.auditComponent.areAuditValuesRequired(ROOT_PATH);
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        if (this.auditEnabled()) {
            this.getNodeChange(nodeRef).beforeDeleteNode(nodeRef);
        }
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        if (this.auditEnabled()) {
            this.getNodeChange(childAssocRef.getChildRef()).onCreateNode(childAssocRef);
        }
    }

    @Override
    public void onMoveNode(ChildAssociationRef fromChildAssocRef, ChildAssociationRef toChildAssocRef) {
        if (this.auditEnabled()) {
            this.getNodeChange(toChildAssocRef.getChildRef()).onMoveNode(fromChildAssocRef, toChildAssocRef);
        }
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> fromProperties, Map<QName, Serializable> toProperties) {
        if (this.auditEnabled()) {
            this.getNodeChange(nodeRef).onUpdateProperties(nodeRef, fromProperties, toProperties);
        }
    }

    @Override
    public void onRemoveAspect(NodeRef nodeRef, QName aspect) {
        if (this.auditEnabled()) {
            this.getNodeChange(nodeRef).onRemoveAspect(nodeRef, aspect);
        }
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspect) {
        if (this.auditEnabled()) {
            this.getNodeChange(nodeRef).onAddAspect(nodeRef, aspect);
        }
    }

    @Override
    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        if (this.auditEnabled()) {
            this.getNodeChange(nodeRef).onContentUpdate(nodeRef, newContent);
        }
    }

    @Override
    public void onContentRead(NodeRef nodeRef) {
        if (this.auditEnabled()) {
            this.getNodeChange(nodeRef).onContentRead(nodeRef);
        }
    }

    @Override
    public void onCreateVersion(QName classRef, NodeRef nodeRef, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
        if (this.auditEnabled()) {
            this.getNodeChange(nodeRef).onCreateVersion(classRef, nodeRef, versionProperties, nodeDetails);
        }
    }

    @Override
    public void onCopyComplete(QName classRef, NodeRef sourceNodeRef, NodeRef targetNodeRef, boolean copyToNewNode, Map<NodeRef, NodeRef> copyMap) {
        if (this.auditEnabled()) {
            this.getNodeChange(targetNodeRef).onCopyComplete(classRef, sourceNodeRef, targetNodeRef, copyToNewNode, copyMap);
        }
    }

    @Override
    public void onCheckOut(NodeRef workingCopy) {
        if (this.auditEnabled()) {
            this.getNodeChange(workingCopy).onCheckOut(workingCopy);
        }
    }

    @Override
    public void onCheckIn(NodeRef nodeRef) {
        if (this.auditEnabled()) {
            this.getNodeChange(nodeRef).onCheckIn(nodeRef);
        }
    }

    @Override
    public void onCancelCheckOut(NodeRef nodeRef) {
        if (this.auditEnabled()) {
            this.getNodeChange(nodeRef).onCancelCheckOut(nodeRef);
        }
    }

    private NodeChange getNodeChange(NodeRef nodeRef) {
        NodeChange nodeChange;
        Map<NodeRef, NodeChange> accessAuditNodes = TransactionalResourceHelper.getMap(this.transactionListener);
        if (accessAuditNodes.isEmpty()) {
            AlfrescoTransactionSupport.bindListener(this.transactionListener);
        }
        if ((nodeChange = (NodeChange)accessAuditNodes.get(nodeRef)) == null) {
            nodeChange = new NodeChange(this.nodeInfoFactory, this.namespaceService, nodeRef);
            nodeChange.setAuditSubActions(this.auditSubActions);
            accessAuditNodes.put(nodeRef, nodeChange);
        }
        return nodeChange;
    }

    private boolean recordAuditValues(String action, Map<String, Serializable> auditMap) {
        String rootPath = AuditApplication.buildPath(ROOT_PATH, action);
        Map<String, Serializable> recordedAuditMap = this.auditComponent.recordAuditValues(rootPath, auditMap);
        if (!recordedAuditMap.isEmpty()) {
            if (logger.isDebugEnabled()) {
                boolean devOutput = logger.isTraceEnabled();
                StringBuilder sb = new StringBuilder();
                StringBuilder subActions = new StringBuilder("");
                if (!devOutput) {
                    sb.append("\n\tAudit data:");
                    for (String key : new TreeSet<String>(recordedAuditMap.keySet())) {
                        sb.append("\n\t\t").append(key).append('=');
                        this.appendAuditMapValue(sb, recordedAuditMap.get(key));
                    }
                    sb.append("\n\n\tInbound audit values: ");
                }
                for (String key : new TreeSet<String>(auditMap.keySet())) {
                    if (devOutput && NodeChange.SUMMARY_KEYS.contains(key)) continue;
                    StringBuilder output = key.startsWith("sub-action/") ? subActions : sb;
                    output.append("\n\t\t").append(rootPath).append('/').append(key).append('=');
                    this.appendAuditMapValue(output, auditMap.get(key));
                }
                if (subActions.length() > 0) {
                    sb.append("\n\t\t--- sub actions ---");
                    sb.append(subActions.toString());
                }
                if (devOutput) {
                    logger.trace((Object)sb.toString());
                } else {
                    logger.debug((Object)sb.toString());
                }
            }
            return true;
        }
        return false;
    }

    private void appendAuditMapValue(StringBuilder sb, Serializable value) {
        if (value instanceof QName) {
            sb.append(((QName)value).toPrefixString());
        } else if (value instanceof Map) {
            sb.append('{');
            boolean first = true;
            Map map = (Map)((Object)value);
            for (Map.Entry entry : map.entrySet()) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                Serializable key = (Serializable)entry.getKey();
                Serializable val = (Serializable)entry.getValue();
                this.appendAuditMapValue(sb, key);
                sb.append('=');
                this.appendAuditMapValue(sb, val);
            }
            sb.append('}');
        } else if (value instanceof List) {
            sb.append('[');
            boolean first = true;
            List list = (List)((Object)value);
            for (Object element : list) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                this.appendAuditMapValue(sb, (Serializable)element);
            }
            sb.append(']');
        } else if (value instanceof Set) {
            sb.append('[');
            boolean first = true;
            Set set = (Set)((Object)value);
            for (Object element : set) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                this.appendAuditMapValue(sb, (Serializable)element);
            }
            sb.append(']');
        } else {
            sb.append(value);
        }
    }

    private class AccessTransactionListener
    extends TransactionListenerAdapter {
        private AccessTransactionListener() {
        }

        public void afterCommit() {
            Map changedNodes = TransactionalResourceHelper.getMap(this);
            for (Map.Entry entry : changedNodes.entrySet()) {
                NodeChange nodeChange = (NodeChange)entry.getValue();
                if (nodeChange.isTemporaryNode()) continue;
                Map<String, Serializable> auditMap = nodeChange.getAuditData(false);
                AccessAuditor.this.recordAuditValues(AccessAuditor.TRANSACTION, auditMap);
            }
        }
    }
}

