/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit.access;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.audit.AuditComponent;
import org.alfresco.repo.audit.access.AccessAuditor;
import org.alfresco.repo.audit.access.NodeInfoFactory;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.debug.NodeStoreInspector;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ComparisonFailure;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessAuditorTest {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private static ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
    private static NodeService nodeService = serviceRegistry.getNodeService();
    private static TransactionService transactionService = serviceRegistry.getTransactionService();
    private static NamespaceService namespaceService = serviceRegistry.getNamespaceService();
    private static PolicyComponent policyComponent = (PolicyComponent)ctx.getBean("policyComponent");
    private static AuthenticationComponent authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
    private static StoreRef storeRef;
    private static NodeRef homeFolder;
    private static NodeRef folder0;
    private static NodeRef folder1;
    private static NodeRef folder2;
    private static NodeRef folder3;
    private static NodeRef content0;
    private static NodeRef content1;
    private static NodeRef content2;
    private static NodeRef content3;
    private static AccessAuditor auditor;
    private static Properties properties;
    private static NodeRef workingCopyNodeRef;
    private UserTransaction txn;
    private static List<Map<String, Serializable>> auditMapList;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        AuthenticationUtil.setRunAsUserSystem();
        storeRef = nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        NodeRef rootNodeRef = nodeService.getRootNode(storeRef);
        homeFolder = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"homeFolder"), ContentModel.TYPE_FOLDER).getChildRef();
        folder0 = AccessAuditorTest.newFolder(homeFolder, "folder0");
        folder1 = AccessAuditorTest.newFolder(homeFolder, "folder1");
        folder2 = AccessAuditorTest.newFolder(homeFolder, "folder2");
        folder3 = AccessAuditorTest.newFolder(homeFolder, "folder3");
        content0 = AccessAuditorTest.newContent(folder0, "content0");
        content1 = AccessAuditorTest.newContent(folder1, "content1");
        content2 = AccessAuditorTest.newContent(folder2, "content2");
        content3 = AccessAuditorTest.newContent(folder3, "content3");
        System.out.println(NodeStoreInspector.dumpNodeStore(nodeService, storeRef));
        try {
            authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable e) {
            // empty catch block
        }
        AuditComponent auditComponent = (AuditComponent)Mockito.mock(AuditComponent.class);
        Mockito.when((Object)auditComponent.areAuditValuesRequired(Matchers.anyString())).thenReturn((Object)true);
        Mockito.when(auditComponent.recordAuditValues(Matchers.anyString(), Matchers.anyMap())).thenAnswer((Answer)new Answer<Map<String, Serializable>>(){

            public Map<String, Serializable> answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                Map auditMap = (Map)args[1];
                if ("/alfresco-access/transaction".equals(args[0])) {
                    auditMapList.add(auditMap);
                }
                return auditMap;
            }
        });
        properties = new Properties();
        properties.put("audit.alfresco-access.sub-actions.enabled", "false");
        auditor = new AccessAuditor();
        auditor.setTransactionService(transactionService);
        auditor.setNamespaceService(namespaceService);
        auditor.setNodeInfoFactory(new NodeInfoFactory(nodeService, namespaceService));
        auditor.setPolicyComponent(policyComponent);
        auditor.setProperties(properties);
        auditor.setAuditComponent(auditComponent);
        auditor.afterPropertiesSet();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AuthenticationUtil.setRunAsUserSystem();
        System.out.println(NodeStoreInspector.dumpNodeStore(nodeService, storeRef));
        nodeService.deleteStore(storeRef);
        try {
            authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        properties = null;
        auditor = null;
    }

    @Before
    public void setUp() throws Exception {
        authenticationComponent.setSystemUserAsCurrentUser();
        this.txn = transactionService.getUserTransaction();
        this.txn.begin();
    }

    @After
    public void tearDown() throws Exception {
        try {
            authenticationComponent.clearCurrentSecurityContext();
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            if (this.txn != null) {
                this.txn.rollback();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        auditMapList.clear();
    }

    private static NodeRef newFolder(NodeRef parent, String name) {
        return serviceRegistry.getFileFolderService().create(parent, name, ContentModel.TYPE_FOLDER).getNodeRef();
    }

    private static NodeRef newContent(NodeRef parent, String name) {
        PropertyMap propertyMap0 = new PropertyMap();
        propertyMap0.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-16", Locale.ENGLISH));
        NodeRef content = nodeService.createNode(parent, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)name), ContentModel.TYPE_CONTENT, (Map)propertyMap0).getChildRef();
        ContentWriter writer = serviceRegistry.getContentService().getWriter(content, ContentModel.TYPE_CONTENT, true);
        writer.putContent("The cat sat on the mat.");
        return content;
    }

    private Map<String, Serializable> getVersionProperties() {
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        versionProperties.put("description", (Serializable)((Object)"This is a test"));
        return versionProperties;
    }

    private void assertContains(String expected, Serializable actual) {
        String actualString = (String)((Object)actual);
        if (actual == null || !actualString.contains(expected)) {
            throw new ComparisonFailure("Expected not contained in actual.", expected, actualString);
        }
    }

    @Test
    public final void testOnCreateNodeAndOnUpdateProperties() throws Exception {
        AccessAuditorTest.newContent(homeFolder, "content4");
        this.txn.commit();
        this.txn = null;
        Assert.assertEquals((long)1L, (long)auditMapList.size());
        Map<String, Serializable> auditMap = auditMapList.get(0);
        Assert.assertEquals((Object)"CREATE", (Object)auditMap.get("action"));
        this.assertContains("createNode", auditMap.get("sub-actions"));
        this.assertContains("updateNodeProperties", auditMap.get("sub-actions"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:content4", (Object)auditMap.get("path"));
        Assert.assertEquals((Object)"cm:content", (Object)auditMap.get("type"));
    }

    @Test
    public final void testOnCopyComplete() throws Exception {
        serviceRegistry.getFileFolderService().copy(content2, folder1, null);
        this.txn.commit();
        this.txn = null;
        Assert.assertEquals((long)1L, (long)auditMapList.size());
        Map<String, Serializable> auditMap = auditMapList.get(0);
        Assert.assertEquals((Object)"COPY", (Object)auditMap.get("action"));
        this.assertContains("createNode", auditMap.get("sub-actions"));
        this.assertContains("updateNodeProperties", auditMap.get("sub-actions"));
        this.assertContains("addNodeAspect", auditMap.get("sub-actions"));
        this.assertContains("copyNode", auditMap.get("sub-actions"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder1/cm:content2", (Object)auditMap.get("path"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder2/cm:content2", (Object)auditMap.get("copy/from/path"));
        Assert.assertEquals((Object)"cm:content", (Object)auditMap.get("type"));
    }

    @Test
    public final void testOnCopyCompleteAndNewName() throws Exception {
        serviceRegistry.getFileFolderService().copy(content2, folder1, "newName1");
        this.txn.commit();
        this.txn = null;
        Assert.assertEquals((long)1L, (long)auditMapList.size());
        Map<String, Serializable> auditMap = auditMapList.get(0);
        Assert.assertEquals((Object)"COPY", (Object)auditMap.get("action"));
        this.assertContains("createNode", auditMap.get("sub-actions"));
        this.assertContains("updateNodeProperties", auditMap.get("sub-actions"));
        this.assertContains("addNodeAspect", auditMap.get("sub-actions"));
        this.assertContains("copyNode", auditMap.get("sub-actions"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder1/cm:newName1", (Object)auditMap.get("path"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder2/cm:content2", (Object)auditMap.get("copy/from/path"));
        Assert.assertEquals((Object)"cm:content", (Object)auditMap.get("type"));
    }

    @Test
    public final void testOnMoveNode() throws Exception {
        serviceRegistry.getNodeService().moveNode(content3, folder1, ContentModel.ASSOC_CONTAINS, null);
        this.txn.commit();
        this.txn = null;
        Assert.assertEquals((long)1L, (long)auditMapList.size());
        Map<String, Serializable> auditMap = auditMapList.get(0);
        Assert.assertEquals((Object)"MOVE", (Object)auditMap.get("action"));
        this.assertContains("moveNode", auditMap.get("sub-actions"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder1/cm:content3", (Object)auditMap.get("path"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder3/cm:content3", (Object)auditMap.get("move/from/path"));
        Assert.assertEquals((Object)"cm:content", (Object)auditMap.get("type"));
    }

    @Test
    public final void testOnMoveNodeAndNewName() throws Exception {
        serviceRegistry.getNodeService().moveNode(content3, folder1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"newName2"));
        this.txn.commit();
        this.txn = null;
        Assert.assertEquals((long)1L, (long)auditMapList.size());
        Map<String, Serializable> auditMap = auditMapList.get(0);
        Assert.assertEquals((Object)"MOVE", (Object)auditMap.get("action"));
        this.assertContains("moveNode", auditMap.get("sub-actions"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder1/cm:newName2", (Object)auditMap.get("path"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder1/cm:content3", (Object)auditMap.get("move/from/path"));
        Assert.assertEquals((Object)"cm:content", (Object)auditMap.get("type"));
    }

    @Test
    public final void testBeforeDeleteNode() throws Exception {
        serviceRegistry.getNodeService().deleteNode(content0);
        this.txn.commit();
        this.txn = null;
        Assert.assertEquals((long)1L, (long)auditMapList.size());
        Map<String, Serializable> auditMap = auditMapList.get(0);
        Assert.assertEquals((Object)"DELETE", (Object)auditMap.get("action"));
        this.assertContains("deleteNode", auditMap.get("sub-actions"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder0/cm:content0", (Object)auditMap.get("path"));
        Assert.assertEquals((Object)"cm:content", (Object)auditMap.get("type"));
    }

    @Test
    public final void testOnAddAspect() throws Exception {
        serviceRegistry.getNodeService().addAspect(content1, ContentModel.ASPECT_AUTHOR, null);
        serviceRegistry.getNodeService().addAspect(content1, ContentModel.ASPECT_OWNABLE, null);
        this.txn.commit();
        this.txn = null;
        Assert.assertEquals((long)1L, (long)auditMapList.size());
        Map<String, Serializable> auditMap = auditMapList.get(0);
        Assert.assertEquals((Object)"addNodeAspect", (Object)auditMap.get("action"));
        this.assertContains("addNodeAspect", auditMap.get("sub-actions"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder1/cm:content1", (Object)auditMap.get("path"));
        Assert.assertEquals((long)2L, (long)((Set)((Object)auditMap.get("aspects/add"))).size());
        Assert.assertTrue((String)"Individual author aspect missing", (boolean)auditMap.containsKey("aspects/add/cm:author"));
        Assert.assertTrue((String)"Individual ownable aspect missing", (boolean)auditMap.containsKey("aspects/add/cm:ownable"));
        Assert.assertEquals((Object)"cm:content", (Object)auditMap.get("type"));
    }

    @Test
    public final void testOnRemoveAspect() throws Exception {
        serviceRegistry.getNodeService().removeAspect(content1, ContentModel.ASPECT_AUTHOR);
        this.txn.commit();
        this.txn = null;
        Assert.assertEquals((long)1L, (long)auditMapList.size());
        Map<String, Serializable> auditMap = auditMapList.get(0);
        Assert.assertEquals((Object)"deleteNodeAspect", (Object)auditMap.get("action"));
        this.assertContains("deleteNodeAspect", auditMap.get("sub-actions"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder1/cm:content1", (Object)auditMap.get("path"));
        Assert.assertEquals((long)1L, (long)((Set)((Object)auditMap.get("aspects/delete"))).size());
        Assert.assertTrue((String)"Individual author aspect missing", (boolean)auditMap.containsKey("aspects/delete/cm:author"));
        Assert.assertEquals((Object)"cm:content", (Object)auditMap.get("type"));
    }

    @Test
    public final void testOnContentUpdate() throws Exception {
        ContentWriter writer = serviceRegistry.getContentService().getWriter(content1, ContentModel.TYPE_CONTENT, true);
        writer.putContent("The cow jumped over the moon.");
        this.txn.commit();
        this.txn = null;
        Assert.assertEquals((long)1L, (long)auditMapList.size());
        Map<String, Serializable> auditMap = auditMapList.get(0);
        Assert.assertEquals((Object)"UPDATE CONTENT", (Object)auditMap.get("action"));
        this.assertContains("updateContent", auditMap.get("sub-actions"));
        this.assertContains("updateNodeProperties", auditMap.get("sub-actions"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder1/cm:content1", (Object)auditMap.get("path"));
        Assert.assertEquals((Object)"cm:content", (Object)auditMap.get("type"));
    }

    @Test
    public final void testOnContentRead() throws Exception {
        serviceRegistry.getContentService().getReader(content1, ContentModel.TYPE_CONTENT);
        this.txn.commit();
        this.txn = null;
        Assert.assertEquals((long)1L, (long)auditMapList.size());
        Map<String, Serializable> auditMap = auditMapList.get(0);
        Assert.assertEquals((Object)"READ", (Object)auditMap.get("action"));
        this.assertContains("readContent", auditMap.get("sub-actions"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder1/cm:content1", (Object)auditMap.get("path"));
        Assert.assertEquals((Object)"cm:content", (Object)auditMap.get("type"));
    }

    @Test
    public final void testOnCreateVersion() throws Exception {
        Map<String, Serializable> versionProperties = this.getVersionProperties();
        serviceRegistry.getVersionService().createVersion(content1, versionProperties);
        this.txn.commit();
        this.txn = null;
        Assert.assertEquals((long)1L, (long)auditMapList.size());
        Map<String, Serializable> auditMap = auditMapList.get(0);
        Assert.assertEquals((Object)"CREATE VERSION", (Object)auditMap.get("action"));
        this.assertContains("updateNodeProperties", auditMap.get("sub-actions"));
        this.assertContains("createVersion", auditMap.get("sub-actions"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder1/cm:content1", (Object)auditMap.get("path"));
        Assert.assertTrue((String)"cm:versionable should be a value with in the set", (boolean)((Set)((Object)auditMap.get("aspects/add"))).contains(ContentModel.ASPECT_VERSIONABLE));
        Assert.assertTrue((String)"Individual versionable aspect should exist", (boolean)auditMap.containsKey("aspects/add/cm:versionable"));
        Assert.assertEquals((Object)"cm:content", (Object)auditMap.get("type"));
    }

    @Test
    public final void testOnCheckOut() throws Exception {
        workingCopyNodeRef = serviceRegistry.getCheckOutCheckInService().checkout(content1);
        this.txn.commit();
        this.txn = null;
        Assert.assertEquals((long)2L, (long)auditMapList.size());
        boolean origIn0 = ((String)((Object)auditMapList.get(0).get("path"))).endsWith("cm:content1");
        Map<String, Serializable> origMap = auditMapList.get(origIn0 ? 0 : 1);
        Map<String, Serializable> workMap = auditMapList.get(origIn0 ? 1 : 0);
        Assert.assertEquals((Object)"addNodeAspect", (Object)origMap.get("action"));
        this.assertContains("updateNodeProperties", origMap.get("sub-actions"));
        Assert.assertEquals((Object)"cm:content", (Object)origMap.get("type"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder1/cm:content1", (Object)origMap.get("path"));
        Assert.assertEquals((Object)"CHECK OUT", (Object)workMap.get("action"));
        this.assertContains("createNode", workMap.get("sub-actions"));
        this.assertContains("createContent", workMap.get("sub-actions"));
        this.assertContains("updateNodeProperties", workMap.get("sub-actions"));
        this.assertContains("addNodeAspect", workMap.get("sub-actions"));
        this.assertContains("copyNode", workMap.get("sub-actions"));
        this.assertContains("checkOut", workMap.get("sub-actions"));
        this.assertContains("createVersion", workMap.get("sub-actions"));
        Assert.assertTrue((String)"Expected working copy", (((String)((Object)workMap.get("path"))).endsWith("(Working Copy)") && ((String)((Object)workMap.get("path"))).startsWith("/cm:homeFolder/cm:folder1/") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"cm:content", (Object)workMap.get("type"));
    }

    @Test
    public final void testOnCheckIn() throws Exception {
        HashMap<String, Serializable> checkinProperties = new HashMap<String, Serializable>();
        checkinProperties.put("description", null);
        checkinProperties.put("versionType", (Serializable)((Object)VersionType.MAJOR));
        serviceRegistry.getCheckOutCheckInService().checkin(workingCopyNodeRef, checkinProperties);
        this.txn.commit();
        this.txn = null;
        Assert.assertEquals((long)2L, (long)auditMapList.size());
        boolean origIn0 = ((String)((Object)auditMapList.get(0).get("path"))).endsWith("cm:content1");
        Map<String, Serializable> origMap = auditMapList.get(origIn0 ? 0 : 1);
        Map<String, Serializable> workMap = auditMapList.get(origIn0 ? 1 : 0);
        Assert.assertEquals((Object)"DELETE", (Object)workMap.get("action"));
        this.assertContains("deleteNode", workMap.get("sub-actions"));
        Assert.assertTrue((String)"Expected working copy", (((String)((Object)workMap.get("path"))).endsWith("(Working Copy)") && ((String)((Object)workMap.get("path"))).startsWith("/cm:homeFolder/cm:folder1/") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"cm:content", (Object)workMap.get("type"));
        Assert.assertEquals((Object)"CHECK IN", (Object)origMap.get("action"));
        this.assertContains("deleteNodeAspect", origMap.get("sub-actions"));
        this.assertContains("addNodeAspect", origMap.get("sub-actions"));
        this.assertContains("copyNode", origMap.get("sub-actions"));
        this.assertContains("createVersion", origMap.get("sub-actions"));
        this.assertContains("updateNodeProperties", origMap.get("sub-actions"));
        this.assertContains("checkIn", origMap.get("sub-actions"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder1/cm:content1", (Object)origMap.get("path"));
        Assert.assertEquals((Object)"cm:content", (Object)origMap.get("type"));
    }

    @Test
    public final void testOnCancelCheckOut() throws Exception {
        workingCopyNodeRef = serviceRegistry.getCheckOutCheckInService().checkout(content1);
        this.txn.commit();
        this.txn = null;
        this.tearDown();
        this.setUp();
        serviceRegistry.getCheckOutCheckInService().cancelCheckout(workingCopyNodeRef);
        this.txn.commit();
        this.txn = null;
        Assert.assertEquals((long)2L, (long)auditMapList.size());
        boolean origIn0 = ((String)((Object)auditMapList.get(0).get("path"))).endsWith("cm:content1");
        Map<String, Serializable> origMap = auditMapList.get(origIn0 ? 0 : 1);
        Map<String, Serializable> workMap = auditMapList.get(origIn0 ? 1 : 0);
        Assert.assertEquals((Object)"DELETE", (Object)workMap.get("action"));
        this.assertContains("deleteNode", workMap.get("sub-actions"));
        Assert.assertTrue((String)"Expected working copy", (((String)((Object)workMap.get("path"))).endsWith("(Working Copy)") && ((String)((Object)workMap.get("path"))).startsWith("/cm:homeFolder/cm:folder1/") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"cm:content", (Object)workMap.get("type"));
        Assert.assertEquals((Object)"CANCEL CHECK OUT", (Object)origMap.get("action"));
        this.assertContains("deleteNodeAspect", origMap.get("sub-actions"));
        this.assertContains("cancelCheckOut", origMap.get("sub-actions"));
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder1/cm:content1", (Object)origMap.get("path"));
        Assert.assertEquals((Object)"cm:content", (Object)origMap.get("type"));
    }

    static {
        auditMapList = new ArrayList<Map<String, Serializable>>();
    }
}

