/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit.access;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.audit.access.NodeChange;
import org.alfresco.repo.audit.access.NodeInfoFactory;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeChangeTest {
    private static final StoreRef STORE = new StoreRef("protocol", "store");
    private NodeChange nodeChange;
    private NodeInfoFactory nodeInfoFactory;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private NodeRef folder1;
    private NodeRef folder2;
    private NodeRef content1;
    private Path folderPath1;
    private Path folderPath2;

    @Before
    public void setUp() throws Exception {
        this.namespaceService = (NamespaceService)Mockito.mock(NamespaceService.class);
        ArrayList<String> cmAlways = new ArrayList<String>();
        cmAlways.add("cm");
        Mockito.when((Object)this.namespaceService.getPrefixes(Matchers.anyString())).thenReturn(cmAlways);
        Mockito.when((Object)this.namespaceService.getNamespaceURI(Matchers.anyString())).thenReturn((Object)"cm");
        this.nodeService = (NodeService)Mockito.mock(NodeService.class);
        Path rootPath = this.newPath(null, "/");
        Path homeFolderPath = this.newPath(rootPath, "cm:homeFolder");
        this.folderPath1 = this.newPath(homeFolderPath, "cm:folder1");
        this.folderPath2 = this.newPath(homeFolderPath, "cm:folder2");
        this.folder1 = this.newFolder(this.folderPath1);
        this.folder2 = this.newFolder(this.folderPath2);
        this.content1 = this.newContent(this.folderPath1, "cm:content1");
        this.nodeInfoFactory = new NodeInfoFactory(this.nodeService, this.namespaceService);
        this.nodeChange = new NodeChange(this.nodeInfoFactory, this.namespaceService, this.content1);
    }

    private NodeRef newFolder(Path path) {
        String name = path.get(path.size() - 1).getElementString();
        return this.newNodeRef(path, name, "folder");
    }

    private NodeRef newContent(Path parentPath, String name) {
        Path path = this.newPath(parentPath, name);
        return this.newNodeRef(path, name, "content");
    }

    private NodeRef newNodeRef(Path path, String name, String type) {
        NodeRef nodeRef = new NodeRef(STORE, name);
        QName qNameType = QName.createQName((String)"URI", (String)type);
        Mockito.when((Object)this.nodeService.getType(nodeRef)).thenReturn((Object)qNameType);
        Mockito.when((Object)this.nodeService.getPath(nodeRef)).thenReturn((Object)path);
        return nodeRef;
    }

    private Path newPath(Path parent, final String name) {
        Path path = new Path();
        if (parent != null) {
            for (Path.Element element : parent) {
                path.append(element);
            }
        }
        path.append(new Path.Element(){

            public String getElementString() {
                return name;
            }

            public Path.Element getBaseNameElement(TenantService tenantService) {
                return this;
            }
        });
        return path;
    }

    private void assertStandardData(Map<String, Serializable> auditMap, String expectedAction, String expectedSubActions) {
        String expectedPath = "/cm:homeFolder/cm:folder1/cm:content1";
        Assert.assertEquals((Object)expectedAction, (Object)auditMap.get("action"));
        Assert.assertEquals((Object)expectedSubActions, (Object)auditMap.get("sub-actions"));
        Assert.assertEquals((Object)expectedPath, (Object)auditMap.get("path"));
        Assert.assertEquals((Object)this.content1, (Object)auditMap.get("node"));
        Assert.assertEquals((Object)"cm:content", (Object)auditMap.get("type"));
    }

    private void callCreateNode() {
        ChildAssociationRef childAssocRef = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)childAssocRef.getChildRef()).thenReturn((Object)this.content1);
        this.nodeChange.onCreateNode(childAssocRef);
    }

    private void callDeleteNode() {
        this.nodeChange.beforeDeleteNode(this.content1);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public final void testGetAuditDataTrueSubAction() {
        this.callCreateNode();
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(true);
        Assert.assertEquals((String)"Should NOT be derived", (Object)"createNode", (Object)auditMap.get("action"));
        Assert.assertFalse((String)"'user' should not exist in a subAction", (boolean)auditMap.keySet().contains("user"));
        Assert.assertFalse((String)"'sub-actions' should not exist in a subAction", (boolean)auditMap.keySet().contains("sub-actions"));
        Assert.assertFalse((String)"'node' should not exist in a subAction", (boolean)auditMap.keySet().contains("node"));
        Assert.assertFalse((String)"'path' should not exist in a subAction", (boolean)auditMap.keySet().contains("path"));
        Assert.assertFalse((String)"'type' should not exist in a subAction", (boolean)auditMap.keySet().contains("type"));
    }

    @Test
    public final void testGetAuditDataFalseTopLevelAction() {
        this.callCreateNode();
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        Assert.assertEquals((String)"Should be derived", (Object)"CREATE", (Object)auditMap.get("action"));
        Assert.assertTrue((String)"'user' should exist if not a subAction", (boolean)auditMap.keySet().contains("user"));
        Assert.assertTrue((String)"'sub-actions' should exist if not a subAction", (boolean)auditMap.keySet().contains("sub-actions"));
        Assert.assertTrue((String)"'node' should exist if not a subAction", (boolean)auditMap.keySet().contains("node"));
        Assert.assertTrue((String)"'path' should exist if not a subAction", (boolean)auditMap.keySet().contains("path"));
        Assert.assertTrue((String)"'type' should exist if not a subAction", (boolean)auditMap.keySet().contains("type"));
    }

    @Test
    public final void testSetAuditSubActionsTrue() {
        this.nodeChange.setAuditSubActions(true);
        this.callCreateNode();
        this.nodeChange.beforeDeleteNode(this.content1);
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        Assert.assertEquals((String)"subAction audit should exist", (Object)"createNode", (Object)auditMap.get("sub-action/0/action"));
        Assert.assertEquals((String)"subAction audit should exist", (Object)"deleteNode", (Object)auditMap.get("sub-action/1/action"));
    }

    @Test
    public final void testSetAuditSubActionsFalse() {
        this.nodeChange.setAuditSubActions(false);
        this.callCreateNode();
        this.nodeChange.beforeDeleteNode(this.content1);
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        Assert.assertFalse((String)"subAction audit should NOT exist", (boolean)auditMap.keySet().contains("sub-action/0/action"));
        Assert.assertFalse((String)"subAction audit should NOT exist", (boolean)auditMap.keySet().contains("sub-action/1/action"));
    }

    @Test
    public final void testOnCreateNode() {
        this.callCreateNode();
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        this.assertStandardData(auditMap, "CREATE", "createNode");
    }

    @Test
    public final void testBeforeDeleteNode() {
        this.callDeleteNode();
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        this.assertStandardData(auditMap, "DELETE", "deleteNode");
    }

    @Test
    public final void testIsTemporaryNodeYes() {
        this.callCreateNode();
        this.nodeChange.beforeDeleteNode(this.content1);
        Assert.assertTrue((String)"A node was created and deleted so should have been temporary.", (boolean)this.nodeChange.isTemporaryNode());
    }

    @Test
    public final void testOnMoveNode() {
        ChildAssociationRef fromChildAssocRef = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)fromChildAssocRef.getChildRef()).thenReturn((Object)this.content1);
        Mockito.when((Object)fromChildAssocRef.getParentRef()).thenReturn((Object)this.folder2);
        Mockito.when((Object)fromChildAssocRef.getQName()).thenReturn((Object)QName.createQName((String)"URI", (String)"content1"));
        ChildAssociationRef toChildAssocRef = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        Mockito.when((Object)toChildAssocRef.getChildRef()).thenReturn((Object)this.content1);
        Mockito.when((Object)toChildAssocRef.getParentRef()).thenReturn((Object)this.folder1);
        Mockito.when((Object)toChildAssocRef.getQName()).thenReturn((Object)QName.createQName((String)"URI", (String)"content1"));
        this.nodeChange.onMoveNode(fromChildAssocRef, toChildAssocRef);
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        this.assertStandardData(auditMap, "MOVE", "moveNode");
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder2/cm:content1", (Object)auditMap.get("move/from/path"));
        Assert.assertEquals((Object)this.content1, (Object)auditMap.get("move/from/node"));
        Assert.assertEquals((Object)"cm:content", (Object)auditMap.get("move/from/type"));
    }

    @Test
    public final void testOnCopyComplete() {
        NodeRef content2 = this.newContent(this.folderPath2, "cm:content2");
        this.nodeChange.onCopyComplete(null, content2, this.content1, true, null);
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        this.assertStandardData(auditMap, "COPY", "copyNode");
        Assert.assertEquals((Object)"/cm:homeFolder/cm:folder2/cm:content2", (Object)auditMap.get("copy/from/path"));
        Assert.assertEquals((Object)content2, (Object)auditMap.get("copy/from/node"));
        Assert.assertEquals((Object)"cm:content", (Object)auditMap.get("copy/from/type"));
    }

    @Test
    public final void testOnUpdateProperties() {
        HashMap<QName, Serializable> fromProperties = new HashMap<QName, Serializable>();
        fromProperties.put(ContentModel.PROP_CREATED, (Serializable)((Object)"created"));
        fromProperties.put(ContentModel.PROP_CREATOR, (Serializable)((Object)"creator"));
        fromProperties.put(ContentModel.PROP_CONTENT, (Serializable)((Object)"content"));
        fromProperties.put(ContentModel.PROP_LOCATION, (Serializable)((Object)"location"));
        fromProperties.put(ContentModel.PROP_MOBILE, (Serializable)((Object)"mobile"));
        fromProperties.put(ContentModel.PROP_HITS, (Serializable)((Object)"hits"));
        fromProperties.put(ContentModel.PROP_TITLE, (Serializable)((Object)"title"));
        HashMap<QName, Serializable> toProperties = new HashMap<QName, Serializable>(fromProperties);
        toProperties.put(ContentModel.PROP_AUTHOR, (Serializable)((Object)"AUTHOR"));
        toProperties.put(ContentModel.PROP_ADDRESSEE, (Serializable)((Object)"ADDRESSEE"));
        toProperties.remove(ContentModel.PROP_CREATED);
        toProperties.remove(ContentModel.PROP_CREATOR);
        toProperties.remove(ContentModel.PROP_CONTENT);
        toProperties.put(ContentModel.PROP_LOCATION, (Serializable)((Object)"LOCATION"));
        this.nodeChange.onUpdateProperties(this.content1, fromProperties, toProperties);
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        this.assertStandardData(auditMap, "updateNodeProperties", "updateNodeProperties");
        Assert.assertEquals((long)1L, (long)((Map)((Object)auditMap.get("properties/from"))).size());
        Assert.assertEquals((Object)"location", ((Map)((Object)auditMap.get("properties/from"))).get(ContentModel.PROP_LOCATION));
        Assert.assertEquals((Object)"location", (Object)auditMap.get("properties/from/cm:location"));
        Assert.assertEquals((long)1L, (long)((Map)((Object)auditMap.get("properties/to"))).size());
        Assert.assertEquals((Object)"LOCATION", ((Map)((Object)auditMap.get("properties/to"))).get(ContentModel.PROP_LOCATION));
        Assert.assertEquals((Object)"LOCATION", (Object)auditMap.get("properties/to/cm:location"));
        Assert.assertEquals((long)2L, (long)((Map)((Object)auditMap.get("properties/add"))).size());
        Assert.assertEquals((Object)"AUTHOR", ((Map)((Object)auditMap.get("properties/add"))).get(ContentModel.PROP_AUTHOR));
        Assert.assertEquals((Object)"ADDRESSEE", ((Map)((Object)auditMap.get("properties/add"))).get(ContentModel.PROP_ADDRESSEE));
        Assert.assertEquals((Object)"AUTHOR", (Object)auditMap.get("properties/add/cm:author"));
        Assert.assertEquals((Object)"ADDRESSEE", (Object)auditMap.get("properties/add/cm:addressee"));
        Assert.assertEquals((long)3L, (long)((Map)((Object)auditMap.get("properties/delete"))).size());
        Assert.assertEquals((Object)"created", ((Map)((Object)auditMap.get("properties/delete"))).get(ContentModel.PROP_CREATED));
        Assert.assertEquals((Object)"creator", ((Map)((Object)auditMap.get("properties/delete"))).get(ContentModel.PROP_CREATOR));
        Assert.assertEquals((Object)"content", ((Map)((Object)auditMap.get("properties/delete"))).get(ContentModel.PROP_CONTENT));
        Assert.assertEquals((Object)"created", (Object)auditMap.get("properties/delete/cm:created"));
        Assert.assertEquals((Object)"creator", (Object)auditMap.get("properties/delete/cm:creator"));
        Assert.assertEquals((Object)"content", (Object)auditMap.get("properties/delete/cm:content"));
    }

    @Test
    public final void testReplaceInvalidPathChars() {
        HashMap<QName, Serializable> fromProperties = new HashMap<QName, Serializable>();
        HashMap<QName, Serializable> toProperties = new HashMap<QName, Serializable>();
        QName qName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"valid/&\u3001");
        fromProperties.put(qName, (Serializable)((Object)"/&\u3001"));
        this.nodeChange.onUpdateProperties(this.content1, fromProperties, toProperties);
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        Assert.assertEquals((Object)"/&\u3001", ((Map)((Object)auditMap.get("properties/delete"))).get(qName));
        Assert.assertEquals((Object)"/&\u3001", (Object)auditMap.get("properties/delete/cm:valid---"));
    }

    @Test
    public final void testOnAddAspect() {
        this.nodeChange.onAddAspect(this.content1, ContentModel.ASPECT_ARCHIVED);
        this.nodeChange.onRemoveAspect(this.content1, ContentModel.ASPECT_COPIEDFROM);
        this.nodeChange.onAddAspect(this.content1, ContentModel.ASPECT_COPIEDFROM);
        this.nodeChange.onAddAspect(this.content1, ContentModel.ASPECT_EMAILED);
        this.nodeChange.onRemoveAspect(this.content1, ContentModel.ASPECT_EMAILED);
        this.nodeChange.onAddAspect(this.content1, ContentModel.ASPECT_EMAILED);
        this.nodeChange.onAddAspect(this.content1, ContentModel.ASPECT_GEOGRAPHIC);
        this.nodeChange.onAddAspect(this.content1, ContentModel.ASPECT_GEOGRAPHIC);
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        this.assertStandardData(auditMap, "addNodeAspect", "addNodeAspect deleteNodeAspect");
        Assert.assertEquals((long)3L, (long)((Set)((Object)auditMap.get("aspects/add"))).size());
        Assert.assertTrue((String)"Grouped cm:archived aspect missing", (boolean)((Set)((Object)auditMap.get("aspects/add"))).contains(ContentModel.ASPECT_ARCHIVED));
        Assert.assertTrue((String)"Grouped cm:emailed aspect missing", (boolean)((Set)((Object)auditMap.get("aspects/add"))).contains(ContentModel.ASPECT_EMAILED));
        Assert.assertTrue((String)"Grouped cm:geographic aspect missing", (boolean)((Set)((Object)auditMap.get("aspects/add"))).contains(ContentModel.ASPECT_GEOGRAPHIC));
        Assert.assertTrue((String)"Individual cm:archived aspect missing", (boolean)auditMap.containsKey("aspects/add/cm:archived"));
        Assert.assertTrue((String)"Individual cm:emailed aspect missing", (boolean)auditMap.containsKey("aspects/add/cm:emailed"));
        Assert.assertTrue((String)"Individual cm:geographic aspect missing", (boolean)auditMap.containsKey("aspects/add/cm:geographic"));
    }

    @Test
    public final void testOnRemoveAspect() {
        this.nodeChange.onRemoveAspect(this.content1, ContentModel.ASPECT_ARCHIVED);
        this.nodeChange.onAddAspect(this.content1, ContentModel.ASPECT_COPIEDFROM);
        this.nodeChange.onRemoveAspect(this.content1, ContentModel.ASPECT_COPIEDFROM);
        this.nodeChange.onRemoveAspect(this.content1, ContentModel.ASPECT_EMAILED);
        this.nodeChange.onAddAspect(this.content1, ContentModel.ASPECT_EMAILED);
        this.nodeChange.onRemoveAspect(this.content1, ContentModel.ASPECT_EMAILED);
        this.nodeChange.onRemoveAspect(this.content1, ContentModel.ASPECT_GEOGRAPHIC);
        this.nodeChange.onRemoveAspect(this.content1, ContentModel.ASPECT_GEOGRAPHIC);
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        this.assertStandardData(auditMap, "deleteNodeAspect", "deleteNodeAspect addNodeAspect");
        Assert.assertEquals((long)3L, (long)((Set)((Object)auditMap.get("aspects/delete"))).size());
        Assert.assertTrue((String)"Grouped cm:archived aspect missing", (boolean)((Set)((Object)auditMap.get("aspects/delete"))).contains(ContentModel.ASPECT_ARCHIVED));
        Assert.assertTrue((String)"Grouped cm:emailed aspect missing", (boolean)((Set)((Object)auditMap.get("aspects/delete"))).contains(ContentModel.ASPECT_EMAILED));
        Assert.assertTrue((String)"Grouped cm:geographic aspect missing", (boolean)((Set)((Object)auditMap.get("aspects/delete"))).contains(ContentModel.ASPECT_GEOGRAPHIC));
        Assert.assertTrue((String)"Individual cm:archived aspect missing", (boolean)auditMap.containsKey("aspects/delete/cm:archived"));
        Assert.assertTrue((String)"Individual cm:emailed aspect missing", (boolean)auditMap.containsKey("aspects/delete/cm:emailed"));
        Assert.assertTrue((String)"Individual cm:geographic aspect missing", (boolean)auditMap.containsKey("aspects/delete/cm:geographic"));
    }

    @Test
    public final void testOnContentUpdateTrue() {
        this.nodeChange.onContentUpdate(this.content1, true);
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        this.assertStandardData(auditMap, "createContent", "createContent");
    }

    @Test
    public final void testOnContentUpdateFalse() {
        this.nodeChange.onContentUpdate(this.content1, false);
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        this.assertStandardData(auditMap, "UPDATE CONTENT", "updateContent");
    }

    @Test
    public final void testOnContentRead() {
        this.nodeChange.onContentRead(this.content1);
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        this.assertStandardData(auditMap, "READ", "readContent");
    }

    @Test
    public final void testOnCreateVersion() {
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        versionProperties.put("description", (Serializable)((Object)"This is a test"));
        this.nodeChange.onCreateVersion(null, this.content1, versionProperties, null);
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        this.assertStandardData(auditMap, "CREATE VERSION", "createVersion");
        Assert.assertEquals((long)1L, (long)((Map)((Object)auditMap.get("version-properties"))).size());
        Assert.assertEquals((String)"Grouped description version-properties missing", (Object)"This is a test", ((Map)((Object)auditMap.get("version-properties"))).get("description"));
        Assert.assertEquals((String)"Individual description version-properties missing", (Object)"This is a test", (Object)auditMap.get("version-properties/description"));
    }

    @Test
    public final void testOnCheckOut() {
        this.nodeChange.onCheckOut(this.content1);
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        this.assertStandardData(auditMap, "CHECK OUT", "checkOut");
    }

    @Test
    public final void testOnCheckIn() {
        this.nodeChange.onCheckIn(this.content1);
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        this.assertStandardData(auditMap, "CHECK IN", "checkIn");
    }

    @Test
    public final void testOnCancelCheckOut() {
        this.nodeChange.onCancelCheckOut(this.content1);
        Map<String, Serializable> auditMap = this.nodeChange.getAuditData(false);
        this.assertStandardData(auditMap, "CANCEL CHECK OUT", "cancelCheckOut");
    }
}

