/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.AVMNodeDAO;
import org.alfresco.repo.avm.AVMRepository;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.AVMTestSuite;
import org.alfresco.repo.domain.permissions.AccessControlListDAO;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.context.ApplicationContext;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMServicePermissionsTest
extends TestCase {
    private static ApplicationContext applicationContext = AVMTestSuite.getContext();
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected PermissionServiceSPI permissionService;
    protected MutableAuthenticationService authenticationService;
    private MutableAuthenticationDao authenticationDAO;
    protected LocalSessionFactoryBean sessionFactory;
    protected NodeRef rootNodeRef;
    protected NamespacePrefixResolver namespacePrefixResolver;
    protected ServiceRegistry serviceRegistry;
    protected NodeRef systemNodeRef;
    protected AuthenticationComponent authenticationComponent;
    protected ModelDAO permissionModelDAO;
    protected PersonService personService;
    protected AuthorityService authorityService;
    private AclDAO aclDaoComponent;
    private UserTransaction testTX;
    private TransactionService transactionService;
    private AVMService avmService;
    private AccessControlListDAO avmACLDAO;
    private AVMNodeDAO avmNodeDAO;
    private AVMSyncService avmSyncService;
    private ContentService contentService;
    private static final String FILE_NAME = "fileForExport";
    private static final String ROOT = "ROOT";

    protected void setUp() throws Exception {
        this.avmNodeDAO = (AVMNodeDAO)applicationContext.getBean("avmNodeDAO");
        this.avmACLDAO = (AccessControlListDAO)applicationContext.getBean("avmNodeACLDAO");
        this.aclDaoComponent = (AclDAO)applicationContext.getBean("aclDAO");
        this.avmService = (AVMService)applicationContext.getBean("avmService");
        this.avmSyncService = (AVMSyncService)applicationContext.getBean("AVMSyncService");
        this.nodeService = (NodeService)applicationContext.getBean("nodeService");
        this.dictionaryService = (DictionaryService)applicationContext.getBean(ServiceRegistry.DICTIONARY_SERVICE.getLocalName());
        this.permissionService = (PermissionServiceSPI)applicationContext.getBean("permissionService");
        this.namespacePrefixResolver = (NamespacePrefixResolver)applicationContext.getBean(ServiceRegistry.NAMESPACE_SERVICE.getLocalName());
        this.authenticationService = (MutableAuthenticationService)applicationContext.getBean("authenticationService");
        this.authenticationComponent = (AuthenticationComponent)applicationContext.getBean("authenticationComponent");
        this.serviceRegistry = (ServiceRegistry)applicationContext.getBean("ServiceRegistry");
        this.permissionModelDAO = (ModelDAO)applicationContext.getBean("permissionsModelDAO");
        this.personService = (PersonService)applicationContext.getBean("personService");
        this.authorityService = (AuthorityService)applicationContext.getBean("authorityService");
        this.contentService = (ContentService)applicationContext.getBean("contentService");
        this.authenticationComponent.setCurrentUser(this.authenticationComponent.getSystemUserName());
        this.authenticationDAO = (MutableAuthenticationDao)applicationContext.getBean("authenticationDao");
        this.transactionService = (TransactionService)applicationContext.getBean("transactionComponent");
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.nanoTime());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        QName children = ContentModel.ASSOC_CHILDREN;
        QName system = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"system");
        QName container = ContentModel.TYPE_CONTAINER;
        QName types = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"people");
        this.systemNodeRef = this.nodeService.createNode(this.rootNodeRef, children, system, container).getChildRef();
        NodeRef typesNodeRef = this.nodeService.createNode(this.systemNodeRef, children, types, container).getChildRef();
        Map<QName, Serializable> props = this.createPersonProperties("andy");
        this.nodeService.createNode(typesNodeRef, children, ContentModel.TYPE_PERSON, container, props).getChildRef();
        props = this.createPersonProperties("lemur");
        this.nodeService.createNode(typesNodeRef, children, ContentModel.TYPE_PERSON, container, props).getChildRef();
        if (this.authenticationDAO.userExists("andy")) {
            this.authenticationService.deleteAuthentication("andy");
        }
        this.authenticationService.createAuthentication("andy", "andy".toCharArray());
        if (this.authenticationDAO.userExists("lemur")) {
            this.authenticationService.deleteAuthentication("lemur");
        }
        this.authenticationService.createAuthentication("lemur", "lemur".toCharArray());
        if (this.authenticationDAO.userExists(AuthenticationUtil.getAdminUserName())) {
            this.authenticationService.deleteAuthentication(AuthenticationUtil.getAdminUserName());
        }
        this.authenticationService.createAuthentication(AuthenticationUtil.getAdminUserName(), "admin".toCharArray());
        if (this.authenticationDAO.userExists("manager")) {
            this.authenticationService.deleteAuthentication("manager");
        }
        this.authenticationService.createAuthentication("manager", "manager".toCharArray());
        if (this.authenticationDAO.userExists("publisher")) {
            this.authenticationService.deleteAuthentication("publisher");
        }
        this.authenticationService.createAuthentication("publisher", "publisher".toCharArray());
        if (this.authenticationDAO.userExists("contributor")) {
            this.authenticationService.deleteAuthentication("contributor");
        }
        this.authenticationService.createAuthentication("contributor", "contributor".toCharArray());
        if (this.authenticationDAO.userExists("reviewer")) {
            this.authenticationService.deleteAuthentication("reviewer");
        }
        this.authenticationService.createAuthentication("reviewer", "reviewer".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.removeStore("main");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tearDown() throws Exception {
        try {
            try {
                this.testTX.commit();
            }
            catch (Throwable t) {
                t.printStackTrace();
                Object var3_2 = null;
                AuthenticationUtil.clearCurrentSecurityContext();
                super.tearDown();
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            AuthenticationUtil.clearCurrentSecurityContext();
            super.tearDown();
            throw throwable;
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    protected void runAs(String userName) {
        this.authenticationService.authenticate(userName, userName.toCharArray());
        AVMServicePermissionsTest.assertNotNull((Object)this.authenticationService.getCurrentUserName());
    }

    private Map<QName, Serializable> createPersonProperties(String userName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        return properties;
    }

    protected PermissionReference getPermission(String permission) {
        return this.permissionModelDAO.getPermissionReference(null, permission);
    }

    private void buildBaseStructure(String base) throws IOException {
        this.avmService.createStore(base);
        this.avmService.createDirectory(base + ":/", "base");
        this.avmService.createDirectory(base + ":/base", "d-a");
        this.avmService.createDirectory(base + ":/base/d-a", "d-aa");
        this.avmService.createDirectory(base + ":/base/d-a", "d-ab");
        this.avmService.createDirectory(base + ":/base/d-a", "d-ac");
        this.avmService.createFile(base + ":/base/d-a", "f-aa").close();
        this.avmService.createDirectory(base + ":/base", "d-b");
        this.avmService.createDirectory(base + ":/base/d-b", "d-ba");
        this.avmService.createDirectory(base + ":/base/d-b", "d-bb");
        this.avmService.createDirectory(base + ":/base/d-b", "d-bc");
        this.avmService.createFile(base + ":/base/d-b", "f-ba").close();
        this.avmService.createDirectory(base + ":/base", "d-c");
        this.avmService.createDirectory(base + ":/base/d-c", "d-ca");
        this.avmService.createDirectory(base + ":/base/d-c", "d-cb");
        this.avmService.createDirectory(base + ":/base/d-c", "d-cc");
        this.avmService.createFile(base + ":/base/d-c", "f-ca").close();
        this.avmService.createFile(base + ":/base", "f-a").close();
        this.avmService.createDirectory(base + ":/base", "d-d");
        this.avmService.createLayeredDirectory(base + ":/base/d-a", base + ":/base/d-d", "layer-d-a");
        this.avmService.createLayeredDirectory(base + ":/base/d-b", base + ":/base/d-d", "layer-d-b");
        this.avmService.createLayeredDirectory(base + ":/base/d-c", base + ":/base/d-d", "layer-d-c");
        this.avmService.createLayeredFile(base + ":/base/f-a", base + ":/base/d-d", "layer-fa");
        this.avmService.createLayeredDirectory(base + ":/base", base + ":/", "layer");
        String layeredStore1 = base + "-layer-base";
        this.avmService.createStore(layeredStore1);
        this.avmService.createLayeredDirectory(base + ":/base", layeredStore1 + ":/", "layer-to-base");
        String layeredStore2 = base + "-layer-a";
        this.avmService.createStore(layeredStore2);
        this.avmService.createLayeredDirectory(base + ":/base/d-a", layeredStore2 + ":/", "layer-to-d-a");
        String layeredStore3 = base + "-layer-b";
        this.avmService.createStore(layeredStore3);
        this.avmService.createLayeredDirectory(base + ":/base/d-b", layeredStore3 + ":/", "layer-to-d-b");
        String layeredStore4 = base + "-layer-c";
        this.avmService.createStore(layeredStore4);
        this.avmService.createLayeredDirectory(base + ":/base/d-c", layeredStore4 + ":/", "layer-to-d-c");
        String layeredStore5 = base + "-layer-d";
        this.avmService.createStore(layeredStore5);
        this.avmService.createLayeredDirectory(base + ":/base/d-d", layeredStore5 + ":/", "layer-to-d-d");
        String layeredStore6 = base + "-layer-layer-base";
        this.avmService.createStore(layeredStore6);
        this.avmService.createLayeredDirectory(layeredStore1 + ":/layer-to-base", layeredStore6 + ":/", "layer-to-layer-to-base");
        String layeredStore7 = base + "-layer-layer-layer-base";
        this.avmService.createStore(layeredStore7);
        this.avmService.createLayeredDirectory(layeredStore6 + ":/layer-to-layer-to-base", layeredStore7 + ":/", "layer-to-layer-to-layer-to-base");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPermission(String user, String path, String permission, boolean allowed) {
        String curentUser = AuthenticationUtil.getRunAsUser();
        try {
            this.runAs(user);
            AVMNodeDescriptor desc = this.avmService.lookup(-1, path);
            AVMNode node = this.avmNodeDAO.getByID(desc.getId());
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, path);
            AVMStore store = AVMDAOs.Instance().fAVMStoreDAO.getByName(nodeRef.getStoreRef().getIdentifier());
            boolean can = AVMRepository.GetInstance().can(store, node, permission, AVMRepository.GetInstance().lookup(-1, path, false).getDirectlyContained());
            boolean bl = allowed ? can : !can;
            Object var13_12 = null;
            this.runAs(curentUser);
            return bl;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.runAs(curentUser);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCanPerformance(String user, String path, String permission, boolean allowed, int count) {
        String curentUser = AuthenticationUtil.getRunAsUser();
        try {
            this.runAs(user);
            AVMNodeDescriptor desc = this.avmService.lookup(-1, path);
            AVMNode node = this.avmNodeDAO.getByID(desc.getId());
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, path);
            AVMStore store = AVMDAOs.Instance().fAVMStoreDAO.getByName(nodeRef.getStoreRef().getIdentifier());
            boolean can = AVMRepository.GetInstance().can(store, node, permission, AVMRepository.GetInstance().lookup(-1, path, false).getDirectlyContained());
            long start = System.nanoTime();
            for (int i = 0; i < count; ++i) {
                can = AVMRepository.GetInstance().can(null, node, permission, AVMRepository.GetInstance().lookup(-1, path, false).getDirectlyContained());
            }
            long end = System.nanoTime();
            System.out.println("Can in " + (float)(end - start) / 1.0E10f / (float)count);
            System.out.println("Can per second " + 1.0f / ((float)(end - start) / 1.0E10f / (float)count));
            boolean bl = allowed ? can : !can;
            Object var18_16 = null;
            this.runAs(curentUser);
            return bl;
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            this.runAs(curentUser);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkHasPermissionsPerformance(String user, String path, String permission, boolean allowed, int count) {
        String curentUser = AuthenticationUtil.getRunAsUser();
        try {
            this.runAs(user);
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, path);
            boolean can = this.permissionService.hasPermission(nodeRef, permission) == AccessStatus.ALLOWED;
            long start = System.nanoTime();
            for (int i = 0; i < count; ++i) {
                can = this.permissionService.hasPermission(nodeRef, permission) == AccessStatus.ALLOWED;
            }
            long end = System.nanoTime();
            System.out.println("Has Permission in " + (float)(end - start) / 1.0E10f / (float)count);
            System.out.println("Has Permission per second " + 1.0f / ((float)(end - start) / 1.0E10f / (float)count));
            boolean bl = allowed ? can : !can;
            Object var15_13 = null;
            this.runAs(curentUser);
            return bl;
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            this.runAs(curentUser);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkHasPermission(String user, NodeRef nodeRef, String permission, boolean allowed) {
        String curentUser = AuthenticationUtil.getRunAsUser();
        try {
            boolean can;
            this.runAs(user);
            boolean bl = can = this.permissionService.hasPermission(nodeRef, permission) == AccessStatus.ALLOWED;
            boolean bl2 = allowed ? can : !can;
            Object var9_8 = null;
            this.runAs(curentUser);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.runAs(curentUser);
            throw throwable;
        }
    }

    public void testSetup() throws Exception {
    }

    public void test_ETWOTWO_457_NPE1() throws Exception {
        try {
            try {
                this.authenticationService.clearCurrentSecurityContext();
                this.avmService.createStore("main");
                this.avmService.createDirectory("main:/", "a");
                Set perms = this.permissionService.getPermissions(AVMNodeConverter.ToNodeRef(-1, "main:/a"));
                for (AccessPermission permission : perms) {
                    System.out.println(permission);
                }
                Object var5_5 = null;
                this.avmService.purgeStore("main");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.avmService.purgeStore("main");
            throw throwable;
        }
    }

    public void test_ETWOTWO_457_NPE2() throws Exception {
        try {
            try {
                this.authenticationService.authenticate("admin", "admin".toCharArray());
                this.avmService.createStore("main");
                this.avmService.createDirectory("main:/", "a");
                Set perms = this.permissionService.getPermissions(AVMNodeConverter.ToNodeRef(-1, "main:/a"));
                for (AccessPermission permission : perms) {
                    System.out.println(permission);
                }
                this.permissionService.deletePermission(AVMNodeConverter.ToNodeRef(-1, "main:/a"), "ROLE_ADMINISTRATOR", "All");
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var5_5 = null;
            this.avmService.purgeStore("main");
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.avmService.purgeStore("main");
            throw throwable;
        }
    }

    public void test_ETWOTWO_457_NPE3() throws Exception {
        try {
            try {
                this.authenticationService.clearCurrentSecurityContext();
                this.authenticationComponent.setSystemUserAsCurrentUser();
                this.avmService.createStore("main");
                this.avmService.createFile("main:/", "foo").close();
                this.permissionService.setPermission(AVMNodeConverter.ToNodeRef(-1, "main:/").getStoreRef(), "GROUP_EVERYONE", "All", true);
                ContentReader cr = this.contentService.getReader(AVMNodeConverter.ToNodeRef(-1, "main:/foo"), ContentModel.PROP_CONTENT);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw e;
            }
            Object var3_3 = null;
            this.avmService.purgeStore("main");
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.avmService.purgeStore("main");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStoreAcls() throws Exception {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            this.buildBaseStructure(storeName);
            AVMNodeDescriptor nodeDesc = this.avmService.lookup(-1, storeName + ":/base");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, nodeDesc.getPath());
            this.permissionService.setPermission(nodeRef, "GROUP_EVERYONE", "All", true);
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("andy", storeName + ":/base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission("andy", nodeRef, "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission("lemur", nodeRef, "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission(AuthenticationUtil.getAdminUserName(), storeName + ":/base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission(AuthenticationUtil.getAdminUserName(), nodeRef, "All", true));
            this.permissionService.setPermission(nodeRef.getStoreRef(), "andy", "All", true);
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("andy", storeName + ":/base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission("andy", nodeRef, "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/base", "All", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission("lemur", nodeRef, "All", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission(AuthenticationUtil.getAdminUserName(), storeName + ":/base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission(AuthenticationUtil.getAdminUserName(), nodeRef, "All", true));
            this.permissionService.deletePermission(nodeRef.getStoreRef(), "andy", "All");
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("andy", storeName + ":/base", "All", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission("andy", nodeRef, "All", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/base", "All", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission("lemur", nodeRef, "All", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission(AuthenticationUtil.getAdminUserName(), storeName + ":/base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission(AuthenticationUtil.getAdminUserName(), nodeRef, "All", true));
            this.permissionService.deletePermissions(nodeRef.getStoreRef());
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("andy", storeName + ":/base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission("andy", nodeRef, "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission("lemur", nodeRef, "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission(AuthenticationUtil.getAdminUserName(), storeName + ":/base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission(AuthenticationUtil.getAdminUserName(), nodeRef, "All", true));
            this.permissionService.setPermission(nodeRef.getStoreRef(), "andy", "All", true);
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission("andy", nodeRef, "All", true));
            this.permissionService.setPermission(nodeRef.getStoreRef(), "andy", "Read", true);
            this.permissionService.setPermission(nodeRef.getStoreRef(), "lemur", "All", true);
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("andy", storeName + ":/base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission("andy", nodeRef, "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission("lemur", nodeRef, "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission(AuthenticationUtil.getAdminUserName(), storeName + ":/base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission(AuthenticationUtil.getAdminUserName(), nodeRef, "All", true));
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getAllSetPermissions(nodeRef.getStoreRef()).size(), (int)3);
            this.permissionService.clearPermission(nodeRef.getStoreRef(), "andy");
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("andy", storeName + ":/base", "All", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission("andy", nodeRef, "All", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission("lemur", nodeRef, "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission(AuthenticationUtil.getAdminUserName(), storeName + ":/base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission(AuthenticationUtil.getAdminUserName(), nodeRef, "All", true));
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getAllSetPermissions(nodeRef.getStoreRef()).size(), (int)1);
            this.permissionService.clearPermission(nodeRef.getStoreRef(), "lemur");
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("andy", storeName + ":/base", "All", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission("andy", nodeRef, "All", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/base", "All", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission("lemur", nodeRef, "All", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission(AuthenticationUtil.getAdminUserName(), storeName + ":/base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkHasPermission(AuthenticationUtil.getAdminUserName(), nodeRef, "All", true));
            Object var5_4 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-layer-base");
            this.removeStore(storeName + "-layer-a");
            this.removeStore(storeName + "-layer-b");
            this.removeStore(storeName + "-layer-c");
            this.removeStore(storeName + "-layer-d");
            this.removeStore(storeName + "-layer-layer-base");
            this.removeStore(storeName + "-layer-layer-layer-base");
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-layer-base");
            this.removeStore(storeName + "-layer-a");
            this.removeStore(storeName + "-layer-b");
            this.removeStore(storeName + "-layer-c");
            this.removeStore(storeName + "-layer-d");
            this.removeStore(storeName + "-layer-layer-base");
            this.removeStore(storeName + "-layer-layer-layer-base");
            throw throwable;
        }
    }

    public void testSimpleUpdate() throws Throwable {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            try {
                this.buildBaseStructure(storeName);
                this.avmService.createDirectory(storeName + "-layer-base:/layer-to-base", "update-dir");
                this.avmService.createFile(storeName + "-layer-base:/layer-to-base/update-dir", "update-file").close();
                AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + "-layer-base:/layer-to-base");
                AVMNode node = this.avmNodeDAO.getByID(desc.getId());
                Acl acl = node.getAcl();
                AVMServicePermissionsTest.assertNotNull((Object)acl);
                acl = this.aclDaoComponent.getAcl(this.aclDaoComponent.getInheritedAccessControlList(acl.getId()));
                AVMServicePermissionsTest.assertNotNull((Object)acl);
                desc = this.avmService.lookup(-1, storeName + "-layer-base:/layer-to-base/update-dir");
                node = this.avmNodeDAO.getByID(desc.getId());
                Acl dirAcl = node.getAcl();
                AVMServicePermissionsTest.assertNotNull((Object)dirAcl);
                AVMServicePermissionsTest.assertEquals((Object)acl.getId(), (Object)dirAcl.getId());
                desc = this.avmService.lookup(-1, storeName + "-layer-base:/layer-to-base/update-dir/update-file");
                node = this.avmNodeDAO.getByID(desc.getId());
                Acl fileAcl = node.getAcl();
                AVMServicePermissionsTest.assertNotNull((Object)fileAcl);
                AVMServicePermissionsTest.assertEquals((Object)acl.getId(), (Object)fileAcl.getId());
                this.avmService.createSnapshot(storeName, "store", "store");
                this.avmService.createSnapshot(storeName + "-layer-base", "store", "store");
                List<AVMDifference> diffs = this.avmSyncService.compare(-1, storeName + "-layer-base:/layer-to-base", -1, storeName + ":/base", null);
                AVMServicePermissionsTest.assertEquals((int)1, (int)diffs.size());
                AVMServicePermissionsTest.assertEquals((String)("[" + storeName + "-layer-base:/layer-to-base/update-dir[-1] > " + storeName + ":/base/update-dir[-1]]"), (String)diffs.toString());
                this.avmSyncService.update(diffs, null, false, false, false, false, "A", "A");
                desc = this.avmService.lookup(-1, storeName + ":/base/update-dir");
                node = this.avmNodeDAO.getByID(desc.getId());
                dirAcl = node.getAcl();
                AVMServicePermissionsTest.assertNull((Object)dirAcl);
                desc = this.avmService.lookup(-1, storeName + ":/base/update-dir/update-file");
                node = this.avmNodeDAO.getByID(desc.getId());
                fileAcl = node.getAcl();
                AVMServicePermissionsTest.assertNull((Object)fileAcl);
                desc = this.avmService.lookup(-1, storeName + "-layer-base:/layer-to-base/update-dir");
                node = this.avmNodeDAO.getByID(desc.getId());
                dirAcl = node.getAcl();
                AVMServicePermissionsTest.assertNotNull((Object)dirAcl);
                AVMServicePermissionsTest.assertEquals((Object)acl.getId(), (Object)dirAcl.getId());
                desc = this.avmService.lookup(-1, storeName + "-layer-base:/layer-to-base/update-dir/update-file");
                node = this.avmNodeDAO.getByID(desc.getId());
                fileAcl = node.getAcl();
                AVMServicePermissionsTest.assertNull((Object)fileAcl);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
            Object var9_9 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-layer-base");
            this.removeStore(storeName + "-layer-a");
            this.removeStore(storeName + "-layer-b");
            this.removeStore(storeName + "-layer-c");
            this.removeStore(storeName + "-layer-d");
            this.removeStore(storeName + "-layer-layer-base");
            this.removeStore(storeName + "-layer-layer-layer-base");
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-layer-base");
            this.removeStore(storeName + "-layer-a");
            this.removeStore(storeName + "-layer-b");
            this.removeStore(storeName + "-layer-c");
            this.removeStore(storeName + "-layer-d");
            this.removeStore(storeName + "-layer-layer-base");
            this.removeStore(storeName + "-layer-layer-layer-base");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateWithPermissions() throws Exception {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            this.buildBaseStructure(storeName);
            AVMNodeDescriptor nodeDesc = this.avmService.lookup(-1, storeName + ":/base");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, nodeDesc.getPath());
            this.permissionService.setPermission(nodeRef, "GROUP_EVERYONE", "All", true);
            Long baseAcl = this.avmNodeDAO.getByID(nodeDesc.getId()).getAcl().getId();
            Long inheritedBaseAcl = this.aclDaoComponent.getInheritedAccessControlList(baseAcl);
            this.avmService.createDirectory(storeName + "-layer-base:/layer-to-base", "update-dir");
            this.avmService.createFile(storeName + "-layer-base:/layer-to-base/update-dir", "update-file").close();
            AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + "-layer-base:/layer-to-base");
            AVMNode node = this.avmNodeDAO.getByID(desc.getId());
            Acl acl = node.getAcl();
            AVMServicePermissionsTest.assertNotNull((Object)acl);
            acl = this.aclDaoComponent.getAcl(this.aclDaoComponent.getInheritedAccessControlList(acl.getId()));
            AVMServicePermissionsTest.assertNotNull((Object)acl);
            desc = this.avmService.lookup(-1, storeName + "-layer-base:/layer-to-base/update-dir");
            node = this.avmNodeDAO.getByID(desc.getId());
            Acl dirAcl = node.getAcl();
            AVMServicePermissionsTest.assertNotNull((Object)dirAcl);
            AVMServicePermissionsTest.assertEquals((Object)acl.getId(), (Object)dirAcl.getId());
            desc = this.avmService.lookup(-1, storeName + "-layer-base:/layer-to-base/update-dir/update-file");
            node = this.avmNodeDAO.getByID(desc.getId());
            Acl fileAcl = node.getAcl();
            AVMServicePermissionsTest.assertNotNull((Object)fileAcl);
            AVMServicePermissionsTest.assertEquals((Object)acl.getId(), (Object)fileAcl.getId());
            this.avmService.createSnapshot(storeName, "store", "store");
            this.avmService.createSnapshot(storeName + "-layer-base", "store", "store");
            List<AVMDifference> diffs = this.avmSyncService.compare(-1, storeName + "-layer-base:/layer-to-base", -1, storeName + ":/base", null);
            AVMServicePermissionsTest.assertEquals((int)1, (int)diffs.size());
            AVMServicePermissionsTest.assertEquals((String)("[" + storeName + "-layer-base:/layer-to-base/update-dir[-1] > " + storeName + ":/base/update-dir[-1]]"), (String)diffs.toString());
            this.avmSyncService.update(diffs, null, false, false, false, false, "A", "A");
            desc = this.avmService.lookup(-1, storeName + ":/base/update-dir");
            node = this.avmNodeDAO.getByID(desc.getId());
            dirAcl = node.getAcl();
            AVMServicePermissionsTest.assertNotNull((Object)dirAcl);
            AVMServicePermissionsTest.assertEquals((Object)inheritedBaseAcl, (Object)dirAcl.getId());
            desc = this.avmService.lookup(-1, storeName + ":/base/update-dir/update-file");
            node = this.avmNodeDAO.getByID(desc.getId());
            fileAcl = node.getAcl();
            AVMServicePermissionsTest.assertNotNull((Object)fileAcl);
            AVMServicePermissionsTest.assertEquals((Object)inheritedBaseAcl, (Object)fileAcl.getId());
            desc = this.avmService.lookup(-1, storeName + "-layer-base:/layer-to-base/update-dir");
            node = this.avmNodeDAO.getByID(desc.getId());
            dirAcl = node.getAcl();
            AVMServicePermissionsTest.assertNotNull((Object)dirAcl);
            AVMServicePermissionsTest.assertEquals((Object)acl.getId(), (Object)dirAcl.getId());
            desc = this.avmService.lookup(-1, storeName + "-layer-base:/layer-to-base/update-dir/update-file");
            node = this.avmNodeDAO.getByID(desc.getId());
            fileAcl = node.getAcl();
            AVMServicePermissionsTest.assertNotNull((Object)fileAcl);
            AVMServicePermissionsTest.assertEquals((Object)inheritedBaseAcl, (Object)fileAcl.getId());
            Object var13_12 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-layer-base");
            this.removeStore(storeName + "-layer-a");
            this.removeStore(storeName + "-layer-b");
            this.removeStore(storeName + "-layer-c");
            this.removeStore(storeName + "-layer-d");
            this.removeStore(storeName + "-layer-layer-base");
            this.removeStore(storeName + "-layer-layer-layer-base");
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-layer-base");
            this.removeStore(storeName + "-layer-a");
            this.removeStore(storeName + "-layer-b");
            this.removeStore(storeName + "-layer-c");
            this.removeStore(storeName + "-layer-d");
            this.removeStore(storeName + "-layer-layer-base");
            this.removeStore(storeName + "-layer-layer-layer-base");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComplexStore_AlterInheritance() throws IOException {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            this.buildBaseStructure(storeName);
            this.checkHeadPermissionNotSetForPath(storeName + ":/base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-base:/layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-a:/layer-to-d-a", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-b:/layer-to-d-b", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-c:/layer-to-d-c", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-d:/layer-to-d-d", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + "-layer-base:/layer-to-base");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "GROUP_EVERYONE", "All", true);
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission(AuthenticationUtil.getAdminUserName(), storeName + ":/base", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission(AuthenticationUtil.getAdminUserName(), storeName + "-layer-base:/layer-to-base", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission(AuthenticationUtil.getAdminUserName(), storeName + "-layer-base:/layer-to-base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/base", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + "-layer-base:/layer-to-base", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + "-layer-base:/layer-to-base", "All", true));
            desc = this.avmService.lookup(-1, storeName + ":/base");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "GROUP_EVERYONE", "All", true);
            this.permissionService.deletePermission(nodeRef, "GROUP_EVERYONE", "All");
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission(AuthenticationUtil.getAdminUserName(), storeName + ":/base", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission(AuthenticationUtil.getAdminUserName(), storeName + "-layer-base:/layer-to-base", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission(AuthenticationUtil.getAdminUserName(), storeName + "-layer-base:/layer-to-base", "All", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/base", "Read", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + "-layer-base:/layer-to-base", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + "-layer-base:/layer-to-base", "All", true));
            this.checkCanPerformance("lemur", storeName + ":/base", "Read", false, 10000);
            this.checkHasPermissionsPerformance("lemur", storeName + ":/base", "Read", false, 10000);
            String[] excludeL = new String[]{storeName + "-layer-base:/layer-to-base/d-d/layer-d-a"};
            String[] excludeLL = new String[]{storeName + "-layer-layer-base:/layer-to-layer-to-base/d-d/layer-d-a"};
            String[] excludeLLL = new String[]{storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base/d-d/layer-d-a"};
            this.checkHeadPermissionNotSetForPath(storeName + ":/base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-base:/layer-to-base", "GROUP_EVERYONE", "All", true, excludeL);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-a:/layer-to-d-a", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-b:/layer-to-d-b", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-c:/layer-to-d-c", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-d:/layer-to-d-d", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, excludeLL);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, excludeLLL);
            desc = this.avmService.lookup(-1, storeName + "-layer-base:/layer-to-base/d-a");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setInheritParentPermissions(nodeRef, false);
            String[] excludeL2 = new String[]{storeName + "-layer-base:/layer-to-base/d-d/layer-d-a", storeName + "-layer-base:/layer-to-base/d-a"};
            String[] excludeLL2 = new String[]{storeName + "-layer-layer-base:/layer-to-layer-to-base/d-d/layer-d-a", storeName + "-layer-layer-base:/layer-to-layer-to-base/d-a"};
            String[] excludeLLL2 = new String[]{storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base/d-d/layer-d-a", storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base/d-a"};
            this.checkHeadPermissionNotSetForPath(storeName + ":/base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-base:/layer-to-base", "GROUP_EVERYONE", "All", true, excludeL2);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-base:/layer-to-base/d-a", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-a:/layer-to-d-a", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-b:/layer-to-d-b", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-c:/layer-to-d-c", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-d:/layer-to-d-d", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, excludeLL2);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, excludeLLL2);
            desc = this.avmService.lookup(-1, storeName + "-layer-base:/layer-to-base/d-a");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setInheritParentPermissions(nodeRef, true);
            this.checkHeadPermissionNotSetForPath(storeName + ":/base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-base:/layer-to-base", "GROUP_EVERYONE", "All", true, excludeL);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-a:/layer-to-d-a", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-b:/layer-to-d-b", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-c:/layer-to-d-c", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-d:/layer-to-d-d", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, excludeLL);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, excludeLLL);
            Object var11_10 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-layer-base");
            this.removeStore(storeName + "-layer-a");
            this.removeStore(storeName + "-layer-b");
            this.removeStore(storeName + "-layer-c");
            this.removeStore(storeName + "-layer-d");
            this.removeStore(storeName + "-layer-layer-base");
            this.removeStore(storeName + "-layer-layer-layer-base");
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-layer-base");
            this.removeStore(storeName + "-layer-a");
            this.removeStore(storeName + "-layer-b");
            this.removeStore(storeName + "-layer-c");
            this.removeStore(storeName + "-layer-d");
            this.removeStore(storeName + "-layer-layer-base");
            this.removeStore(storeName + "-layer-layer-layer-base");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComplexStore_AddPermissionsToMiddle() throws IOException {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            this.buildBaseStructure(storeName);
            this.checkHeadPermissionNotSetForPath(storeName + ":/base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-base:/layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-a:/layer-to-d-a", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-b:/layer-to-d-b", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-c:/layer-to-d-c", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-d:/layer-to-d-d", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + "-layer-a:/layer-to-d-a");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "GROUP_EVERYONE", "All", true);
            this.checkHeadPermissionNotSetForPath(storeName + ":/base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-base:/layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-a:/layer-to-d-a", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-b:/layer-to-d-b", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-c:/layer-to-d-c", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-d:/layer-to-d-d", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            desc = this.avmService.lookup(-1, storeName + "-layer-base:/layer-to-base");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "loon", "All", true);
            this.checkHeadPermissionNotSetForPath(storeName + ":/base", "loon", "All", true, null);
            String[] excludeL = new String[]{storeName + "-layer-base:/layer-to-base/d-d/layer-d-a"};
            this.checkHeadPermissionForPath(storeName + "-layer-base:/layer-to-base", "loon", "All", true, excludeL);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-a:/layer-to-d-a", "loon", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-b:/layer-to-d-b", "loon", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-c:/layer-to-d-c", "loon", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-d:/layer-to-d-d", "loon", "All", true, null);
            String[] excludeLL = new String[]{storeName + "-layer-layer-base:/layer-to-layer-to-base/d-d/layer-d-a"};
            this.checkHeadPermissionForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "loon", "All", true, excludeLL);
            String[] excludeLLL = new String[]{storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base/d-d/layer-d-a"};
            this.checkHeadPermissionForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "loon", "All", true, excludeLLL);
            desc = this.avmService.lookup(-1, storeName + "-layer-base:/layer-to-base");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "monkey", "All", true);
            this.debugPermissions(storeName + ":/base");
            this.debugPermissions(storeName + "-layer-base:/layer-to-base");
            this.checkHeadPermissionNotSetForPath(storeName + ":/base", "monkey", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-base:/layer-to-base", "monkey", "All", true, excludeL);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-a:/layer-to-d-a", "monkey", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-b:/layer-to-d-b", "monkey", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-c:/layer-to-d-c", "monkey", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-d:/layer-to-d-d", "monkey", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "monkey", "All", true, excludeLL);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "monkey", "All", true, excludeLLL);
            this.debugPermissions(storeName + ":/base");
            this.debugPermissions(storeName + "-layer-base:/layer-to-base");
            desc = this.avmService.lookup(-1, storeName + ":/base");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "base", "All", true);
            this.debugPermissions(storeName + ":/base");
            this.debugPermissions(storeName + "-layer-base:/layer-to-base");
            this.checkHeadPermissionForPath(storeName + ":/base", "base", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-base:/layer-to-base", "base", "All", true, excludeL);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-a:/layer-to-d-a", "base", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-b:/layer-to-d-b", "base", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-c:/layer-to-d-c", "base", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-d:/layer-to-d-d", "base", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "base", "All", true, excludeLL);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "base", "All", true, excludeLLL);
            Object var8_7 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-layer-base");
            this.removeStore(storeName + "-layer-a");
            this.removeStore(storeName + "-layer-b");
            this.removeStore(storeName + "-layer-c");
            this.removeStore(storeName + "-layer-d");
            this.removeStore(storeName + "-layer-layer-base");
            this.removeStore(storeName + "-layer-layer-layer-base");
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-layer-base");
            this.removeStore(storeName + "-layer-a");
            this.removeStore(storeName + "-layer-b");
            this.removeStore(storeName + "-layer-c");
            this.removeStore(storeName + "-layer-d");
            this.removeStore(storeName + "-layer-layer-base");
            this.removeStore(storeName + "-layer-layer-layer-base");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testComplexStore_AddPermissionsToBottom() throws IOException {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            this.buildBaseStructure(storeName);
            this.checkHeadPermissionNotSetForPath(storeName + ":/base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-base:/layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-a:/layer-to-d-a", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-b:/layer-to-d-b", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-c:/layer-to-d-c", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-d:/layer-to-d-d", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + ":/base");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "GROUP_EVERYONE", "All", true);
            this.checkHeadPermissionForPath(storeName + ":/base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-base:/layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-a:/layer-to-d-a", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-b:/layer-to-d-b", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-c:/layer-to-d-c", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-d:/layer-to-d-d", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.permissionService.setPermission(nodeRef, "squid", "All", true);
            this.checkHeadPermissionForPath(storeName + ":/base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-base:/layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-a:/layer-to-d-a", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-b:/layer-to-d-b", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-c:/layer-to-d-c", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-d:/layer-to-d-d", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + ":/base", "squid", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-base:/layer-to-base", "squid", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-a:/layer-to-d-a", "squid", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-b:/layer-to-d-b", "squid", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-c:/layer-to-d-c", "squid", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-d:/layer-to-d-d", "squid", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "squid", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "squid", "All", true, null);
            this.permissionService.deletePermission(nodeRef, "GROUP_EVERYONE", "All");
            this.checkHeadPermissionNotSetForPath(storeName + ":/base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-base:/layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-a:/layer-to-d-a", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-b:/layer-to-d-b", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-c:/layer-to-d-c", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-d:/layer-to-d-d", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.permissionService.setPermission(nodeRef, "me", "All", true);
            this.checkHeadPermissionNotSetForPath(storeName + ":/base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-base:/layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-a:/layer-to-d-a", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-b:/layer-to-d-b", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-c:/layer-to-d-c", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-d:/layer-to-d-d", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + ":/base", "me", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-base:/layer-to-base", "me", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-a:/layer-to-d-a", "me", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-b:/layer-to-d-b", "me", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-c:/layer-to-d-c", "me", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-d:/layer-to-d-d", "me", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "me", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "me", "All", true, null);
            desc = this.avmService.lookup(-1, storeName + ":/base/d-a");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "lemon", "Read", true);
            this.checkHeadPermissionNotSetForPath(storeName + ":/base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-base:/layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-a:/layer-to-d-a", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-b:/layer-to-d-b", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-c:/layer-to-d-c", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-d:/layer-to-d-d", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "GROUP_EVERYONE", "All", true, null);
            this.checkHeadPermissionForPath(storeName + ":/base", "me", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-base:/layer-to-base", "me", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-a:/layer-to-d-a", "me", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-b:/layer-to-d-b", "me", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-c:/layer-to-d-c", "me", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-d:/layer-to-d-d", "me", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base", "me", "All", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base", "me", "All", true, null);
            this.checkHeadPermissionForPath(storeName + ":/base/d-a", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + ":/base/d-b", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + ":/base/d-c", "lemon", "Read", true, null);
            this.checkHeadPermissionForPath(storeName + ":/base/d-d/layer-d-a", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + ":/base/d-d/layer-d-b", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + ":/base/d-d/layer-d-c", "lemon", "Read", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-base:/layer-to-base/d-a", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-base:/layer-to-base/d-b", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-base:/layer-to-base/d-c", "lemon", "Read", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-base:/layer-to-base/d-d/layer-d-a", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-base:/layer-to-base/d-d/layer-d-b", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-base:/layer-to-base/d-d/layer-d-c", "lemon", "Read", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-a:/layer-to-d-a", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-b:/layer-to-d-b", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-c:/layer-to-d-c", "lemon", "Read", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-d:/layer-to-d-d/layer-d-a", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-d:/layer-to-d-d/layer-d-b", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-d:/layer-to-d-d/layer-d-c", "lemon", "Read", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base/d-a", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base/d-b", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base/d-c", "lemon", "Read", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base/d-d/layer-d-a", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base/d-d/layer-d-b", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-base:/layer-to-layer-to-base/d-d/layer-d-c", "lemon", "Read", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base/d-a", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base/d-b", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base/d-c", "lemon", "Read", true, null);
            this.checkHeadPermissionForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base/d-d/layer-d-a", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base/d-d/layer-d-b", "lemon", "Read", true, null);
            this.checkHeadPermissionNotSetForPath(storeName + "-layer-layer-layer-base:/layer-to-layer-to-layer-to-base/d-d/layer-d-c", "lemon", "Read", true, null);
            Object var5_4 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-layer-base");
            this.removeStore(storeName + "-layer-a");
            this.removeStore(storeName + "-layer-b");
            this.removeStore(storeName + "-layer-c");
            this.removeStore(storeName + "-layer-d");
            this.removeStore(storeName + "-layer-layer-base");
            this.removeStore(storeName + "-layer-layer-layer-base");
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-layer-base");
            this.removeStore(storeName + "-layer-a");
            this.removeStore(storeName + "-layer-b");
            this.removeStore(storeName + "-layer-c");
            this.removeStore(storeName + "-layer-d");
            this.removeStore(storeName + "-layer-layer-base");
            this.removeStore(storeName + "-layer-layer-layer-base");
            throw throwable;
        }
    }

    public void testSimpleFilePermissionDiff() throws Throwable {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String prefix = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        String baseStore = prefix + "-main";
        String layeredStore = prefix + "-layer";
        try {
            try {
                System.out.println("create store: " + baseStore);
                this.avmService.createStore(baseStore);
                System.out.println("create D: " + baseStore + ":/base");
                this.avmService.createDirectory(baseStore + ":/", "base");
                System.out.println("create D: " + baseStore + ":/base/d-a");
                this.avmService.createDirectory(baseStore + ":/base", "d-a");
                System.out.println("create F: " + baseStore + ":/base/d-a/f-aa");
                this.avmService.createFile(baseStore + ":/base/d-a", "f-aa").close();
                AVMNodeDescriptor baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/base/d-a/f-aa");
                this.checkHeadPermissionNotSet(baseNodeDesc, "andy", "Delete", true);
                System.out.println("create store: " + layeredStore);
                this.avmService.createStore(layeredStore);
                System.out.println("create LD: " + layeredStore + ":/layer-to-base -> " + baseStore + ":/base");
                this.avmService.createLayeredDirectory(baseStore + ":/base", layeredStore + ":/", "layer-to-base");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                List<AVMDifference> diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer-to-base", -1, baseStore + ":/base", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                AVMNodeDescriptor layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer-to-base/d-a/f-aa");
                NodeRef layeredNodeRef = AVMNodeConverter.ToNodeRef(-1, layeredNodeDesc.getPath());
                System.out.println("set P (DELETE): " + layeredStore + ":/layer-to-base/d-a/f-aa");
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Delete", true);
                this.permissionService.setPermission(layeredNodeRef, "andy", "Delete", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer-to-base", -1, baseStore + ":/base", null);
                AVMServicePermissionsTest.assertEquals((String)("[" + layeredStore + ":/layer-to-base/d-a/f-aa[-1] > " + baseStore + ":/base/d-a/f-aa[-1]]"), (String)diffs.toString());
                AVMServicePermissionsTest.assertEquals((int)1, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/base/d-a/f-aa");
                this.checkHeadPermissionNotSet(baseNodeDesc, "andy", "Delete", true);
                System.out.println("update: main from layer");
                this.avmSyncService.update(diffs, null, false, false, false, false, null, null);
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/base/d-a/f-aa");
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer-to-base", -1, baseStore + ":/base", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                System.out.println("flatten: layer to main");
                this.avmSyncService.flatten(layeredStore + ":/layer-to-base", baseStore + ":/base");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer-to-base", -1, baseStore + ":/base", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/base/d-a/f-aa");
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer-to-base/d-a/f-aa");
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                AVMServicePermissionsTest.assertEquals((Object)baseNodeDesc, (Object)layeredNodeDesc);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
            Object var9_9 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
            throw throwable;
        }
    }

    public void testSimpleDirectoryPermissionDiff0() throws Throwable {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String prefix = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        String baseStore = prefix + "-main";
        String layeredStore = prefix + "-layer";
        try {
            try {
                System.out.println("create store: " + baseStore);
                this.avmService.createStore(baseStore);
                System.out.println("create D: " + baseStore + ":/d-a");
                this.avmService.createDirectory(baseStore + ":/", "d-a");
                AVMNodeDescriptor baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermissionNotSet(baseNodeDesc, "andy", "Delete", true);
                System.out.println("create store: " + layeredStore);
                this.avmService.createStore(layeredStore);
                System.out.println("create LD: " + layeredStore + ":/layer -> " + baseStore + ":/");
                this.avmService.createLayeredDirectory(baseStore + ":/", layeredStore + ":/", "layer");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                List<AVMDifference> diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                NodeRef baseNodeRef = AVMNodeConverter.ToNodeRef(-1, baseNodeDesc.getPath());
                System.out.println("set P (DELETE): " + baseStore + ":/d-a");
                this.checkHeadPermissionNotSet(baseNodeDesc, "andy", "Delete", true);
                this.permissionService.setPermission(baseNodeRef, "andy", "Delete", true);
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                System.out.println("update: main from layer");
                this.avmSyncService.update(diffs, null, false, false, false, false, null, null);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                System.out.println("flatten: layer to main");
                this.avmSyncService.flatten(layeredStore + ":/layer", baseStore + ":/");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                AVMNodeDescriptor layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                AVMServicePermissionsTest.assertEquals((Object)baseNodeDesc, (Object)layeredNodeDesc);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
            Object var9_9 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
            throw throwable;
        }
    }

    public void testSimpleDirectoryPermissionDiff1() throws Throwable {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String prefix = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        String baseStore = prefix + "-main";
        String layeredStore = prefix + "-layer";
        try {
            try {
                System.out.println("create store: " + baseStore);
                this.avmService.createStore(baseStore);
                System.out.println("create D: " + baseStore + ":/d-a");
                this.avmService.createDirectory(baseStore + ":/", "d-a");
                AVMNodeDescriptor baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermissionNotSet(baseNodeDesc, "andy", "Delete", true);
                System.out.println("create store: " + layeredStore);
                this.avmService.createStore(layeredStore);
                System.out.println("create LD: " + layeredStore + ":/layer -> " + baseStore + ":/");
                this.avmService.createLayeredDirectory(baseStore + ":/", layeredStore + ":/", "layer");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                List<AVMDifference> diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                AVMNodeDescriptor layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                NodeRef layeredNodeRef = AVMNodeConverter.ToNodeRef(-1, layeredNodeDesc.getPath());
                System.out.println("set P (DELETE): " + layeredStore + ":/layer/d-a");
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Delete", true);
                this.permissionService.setPermission(layeredNodeRef, "andy", "Delete", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((String)("[" + layeredStore + ":/layer/d-a[-1] > " + baseStore + ":/d-a[-1]]"), (String)diffs.toString());
                AVMServicePermissionsTest.assertEquals((int)1, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermissionNotSet(baseNodeDesc, "andy", "Delete", true);
                System.out.println("update: main from layer");
                this.avmSyncService.update(diffs, null, false, false, false, false, null, null);
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                System.out.println("flatten: layer to main");
                this.avmSyncService.flatten(layeredStore + ":/layer", baseStore + ":/");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                AVMServicePermissionsTest.assertEquals((Object)baseNodeDesc, (Object)layeredNodeDesc);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
            Object var9_9 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
            throw throwable;
        }
    }

    public void testSimpleDirectoryPermissionDiff2() throws Throwable {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String prefix = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        String baseStore = prefix + "-main";
        String layeredStore = prefix + "-layer";
        try {
            try {
                System.out.println("create store: " + baseStore);
                this.avmService.createStore(baseStore);
                System.out.println("create store: " + layeredStore);
                this.avmService.createStore(layeredStore);
                System.out.println("create LD: " + layeredStore + ":/layer -> " + baseStore + ":/");
                this.avmService.createLayeredDirectory(baseStore + ":/", layeredStore + ":/", "layer");
                System.out.println("create D: " + layeredStore + ":/layer/d-a");
                this.avmService.createDirectory(layeredStore + ":/layer", "d-a");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                AVMNodeDescriptor layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                AVMNodeDescriptor baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                NodeRef layeredNodeRef = AVMNodeConverter.ToNodeRef(-1, layeredNodeDesc.getPath());
                System.out.println("set P (DELETE): " + layeredStore + ":/layer/d-a");
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Delete", true);
                this.permissionService.setPermission(layeredNodeRef, "andy", "Delete", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                List<AVMDifference> diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((String)("[" + layeredStore + ":/layer/d-a[-1] > " + baseStore + ":/d-a[-1]]"), (String)diffs.toString());
                AVMServicePermissionsTest.assertEquals((int)1, (int)diffs.size());
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                System.out.println("update: main from layer");
                this.avmSyncService.update(diffs, null, false, false, false, false, null, null);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                layeredNodeRef = AVMNodeConverter.ToNodeRef(-1, layeredNodeDesc.getPath());
                System.out.println("flatten: layer to main");
                this.avmSyncService.flatten(layeredStore + ":/layer", baseStore + ":/");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                AVMServicePermissionsTest.assertEquals((Object)baseNodeDesc, (Object)layeredNodeDesc);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
            Object var9_9 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
            throw throwable;
        }
    }

    public void testSimpleDirectoryPermissionDiff3() throws Throwable {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String prefix = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        String baseStore = prefix + "-main";
        String layeredStore = prefix + "-layer";
        try {
            try {
                System.out.println("create store: " + baseStore);
                this.avmService.createStore(baseStore);
                System.out.println("create store: " + layeredStore);
                this.avmService.createStore(layeredStore);
                System.out.println("create LD: " + layeredStore + ":/layer -> " + baseStore + ":/");
                this.avmService.createLayeredDirectory(baseStore + ":/", layeredStore + ":/", "layer");
                System.out.println("create D: " + layeredStore + ":/layer/d-a");
                this.avmService.createDirectory(layeredStore + ":/layer", "d-a");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                AVMNodeDescriptor layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                AVMNodeDescriptor baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                NodeRef layeredNodeRef = AVMNodeConverter.ToNodeRef(-1, layeredNodeDesc.getPath());
                System.out.println("set P (DELETE): " + layeredStore + ":/layer/d-a");
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Delete", true);
                this.permissionService.setPermission(layeredNodeRef, "andy", "Delete", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                List<AVMDifference> diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((String)("[" + layeredStore + ":/layer/d-a[-1] > " + baseStore + ":/d-a[-1]]"), (String)diffs.toString());
                AVMServicePermissionsTest.assertEquals((int)1, (int)diffs.size());
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                System.out.println("update: main from layer");
                this.avmSyncService.update(diffs, null, false, false, false, false, null, null);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                System.out.println("flatten: layer to main");
                this.avmSyncService.flatten(layeredStore + ":/layer", baseStore + ":/");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                AVMServicePermissionsTest.assertEquals((Object)baseNodeDesc, (Object)layeredNodeDesc);
                System.out.println("set P (WRITE): " + layeredStore + ":/layer/d-a");
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Write", true);
                this.permissionService.setPermission(layeredNodeRef, "andy", "Write", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Write", true);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((String)("[" + layeredStore + ":/layer/d-a[-1] > " + baseStore + ":/d-a[-1]]"), (String)diffs.toString());
                AVMServicePermissionsTest.assertEquals((int)1, (int)diffs.size());
                System.out.println("update: main from layer");
                this.avmSyncService.update(diffs, null, false, false, false, false, null, null);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Write", true);
                System.out.println("flatten: layer to main");
                this.avmSyncService.flatten(layeredStore + ":/layer", baseStore + ":/");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                this.checkHeadPermission(baseNodeDesc, "andy", "Write", true);
                layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Write", true);
                AVMServicePermissionsTest.assertEquals((Object)baseNodeDesc, (Object)layeredNodeDesc);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
            Object var9_9 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
            throw throwable;
        }
    }

    public void testSimpleDirectoryPermissionDiff4() throws Throwable {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String prefix = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        String baseStore = prefix + "-main";
        String layeredStore = prefix + "-layer";
        try {
            try {
                System.out.println("create store: " + baseStore);
                this.avmService.createStore(baseStore);
                System.out.println("create store: " + layeredStore);
                this.avmService.createStore(layeredStore);
                System.out.println("create LD: " + layeredStore + ":/layer -> " + baseStore + ":/");
                this.avmService.createLayeredDirectory(baseStore + ":/", layeredStore + ":/", "layer");
                System.out.println("create D: " + layeredStore + ":/layer/d-a");
                this.avmService.createDirectory(layeredStore + ":/layer", "d-a");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                AVMNodeDescriptor layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                AVMNodeDescriptor baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                NodeRef layeredNodeRef = AVMNodeConverter.ToNodeRef(-1, layeredNodeDesc.getPath());
                System.out.println("set P (DELETE): " + layeredStore + ":/layer/d-a");
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Delete", true);
                this.permissionService.setPermission(layeredNodeRef, "andy", "Delete", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                List<AVMDifference> diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((String)("[" + layeredStore + ":/layer/d-a[-1] > " + baseStore + ":/d-a[-1]]"), (String)diffs.toString());
                AVMServicePermissionsTest.assertEquals((int)1, (int)diffs.size());
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                System.out.println("snapshot: layer");
                this.avmService.createSnapshot(layeredStore, null, null);
                System.out.println("update: main from layer");
                this.avmSyncService.update(diffs, null, false, false, false, false, null, null);
                System.out.println("snapshot: main");
                this.avmService.createSnapshot(baseStore, null, null);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                System.out.println("create F: " + layeredStore + ":/layer/d-a/f-aa");
                this.avmService.createFile(layeredStore + ":/layer/d-a", "f-aa").close();
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((String)("[" + layeredStore + ":/layer/d-a/f-aa[-1] > " + baseStore + ":/d-a/f-aa[-1]]"), (String)diffs.toString());
                AVMServicePermissionsTest.assertEquals((int)1, (int)diffs.size());
                System.out.println("snapshot: layer");
                this.avmService.createSnapshot(layeredStore, null, null);
                System.out.println("update: main from layer");
                this.avmSyncService.update(diffs, null, false, false, false, false, null, null);
                System.out.println("snapshot: main");
                this.avmService.createSnapshot(baseStore, null, null);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                System.out.println("flatten: layer to main");
                this.avmSyncService.flatten(layeredStore + ":/layer", baseStore + ":/");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                AVMServicePermissionsTest.assertEquals((Object)baseNodeDesc, (Object)layeredNodeDesc);
                System.out.println("set P (WRITE): " + layeredStore + ":/layer/d-a");
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Write", true);
                this.permissionService.setPermission(layeredNodeRef, "andy", "Write", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Write", true);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((String)("[" + layeredStore + ":/layer/d-a[-1] > " + baseStore + ":/d-a[-1]]"), (String)diffs.toString());
                AVMServicePermissionsTest.assertEquals((int)1, (int)diffs.size());
                System.out.println("snapshot: layer");
                this.avmService.createSnapshot(layeredStore, null, null);
                System.out.println("update: main from layer");
                this.avmSyncService.update(diffs, null, false, false, false, false, null, null);
                System.out.println("snapshot: main");
                this.avmService.createSnapshot(baseStore, null, null);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Write", true);
                System.out.println("flatten: layer to main");
                this.avmSyncService.flatten(layeredStore + ":/layer", baseStore + ":/");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                this.checkHeadPermission(baseNodeDesc, "andy", "Write", true);
                layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Write", true);
                AVMServicePermissionsTest.assertEquals((Object)baseNodeDesc, (Object)layeredNodeDesc);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
            Object var9_9 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
            throw throwable;
        }
    }

    public void testSimpleDirectoryPermissionDiff5() throws Throwable {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String prefix = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        String baseStore = prefix + "-main";
        String layeredStore = prefix + "-layer";
        try {
            try {
                System.out.println("create store: " + baseStore);
                this.avmService.createStore(baseStore);
                System.out.println("create store: " + layeredStore);
                this.avmService.createStore(layeredStore);
                System.out.println("create LD: " + layeredStore + ":/layer -> " + baseStore + ":/");
                this.avmService.createLayeredDirectory(baseStore + ":/", layeredStore + ":/", "layer");
                System.out.println("create D: " + layeredStore + ":/layer/d-a");
                this.avmService.createDirectory(layeredStore + ":/layer", "d-a");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                AVMNodeDescriptor layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                AVMNodeDescriptor baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                NodeRef layeredNodeRef = AVMNodeConverter.ToNodeRef(-1, layeredNodeDesc.getPath());
                System.out.println("set P (DELETE): " + layeredStore + ":/layer/d-a");
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Delete", true);
                this.permissionService.setPermission(layeredNodeRef, "andy", "Delete", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                System.out.println("set P (WRITE): " + layeredStore + ":/layer/d-a");
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Write", true);
                this.permissionService.setPermission(layeredNodeRef, "andy", "Write", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Write", true);
                List<AVMDifference> diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((String)("[" + layeredStore + ":/layer/d-a[-1] > " + baseStore + ":/d-a[-1]]"), (String)diffs.toString());
                AVMServicePermissionsTest.assertEquals((int)1, (int)diffs.size());
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                System.out.println("snapshot: layer");
                this.avmService.createSnapshot(layeredStore, null, null);
                System.out.println("update: main from layer");
                this.avmSyncService.update(diffs, null, false, false, false, false, null, null);
                System.out.println("snapshot: main");
                this.avmService.createSnapshot(baseStore, null, null);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                System.out.println("flatten: layer to main");
                this.avmSyncService.flatten(layeredStore + ":/layer", baseStore + ":/");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                this.checkHeadPermission(baseNodeDesc, "andy", "Write", true);
                layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Write", true);
                AVMServicePermissionsTest.assertEquals((Object)baseNodeDesc, (Object)layeredNodeDesc);
                System.out.println("delete P (DELETE): " + layeredStore + ":/layer/d-a");
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                this.permissionService.deletePermission(layeredNodeRef, "andy", "Delete");
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Delete", true);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((String)("[" + layeredStore + ":/layer/d-a[-1] > " + baseStore + ":/d-a[-1]]"), (String)diffs.toString());
                AVMServicePermissionsTest.assertEquals((int)1, (int)diffs.size());
                System.out.println("snapshot: layer");
                this.avmService.createSnapshot(layeredStore, null, null);
                System.out.println("update: main from layer");
                this.avmSyncService.update(diffs, null, false, false, false, false, null, null);
                System.out.println("snapshot: main");
                this.avmService.createSnapshot(baseStore, null, null);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermissionNotSet(baseNodeDesc, "andy", "Delete", true);
                System.out.println("flatten: layer to main");
                this.avmSyncService.flatten(layeredStore + ":/layer", baseStore + ":/");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Write", true);
                this.checkHeadPermissionNotSet(baseNodeDesc, "andy", "Delete", true);
                layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                this.checkHeadPermission(layeredNodeDesc, "andy", "Write", true);
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Delete", true);
                AVMServicePermissionsTest.assertEquals((Object)baseNodeDesc, (Object)layeredNodeDesc);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
            Object var9_9 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
            throw throwable;
        }
    }

    public void testSimpleDirectoryPermissionDiff6() throws Throwable {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String prefix = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        String baseStore = prefix + "-main";
        String layeredStore = prefix + "-layer";
        try {
            try {
                System.out.println("create store: " + baseStore);
                this.avmService.createStore(baseStore);
                System.out.println("create store: " + layeredStore);
                this.avmService.createStore(layeredStore);
                System.out.println("create LD: " + layeredStore + ":/layer -> " + baseStore + ":/");
                this.avmService.createLayeredDirectory(baseStore + ":/", layeredStore + ":/", "layer");
                System.out.println("create D: " + layeredStore + ":/layer/d-a");
                this.avmService.createDirectory(layeredStore + ":/layer", "d-a");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                AVMNodeDescriptor layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                AVMNodeDescriptor baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                NodeRef layeredNodeRef = AVMNodeConverter.ToNodeRef(-1, layeredNodeDesc.getPath());
                System.out.println("set P (DELETE): " + layeredStore + ":/layer/d-a");
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Delete", true);
                this.permissionService.setPermission(layeredNodeRef, "andy", "Delete", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                System.out.println("set P (WRITE): " + layeredStore + ":/layer/d-a");
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Write", true);
                this.permissionService.setPermission(layeredNodeRef, "andy", "Write", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Write", true);
                List<AVMDifference> diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((String)("[" + layeredStore + ":/layer/d-a[-1] > " + baseStore + ":/d-a[-1]]"), (String)diffs.toString());
                AVMServicePermissionsTest.assertEquals((int)1, (int)diffs.size());
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                System.out.println("snapshot: layer");
                this.avmService.createSnapshot(layeredStore, null, null);
                System.out.println("update: main from layer");
                this.avmSyncService.update(diffs, null, false, false, false, false, null, null);
                System.out.println("snapshot: main");
                this.avmService.createSnapshot(baseStore, null, null);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                System.out.println("flatten: layer to main");
                this.avmSyncService.flatten(layeredStore + ":/layer", baseStore + ":/");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Delete", true);
                this.checkHeadPermission(baseNodeDesc, "andy", "Write", true);
                layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Write", true);
                AVMServicePermissionsTest.assertEquals((Object)baseNodeDesc, (Object)layeredNodeDesc);
                System.out.println("delete P (DELETE): " + layeredStore + ":/layer/d-a");
                this.checkHeadPermission(layeredNodeDesc, "andy", "Delete", true);
                this.permissionService.deletePermission(layeredNodeRef, "andy", "Delete");
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Delete", true);
                System.out.println("set P (READ): " + layeredStore + ":/layer/d-a");
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Read", true);
                this.permissionService.setPermission(layeredNodeRef, "andy", "Read", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Read", true);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((String)("[" + layeredStore + ":/layer/d-a[-1] > " + baseStore + ":/d-a[-1]]"), (String)diffs.toString());
                AVMServicePermissionsTest.assertEquals((int)1, (int)diffs.size());
                System.out.println("snapshot: layer");
                this.avmService.createSnapshot(layeredStore, null, null);
                System.out.println("update: main from layer");
                this.avmSyncService.update(diffs, null, false, false, false, false, null, null);
                System.out.println("snapshot: main");
                this.avmService.createSnapshot(baseStore, null, null);
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermissionNotSet(baseNodeDesc, "andy", "Delete", true);
                this.checkHeadPermission(baseNodeDesc, "andy", "Read", true);
                System.out.println("flatten: layer to main");
                this.avmSyncService.flatten(layeredStore + ":/layer", baseStore + ":/");
                this.recursiveList(baseStore);
                this.recursiveList(layeredStore);
                diffs = this.avmSyncService.compare(-1, layeredStore + ":/layer", -1, baseStore + ":/", null);
                AVMServicePermissionsTest.assertEquals((int)0, (int)diffs.size());
                baseNodeDesc = this.avmService.lookup(-1, baseStore + ":/d-a");
                this.checkHeadPermission(baseNodeDesc, "andy", "Write", true);
                this.checkHeadPermission(baseNodeDesc, "andy", "Read", true);
                this.checkHeadPermissionNotSet(baseNodeDesc, "andy", "Delete", true);
                layeredNodeDesc = this.avmService.lookup(-1, layeredStore + ":/layer/d-a");
                this.checkHeadPermission(layeredNodeDesc, "andy", "Write", true);
                this.checkHeadPermission(layeredNodeDesc, "andy", "Write", true);
                this.checkHeadPermissionNotSet(layeredNodeDesc, "andy", "Delete", true);
                AVMServicePermissionsTest.assertEquals((Object)baseNodeDesc, (Object)layeredNodeDesc);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
            Object var9_9 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.removeStore(baseStore);
            this.removeStore(layeredStore);
            throw throwable;
        }
    }

    private void checkHeadPermissionForPath(String path, String authority, String permission, boolean allow, String[] excludes) {
        AVMNodeDescriptor desc = this.avmService.lookup(-1, path);
        this.checkHeadPermission(desc, authority, permission, allow);
        if (desc.isDirectory()) {
            SortedMap<String, AVMNodeDescriptor> children = this.avmService.getDirectoryListing(desc);
            for (String child : children.keySet()) {
                String newPath = path + "/" + child;
                if (excludes != null) {
                    for (String exclude : excludes) {
                        if (!newPath.startsWith(exclude)) continue;
                        return;
                    }
                }
                this.checkHeadPermissionForPath(newPath, authority, permission, allow, excludes);
            }
        }
    }

    private void checkHeadPermissionNotSetForPath(String path, String authority, String permission, boolean allow, String[] excludes) {
        AVMNodeDescriptor desc = this.avmService.lookup(-1, path);
        this.checkHeadPermissionNotSet(desc, authority, permission, allow);
        if (desc.isDirectory()) {
            SortedMap<String, AVMNodeDescriptor> children = this.avmService.getDirectoryListing(desc);
            for (String child : children.keySet()) {
                String newPath = path + "/" + child;
                if (excludes != null) {
                    for (String exclude : excludes) {
                        if (!newPath.startsWith(exclude)) continue;
                        return;
                    }
                }
                this.checkHeadPermissionNotSetForPath(newPath, authority, permission, allow, excludes);
            }
        }
    }

    private void checkHeadPermission(AVMNodeDescriptor desc, String authority, String permission, boolean allow) {
        NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
        Set set = this.permissionService.getAllSetPermissions(nodeRef);
        for (AccessPermission p : set) {
            if (!p.getAuthority().equals(authority) || !p.getPermission().equals(permission)) continue;
            return;
        }
        this.debugPermissions(desc.getPath());
        AVMServicePermissionsTest.fail((String)("Permisssions not found at " + desc.getPath()));
    }

    private void checkHeadPermissionNotSet(AVMNodeDescriptor desc, String authority, String permission, boolean allow) {
        NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
        Set set = this.permissionService.getAllSetPermissions(nodeRef);
        for (AccessPermission p : set) {
            if (!p.getAuthority().equals(authority) || !p.getPermission().equals(permission)) continue;
            this.debugPermissions(desc.getPath());
            AVMServicePermissionsTest.fail((String)("Permisssions found at " + desc.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRedirectLayeredDirectory() throws IOException {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            this.avmService.createStore(storeName);
            this.avmService.createDirectory(storeName + ":/", "www");
            this.avmService.createDirectory(storeName + ":/www", "avm-web-apps");
            this.avmService.createFile(storeName + ":/www", "dog").close();
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps", ROOT);
            this.avmService.createFile(storeName + ":/www/avm-web-apps", "cat").close();
            AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + ":/www");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "GROUP_EVERYONE", "Read", true);
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www", "Editor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www", "Editor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www", "Editor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www", "Editor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www", "Editor", false));
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "manager", "ContentManager", true);
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/avm-web-apps", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/avm-web-apps", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/avm-web-apps", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/avm-web-apps", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/avm-web-apps", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/avm-web-apps", "ContentManager", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/avm-web-apps", "ContentManager", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/avm-web-apps", "ContentManager", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/avm-web-apps", "ContentManager", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/avm-web-apps", "ContentManager", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/avm-web-apps", "ContentPublisher", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/avm-web-apps", "ContentPublisher", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/avm-web-apps", "ContentPublisher", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/avm-web-apps", "ContentPublisher", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/avm-web-apps", "ContentPublisher", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/avm-web-apps", "ContentContributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/avm-web-apps", "ContentContributor", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/avm-web-apps", "ContentContributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/avm-web-apps", "ContentContributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/avm-web-apps", "ContentContributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/avm-web-apps", "ContentReviewer", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/avm-web-apps", "ContentReviewer", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/avm-web-apps", "ContentReviewer", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/avm-web-apps", "ContentReviewer", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/avm-web-apps", "ContentReviewer", false));
            desc = this.avmService.lookup(-1, storeName + ":/www/dog");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "publisher", "Collaborator", true);
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/dog", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/dog", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/dog", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/dog", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/dog", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/dog", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/dog", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/dog", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/dog", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/dog", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/dog", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/dog", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/dog", "Collaborator", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/dog", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/dog", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/dog", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/dog", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/dog", "Contributor", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/dog", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/dog", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/dog", "Editor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/dog", "Editor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/dog", "Editor", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/dog", "Editor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/dog", "Editor", false));
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "contributor", "Coordinator", true);
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/avm-web-apps/ROOT", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/avm-web-apps/ROOT", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/avm-web-apps/ROOT", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/avm-web-apps/ROOT", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/avm-web-apps/ROOT", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/avm-web-apps/ROOT", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/avm-web-apps/ROOT", "Coordinator", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/avm-web-apps/ROOT", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/avm-web-apps/ROOT", "Coordinator", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/avm-web-apps/ROOT", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/avm-web-apps/ROOT", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/avm-web-apps/ROOT", "Collaborator", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/avm-web-apps/ROOT", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/avm-web-apps/ROOT", "Collaborator", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/avm-web-apps/ROOT", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/avm-web-apps/ROOT", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/avm-web-apps/ROOT", "Contributor", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/avm-web-apps/ROOT", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/avm-web-apps/ROOT", "Contributor", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/avm-web-apps/ROOT", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/avm-web-apps/ROOT", "Editor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/avm-web-apps/ROOT", "Editor", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/avm-web-apps/ROOT", "Editor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/avm-web-apps/ROOT", "Editor", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/avm-web-apps/ROOT", "Editor", false));
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/cat");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "reviewer", "Editor", true);
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/avm-web-apps/cat", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/avm-web-apps/cat", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/avm-web-apps/cat", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/avm-web-apps/cat", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/avm-web-apps/cat", "Read", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/avm-web-apps/cat", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/avm-web-apps/cat", "Coordinator", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/avm-web-apps/cat", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/avm-web-apps/cat", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/avm-web-apps/cat", "Coordinator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/avm-web-apps/cat", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/avm-web-apps/cat", "Collaborator", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/avm-web-apps/cat", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/avm-web-apps/cat", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/avm-web-apps/cat", "Collaborator", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/avm-web-apps/cat", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/avm-web-apps/cat", "Contributor", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/avm-web-apps/cat", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/avm-web-apps/cat", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/avm-web-apps/cat", "Contributor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("lemur", storeName + ":/www/avm-web-apps/cat", "Editor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("manager", storeName + ":/www/avm-web-apps/cat", "Editor", true));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("publisher", storeName + ":/www/avm-web-apps/cat", "Editor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("contributor", storeName + ":/www/avm-web-apps/cat", "Editor", false));
            AVMServicePermissionsTest.assertTrue((boolean)this.checkPermission("reviewer", storeName + ":/www/avm-web-apps/cat", "Editor", true));
            this.avmService.createSnapshot(storeName, null, null);
            this.avmService.createLayeredDirectory(storeName + ":/www", storeName + ":/", "layer");
            desc = this.avmService.lookup(-1, storeName + ":/layer");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/layer/dog");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/cat");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            this.avmService.retargetLayeredDirectory(storeName + ":/layer", storeName + ":/www/avm-web-apps");
            desc = this.avmService.lookup(-1, storeName + ":/layer");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/layer/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer/cat");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            this.avmService.retargetLayeredDirectory(storeName + ":/layer", storeName + ":/www");
            desc = this.avmService.lookup(-1, storeName + ":/layer");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/layer/dog");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/cat");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "monkey", "Read", true);
            this.avmService.createDirectory(storeName + ":/layer", "l-d");
            desc = this.avmService.lookup(-1, storeName + ":/layer/l-d");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "directory-monkey", "Read", true);
            this.avmService.createFile(storeName + ":/layer", "l-f").close();
            desc = this.avmService.lookup(-1, storeName + ":/layer/l-f");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "file-monkey", "Read", true);
            desc = this.avmService.lookup(-1, storeName + ":/layer");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/layer/l-d");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer/l-f");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer/dog");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/cat");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            this.debugPermissions(storeName + ":/layer/avm-web-apps/cat");
            this.avmService.retargetLayeredDirectory(storeName + ":/layer", storeName + ":/www/avm-web-apps");
            desc = this.avmService.lookup(-1, storeName + ":/layer");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/layer/l-d");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer/l-f");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            desc = this.avmService.lookup(-1, storeName + ":/layer/cat");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/cat");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            this.avmService.retargetLayeredDirectory(storeName + ":/layer", storeName + ":/www");
            desc = this.avmService.lookup(-1, storeName + ":/layer");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/layer/l-d");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer/l-f");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer/dog");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/cat");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            Object var5_4 = null;
            this.removeStore(storeName);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.removeStore(storeName);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopy() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            this.avmService.createStore(storeName);
            this.avmService.createDirectory(storeName + ":/", "www");
            this.avmService.createDirectory(storeName + ":/www", "avm-web-apps");
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps", ROOT);
            AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + ":/www");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            Map<String, Integer> s1 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.permissionService.setPermission(nodeRef, "GROUP_EVERYONE", "All", true);
            Map<String, Integer> s2 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.permissionService.setPermission(nodeRef, "manager", "ContentManager", true);
            Map<String, Integer> s3 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.permissionService.setPermission(nodeRef, "publisher", "ContentPublisher", true);
            Map<String, Integer> s4 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.permissionService.setPermission(nodeRef, "contributor", "ContentContributor", true);
            Map<String, Integer> s5 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.permissionService.setPermission(nodeRef, "reviewer", "ContentReviewer", true);
            Map<String, Integer> s6 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.avmService.copy(-1, storeName + ":/www", storeName + ":/", "head");
            desc = this.avmService.lookup(-1, storeName + ":/head");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, storeName + ":/head/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            this.avmService.copy(s1.get(storeName), storeName + ":/www", storeName + ":/", "s1");
            desc = this.avmService.lookup(-1, storeName + ":/s1");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)0);
            desc = this.avmService.lookup(-1, storeName + ":/s1/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)0);
            this.avmService.copy(s2.get(storeName), storeName + ":/www", storeName + ":/", "s2");
            desc = this.avmService.lookup(-1, storeName + ":/s2");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            desc = this.avmService.lookup(-1, storeName + ":/s2/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.copy(s3.get(storeName), storeName + ":/www", storeName + ":/", "s3");
            desc = this.avmService.lookup(-1, storeName + ":/s3");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/s3/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            this.avmService.copy(s4.get(storeName), storeName + ":/www", storeName + ":/", "s4");
            desc = this.avmService.lookup(-1, storeName + ":/s4");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/s4/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            this.avmService.copy(s5.get(storeName), storeName + ":/www", storeName + ":/", "s5");
            desc = this.avmService.lookup(-1, storeName + ":/s5");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            desc = this.avmService.lookup(-1, storeName + ":/s5/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            this.avmService.copy(s6.get(storeName), storeName + ":/www", storeName + ":/", "s6");
            desc = this.avmService.lookup(-1, storeName + ":/s6");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, storeName + ":/s6/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "monkey", "ContentReviewer", true);
            this.avmService.copy(s6.get(storeName), storeName + ":/www", storeName + ":/", "s6");
            desc = this.avmService.lookup(-1, storeName + ":/s6");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, storeName + ":/s6/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "monkey", "ContentReviewer", true);
            this.avmService.copy(s6.get(storeName), storeName + ":/www", storeName + ":/", "s6");
            desc = this.avmService.lookup(-1, storeName + ":/s6");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, storeName + ":/s6/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            Object var11_10 = null;
            this.removeStore(storeName);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.removeStore(storeName);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBranches() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            this.avmService.createStore(storeName);
            this.avmService.createDirectory(storeName + ":/", "www");
            this.avmService.createDirectory(storeName + ":/www", "avm-web-apps");
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps", ROOT);
            AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + ":/www");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            Map<String, Integer> s1 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.permissionService.setPermission(nodeRef, "GROUP_EVERYONE", "All", true);
            Map<String, Integer> s2 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.permissionService.setPermission(nodeRef, "manager", "ContentManager", true);
            Map<String, Integer> s3 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.permissionService.setPermission(nodeRef, "publisher", "ContentPublisher", true);
            Map<String, Integer> s4 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.permissionService.setPermission(nodeRef, "contributor", "ContentContributor", true);
            Map<String, Integer> s5 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.permissionService.setPermission(nodeRef, "reviewer", "ContentReviewer", true);
            Map<String, Integer> s6 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.avmService.createBranch(-1, storeName + ":/www", storeName + ":/", "head");
            desc = this.avmService.lookup(-1, storeName + ":/head");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, storeName + ":/head/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            this.avmService.createBranch(s1.get(storeName), storeName + ":/www", storeName + ":/", "s1");
            desc = this.avmService.lookup(-1, storeName + ":/s1");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)0);
            desc = this.avmService.lookup(-1, storeName + ":/s1/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)0);
            this.avmService.createBranch(s2.get(storeName), storeName + ":/www", storeName + ":/", "s2");
            desc = this.avmService.lookup(-1, storeName + ":/s2");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            desc = this.avmService.lookup(-1, storeName + ":/s2/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.createBranch(s3.get(storeName), storeName + ":/www", storeName + ":/", "s3");
            desc = this.avmService.lookup(-1, storeName + ":/s3");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/s3/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            this.avmService.createBranch(s4.get(storeName), storeName + ":/www", storeName + ":/", "s4");
            desc = this.avmService.lookup(-1, storeName + ":/s4");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/s4/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            this.avmService.createBranch(s5.get(storeName), storeName + ":/www", storeName + ":/", "s5");
            desc = this.avmService.lookup(-1, storeName + ":/s5");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            desc = this.avmService.lookup(-1, storeName + ":/s5/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            this.avmService.createBranch(s6.get(storeName), storeName + ":/www", storeName + ":/", "s6");
            desc = this.avmService.lookup(-1, storeName + ":/s6");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, storeName + ":/s6/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "monkey", "ContentReviewer", true);
            this.avmService.createBranch(s6.get(storeName), storeName + ":/www", storeName + ":/", "s6");
            desc = this.avmService.lookup(-1, storeName + ":/s6");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, storeName + ":/s6/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "monkey", "ContentReviewer", true);
            this.avmService.createBranch(s6.get(storeName), storeName + ":/www", storeName + ":/", "s6");
            desc = this.avmService.lookup(-1, storeName + ":/s6");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, storeName + ":/s6/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            Object var11_10 = null;
            this.removeStore(storeName);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.removeStore(storeName);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWCMStyleTemplateAsBranch() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        String branchName = storeName + "-Branch";
        try {
            this.avmService.createStore(storeName);
            this.avmService.createDirectory(storeName + ":/", "www");
            this.avmService.createDirectory(storeName + ":/www", "avm-web-apps");
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps", ROOT);
            AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + ":/www");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            Map<String, Integer> s1 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.permissionService.setPermission(nodeRef, "GROUP_EVERYONE", "All", true);
            Map<String, Integer> s2 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.permissionService.setPermission(nodeRef, "manager", "ContentManager", true);
            Map<String, Integer> s3 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.permissionService.setPermission(nodeRef, "publisher", "ContentPublisher", true);
            Map<String, Integer> s4 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.permissionService.setPermission(nodeRef, "contributor", "ContentContributor", true);
            Map<String, Integer> s5 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            this.permissionService.setPermission(nodeRef, "reviewer", "ContentReviewer", true);
            Map<String, Integer> s6 = this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            this.avmService.createStore(branchName);
            this.avmService.createBranch(-1, storeName + ":/www", branchName + ":/", "www");
            this.avmService.createSnapshot(branchName, null, null);
            desc = this.avmService.lookup(-1, branchName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, branchName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            this.debugPermissions(storeName + ":/www");
            this.debugPermissions(branchName + ":/www");
            this.debugPermissions(branchName + ":/www/avm-web-apps");
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "template", "ContentReviewer", true);
            desc = this.avmService.lookup(-1, branchName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, branchName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            this.debugPermissions(storeName + ":/www");
            this.debugPermissions(branchName + ":/www");
            this.debugPermissions(branchName + ":/www/avm-web-apps");
            desc = this.avmService.lookup(-1, branchName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "new", "ContentReviewer", true);
            desc = this.avmService.lookup(-1, branchName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            desc = this.avmService.lookup(-1, branchName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.debugPermissions(storeName + ":/www");
            this.debugPermissions(branchName + ":/www");
            this.debugPermissions(branchName + ":/www/avm-web-apps");
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            Object var12_11 = null;
            this.removeStore(storeName);
            this.removeStore(branchName);
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.removeStore(storeName);
            this.removeStore(branchName);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleExternalLayer() throws Exception {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            this.avmService.createStore(storeName);
            this.avmService.createDirectory(storeName + ":/", "www");
            this.avmService.createDirectory(storeName + ":/www", "avm-web-apps");
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps", ROOT);
            AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + ":/www");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "GROUP_EVERYONE", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            Long definingId = this.avmACLDAO.getAccessControlList(nodeRef).getId();
            String definingGuid = this.aclDaoComponent.getAccessControlListProperties(definingId).getAclId();
            this.permissionService.setPermission(nodeRef, "manager", "ContentManager", true);
            this.permissionService.setPermission(nodeRef, "publisher", "ContentPublisher", true);
            this.permissionService.setPermission(nodeRef, "contributor", "ContentContributor", true);
            this.permissionService.setPermission(nodeRef, "reviewer", "ContentReviewer", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)definingId, (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps/ROOT", "directory");
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/directory");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            this.avmService.createFile(storeName + ":/www/avm-web-apps/ROOT", "file").close();
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/file");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            this.avmService.createSnapshot(storeName, null, null);
            this.avmService.createStore(storeName + "-a-");
            this.avmService.createLayeredDirectory(storeName + ":/www", storeName + "-a-:/", "www");
            this.avmService.createSnapshot(storeName, null, null);
            this.avmService.createSnapshot(storeName + "-a-", null, null);
            desc = this.avmService.lookup(-1, storeName + "-a-:/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, storeName + "-a-:/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + "-a-:/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + "-a-:/www/avm-web-apps/ROOT/directory");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + "-a-:/www/avm-web-apps/ROOT/file");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.testTX.commit();
            this.testTX = this.transactionService.getUserTransaction();
            this.testTX.begin();
            this.permissionService.setPermission(nodeRef, "andy", "ContentReviewer", true);
            Long newId = this.avmACLDAO.getAccessControlList(nodeRef).getId();
            AVMServicePermissionsTest.assertFalse((boolean)newId.equals(definingId));
            AVMServicePermissionsTest.assertEquals((String)definingGuid, (String)this.aclDaoComponent.getAccessControlListProperties(newId).getAclId());
            AVMServicePermissionsTest.assertEquals((long)(this.aclDaoComponent.getAccessControlListProperties(definingId).getAclVersion() + 1L), (long)this.aclDaoComponent.getAccessControlListProperties(newId).getAclVersion());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)newId, (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/directory");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/file");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + "-a-:/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            desc = this.avmService.lookup(-1, storeName + "-a-:/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + "-a-:/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + "-a-:/www/avm-web-apps/ROOT/directory");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + "-a-:/www/avm-web-apps/ROOT/file");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + "-a-:/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "bob", "ContentReviewer", true);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)newId, (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/directory");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/file");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + "-a-:/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)7);
            newId = this.avmACLDAO.getAccessControlList(nodeRef).getId();
            desc = this.avmService.lookup(-1, storeName + "-a-:/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)7);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + "-a-:/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)7);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + "-a-:/www/avm-web-apps/ROOT/directory");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)7);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + "-a-:/www/avm-web-apps/ROOT/file");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)7);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            Object var8_7 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-a-");
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-a-");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void x_testSimpleInternalLayer() throws IOException {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            this.avmService.createStore(storeName);
            this.avmService.createDirectory(storeName + ":/", "www");
            this.avmService.createDirectory(storeName + ":/www", "avm-web-apps");
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps", ROOT);
            AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + ":/www");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "GROUP_EVERYONE", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            Long definingId = this.avmACLDAO.getAccessControlList(nodeRef).getId();
            String definingGuid = this.aclDaoComponent.getAccessControlListProperties(definingId).getAclId();
            this.permissionService.setPermission(nodeRef, "manager", "ContentManager", true);
            this.permissionService.setPermission(nodeRef, "publisher", "ContentPublisher", true);
            this.permissionService.setPermission(nodeRef, "contributor", "ContentContributor", true);
            this.permissionService.setPermission(nodeRef, "reviewer", "ContentReviewer", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)definingId, (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps/ROOT", "directory");
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/directory");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            this.avmService.createFile(storeName + ":/www/avm-web-apps/ROOT", "file").close();
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/file");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            this.avmService.createSnapshot(storeName, null, null);
            this.avmService.createLayeredDirectory(storeName + ":/www", storeName + ":/", "layer");
            this.avmService.createSnapshot(storeName, null, null);
            this.avmService.createSnapshot(storeName, null, null);
            desc = this.avmService.lookup(-1, storeName + ":/layer");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/ROOT/directory");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/ROOT/file");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(definingId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "andy", "ContentReviewer", true);
            Long newId = this.avmACLDAO.getAccessControlList(nodeRef).getId();
            AVMServicePermissionsTest.assertFalse((boolean)newId.equals(definingId));
            AVMServicePermissionsTest.assertEquals((String)definingGuid, (String)this.aclDaoComponent.getAccessControlListProperties(newId).getAclId());
            AVMServicePermissionsTest.assertEquals((long)(this.aclDaoComponent.getAccessControlListProperties(definingId).getAclVersion() + 1L), (long)this.aclDaoComponent.getAccessControlListProperties(newId).getAclVersion());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)newId, (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/directory");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/file");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/layer");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/ROOT/directory");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/ROOT/file");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/layer");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "bob", "ContentReviewer", true);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)newId, (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/directory");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/file");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)6);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/layer");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)7);
            newId = this.avmACLDAO.getAccessControlList(nodeRef).getId();
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)7);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)7);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/ROOT/directory");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)7);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            desc = this.avmService.lookup(-1, storeName + ":/layer/avm-web-apps/ROOT/file");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)7);
            AVMServicePermissionsTest.assertEquals((Object)this.aclDaoComponent.getInheritedAccessControlList(newId), (Object)this.avmACLDAO.getAccessControlList(nodeRef).getId());
            Object var8_7 = null;
            this.removeStore(storeName);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.removeStore(storeName);
            throw throwable;
        }
    }

    private void debugPermissions(String path) {
        AVMNodeDescriptor desc = this.avmService.lookup(-1, path);
        NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
        Acl acl = this.avmACLDAO.getAccessControlList(nodeRef);
        System.out.println(path);
        System.out.println("\t => Ind=" + desc.getIndirection() + ",Deleted=" + desc.isDeleted() + ",LD=" + desc.isLayeredDirectory() + ",LF=" + desc.isLayeredFile() + ",PD=" + desc.isPlainDirectory() + ",PF=" + desc.isPlainFile() + ",Primary=" + desc.isPrimary());
        System.out.println("\t => " + acl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMutationsWithSimpleLayers() throws IOException {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            this.avmService.createStore(storeName);
            this.avmService.createDirectory(storeName + ":/", "www");
            this.avmService.createDirectory(storeName + ":/www", "avm-web-apps");
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps", ROOT);
            AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + ":/www");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "GROUP_EVERYONE", "All", true);
            this.permissionService.setPermission(nodeRef, "manager", "ContentManager", true);
            this.permissionService.setPermission(nodeRef, "publisher", "ContentPublisher", true);
            this.permissionService.setPermission(nodeRef, "contributor", "ContentContributor", true);
            this.permissionService.setPermission(nodeRef, "reviewer", "ContentReviewer", true);
            this.avmService.createSnapshot(storeName, null, null);
            this.avmService.createStore(storeName + "-a-");
            this.avmService.createLayeredDirectory(storeName + ":/www", storeName + "-a-:/", "www");
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps/ROOT", "directory");
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/directory");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            this.avmService.createDirectory(storeName + "-a-:/www/avm-web-apps/ROOT", "directory2");
            desc = this.avmService.lookup(-1, storeName + "-a-:/www/avm-web-apps/ROOT/directory2");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)5);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "andy", "ContentReviewer", true);
            this.permissionService.setPermission(nodeRef, "lemur", "ContentReviewer", true);
            desc = this.avmService.lookup(-1, storeName + "-a-:/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "bob", "ContentReviewer", true);
            this.permissionService.setPermission(nodeRef, "jim", "ContentReviewer", true);
            this.permissionService.setPermission(nodeRef, "dave", "ContentReviewer", true);
            this.avmService.createFile(storeName + ":/www/avm-web-apps/ROOT", "file").close();
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/file");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)7);
            this.avmService.createFile(storeName + "-a-:/www/avm-web-apps/ROOT", "file2").close();
            desc = this.avmService.lookup(-1, storeName + "-a-:/www/avm-web-apps/ROOT/file2");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)10);
            Object var5_4 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-a-");
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-a-");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRenamePlainDirectory() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            this.avmService.createStore(storeName);
            this.avmService.createDirectory(storeName + ":/", "www");
            AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + ":/www");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "one", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.createDirectory(storeName + ":/www", "avm-web-apps");
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "two", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps", ROOT);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "three", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps/ROOT", "test");
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/test");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "four", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.rename(storeName + ":/www/avm-web-apps/ROOT", "test", storeName + ":/www/avm-web-apps/ROOT", "lemon");
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/lemon");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.rename(storeName + ":/www/avm-web-apps/ROOT", "lemon", storeName + ":/www/avm-web-apps", "orange");
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/orange");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            this.avmService.rename(storeName + ":/www/avm-web-apps", "orange", storeName + ":/www", "blue");
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/orange");
            desc = this.avmService.lookup(-1, storeName + ":/www/blue");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            Object var5_4 = null;
            this.removeStore(storeName);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.removeStore(storeName);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRenamePlainFile() throws IOException {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            this.avmService.createStore(storeName);
            this.avmService.createDirectory(storeName + ":/", "www");
            AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + ":/www");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "one", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.createDirectory(storeName + ":/www", "avm-web-apps");
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "two", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps", ROOT);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "three", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.createFile(storeName + ":/www/avm-web-apps/ROOT", "test").close();
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/test");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "four", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.rename(storeName + ":/www/avm-web-apps/ROOT", "test", storeName + ":/www/avm-web-apps/ROOT", "lemon");
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/lemon");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.rename(storeName + ":/www/avm-web-apps/ROOT", "lemon", storeName + ":/www/avm-web-apps", "orange");
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/orange");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            this.avmService.rename(storeName + ":/www/avm-web-apps", "orange", storeName + ":/www", "blue");
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/orange");
            desc = this.avmService.lookup(-1, storeName + ":/www/blue");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            Object var5_4 = null;
            this.removeStore(storeName);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.removeStore(storeName);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRenamePlainDirectoryIntoLayer() {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            this.avmService.createStore(storeName);
            this.avmService.createDirectory(storeName + ":/", "www");
            AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + ":/www");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "one", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.createDirectory(storeName + ":/www", "avm-web-apps");
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "two", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps", ROOT);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "three", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps/ROOT", "test");
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/test");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "four", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.createSnapshot(storeName, null, null);
            this.avmService.createStore(storeName + "-a-");
            this.avmService.createLayeredDirectory(storeName + ":/www", storeName + "-a-:/", "www");
            this.avmService.rename(storeName + "-a-:/www/avm-web-apps/ROOT", "test", storeName + "-a-:/www/avm-web-apps/ROOT", "banana");
            Object var5_4 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-a-");
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-a-");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRenamePlainFileIntoLayer() throws IOException {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            this.avmService.createStore(storeName);
            this.avmService.createDirectory(storeName + ":/", "www");
            AVMNodeDescriptor desc = this.avmService.lookup(-1, storeName + ":/www");
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "one", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.createDirectory(storeName + ":/www", "avm-web-apps");
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "two", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.createDirectory(storeName + ":/www/avm-web-apps", ROOT);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "three", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.createFile(storeName + ":/www/avm-web-apps/ROOT", "test").close();
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT/test");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            this.permissionService.setPermission(nodeRef, "four", "All", true);
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)4);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps/ROOT");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)3);
            desc = this.avmService.lookup(-1, storeName + ":/www/avm-web-apps");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)2);
            desc = this.avmService.lookup(-1, storeName + ":/www");
            nodeRef = AVMNodeConverter.ToNodeRef(-1, desc.getPath());
            AVMServicePermissionsTest.assertEquals((int)this.permissionService.getSetPermissions(nodeRef).getPermissionEntries().size(), (int)1);
            this.avmService.createSnapshot(storeName, null, null);
            this.avmService.createStore(storeName + "-a-");
            this.avmService.createLayeredDirectory(storeName + ":/www", storeName + "-a-:/", "www");
            this.avmService.rename(storeName + "-a-:/www/avm-web-apps/ROOT", "test", storeName + "-a-:/www/avm-web-apps/ROOT", "banana");
            Object var5_4 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-a-");
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.removeStore(storeName);
            this.removeStore(storeName + "-a-");
            throw throwable;
        }
    }

    protected void recursiveList(String store) {
        String list = this.recursiveList(store, -1, true);
        System.out.println(store + ":");
        System.out.println(list);
    }

    protected String recursiveList(String repoName, int version, boolean followLinks) {
        return this.recursiveList(repoName + ":/", version, 0, followLinks);
    }

    protected String recursiveList(String path, int version, int indent, boolean followLinks) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            builder.append(' ');
        }
        builder.append(path.substring(path.lastIndexOf(47) + 1));
        builder.append(' ');
        AVMNodeDescriptor desc = this.avmService.lookup(version, path, true);
        builder.append(desc.toString());
        builder.append(" - ");
        AVMNode layeredNode = this.avmNodeDAO.getByID(desc.getId());
        Acl acl = layeredNode.getAcl();
        builder.append(acl);
        builder.append('\n');
        if (desc.getType() == 2 || desc.getType() == 3 && followLinks) {
            String basename = path.endsWith("/") ? path : path + "/";
            SortedMap<String, AVMNodeDescriptor> listing = this.avmService.getDirectoryListing(version, path);
            for (String name : listing.keySet()) {
                builder.append(this.recursiveList(basename + name, version, indent + 2, followLinks));
            }
        }
        return builder.toString();
    }

    private void createStagingWithSnapshots(String storeName) throws IOException {
        this.removeStore(storeName);
        this.avmService.createStore(storeName);
        AVMServicePermissionsTest.assertNotNull((Object)this.avmService.getStore(storeName));
        this.avmService.createDirectory(storeName + ":/", "www");
        this.avmService.createSnapshot(storeName, "first", "first");
        AVMServicePermissionsTest.assertNotNull((Object)this.avmService.lookup(-1, storeName + ":/" + "www"));
        this.avmService.createDirectory(storeName + ":/" + "www", "avm_webapps");
        this.avmService.createSnapshot(storeName, "second", "second");
        AVMServicePermissionsTest.assertNotNull((Object)this.avmService.lookup(-1, storeName + ":/" + "www" + "/" + "avm_webapps"));
        this.avmService.createDirectory(storeName + ":/" + "www" + "/" + "avm_webapps", ROOT);
        this.avmService.createSnapshot(storeName, "third", "third");
        AVMServicePermissionsTest.assertNotNull((Object)this.avmService.lookup(-1, storeName + ":/" + "www" + "/" + "avm_webapps" + "/" + ROOT));
        this.avmService.createFile(storeName + ":/" + "www" + "/" + "avm_webapps" + "/" + ROOT, FILE_NAME).close();
        this.avmService.createSnapshot(storeName, "fourth", "fourth");
        AVMServicePermissionsTest.assertNotNull((Object)this.avmService.lookup(-1, storeName + ":/" + "www" + "/" + "avm_webapps" + "/" + ROOT + "/" + FILE_NAME));
    }

    private void removeStore(String storeName) {
        if (this.avmService.getStore(storeName) != null) {
            this.avmService.purgeStore(storeName);
        }
        AVMServicePermissionsTest.assertNull((Object)this.avmService.getStore(storeName));
    }

    public void testSetInheritParentPermissions() throws Exception {
        this.runAs(AuthenticationUtil.getAdminUserName());
        String storeName = "PermissionsTest-" + this.getName() + "-" + new Date().getTime();
        try {
            try {
                this.createStagingWithSnapshots(storeName);
                AVMNodeDescriptor nodeDescriptor = this.avmService.lookup(-1, storeName + ":/" + "www" + "/" + "avm_webapps" + "/" + ROOT + "/" + FILE_NAME);
                AVMServicePermissionsTest.assertNotNull((Object)nodeDescriptor);
                NodeRef nodeRef = AVMNodeConverter.ToNodeRef(-1, nodeDescriptor.getPath());
                AVMServicePermissionsTest.assertNotNull((Object)nodeRef);
                this.permissionService.setInheritParentPermissions(nodeRef, false);
                AVMServicePermissionsTest.assertFalse((boolean)this.permissionService.getInheritParentPermissions(nodeRef));
                this.permissionService.setInheritParentPermissions(nodeRef, true);
                AVMServicePermissionsTest.assertTrue((boolean)this.permissionService.getInheritParentPermissions(nodeRef));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            Object var5_5 = null;
            this.removeStore(storeName);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.removeStore(storeName);
            throw throwable;
        }
    }
}

