/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.AVMRepository;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.BasicAttributes;
import org.alfresco.repo.avm.ChildEntry;
import org.alfresco.repo.avm.ChildEntryImpl;
import org.alfresco.repo.avm.ChildKey;
import org.alfresco.repo.avm.DeletedNodeImpl;
import org.alfresco.repo.avm.DirectoryNode;
import org.alfresco.repo.avm.DirectoryNodeImpl;
import org.alfresco.repo.avm.LayeredDirectoryNode;
import org.alfresco.repo.avm.Lookup;
import org.alfresco.repo.avm.PlainDirectoryNode;
import org.alfresco.repo.avm.PlainFileNode;
import org.alfresco.repo.avm.util.AVMUtil;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.repo.security.permissions.ACLCopyMode;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.service.cmr.avm.AVMBadArgumentException;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.AVMExistsException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayeredDirectoryNodeImpl
extends DirectoryNodeImpl
implements LayeredDirectoryNode {
    static final long serialVersionUID = 4623043057918181724L;
    private long fLayerID;
    private String fIndirection;
    private boolean fPrimaryIndirection;
    private boolean fOpacity;
    private int fIndirectionVersion;

    public LayeredDirectoryNodeImpl() {
    }

    public LayeredDirectoryNodeImpl(String indirection, AVMStore store, AVMNode toCopy, Long parentAcl, ACLCopyMode mode) {
        super(store);
        this.setLayerID(-1L);
        this.setIndirection(indirection);
        this.setIndirectionVersion(-1);
        this.setPrimaryIndirection(true);
        this.setOpacity(false);
        if (toCopy != null) {
            this.setVersionID(toCopy.getVersionID() + 1);
            this.copyACLs(toCopy, parentAcl, mode);
            this.copyCreationAndOwnerBasicAttributes(toCopy);
        } else {
            this.setVersionID(1);
            if (indirection != null) {
                Lookup lookup = AVMRepository.GetInstance().lookupDirectory(-1, indirection);
                if (lookup != null) {
                    DirectoryNode dir = (DirectoryNode)lookup.getCurrentNode();
                    if (dir.getAcl() != null) {
                        this.setAcl(AVMDAOs.Instance().fAclDAO.createLayeredAcl(dir.getAcl().getId()));
                    } else {
                        this.setAcl(AVMDAOs.Instance().fAclDAO.createLayeredAcl(null));
                    }
                } else {
                    this.setAcl(AVMDAOs.Instance().fAclDAO.createLayeredAcl(null));
                }
            } else {
                this.setAcl(AVMDAOs.Instance().fAclDAO.createLayeredAcl(null));
            }
        }
        AVMDAOs.Instance().fAVMNodeDAO.save(this);
        if (toCopy != null) {
            this.copyProperties(toCopy);
            this.copyAspects(toCopy);
        }
    }

    public LayeredDirectoryNodeImpl(LayeredDirectoryNode other, AVMStore repos, Lookup lookup, boolean copyAll, Long parentAcl, ACLCopyMode mode) {
        super(repos);
        this.setLayerID(-1L);
        this.setIndirection(other.getIndirection());
        this.setIndirectionVersion(-1);
        this.setPrimaryIndirection(other.getPrimaryIndirection());
        this.setOpacity(other.getOpacity());
        this.setVersionID(other.getVersionID() + 1);
        this.copyACLs(other, parentAcl, mode);
        this.copyCreationAndOwnerBasicAttributes(other);
        AVMDAOs.Instance().fAVMNodeDAO.save(this);
        this.copyProperties(other);
        this.copyAspects(other);
        Map<String, AVMNode> children = null;
        children = copyAll ? other.getListing(lookup, true) : other.getListingDirect(lookup, true);
        for (Map.Entry<String, AVMNode> child : children.entrySet()) {
            ChildKey key = new ChildKey(this, child.getKey());
            ChildEntryImpl entry = new ChildEntryImpl(key, child.getValue());
            AVMDAOs.Instance().fChildEntryDAO.save(entry);
        }
    }

    public LayeredDirectoryNodeImpl(PlainDirectoryNode other, AVMStore store, Lookup lPath, boolean copyContents, Long parentAcl, ACLCopyMode mode) {
        super(store);
        this.setLayerID(-1L);
        this.setIndirection(null);
        this.setIndirectionVersion(-1);
        this.setPrimaryIndirection(false);
        this.setOpacity(false);
        this.setVersionID(other.getVersionID() + 1);
        this.copyACLs(other, parentAcl, mode);
        this.copyCreationAndOwnerBasicAttributes(other);
        AVMDAOs.Instance().fAVMNodeDAO.save(this);
        this.copyProperties(other);
        this.copyAspects(other);
        if (copyContents) {
            for (ChildEntry child : AVMDAOs.Instance().fChildEntryDAO.getByParent(other, null)) {
                ChildKey key = new ChildKey(this, child.getKey().getName());
                ChildEntryImpl newChild = new ChildEntryImpl(key, child.getChild());
                AVMDAOs.Instance().fChildEntryDAO.save(newChild);
            }
        }
    }

    public LayeredDirectoryNodeImpl(DirectoryNode dir, AVMStore store, Lookup srcLookup, String name, Long inheritedAcl, ACLCopyMode mode) {
        super(store);
        this.setLayerID(-1L);
        this.setIndirection(srcLookup.getIndirectionPath() + "/" + name);
        this.setIndirectionVersion(-1);
        this.setPrimaryIndirection(true);
        this.setOpacity(false);
        this.setVersionID(dir.getVersionID() + 1);
        this.copyACLs(dir, inheritedAcl, mode);
        this.copyCreationAndOwnerBasicAttributes(dir);
        AVMDAOs.Instance().fAVMNodeDAO.save(this);
        this.copyProperties(dir);
        this.copyAspects(dir);
        Map<String, AVMNode> children = dir.getListing(srcLookup, true);
        for (Map.Entry<String, AVMNode> child : children.entrySet()) {
            ChildKey key = new ChildKey(this, child.getKey());
            ChildEntryImpl entry = new ChildEntryImpl(key, child.getValue());
            AVMDAOs.Instance().fChildEntryDAO.save(entry);
        }
    }

    @Override
    public boolean getPrimaryIndirection() {
        return this.fPrimaryIndirection;
    }

    @Override
    public void setPrimaryIndirection(boolean has) {
        this.fPrimaryIndirection = has;
    }

    @Override
    public String getIndirection() {
        return this.fIndirection;
    }

    @Override
    public String getUnderlying(Lookup lPath) {
        if (this.getPrimaryIndirection()) {
            return this.getIndirection();
        }
        return lPath.getCurrentIndirection();
    }

    @Override
    public int getUnderlyingVersion(Lookup lPath) {
        if (lPath.getVersion() == -1) {
            return -1;
        }
        if (this.getPrimaryIndirection()) {
            return this.getIndirectionVersion();
        }
        return lPath.getCurrentIndirectionVersion();
    }

    @Override
    public long getLayerID() {
        return this.fLayerID;
    }

    @Override
    public void setLayerID(long id) {
        this.fLayerID = id;
    }

    @Override
    public AVMNode copy(Lookup lPath) {
        DirectoryNode dir = lPath.getCurrentNodeDirectory();
        Long parentAclId = null;
        if (dir != null && dir.getAcl() != null) {
            parentAclId = dir.getAcl().getId();
        }
        AVMStore store = lPath.getAVMStore();
        LayeredDirectoryNodeImpl newMe = null;
        if (!lPath.isInThisLayer()) {
            newMe = new LayeredDirectoryNodeImpl(null, store, this, parentAclId, ACLCopyMode.COW);
            newMe.setPrimaryIndirection(false);
            newMe.setLayerID(lPath.getTopLayer().getLayerID());
        } else {
            newMe = new LayeredDirectoryNodeImpl(this, store, lPath, false, parentAclId, ACLCopyMode.COW);
            newMe.setLayerID(this.getLayerID());
        }
        newMe.setAncestor(this);
        AVMDAOs.Instance().fAVMNodeDAO.update(newMe);
        return newMe;
    }

    @Override
    public void putChild(String name, AVMNode node) {
        ChildKey key;
        ChildEntry existing;
        if (DEBUG) {
            this.checkReadOnly();
        }
        if ((existing = AVMDAOs.Instance().fChildEntryDAO.get(key = new ChildKey(this, name))) != null) {
            AVMDAOs.Instance().fChildEntryDAO.delete(existing);
        }
        ChildEntryImpl entry = new ChildEntryImpl(key, node);
        AVMDAOs.Instance().fChildEntryDAO.save(entry);
    }

    @Override
    public Map<String, AVMNode> getListing(Lookup lPath, boolean includeDeleted) {
        return this.getListing(lPath, null, includeDeleted);
    }

    @Override
    public Map<String, AVMNode> getListing(Lookup lPath, String childNamePattern, boolean includeDeleted) {
        Lookup lookup;
        HashMap<String, AVMNode> listing = new HashMap<String, AVMNode>();
        HashMap<String, String> baseLowerKeyName = new HashMap<String, String>();
        if (!this.getOpacity() && (lookup = AVMRepository.GetInstance().lookupDirectory(this.getUnderlyingVersion(lPath), this.getUnderlying(lPath))) != null) {
            DirectoryNode dir = (DirectoryNode)lookup.getCurrentNode();
            Map<String, AVMNode> underListing = dir.getListing(lookup, childNamePattern, includeDeleted);
            for (Map.Entry<String, AVMNode> entry : underListing.entrySet()) {
                if ((entry.getValue().getType() == 3 || entry.getValue().getType() == 2) && !AVMRepository.GetInstance().can(lookup.getAVMStore(), entry.getValue(), "ReadChildren", false)) continue;
                listing.put(entry.getKey(), entry.getValue());
                baseLowerKeyName.put(entry.getKey().toLowerCase(), entry.getKey());
            }
        }
        for (ChildEntry entry : AVMDAOs.Instance().fChildEntryDAO.getByParent(this, childNamePattern)) {
            if ((entry.getChild().getType() == 3 || entry.getChild().getType() == 2) && !AVMRepository.GetInstance().can(lPath.getAVMStore(), entry.getChild(), "ReadChildren", lPath.getDirectlyContained())) continue;
            if (!includeDeleted && entry.getChild().getType() == 4) {
                listing.remove(entry.getKey().getName());
                continue;
            }
            String keyName = (String)baseLowerKeyName.get(entry.getKey().getName().toLowerCase());
            if (keyName != null) {
                listing.remove(keyName);
            }
            listing.put(entry.getKey().getName(), entry.getChild());
        }
        return listing;
    }

    @Override
    public Map<String, AVMNode> getListingDirect(Lookup lPath, boolean includeDeleted) {
        HashMap<String, AVMNode> listing = new HashMap<String, AVMNode>();
        for (ChildEntry entry : AVMDAOs.Instance().fChildEntryDAO.getByParent(this, null)) {
            if ((entry.getChild().getType() == 3 || entry.getChild().getType() == 2) && !AVMRepository.GetInstance().can(lPath != null ? lPath.getAVMStore() : null, entry.getChild(), "ReadChildren", lPath != null ? lPath.getDirectlyContained() : false) || !includeDeleted && entry.getChild().getType() == 4) continue;
            listing.put(entry.getKey().getName(), entry.getChild());
        }
        return listing;
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getListingDirect(AVMNodeDescriptor dir, boolean includeDeleted) {
        List<ChildEntry> children = AVMDAOs.Instance().fChildEntryDAO.getByParent(this, null);
        TreeMap<String, AVMNodeDescriptor> listing = new TreeMap<String, AVMNodeDescriptor>(String.CASE_INSENSITIVE_ORDER);
        for (ChildEntry child : children) {
            AVMNode childNode = child.getChild();
            if ((childNode.getType() == 3 || childNode.getType() == 2) && !AVMRepository.GetInstance().can(null, childNode, "ReadChildren", false) || !includeDeleted && childNode.getType() == 4) continue;
            AVMNodeDescriptor childDesc = childNode.getDescriptor(dir.getPath(), child.getKey().getName(), dir.getIndirection(), dir.getIndirectionVersion());
            listing.put(child.getKey().getName(), childDesc);
        }
        return listing;
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getListing(AVMNodeDescriptor dir, boolean includeDeleted) {
        return this.getListing(dir, null, includeDeleted);
    }

    @Override
    public SortedMap<String, AVMNodeDescriptor> getListing(AVMNodeDescriptor dir, String childNamePattern, boolean includeDeleted) {
        Lookup lookup;
        if (dir.getPath() == null || dir.getIndirection() == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        TreeMap<String, AVMNodeDescriptor> listing = new TreeMap<String, AVMNodeDescriptor>(String.CASE_INSENSITIVE_ORDER);
        HashMap<String, String> baseLowerKeyName = new HashMap<String, String>();
        if (!this.getOpacity() && (lookup = AVMRepository.GetInstance().lookupDirectory(dir.getIndirectionVersion(), dir.getIndirection())) != null) {
            DirectoryNode dirNode = (DirectoryNode)lookup.getCurrentNode();
            Map<String, AVMNode> underListing = dirNode.getListing(lookup, childNamePattern, includeDeleted);
            for (Map.Entry<String, AVMNode> entry : underListing.entrySet()) {
                if ((entry.getValue().getType() == 3 || entry.getValue().getType() == 2) && !AVMRepository.GetInstance().can(null, entry.getValue(), "ReadChildren", false)) continue;
                listing.put(entry.getKey(), entry.getValue().getDescriptor(dir.getPath(), entry.getKey(), lookup.getCurrentIndirection(), lookup.getCurrentIndirectionVersion()));
                baseLowerKeyName.put(entry.getKey().toLowerCase(), entry.getKey());
            }
        }
        for (ChildEntry entry : AVMDAOs.Instance().fChildEntryDAO.getByParent(this, childNamePattern)) {
            if ((entry.getChild().getType() == 3 || entry.getChild().getType() == 2) && !AVMRepository.GetInstance().can(null, entry.getChild(), "ReadChildren", false)) continue;
            if (!includeDeleted && entry.getChild().getType() == 4) {
                listing.remove(entry.getKey().getName());
                continue;
            }
            String keyName = (String)baseLowerKeyName.get(entry.getKey().getName().toLowerCase());
            if (keyName != null) {
                listing.remove(keyName);
            }
            listing.put(entry.getKey().getName(), entry.getChild().getDescriptor(dir.getPath(), entry.getKey().getName(), dir.getIndirection(), dir.getIndirectionVersion()));
        }
        return listing;
    }

    @Override
    public List<String> getDeletedNames() {
        List<ChildEntry> children = AVMDAOs.Instance().fChildEntryDAO.getByParent(this, null);
        ArrayList<String> listing = new ArrayList<String>();
        for (ChildEntry entry : children) {
            if (entry.getChild().getType() != 4) continue;
            listing.add(entry.getKey().getName());
        }
        return listing;
    }

    @Override
    public Pair<ChildEntry, Boolean> lookupChildEntry(Lookup lPath, String name, boolean includeDeleted) {
        ChildKey key = new ChildKey(this, name);
        ChildEntry entry = AVMDAOs.Instance().fChildEntryDAO.get(key);
        if (entry != null) {
            if (!includeDeleted && entry.getChild().getType() == 4) {
                return null;
            }
            Pair result = new Pair((Object)entry, (Object)true);
            return result;
        }
        if (this.getOpacity()) {
            return null;
        }
        Lookup lookup = AVMRepository.GetInstance().lookupDirectory(this.getUnderlyingVersion(lPath), this.getUnderlying(lPath));
        if (lookup != null) {
            DirectoryNode dir = (DirectoryNode)lookup.getCurrentNode();
            Pair<ChildEntry, Boolean> retVal = dir.lookupChildEntry(lookup, name, includeDeleted);
            if (retVal != null) {
                retVal.setSecond((Object)false);
            }
            lPath.setFinalStore(lookup.getFinalStore());
            return retVal;
        }
        return null;
    }

    @Override
    public AVMNodeDescriptor lookupChild(AVMNodeDescriptor mine, String name, boolean includeDeleted) {
        if (mine.getPath() == null || mine.getIndirection() == null) {
            throw new AVMBadArgumentException("Illegal null argument.");
        }
        ChildKey key = new ChildKey(this, name);
        ChildEntry entry = AVMDAOs.Instance().fChildEntryDAO.get(key);
        if (entry != null) {
            if (!includeDeleted && entry.getChild().getType() == 4) {
                return null;
            }
            AVMNodeDescriptor desc = entry.getChild().getDescriptor(mine.getPath(), name, mine.getIndirection(), mine.getIndirectionVersion());
            return desc;
        }
        if (this.getOpacity()) {
            return null;
        }
        Lookup lookup = AVMRepository.GetInstance().lookupDirectory(mine.getIndirectionVersion(), mine.getIndirection());
        if (lookup != null) {
            DirectoryNode dir = (DirectoryNode)lookup.getCurrentNode();
            Pair<AVMNode, Boolean> child = dir.lookupChild(lookup, name, includeDeleted);
            if (child == null) {
                return null;
            }
            AVMNodeDescriptor desc = ((AVMNode)child.getFirst()).getDescriptor(lookup);
            return desc;
        }
        return null;
    }

    @Override
    public void removeChild(Lookup lPath, String name) {
        if (DEBUG) {
            this.checkReadOnly();
        }
        ChildKey key = new ChildKey(this, name);
        ChildEntry entry = AVMDAOs.Instance().fChildEntryDAO.get(key);
        AVMNode child = null;
        boolean indirect = false;
        if (entry != null) {
            child = entry.getChild();
            if (child.getType() == 4) {
                return;
            }
            AVMDAOs.Instance().fChildEntryDAO.delete(entry);
            Lookup lookup = AVMRepository.GetInstance().lookup(-1, AVMUtil.extendAVMPath(lPath.getRepresentedPath(), name), true);
            if (!(0 != child.getType() && 3 != child.getType() && 2 != child.getType() || lookup != null && lookup.getIndirectionPath() != null || this.lookupChild(lPath, name, true) != null)) {
                return;
            }
        } else {
            Pair<AVMNode, Boolean> temp = this.lookupChild(lPath, name, false);
            child = temp == null ? null : (AVMNode)temp.getFirst();
            indirect = true;
        }
        if (child != null && (indirect || child.getStoreNew() == null || child.getAncestor() != null)) {
            DeletedNodeImpl ghost = new DeletedNodeImpl(lPath.getAVMStore(), child.getAcl());
            AVMDAOs.Instance().fAVMNodeDAO.save(ghost);
            ghost.setAncestor(child);
            ghost.setDeletedType(child.getType());
            ghost.copyCreationAndOwnerBasicAttributes(child);
            ghost.copyAspects(child);
            ghost.copyProperties(child);
            AVMDAOs.Instance().fAVMNodeDAO.update(ghost);
            this.putChild(name, ghost);
        }
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public String toString(Lookup lPath) {
        return "[LD:" + this.getId() + (lPath != null ? ":" + this.getUnderlying(lPath) : "") + "]";
    }

    @Override
    public void rawSetPrimary(Lookup lPath, String path) {
        if (DEBUG) {
            this.checkReadOnly();
        }
        this.setIndirection(path);
        this.setPrimaryIndirection(true);
        if (this.getIndirection() != null) {
            if (this.getAcl() == null || this.getAcl().getAclType() == ACLType.LAYERED) {
                Acl acl = null;
                Lookup lookup = AVMRepository.GetInstance().lookupDirectory(-1, this.getIndirection());
                if (lookup != null) {
                    DirectoryNode dir = (DirectoryNode)lookup.getCurrentNode();
                    acl = dir.getAcl() != null ? (this.getAcl() == null ? AVMDAOs.Instance().fAclDAO.createLayeredAcl(dir.getAcl().getId()) : AVMDAOs.Instance().fAclDAO.getAclCopy(this.getAcl().getId(), dir.getAcl().getId(), ACLCopyMode.REDIRECT)) : (this.getAcl() == null ? AVMDAOs.Instance().fAclDAO.createLayeredAcl(null) : AVMDAOs.Instance().fAclDAO.getAclCopy(this.getAcl().getId(), null, ACLCopyMode.REDIRECT));
                }
                this.setAclAndInherit(this, acl, null);
            }
        } else if (this.getAcl().getAclType() == ACLType.LAYERED) {
            Acl acl = null;
            acl = this.getAcl() == null ? AVMDAOs.Instance().fAclDAO.createLayeredAcl(null) : AVMDAOs.Instance().fAclDAO.getAclCopy(this.getAcl().getId(), null, ACLCopyMode.REDIRECT);
            this.setAclAndInherit(this, acl, null);
        }
    }

    @Override
    public void setAclAndInherit(LayeredDirectoryNode layeredDirectory, Acl acl, String name) {
        layeredDirectory.setAcl(acl);
        AVMDAOs.Instance().fAVMNodeDAO.update(layeredDirectory);
        Map<String, AVMNode> directChildren = layeredDirectory.getListingDirect((Lookup)null, true);
        for (String key : directChildren.keySet()) {
            Acl currentAcl;
            AVMNode childNode;
            AVMNode node = directChildren.get(key);
            if (node instanceof LayeredDirectoryNode) {
                childNode = (LayeredDirectoryNode)node;
                currentAcl = node.getAcl();
                if (currentAcl == null) {
                    if (acl == null) {
                        childNode.setAclAndInherit((LayeredDirectoryNode)childNode, null, key);
                        continue;
                    }
                    childNode.setAclAndInherit((LayeredDirectoryNode)childNode, AVMDAOs.Instance().fAclDAO.getAclCopy(acl.getId(), acl.getId(), ACLCopyMode.REDIRECT), key);
                    continue;
                }
                if (acl == null) {
                    childNode.setAclAndInherit((LayeredDirectoryNode)childNode, currentAcl, key);
                    continue;
                }
                childNode.setAclAndInherit((LayeredDirectoryNode)childNode, AVMDAOs.Instance().fAclDAO.getAclCopy(currentAcl.getId(), acl.getId(), ACLCopyMode.REDIRECT), key);
                continue;
            }
            if (!(node instanceof PlainFileNode)) continue;
            childNode = (PlainFileNode)node;
            currentAcl = node.getAcl();
            if (currentAcl == null) {
                if (acl == null) {
                    childNode.setAcl(null);
                } else {
                    childNode.setAcl(AVMDAOs.Instance().fAclDAO.getAclCopy(acl.getId(), acl.getId(), ACLCopyMode.REDIRECT));
                }
            } else if (acl == null) {
                childNode.setAcl(currentAcl);
            } else {
                childNode.setAcl(AVMDAOs.Instance().fAclDAO.getAclCopy(currentAcl.getId(), acl.getId(), ACLCopyMode.REDIRECT));
            }
            AVMDAOs.Instance().fAVMNodeDAO.update(childNode);
        }
    }

    @Override
    public void turnPrimary(Lookup lPath) {
        if (DEBUG) {
            this.checkReadOnly();
        }
        String path = lPath.getCurrentIndirection();
        this.rawSetPrimary(lPath, path);
    }

    @Override
    public void retarget(Lookup lPath, String target) {
        if (DEBUG) {
            this.checkReadOnly();
        }
        this.rawSetPrimary(lPath, target);
    }

    @Override
    public void uncover(Lookup lPath, String name) {
        ChildKey key;
        ChildEntry entry;
        if (DEBUG) {
            this.checkReadOnly();
        }
        if ((entry = AVMDAOs.Instance().fChildEntryDAO.get(key = new ChildKey(this, name))).getChild().getType() != 4) {
            throw new AVMException("One can only uncover deleted nodes.");
        }
        if (entry != null) {
            AVMDAOs.Instance().fChildEntryDAO.delete(entry);
        }
    }

    @Override
    public AVMNodeDescriptor getDescriptor(Lookup lPath, String name) {
        BasicAttributes attrs = this.getBasicAttributes();
        String path = lPath.getRepresentedPath();
        path = AVMNodeConverter.ExtendAVMPath(path, name);
        int indirectionVersion = this.getUnderlyingVersion(lPath);
        String indirect = null;
        indirect = this.getPrimaryIndirection() ? this.getIndirection() : AVMNodeConverter.ExtendAVMPath(lPath.getCurrentIndirection(), name);
        return new AVMNodeDescriptor(path, name, 3, attrs.getCreator(), attrs.getOwner(), attrs.getLastModifier(), attrs.getCreateDate(), attrs.getModDate(), attrs.getAccessDate(), this.getId(), this.getGuid(), this.getVersionID(), indirect, indirectionVersion, this.getPrimaryIndirection(), this.getLayerID(), this.getOpacity(), -1L, -1);
    }

    @Override
    public AVMNodeDescriptor getDescriptor(Lookup lPath) {
        BasicAttributes attrs = this.getBasicAttributes();
        String path = lPath.getRepresentedPath();
        String name = path.substring(path.lastIndexOf("/") + 1);
        return new AVMNodeDescriptor(path, name, 3, attrs.getCreator(), attrs.getOwner(), attrs.getLastModifier(), attrs.getCreateDate(), attrs.getModDate(), attrs.getAccessDate(), this.getId(), this.getGuid(), this.getVersionID(), this.getUnderlying(lPath), this.getUnderlyingVersion(lPath), this.getPrimaryIndirection(), this.getLayerID(), this.getOpacity(), -1L, -1);
    }

    @Override
    public AVMNodeDescriptor getDescriptor(String parentPath, String name, String parentIndirection, int parentIndirectionVersion) {
        BasicAttributes attrs = this.getBasicAttributes();
        String path = parentPath.endsWith("/") ? parentPath + name : parentPath + "/" + name;
        String indirection = null;
        int indirectionVersion = -1;
        if (this.getPrimaryIndirection()) {
            indirection = this.getIndirection();
            indirectionVersion = this.getIndirectionVersion();
        } else {
            indirection = parentIndirection.endsWith("/") ? parentIndirection + name : parentIndirection + "/" + name;
            indirectionVersion = parentIndirectionVersion;
        }
        return new AVMNodeDescriptor(path, name, 3, attrs.getCreator(), attrs.getOwner(), attrs.getLastModifier(), attrs.getCreateDate(), attrs.getModDate(), attrs.getAccessDate(), this.getId(), this.getGuid(), this.getVersionID(), indirection, indirectionVersion, this.getPrimaryIndirection(), this.getLayerID(), this.getOpacity(), -1L, -1);
    }

    @Override
    public void setIndirection(String indirection) {
        this.fIndirection = indirection;
    }

    @Override
    public void setIsRoot(boolean isRoot) {
    }

    @Override
    public boolean getOpacity() {
        return this.fOpacity;
    }

    @Override
    public void setOpacity(boolean opacity) {
        this.fOpacity = opacity;
    }

    @Override
    public void link(Lookup lPath, String name, AVMNodeDescriptor toLink) {
        AVMNode node;
        if (DEBUG) {
            this.checkReadOnly();
        }
        if ((node = AVMDAOs.Instance().fAVMNodeDAO.getByID(toLink.getId())) == null) {
            throw new AVMNotFoundException("Not Found: " + toLink.getId());
        }
        if (node.getType() == 3 && !((LayeredDirectoryNode)node).getPrimaryIndirection()) {
            throw new AVMBadArgumentException("Non primary layered directories cannot be linked.");
        }
        Pair<AVMNode, Boolean> temp = this.lookupChild(lPath, name, true);
        AVMNode existing = temp == null ? null : (AVMNode)temp.getFirst();
        ChildKey key = new ChildKey(this, name);
        if (existing != null) {
            if (existing.getType() != 4) {
                throw new AVMExistsException(name + " exists.");
            }
            if (this.directlyContains(existing)) {
                ChildEntry entry = AVMDAOs.Instance().fChildEntryDAO.get(key);
                AVMDAOs.Instance().fChildEntryDAO.delete(entry);
            }
        }
        ChildEntryImpl newChild = new ChildEntryImpl(key, node);
        AVMDAOs.Instance().fChildEntryDAO.save(newChild);
    }

    @Override
    public void flatten(String name) {
        ChildKey key;
        ChildEntry entry;
        if (DEBUG) {
            this.checkReadOnly();
        }
        if ((entry = AVMDAOs.Instance().fChildEntryDAO.get(key = new ChildKey(this, name))) != null) {
            AVMDAOs.Instance().fChildEntryDAO.delete(entry);
        }
    }

    @Override
    public void setIndirectionVersion(Integer version) {
        this.fIndirectionVersion = version == null ? -1 : version;
    }

    @Override
    public Integer getIndirectionVersion() {
        return this.fIndirectionVersion;
    }
}

