/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.avm.AVMServiceTestBase;
import org.alfresco.repo.avm.util.BulkLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PurgeTestP
extends AVMServiceTestBase {
    private static Log logger = LogFactory.getLog(PurgeTestP.class);

    public void setUp() throws Exception {
        super.setUp();
        this.runOrphanReaper(1000, 0);
    }

    public void testRemoveNodes() throws Throwable {
        try {
            int i;
            logger.info((Object)"testRemoveNodes");
            int fileCount = 10;
            logger.info((Object)("Create " + fileCount + " files ..."));
            for (i = 1; i <= fileCount; ++i) {
                fService.createFile("main:/", "file" + i).close();
            }
            logger.info((Object)("Remove " + fileCount + " files ..."));
            for (i = 1; i <= fileCount; ++i) {
                fService.removeNode("main:/", "file" + i);
            }
            this.runOrphanReaper();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testPurgeVersion() throws Throwable {
        try {
            logger.info((Object)"testPurgeVersion");
            this.setupBasicTree();
            BulkLoader loader = new BulkLoader();
            loader.setAvmService(fService);
            long start = System.currentTimeMillis();
            loader.recursiveLoad("source/java/org/alfresco/repo/avm", "main:/");
            logger.info((Object)("Load time: " + (System.currentTimeMillis() - start) + "ms"));
            fService.createSnapshot("main", null, null);
            logger.info((Object)("Load time + snapshot: " + (System.currentTimeMillis() - start) + "ms"));
            fService.purgeVersion(2, "main");
            this.runOrphanReaper();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testPurgeOlderVersion() throws Throwable {
        try {
            logger.info((Object)"testPurgeOlderVersion");
            this.setupBasicTree();
            BulkLoader loader = new BulkLoader();
            loader.setAvmService(fService);
            long start = System.currentTimeMillis();
            loader.recursiveLoad("source/java/org/alfresco/repo/avm", "main:/");
            logger.info((Object)("Load time: " + (System.currentTimeMillis() - start) + "ms"));
            fService.createSnapshot("main", null, null);
            logger.info((Object)("Load time + snapshot: " + (System.currentTimeMillis() - start) + "ms"));
            fService.removeNode("main:/avm", "actions");
            fService.createSnapshot("main", null, null);
            fService.purgeVersion(2, "main");
            this.runOrphanReaper();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    public void testPurgeStore() throws Throwable {
        try {
            logger.info((Object)"testPurgeStore");
            this.setupBasicTree();
            BulkLoader loader = new BulkLoader();
            loader.setAvmService(fService);
            long start = System.currentTimeMillis();
            loader.recursiveLoad("source/java/org/alfresco/repo/avm", "main:/");
            logger.info((Object)("Load time: " + (System.currentTimeMillis() - start) + "ms"));
            fService.createSnapshot("main", null, null);
            logger.info((Object)("Load time + snapshot: " + (System.currentTimeMillis() - start) + "ms"));
            fService.createLayeredDirectory("main:/avm", "main:/", "layer");
            fService.removeNode("main:/layer", "actions");
            fService.createFile("main:/layer", "goofy").close();
            fService.createSnapshot("main", null, null);
            fService.purgeStore("main");
            this.runOrphanReaper();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
    }

    private void runOrphanReaper() {
        this.runOrphanReaper(-1, -1);
    }

    private void runOrphanReaper(int batchSize, int activeBaseSleep) {
        int cycles;
        logger.info((Object)"Reaper started");
        if (batchSize != -1) {
            fReaper.setBatchSize(batchSize);
        }
        if (activeBaseSleep != -1) {
            fReaper.setActiveBaseSleep(activeBaseSleep);
        }
        fReaper.activate();
        fReaper.execute();
        int maxCycles = 100;
        for (cycles = 0; fReaper.isActive() && cycles <= 100; ++cycles) {
            try {
                logger.info((Object)("Cycle: " + cycles));
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.warn((Object)("OrphanReaper was interrupted - do nothing: " + e));
            }
        }
        if (cycles > 100) {
            throw new AlfrescoRuntimeException("Orphan reaper still active - failed to clean orphans in " + cycles + " wait cycles (max " + 100 + ")");
        }
        if (batchSize != -1) {
            fReaper.setBatchSize(50);
        }
        if (activeBaseSleep != -1) {
            fReaper.setActiveBaseSleep(1000L);
        }
        logger.info((Object)("Reaper finished (in " + cycles + " wait cycles)"));
    }
}

