/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.avm.ibatis;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMStore;
import org.alfresco.repo.avm.AVMStoreDAO;
import org.alfresco.repo.avm.AVMStoreImpl;
import org.alfresco.repo.avm.DirectoryNode;
import org.alfresco.repo.avm.ibatis.AVMNodeDAOIbatis;
import org.alfresco.repo.domain.avm.AVMStoreEntity;
import org.alfresco.repo.domain.permissions.Acl;
import org.alfresco.service.cmr.avm.AVMException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AVMStoreDAOIbatis
implements AVMStoreDAO {
    private static Log logger = LogFactory.getLog(AVMStoreDAOIbatis.class);

    AVMStoreDAOIbatis() {
    }

    @Override
    public void save(AVMStore store) {
        AVMStoreEntity storeEntity = AVMDAOs.Instance().newAVMStoreDAO.createStore(store.getName());
        ((AVMStoreImpl)store).setId(storeEntity.getId());
    }

    @Override
    public void delete(AVMStore store) {
        AVMDAOs.Instance().newAVMStoreDAO.deleteStore(store.getId());
    }

    @Override
    public List<AVMStore> getAll() {
        List<AVMStoreEntity> storeEntities = AVMDAOs.Instance().newAVMStoreDAO.getAllStores();
        ArrayList<AVMStore> result = new ArrayList<AVMStore>(storeEntities.size());
        for (AVMStoreEntity storeEntity : storeEntities) {
            result.add(this.getByID(storeEntity.getId()));
        }
        return result;
    }

    @Override
    public AVMStore getByName(String name) {
        AVMStoreEntity storeEntity = AVMDAOs.Instance().newAVMStoreDAO.getStore(name);
        return this.convertStoreEntityToStore(storeEntity);
    }

    @Override
    public AVMStore getByRoot(AVMNode root) {
        AVMStoreEntity storeEntity = AVMDAOs.Instance().newAVMStoreDAO.getStoreByRoot(root.getId());
        return this.convertStoreEntityToStore(storeEntity);
    }

    @Override
    public void update(AVMStore store) {
        AVMStoreEntity storeEntity = this.convertStoreToStoreEntity(store);
        AVMDAOs.Instance().newAVMStoreDAO.updateStore(storeEntity);
        ((AVMStoreImpl)store).setVers(storeEntity.getVers());
    }

    @Override
    public AVMStore getByID(long id) {
        AVMStoreEntity storeEntity = AVMDAOs.Instance().newAVMStoreDAO.getStore(id);
        return this.convertStoreEntityToStore(storeEntity);
    }

    @Override
    public void invalidateCache() {
        AVMDAOs.Instance().newAVMStoreDAO.clearStoreEntityCache();
    }

    private AVMStore convertStoreEntityToStore(AVMStoreEntity storeEntity) {
        if (storeEntity == null) {
            return null;
        }
        AVMStoreImpl store = new AVMStoreImpl();
        store.setId(storeEntity.getId());
        store.setName(storeEntity.getName());
        store.setNextVersionID(storeEntity.getVersion().intValue());
        store.setVers(storeEntity.getVers());
        Acl acl = null;
        if (storeEntity.getAclId() != null) {
            acl = AVMDAOs.Instance().fAclDAO.getAcl(storeEntity.getAclId());
        }
        store.setStoreAcl(acl);
        Long rootNodeId = storeEntity.getRootNodeId();
        if (rootNodeId == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Root node id is null for store: " + storeEntity));
            }
            throw new AVMException(storeEntity.toString());
        }
        DirectoryNode rootNode = (DirectoryNode)((AVMNodeDAOIbatis)AVMDAOs.Instance().fAVMNodeDAO).getRootNodeByID(store, rootNodeId);
        if (rootNode == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Root node (" + rootNodeId + ") not found for store: " + storeEntity));
            }
            throw new AVMException(storeEntity.toString());
        }
        store.setRoot(rootNode);
        return store;
    }

    private AVMStoreEntity convertStoreToStoreEntity(AVMStore store) {
        AVMStoreEntity storeEntity = new AVMStoreEntity();
        storeEntity.setId(store.getId());
        storeEntity.setName(store.getName());
        storeEntity.setRootNodeId(store.getRoot().getId());
        storeEntity.setVersion(new Long(store.getNextVersionID()));
        storeEntity.setVers(((AVMStoreImpl)store).getVers());
        storeEntity.setAclId(store.getStoreAcl() == null ? null : store.getStoreAcl().getId());
        return storeEntity;
    }
}

