/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.bulkimport.ImportableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysedDirectory {
    private List<File> originalListing = null;
    private Map<File, ImportableItem> importableItems = null;
    private List<ImportableItem> importableDirectories = null;

    public AnalysedDirectory(File[] files) {
        this.originalListing = Arrays.asList(files);
        this.importableItems = new HashMap<File, ImportableItem>();
        this.importableDirectories = new ArrayList<ImportableItem>();
    }

    public List<File> getOriginalListing() {
        return this.originalListing;
    }

    public Collection<ImportableItem> getImportableItems() {
        return this.importableItems.values();
    }

    public List<ImportableItem> getImportableDirectories() {
        return this.importableDirectories;
    }

    public void addImportableItem(ImportableItem importableItem) {
        if (importableItem.getHeadRevision().contentFileExists() && ImportableItem.FileType.DIRECTORY.equals((Object)importableItem.getHeadRevision().getContentFileType())) {
            this.importableDirectories.add(importableItem);
        } else {
            this.importableItems.put(importableItem.getHeadRevision().getContentFile(), importableItem);
        }
    }

    public ImportableItem findImportableItem(File contentFile) {
        ImportableItem result = null;
        result = this.importableItems.get(contentFile);
        return result;
    }
}

