/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.bulkimport.BulkFSImportEvent;
import org.alfresco.repo.bulkimport.BulkFilesystemImporter;
import org.alfresco.repo.bulkimport.BulkImportParameters;
import org.alfresco.repo.bulkimport.BulkImportStatus;
import org.alfresco.repo.bulkimport.DirectoryAnalyser;
import org.alfresco.repo.bulkimport.NodeImporter;
import org.alfresco.repo.bulkimport.impl.BulkImportStatusImpl;
import org.alfresco.repo.bulkimport.impl.FileUtils;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBulkFilesystemImporter
implements BulkFilesystemImporter,
InitializingBean,
ApplicationContextAware {
    private static final QName LOCK = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"BatchFilesystemImport");
    protected static final Log logger = LogFactory.getLog(BulkFilesystemImporter.class);
    protected ApplicationContext applicationContext;
    protected FileFolderService fileFolderService;
    protected TransactionService transactionService;
    protected PermissionService permissionService;
    protected RetryingTransactionHelper transactionHelper;
    protected RuleService ruleService;
    protected BulkImportStatusImpl importStatus;
    protected DirectoryAnalyser directoryAnalyser = null;
    protected JobLockService jobLockService;
    protected BehaviourFilter behaviourFilter;

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setImportStatus(BulkImportStatusImpl importStatus) {
        this.importStatus = importStatus;
    }

    public final void setDirectoryAnalyser(DirectoryAnalyser directoryAnalyser) {
        this.directoryAnalyser = directoryAnalyser;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Override
    public final BulkImportStatus getStatus() {
        return this.importStatus;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"fileFolderService", (Object)this.fileFolderService);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"permissionService", (Object)this.permissionService);
        PropertyCheck.mandatory((Object)this, (String)"importStatus", (Object)this.importStatus);
        PropertyCheck.mandatory((Object)this, (String)"directoryAnalyser", (Object)this.directoryAnalyser);
        this.transactionHelper = this.transactionService.getRetryingTransactionHelper();
    }

    protected abstract void bulkImportImpl(BulkImportParameters var1, NodeImporter var2, String var3);

    protected String getLock(long time) {
        try {
            return this.jobLockService.getLock(LOCK, time);
        }
        catch (LockAcquisitionException e) {
            return null;
        }
    }

    protected void refreshLock(String lockToken, long time) {
        if (lockToken == null) {
            throw new IllegalArgumentException("Must provide existing lockToken");
        }
        this.jobLockService.refreshLock(lockToken, LOCK, time);
    }

    protected void releaseLock(String lockToken) {
        if (lockToken == null) {
            throw new IllegalArgumentException("Must provide existing lockToken");
        }
        this.jobLockService.releaseLock(lockToken, LOCK);
    }

    protected final String mapToString(Map<?, ?> map) {
        StringBuffer result = new StringBuffer();
        if (map != null) {
            result.append('[');
            if (map.size() > 0) {
                for (Object key : map.keySet()) {
                    result.append(String.valueOf(key));
                    result.append(" = ");
                    result.append(String.valueOf(map.get(key)));
                    result.append(",\n");
                }
                result.delete(result.length() - 2, result.length());
            }
            result.append(']');
        } else {
            result.append("(null)");
        }
        return result.toString();
    }

    protected final String getRepositoryPath(NodeRef nodeRef) {
        String result = null;
        if (nodeRef != null) {
            List<FileInfo> pathElements = null;
            try {
                pathElements = this.fileFolderService.getNamePath(null, nodeRef);
                if (pathElements != null && pathElements.size() > 0) {
                    StringBuilder temp = new StringBuilder();
                    for (FileInfo pathElement : pathElements) {
                        temp.append("/");
                        temp.append(pathElement.getName());
                    }
                    result = temp.toString();
                }
            }
            catch (FileNotFoundException fnfe) {
                // empty catch block
            }
        }
        return result;
    }

    protected final void validateNodeRefIsWritableSpace(NodeRef target) {
        if (target == null) {
            throw new IllegalArgumentException("target must not be null.");
        }
        if (!this.fileFolderService.exists(target)) {
            throw new IllegalArgumentException("Target '" + target.toString() + "' doesn't exist.");
        }
        if (AccessStatus.DENIED.equals((Object)this.permissionService.hasPermission(target, "AddChildren"))) {
            throw new IllegalArgumentException("Target '" + target.toString() + "' is not writeable.");
        }
        if (!this.fileFolderService.getFileInfo(target).isFolder()) {
            throw new IllegalArgumentException("Target '" + target.toString() + "' is not a space.");
        }
    }

    protected String getFileName(File file) {
        return FileUtils.getFileName(file);
    }

    protected String getLockToken() {
        RetryingTransactionHelper.RetryingTransactionCallback<String> txnWork = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Exception {
                String lockToken = AbstractBulkFilesystemImporter.this.getLock(20000L);
                return lockToken;
            }
        };
        String lockToken = this.transactionService.getRetryingTransactionHelper().doInTransaction(txnWork, false, true);
        return lockToken;
    }

    public void validateSourceIsReadableDirectory(File source) {
        try {
            if (source == null) {
                throw new IllegalArgumentException("source must not be null.");
            }
            if (!source.exists()) {
                throw new IllegalArgumentException("Source '" + source.getCanonicalPath() + "' doesn't exist.");
            }
            if (!source.canRead()) {
                throw new IllegalArgumentException("Source '" + source.getCanonicalPath() + "' is not readable.");
            }
            if (!source.isDirectory()) {
                throw new IllegalArgumentException("Source '" + source.getCanonicalPath() + "' is not a directory.");
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void asyncBulkImport(final BulkImportParameters bulkImportParameters, final NodeImporter nodeImporter) {
        final String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        Runnable backgroundLogic = new Runnable(){

            public void run() {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

                    public Object doWork() {
                        AbstractBulkFilesystemImporter.this.bulkImport(bulkImportParameters, nodeImporter);
                        return null;
                    }
                }, (String)currentUser);
            }
        };
        Thread backgroundThread = new Thread(backgroundLogic, "BulkFilesystemImport-BackgroundThread");
        backgroundThread.start();
    }

    @Override
    public void bulkImport(final BulkImportParameters bulkImportParameters, final NodeImporter nodeImporter) {
        final File sourceFolder = nodeImporter.getSourceFolder();
        final AbstractBulkFilesystemImporter importer = this;
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                BulkFSImportEvent bulkImportEvent3;
                Void void_;
                String sourceDirectory = AbstractBulkFilesystemImporter.this.getFileName(sourceFolder);
                String targetSpace = AbstractBulkFilesystemImporter.this.getRepositoryPath(bulkImportParameters.getTarget());
                String lockToken = AbstractBulkFilesystemImporter.this.getLockToken();
                try {
                    AbstractBulkFilesystemImporter.this.importStatus.startImport(sourceDirectory, targetSpace);
                    BulkFSImportEvent bulkImportEvent2 = new BulkFSImportEvent(importer);
                    AbstractBulkFilesystemImporter.this.applicationContext.publishEvent((ApplicationEvent)bulkImportEvent2);
                    AbstractBulkFilesystemImporter.this.validateNodeRefIsWritableSpace(bulkImportParameters.getTarget());
                    AbstractBulkFilesystemImporter.this.validateSourceIsReadableDirectory(sourceFolder);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Bulk import started from '" + sourceFolder.getAbsolutePath() + "'..."));
                    }
                    AbstractBulkFilesystemImporter.this.bulkImportImpl(bulkImportParameters, nodeImporter, lockToken);
                    AbstractBulkFilesystemImporter.this.importStatus.stopImport();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Bulk import from '" + AbstractBulkFilesystemImporter.this.getFileName(sourceFolder) + "' succeeded."));
                    }
                    void_ = null;
                    Object var7_7 = null;
                    bulkImportEvent3 = new BulkFSImportEvent(importer);
                }
                catch (Throwable e) {
                    try {
                        logger.error((Object)("Bulk import from '" + AbstractBulkFilesystemImporter.this.getFileName(sourceFolder) + "' failed."), e);
                        AbstractBulkFilesystemImporter.this.importStatus.stopImport(e);
                        throw new AlfrescoRuntimeException("Bulk filesystem import failed", e);
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        BulkFSImportEvent bulkImportEvent3 = new BulkFSImportEvent(importer);
                        AbstractBulkFilesystemImporter.this.applicationContext.publishEvent((ApplicationEvent)bulkImportEvent3);
                        AbstractBulkFilesystemImporter.this.releaseLock(lockToken);
                        throw throwable;
                    }
                }
                AbstractBulkFilesystemImporter.this.applicationContext.publishEvent((ApplicationEvent)bulkImportEvent3);
                AbstractBulkFilesystemImporter.this.releaseLock(lockToken);
                return void_;
            }
        }, false, true);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

