/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.bulkimport.BulkImportStatus;
import org.alfresco.repo.bulkimport.ImportableItem;

public class BulkImportStatusImpl
implements BulkImportStatus {
    private int numThreads;
    private int batchSize;
    private AtomicBoolean inProgress = new AtomicBoolean();
    private String sourceDirectory = null;
    private String targetSpace = null;
    private Date startDate = null;
    private Date endDate = null;
    private Long startNs = null;
    private Long endNs = null;
    private Throwable lastException = null;
    private AtomicLong numberOfBatchesCompleted = new AtomicLong();
    private AtomicLong numberOfFoldersScanned = new AtomicLong();
    private AtomicLong numberOfFilesScanned = new AtomicLong();
    private AtomicLong numberOfUnreadableEntries = new AtomicLong();
    private AtomicLong numberOfContentFilesRead = new AtomicLong();
    private AtomicLong numberOfContentBytesRead = new AtomicLong();
    private AtomicLong numberOfMetadataFilesRead = new AtomicLong();
    private AtomicLong numberOfMetadataBytesRead = new AtomicLong();
    private AtomicLong numberOfContentVersionFilesRead = new AtomicLong();
    private AtomicLong numberOfContentVersionBytesRead = new AtomicLong();
    private AtomicLong numberOfMetadataVersionFilesRead = new AtomicLong();
    private AtomicLong numberOfMetadataVersionBytesRead = new AtomicLong();
    private AtomicLong numberOfSpaceNodesCreated = new AtomicLong();
    private AtomicLong numberOfSpaceNodesReplaced = new AtomicLong();
    private AtomicLong numberOfSpaceNodesSkipped = new AtomicLong();
    private AtomicLong numberOfSpacePropertiesWritten = new AtomicLong();
    private AtomicLong numberOfContentNodesCreated = new AtomicLong();
    private AtomicLong numberOfContentNodesReplaced = new AtomicLong();
    private AtomicLong numberOfContentNodesSkipped = new AtomicLong();
    private AtomicLong numberOfContentBytesWritten = new AtomicLong();
    private AtomicLong numberOfContentPropertiesWritten = new AtomicLong();
    private AtomicLong numberOfContentVersionsCreated = new AtomicLong();
    private AtomicLong numberOfContentVersionBytesWritten = new AtomicLong();
    private AtomicLong numberOfContentVersionPropertiesWritten = new AtomicLong();

    public BulkImportStatusImpl() {
        this.inProgress.set(false);
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getTargetSpace() {
        return this.targetSpace;
    }

    public Date getStartDate() {
        return this.copyDate(this.startDate);
    }

    public Date getEndDate() {
        return this.copyDate(this.endDate);
    }

    public Long getDurationInNs() {
        Long result = null;
        if (this.startNs != null) {
            result = this.endNs != null ? new Long(this.endNs - this.startNs) : new Long(System.nanoTime() - this.startNs);
        }
        return result;
    }

    public Long getDuration() {
        long duration = 0L;
        Long durationNS = this.getDurationInNs();
        if (durationNS != null && (duration = durationNS / 1000000000L) == 0L) {
            return null;
        }
        return new Long(duration);
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    public String getLastExceptionAsString() {
        String result = null;
        if (this.lastException != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            this.lastException.printStackTrace(pw);
            pw.flush();
            sw.flush();
            result = sw.toString();
        }
        return result;
    }

    public boolean inProgress() {
        return this.inProgress.get();
    }

    public long getNumberOfBatchesCompleted() {
        return this.numberOfBatchesCompleted.get();
    }

    public void incrementNumberOfBatchesCompleted() {
        this.numberOfBatchesCompleted.incrementAndGet();
    }

    public void startImport(String sourceDirectory, String targetSpace) {
        if (!this.inProgress.compareAndSet(false, true)) {
            throw new AlfrescoRuntimeException("Import already in progress.");
        }
        this.sourceDirectory = sourceDirectory;
        this.targetSpace = targetSpace;
        this.startDate = new Date();
        this.endDate = null;
        this.lastException = null;
        this.numberOfBatchesCompleted.set(0L);
        this.numberOfFoldersScanned.set(1L);
        this.numberOfFilesScanned.set(0L);
        this.numberOfUnreadableEntries.set(0L);
        this.numberOfContentFilesRead.set(0L);
        this.numberOfContentBytesRead.set(0L);
        this.numberOfMetadataFilesRead.set(0L);
        this.numberOfMetadataBytesRead.set(0L);
        this.numberOfContentVersionFilesRead.set(0L);
        this.numberOfContentVersionBytesRead.set(0L);
        this.numberOfMetadataVersionFilesRead.set(0L);
        this.numberOfMetadataVersionBytesRead.set(0L);
        this.numberOfSpaceNodesCreated.set(0L);
        this.numberOfSpaceNodesReplaced.set(0L);
        this.numberOfSpaceNodesSkipped.set(0L);
        this.numberOfSpacePropertiesWritten.set(0L);
        this.numberOfContentNodesCreated.set(0L);
        this.numberOfContentNodesReplaced.set(0L);
        this.numberOfContentNodesSkipped.set(0L);
        this.numberOfContentBytesWritten.set(0L);
        this.numberOfContentPropertiesWritten.set(0L);
        this.numberOfContentVersionsCreated.set(0L);
        this.numberOfContentVersionBytesWritten.set(0L);
        this.numberOfContentVersionPropertiesWritten.set(0L);
        this.startNs = System.nanoTime();
        this.endNs = null;
    }

    public void stopImport() {
        if (!this.inProgress.compareAndSet(true, false)) {
            throw new RuntimeException("Import not in progress.");
        }
        this.endNs = System.nanoTime();
        this.endDate = new Date();
    }

    public void stopImport(Throwable lastException) {
        this.stopImport();
        this.lastException = lastException;
    }

    public long getNumberOfFoldersScanned() {
        return this.numberOfFoldersScanned.longValue();
    }

    public long getNumberOfFilesScanned() {
        return this.numberOfFilesScanned.longValue();
    }

    public long getNumberOfUnreadableEntries() {
        return this.numberOfUnreadableEntries.longValue();
    }

    public long getNumberOfContentFilesRead() {
        return this.numberOfContentFilesRead.longValue();
    }

    public long getNumberOfContentBytesRead() {
        return this.numberOfContentBytesRead.longValue();
    }

    public long getNumberOfMetadataFilesRead() {
        return this.numberOfMetadataFilesRead.longValue();
    }

    public long getNumberOfMetadataBytesRead() {
        return this.numberOfMetadataBytesRead.longValue();
    }

    public long getNumberOfContentVersionFilesRead() {
        return this.numberOfContentVersionFilesRead.longValue();
    }

    public long getNumberOfContentVersionBytesRead() {
        return this.numberOfContentVersionBytesRead.longValue();
    }

    public long getNumberOfMetadataVersionFilesRead() {
        return this.numberOfMetadataVersionFilesRead.longValue();
    }

    public long getNumberOfMetadataVersionBytesRead() {
        return this.numberOfMetadataVersionBytesRead.longValue();
    }

    public void incrementImportableItemsRead(ImportableItem importableItem, boolean isDirectory) {
        if (importableItem.getHeadRevision().contentFileExists() && !isDirectory) {
            this.numberOfContentFilesRead.incrementAndGet();
            this.numberOfContentBytesRead.addAndGet(importableItem.getHeadRevision().getContentFileSize());
        }
        if (importableItem.getHeadRevision().metadataFileExists()) {
            this.numberOfMetadataFilesRead.incrementAndGet();
            this.numberOfMetadataBytesRead.addAndGet(importableItem.getHeadRevision().getMetadataFileSize());
        }
        if (!isDirectory && importableItem.hasVersionEntries()) {
            for (ImportableItem.VersionedContentAndMetadata versionEntry : importableItem.getVersionEntries()) {
                if (versionEntry.contentFileExists()) {
                    this.numberOfContentVersionFilesRead.incrementAndGet();
                    this.numberOfContentVersionBytesRead.addAndGet(versionEntry.getContentFileSize());
                }
                if (!versionEntry.metadataFileExists()) continue;
                this.numberOfMetadataVersionFilesRead.incrementAndGet();
                this.numberOfMetadataVersionBytesRead.addAndGet(versionEntry.getMetadataFileSize());
            }
        }
    }

    public void incrementNumberOfFilesScanned() {
        this.numberOfFilesScanned.incrementAndGet();
    }

    public void incrementNumberOfFoldersScanned() {
        this.numberOfFoldersScanned.incrementAndGet();
    }

    public void incrementNumberOfUnreadableEntries() {
        this.numberOfUnreadableEntries.incrementAndGet();
    }

    public void incrementImportableItemsSkipped(ImportableItem importableItem, boolean isDirectory) {
        if (importableItem.getHeadRevision().contentFileExists()) {
            long l = isDirectory ? this.numberOfSpaceNodesSkipped.incrementAndGet() : this.numberOfContentNodesSkipped.incrementAndGet();
        }
    }

    public long getNumberOfSpaceNodesCreated() {
        return this.numberOfSpaceNodesCreated.longValue();
    }

    public long getNumberOfSpaceNodesReplaced() {
        return this.numberOfSpaceNodesReplaced.longValue();
    }

    public long getNumberOfSpaceNodesSkipped() {
        return this.numberOfSpaceNodesSkipped.longValue();
    }

    public long getNumberOfSpacePropertiesWritten() {
        return this.numberOfSpacePropertiesWritten.longValue();
    }

    public long getNumberOfContentNodesCreated() {
        return this.numberOfContentNodesCreated.longValue();
    }

    public long getNumberOfContentNodesReplaced() {
        return this.numberOfContentNodesReplaced.longValue();
    }

    public long getNumberOfContentNodesSkipped() {
        return this.numberOfContentNodesSkipped.longValue();
    }

    public long getNumberOfContentBytesWritten() {
        return this.numberOfContentBytesWritten.longValue();
    }

    public long getNumberOfContentPropertiesWritten() {
        return this.numberOfContentPropertiesWritten.longValue();
    }

    public long getNumberOfContentVersionsCreated() {
        return this.numberOfContentVersionsCreated.longValue();
    }

    public long getNumberOfContentVersionBytesWritten() {
        return this.numberOfContentVersionBytesWritten.longValue();
    }

    public long getNumberOfContentVersionPropertiesWritten() {
        return this.numberOfContentVersionPropertiesWritten.longValue();
    }

    public void incrementContentBytesWritten(ImportableItem importableItem, boolean isSpace, NodeState nodeState) {
        if (importableItem.getHeadRevision().contentFileExists()) {
            switch (nodeState) {
                case CREATED: {
                    this.numberOfContentBytesWritten.addAndGet(importableItem.getHeadRevision().getContentFileSize());
                    break;
                }
                case REPLACED: {
                    this.numberOfContentBytesWritten.addAndGet(importableItem.getHeadRevision().getContentFileSize());
                }
            }
        }
    }

    public void incrementNodesWritten(ImportableItem importableItem, boolean isSpace, NodeState nodeState, long numProperties, long numVersionProperties) {
        long ignored;
        if (importableItem.getHeadRevision().contentFileExists()) {
            switch (nodeState) {
                case SKIPPED: {
                    ignored = isSpace ? this.numberOfSpaceNodesSkipped.incrementAndGet() : this.numberOfContentNodesSkipped.incrementAndGet();
                    break;
                }
                case CREATED: {
                    ignored = isSpace ? this.numberOfSpaceNodesCreated.incrementAndGet() : this.numberOfContentNodesCreated.incrementAndGet();
                    break;
                }
                case REPLACED: {
                    ignored = isSpace ? this.numberOfSpaceNodesReplaced.incrementAndGet() : this.numberOfContentNodesReplaced.incrementAndGet();
                }
            }
        }
        switch (nodeState) {
            case SKIPPED: {
                break;
            }
            case CREATED: 
            case REPLACED: {
                long l = ignored = isSpace ? this.numberOfSpacePropertiesWritten.addAndGet(numProperties) : this.numberOfContentPropertiesWritten.addAndGet(numProperties);
            }
        }
        if (!isSpace && importableItem.hasVersionEntries()) {
            this.numberOfContentVersionPropertiesWritten.addAndGet(numVersionProperties);
            for (ImportableItem.VersionedContentAndMetadata versionEntry : importableItem.getVersionEntries()) {
                if (!versionEntry.contentFileExists()) continue;
                switch (nodeState) {
                    case SKIPPED: {
                        break;
                    }
                    case CREATED: 
                    case REPLACED: {
                        this.numberOfContentVersionsCreated.incrementAndGet();
                        this.numberOfContentVersionBytesWritten.addAndGet(versionEntry.getContentFileSize());
                    }
                }
            }
        }
    }

    public Long getFilesReadPerSecond() {
        Long duration = this.getDuration();
        if (duration != null) {
            long totalFilesRead = this.numberOfContentFilesRead.longValue() + this.numberOfMetadataFilesRead.longValue() + this.numberOfContentVersionFilesRead.longValue() + this.numberOfMetadataVersionFilesRead.longValue();
            long filesReadPerSecond = totalFilesRead / duration;
            return filesReadPerSecond;
        }
        return null;
    }

    public Long getBytesReadPerSecond() {
        Long duration = this.getDuration();
        if (duration != null) {
            long totalDataRead = this.numberOfContentBytesRead.longValue() + this.numberOfMetadataBytesRead.longValue() + this.numberOfContentVersionBytesRead.longValue() + this.numberOfMetadataVersionBytesRead.longValue();
            long bytesReadPerSecond = totalDataRead / duration;
            return bytesReadPerSecond;
        }
        return null;
    }

    public Long getEntriesScannedPerSecond() {
        Long duration = this.getDuration();
        if (duration != null) {
            long entriesScannedPerSecond = (this.numberOfFilesScanned.longValue() + this.numberOfFoldersScanned.longValue()) / duration;
            return entriesScannedPerSecond;
        }
        return null;
    }

    public Long getBytesWrittenPerSecond() {
        Long duration = this.getDuration();
        if (duration != null) {
            long totalDataWritten = this.numberOfContentBytesWritten.longValue() + this.numberOfContentVersionBytesWritten.longValue();
            long bytesWrittenPerSecond = totalDataWritten / duration;
            return bytesWrittenPerSecond;
        }
        return null;
    }

    public Long getNodesCreatedPerSecond() {
        Long duration = this.getDuration();
        if (duration != null) {
            long totalNodesWritten = this.numberOfSpaceNodesCreated.longValue() + this.numberOfSpaceNodesReplaced.longValue() + this.numberOfContentNodesCreated.longValue() + this.numberOfContentNodesReplaced.longValue() + this.numberOfContentVersionsCreated.longValue();
            long nodesCreatedPerSecond = totalNodesWritten / duration;
            return nodesCreatedPerSecond;
        }
        return null;
    }

    private final Date copyDate(Date date) {
        Date result = null;
        if (date != null) {
            result = new Date(date.getTime());
        }
        return result;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Bulk Import Status\n");
        sb.append("Source directory: ");
        sb.append(this.getSourceDirectory());
        sb.append("\nTarget space: ");
        sb.append(this.getTargetSpace());
        sb.append("\nStart date : ");
        sb.append(this.getStartDate());
        sb.append("\nEnd date : ");
        sb.append(this.getEndDate());
        sb.append("\nNum threads : ");
        sb.append(this.getNumThreads());
        sb.append("\nBatch size : ");
        sb.append(this.getBatchSize());
        if (this.inProgress()) {
            sb.append("\n\nIn progress");
        } else {
            sb.append("\n\nNot in progress");
        }
        sb.append("\nBytes written/sec : ");
        sb.append(this.getBytesWrittenPerSecond());
        sb.append("\nBytes read/sec : ");
        sb.append(this.getBytesReadPerSecond());
        sb.append("\nEntries scanned/sec : ");
        sb.append(this.getEntriesScannedPerSecond());
        sb.append("\nFiles read/sec : ");
        sb.append(this.getFilesReadPerSecond());
        sb.append("\nNodes created/sec : ");
        sb.append(this.getNodesCreatedPerSecond());
        sb.append("\nNumber of files scanned : ");
        sb.append(this.getNumberOfFilesScanned());
        sb.append("\nNumber of folders scanned : ");
        sb.append(this.getNumberOfFoldersScanned());
        sb.append("\nNumber of content files read : ");
        sb.append(this.getNumberOfContentFilesRead());
        sb.append("\nNumber of content version files read : ");
        sb.append(this.getNumberOfContentVersionFilesRead());
        sb.append("\nNumber of metadata files read : ");
        sb.append(this.getNumberOfMetadataFilesRead());
        sb.append("\nNumber of metadata version files read : ");
        sb.append(this.getNumberOfMetadataVersionFilesRead());
        sb.append("\nNumber of unreadable entries : ");
        sb.append(this.getNumberOfUnreadableEntries());
        sb.append("\nNumber of content nodes created : ");
        sb.append(this.getNumberOfContentNodesCreated());
        sb.append("\nNumber of content nodes replaced : ");
        sb.append(this.getNumberOfContentNodesReplaced());
        sb.append("\nNumber of content nodes skipped : ");
        sb.append(this.getNumberOfContentNodesSkipped());
        sb.append("\nNumber of content properties written : ");
        sb.append(this.getNumberOfContentPropertiesWritten());
        sb.append("\nNumber of content version properties written : ");
        sb.append(this.getNumberOfContentVersionPropertiesWritten());
        sb.append("\nNumber of content versions created : ");
        sb.append(this.getNumberOfContentVersionsCreated());
        sb.append("\nNumber of space nodes created : ");
        sb.append(this.getNumberOfSpaceNodesCreated());
        sb.append("\nNumber of space nodes replaced : ");
        sb.append(this.getNumberOfSpaceNodesReplaced());
        sb.append("\nNumber of space nodes skipped : ");
        sb.append(this.getNumberOfSpaceNodesSkipped());
        sb.append("\nNumber of space properties written : ");
        sb.append(this.getNumberOfSpacePropertiesWritten());
        sb.append("\nNumber of bytes read : ");
        sb.append(this.getNumberOfContentBytesRead());
        sb.append("\nNumber of metadata bytes read: ");
        sb.append(this.getNumberOfMetadataBytesRead());
        sb.append("\nNumber of content version bytes read : ");
        sb.append(this.getNumberOfContentVersionBytesRead());
        sb.append("\nNumber of metadata bytes read : ");
        sb.append(this.getNumberOfMetadataBytesRead());
        sb.append("\nNumber of metadata version bytes read : ");
        sb.append(this.getNumberOfMetadataVersionBytesRead());
        sb.append("\nNumber of batches completed : ");
        sb.append(this.getNumberOfBatchesCompleted());
        sb.append("\nNumber of bytes written : ");
        sb.append(this.getNumberOfContentBytesWritten());
        sb.append("\nNumber of content version bytes written : ");
        sb.append(this.getNumberOfContentVersionBytesWritten());
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeState {
        SKIPPED,
        CREATED,
        REPLACED;

    }
}

