/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.bulkimport.metadataloaders;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.alfresco.repo.bulkimport.impl.FileUtils;
import org.alfresco.repo.bulkimport.metadataloaders.AbstractMapBasedMetadataLoader;
import org.alfresco.service.ServiceRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlPropertiesFileMetadataLoader
extends AbstractMapBasedMetadataLoader {
    private static final Log log = LogFactory.getLog(XmlPropertiesFileMetadataLoader.class);
    private static final String METADATA_FILE_EXTENSION = "properties.xml";

    public XmlPropertiesFileMetadataLoader(ServiceRegistry serviceRegistry) {
        super(serviceRegistry, METADATA_FILE_EXTENSION);
    }

    public XmlPropertiesFileMetadataLoader(ServiceRegistry serviceRegistry, String multiValuedSeparator) {
        super(serviceRegistry, multiValuedSeparator, METADATA_FILE_EXTENSION);
    }

    @Override
    protected Map<String, Serializable> loadMetadataFromFile(File metadataFile) {
        HashMap<Object, Object> result;
        block2: {
            result = null;
            try {
                Properties props = new Properties();
                props.loadFromXML(new BufferedInputStream(new FileInputStream(metadataFile)));
                result = new HashMap<Object, Object>(props);
            }
            catch (IOException ioe) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)("Metadata file '" + FileUtils.getFileName(metadataFile) + "' could not be read."), (Throwable)ioe);
            }
        }
        return result;
    }
}

