/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.calendar;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.calendar.CalendarModel;
import org.alfresco.service.cmr.calendar.CalendarEntry;
import org.alfresco.service.cmr.calendar.CalendarEntryDTO;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarEntryImpl
extends CalendarEntryDTO {
    private NodeRef nodeRef;
    private NodeRef containerNodeRef;
    private String systemName;

    protected CalendarEntryImpl(NodeRef nodeRef, NodeRef containerNodeRef, String systemName) {
        this.nodeRef = nodeRef;
        this.systemName = systemName;
        this.containerNodeRef = containerNodeRef;
    }

    protected void recordStorageDetails(NodeRef nodeRef, NodeRef containerNodeRef, String systemName) {
        this.nodeRef = nodeRef;
        this.systemName = systemName;
        this.containerNodeRef = containerNodeRef;
    }

    @Override
    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    @Override
    public NodeRef getContainerNodeRef() {
        return this.containerNodeRef;
    }

    @Override
    public String getSystemName() {
        return this.systemName;
    }

    protected static Map<QName, Serializable> toNodeProperties(CalendarEntry entry) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(CalendarModel.PROP_WHAT, (Serializable)((Object)entry.getTitle()));
        properties.put(CalendarModel.PROP_DESCRIPTION, (Serializable)((Object)entry.getDescription()));
        properties.put(CalendarModel.PROP_WHERE, (Serializable)((Object)entry.getLocation()));
        properties.put(CalendarModel.PROP_FROM_DATE, entry.getStart());
        properties.put(CalendarModel.PROP_TO_DATE, entry.getEnd());
        properties.put(CalendarModel.PROP_RECURRENCE_RULE, (Serializable)((Object)entry.getRecurrenceRule()));
        properties.put(CalendarModel.PROP_RECURRENCE_LAST_MEETING, entry.getLastRecurrence());
        properties.put(CalendarModel.PROP_IS_OUTLOOK, Boolean.valueOf(entry.isOutlook()));
        properties.put(CalendarModel.PROP_OUTLOOK_UID, (Serializable)((Object)entry.getOutlookUID()));
        properties.put(CalendarModel.PROP_DOC_FOLDER, (Serializable)((Object)entry.getSharePointDocFolder()));
        return properties;
    }

    protected static void populate(CalendarEntry entry, Map<QName, Serializable> properties) {
        entry.setTitle((String)((Object)properties.get(CalendarModel.PROP_WHAT)));
        entry.setLocation((String)((Object)properties.get(CalendarModel.PROP_WHERE)));
        entry.setDescription((String)((Object)properties.get(CalendarModel.PROP_DESCRIPTION)));
        entry.setStart((Date)properties.get(CalendarModel.PROP_FROM_DATE));
        entry.setEnd((Date)properties.get(CalendarModel.PROP_TO_DATE));
        entry.setRecurrenceRule((String)((Object)properties.get(CalendarModel.PROP_RECURRENCE_RULE)));
        entry.setLastRecurrence((Date)properties.get(CalendarModel.PROP_RECURRENCE_LAST_MEETING));
        entry.setSharePointDocFolder((String)((Object)properties.get(CalendarModel.PROP_DOC_FOLDER)));
        Boolean isOutlook = (Boolean)properties.get(CalendarModel.PROP_IS_OUTLOOK);
        entry.setOutlook(isOutlook == null ? false : isOutlook);
        entry.setOutlookUID((String)((Object)properties.get(CalendarModel.PROP_OUTLOOK_UID)));
        if (entry instanceof CalendarEntryDTO) {
            if (properties.containsKey(ContentModel.PROP_CREATED)) {
                ((CalendarEntryDTO)entry).setCreatedAt((Date)properties.get(ContentModel.PROP_CREATED));
            }
            if (properties.containsKey(ContentModel.PROP_MODIFIED)) {
                ((CalendarEntryDTO)entry).setModifiedAt((Date)properties.get(ContentModel.PROP_MODIFIED));
            }
        }
    }

    protected void populate(Map<QName, Serializable> properties) {
        CalendarEntryImpl.populate(this, properties);
    }

    protected void setTags(List<String> tags) {
        super.getTags().clear();
        super.getTags().addAll(tags);
    }
}

