/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching;

import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.caching.CacheMissException;
import org.alfresco.repo.content.caching.CachingContentStore;
import org.alfresco.repo.content.caching.ContentCache;
import org.alfresco.repo.content.caching.quota.QuotaManagerStrategy;
import org.alfresco.repo.content.caching.quota.UnlimitedQuotaStrategy;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CachingContentStoreTest {
    private CachingContentStore cachingStore;
    private ContentReader sourceContent;
    private ContentReader cachedContent;
    @Mock
    private ContentStore backingStore;
    @Mock
    private ContentCache cache;

    @Before
    public void setUp() throws Exception {
        this.cachingStore = new CachingContentStore(this.backingStore, this.cache, false);
        this.cachingStore.setQuota(new UnlimitedQuotaStrategy());
        this.sourceContent = (ContentReader)Mockito.mock(ContentReader.class, (String)"sourceContent");
        this.cachedContent = (ContentReader)Mockito.mock(ContentReader.class, (String)"cachedContent");
    }

    @Test
    public void getReaderForItemInCache() {
        Mockito.when((Object)this.cache.contains("url")).thenReturn((Object)true);
        Mockito.when((Object)this.cache.getReader("url")).thenReturn((Object)this.cachedContent);
        ContentReader returnedReader = this.cachingStore.getReader("url");
        Assert.assertSame((Object)returnedReader, (Object)this.cachedContent);
        ((ContentStore)Mockito.verify((Object)this.backingStore, (VerificationMode)Mockito.never())).getReader(Matchers.anyString());
    }

    @Test
    public void getReaderForItemMissingFromCache() {
        Mockito.when((Object)this.cache.getReader("url")).thenReturn((Object)this.cachedContent);
        Mockito.when((Object)this.backingStore.getReader("url")).thenReturn((Object)this.sourceContent);
        Mockito.when((Object)this.sourceContent.getSize()).thenReturn((Object)1274L);
        Mockito.when((Object)this.cache.put("url", this.sourceContent)).thenReturn((Object)true);
        QuotaManagerStrategy quota = (QuotaManagerStrategy)Mockito.mock(QuotaManagerStrategy.class);
        this.cachingStore.setQuota(quota);
        Mockito.when((Object)quota.beforeWritingCacheFile(1274L)).thenReturn((Object)true);
        ContentReader returnedReader = this.cachingStore.getReader("url");
        Assert.assertSame((Object)returnedReader, (Object)this.cachedContent);
        ((QuotaManagerStrategy)Mockito.verify((Object)quota)).afterWritingCacheFile(1274L);
    }

    @Test
    public void getReaderForItemMissingFromCacheWillGiveUpAfterRetrying() {
        Mockito.when((Object)this.cache.getReader("url")).thenThrow(new Throwable[]{new CacheMissException("url")});
        Mockito.when((Object)this.backingStore.getReader("url")).thenReturn((Object)this.sourceContent);
        Mockito.when((Object)this.cache.put("url", this.sourceContent)).thenReturn((Object)true);
        ContentReader returnedReader = this.cachingStore.getReader("url");
        ((ContentCache)Mockito.verify((Object)this.cache, (VerificationMode)Mockito.atLeastOnce())).remove("url");
        Assert.assertSame((Object)returnedReader, (Object)this.sourceContent);
    }

    @Test
    public void getReaderForItemMissingFromCacheWillRetryAndCanSucceed() {
        Mockito.when((Object)this.cache.getReader("url")).thenThrow(new Throwable[]{new CacheMissException("url")}).thenReturn((Object)this.cachedContent);
        Mockito.when((Object)this.backingStore.getReader("url")).thenReturn((Object)this.sourceContent);
        Mockito.when((Object)this.cache.put("url", this.sourceContent)).thenReturn((Object)true);
        ContentReader returnedReader = this.cachingStore.getReader("url");
        Assert.assertSame((Object)returnedReader, (Object)this.cachedContent);
    }

    @Test
    public void getReaderForItemMissingFromCacheButNoContentToCache() {
        Mockito.when((Object)this.cache.getReader("url")).thenThrow(new Throwable[]{new CacheMissException("url")});
        Mockito.when((Object)this.backingStore.getReader("url")).thenReturn((Object)this.sourceContent);
        Mockito.when((Object)this.cache.put("url", this.sourceContent)).thenReturn((Object)false);
        this.cachingStore.getReader("url");
    }

    @Test
    public void quotaManagerCanVetoCacheFileWriting() {
        Mockito.when((Object)this.backingStore.getReader("url")).thenReturn((Object)this.sourceContent);
        QuotaManagerStrategy quota = (QuotaManagerStrategy)Mockito.mock(QuotaManagerStrategy.class);
        this.cachingStore.setQuota(quota);
        Mockito.when((Object)this.sourceContent.getSize()).thenReturn((Object)1274L);
        Mockito.when((Object)quota.beforeWritingCacheFile(1274L)).thenReturn((Object)false);
        ContentReader returnedReader = this.cachingStore.getReader("url");
        ((ContentCache)Mockito.verify((Object)this.cache, (VerificationMode)Mockito.never())).put("url", this.sourceContent);
        Assert.assertSame((Object)returnedReader, (Object)this.sourceContent);
        ((QuotaManagerStrategy)Mockito.verify((Object)quota, (VerificationMode)Mockito.never())).afterWritingCacheFile(Matchers.anyLong());
    }

    @Test
    public void getWriterWhenNotCacheOnInbound() {
        QuotaManagerStrategy quota = (QuotaManagerStrategy)Mockito.mock(QuotaManagerStrategy.class);
        this.cachingStore.setQuota(quota);
        ContentContext ctx = ContentContext.NULL_CONTEXT;
        this.cachingStore.getWriter(ctx);
        ((ContentStore)Mockito.verify((Object)this.backingStore)).getWriter(ctx);
        ((QuotaManagerStrategy)Mockito.verify((Object)quota, (VerificationMode)Mockito.never())).beforeWritingCacheFile(Matchers.anyLong());
        ((QuotaManagerStrategy)Mockito.verify((Object)quota, (VerificationMode)Mockito.never())).afterWritingCacheFile(Matchers.anyLong());
    }

    @Test
    public void getWriterWhenCacheOnInbound() throws ContentIOException, IOException {
        this.cachingStore = new CachingContentStore(this.backingStore, this.cache, true);
        ContentContext ctx = ContentContext.NULL_CONTEXT;
        ContentWriter bsWriter = (ContentWriter)Mockito.mock(ContentWriter.class);
        Mockito.when((Object)this.backingStore.getWriter(ctx)).thenReturn((Object)bsWriter);
        Mockito.when((Object)bsWriter.getContentUrl()).thenReturn((Object)"url");
        ContentWriter cacheWriter = (ContentWriter)Mockito.mock(ContentWriter.class);
        Mockito.when((Object)this.cache.getWriter("url")).thenReturn((Object)cacheWriter);
        ContentReader readerFromCacheWriter = (ContentReader)Mockito.mock(ContentReader.class);
        Mockito.when((Object)cacheWriter.getReader()).thenReturn((Object)readerFromCacheWriter);
        Mockito.when((Object)cacheWriter.getSize()).thenReturn((Object)54321L);
        QuotaManagerStrategy quota = (QuotaManagerStrategy)Mockito.mock(QuotaManagerStrategy.class);
        this.cachingStore.setQuota(quota);
        Mockito.when((Object)quota.beforeWritingCacheFile(0L)).thenReturn((Object)true);
        this.cachingStore.getWriter(ctx);
        ArgumentCaptor arg = ArgumentCaptor.forClass(ContentStreamListener.class);
        ((ContentWriter)Mockito.verify((Object)cacheWriter)).addListener((ContentStreamListener)arg.capture());
        ((ContentStreamListener)arg.getValue()).contentStreamClosed();
        ((ContentWriter)Mockito.verify((Object)bsWriter)).putContent(readerFromCacheWriter);
        ((QuotaManagerStrategy)Mockito.verify((Object)quota)).afterWritingCacheFile(54321L);
    }

    @Test
    public void quotaManagerCanVetoInboundCaching() {
        this.cachingStore = new CachingContentStore(this.backingStore, this.cache, true);
        QuotaManagerStrategy quota = (QuotaManagerStrategy)Mockito.mock(QuotaManagerStrategy.class);
        this.cachingStore.setQuota(quota);
        ContentContext ctx = ContentContext.NULL_CONTEXT;
        ContentWriter backingStoreWriter = (ContentWriter)Mockito.mock(ContentWriter.class);
        Mockito.when((Object)this.backingStore.getWriter(ctx)).thenReturn((Object)backingStoreWriter);
        Mockito.when((Object)quota.beforeWritingCacheFile(0L)).thenReturn((Object)false);
        ContentWriter returnedWriter = this.cachingStore.getWriter(ctx);
        Assert.assertSame((String)"Should be writing direct to backing store", (Object)backingStoreWriter, (Object)returnedWriter);
        ((QuotaManagerStrategy)Mockito.verify((Object)quota, (VerificationMode)Mockito.never())).afterWritingCacheFile(Matchers.anyLong());
    }

    @Test
    public void quotaManagerCanRequestFileDeletionFromCacheAfterWrite() {
        this.cachingStore = new CachingContentStore(this.backingStore, this.cache, true);
        ContentContext ctx = ContentContext.NULL_CONTEXT;
        ContentWriter bsWriter = (ContentWriter)Mockito.mock(ContentWriter.class);
        Mockito.when((Object)this.backingStore.getWriter(ctx)).thenReturn((Object)bsWriter);
        Mockito.when((Object)bsWriter.getContentUrl()).thenReturn((Object)"url");
        ContentWriter cacheWriter = (ContentWriter)Mockito.mock(ContentWriter.class);
        Mockito.when((Object)this.cache.getWriter("url")).thenReturn((Object)cacheWriter);
        ContentReader readerFromCacheWriter = (ContentReader)Mockito.mock(ContentReader.class);
        Mockito.when((Object)cacheWriter.getReader()).thenReturn((Object)readerFromCacheWriter);
        Mockito.when((Object)cacheWriter.getSize()).thenReturn((Object)54321L);
        QuotaManagerStrategy quota = (QuotaManagerStrategy)Mockito.mock(QuotaManagerStrategy.class);
        this.cachingStore.setQuota(quota);
        Mockito.when((Object)quota.beforeWritingCacheFile(0L)).thenReturn((Object)true);
        this.cachingStore.getWriter(ctx);
        ArgumentCaptor arg = ArgumentCaptor.forClass(ContentStreamListener.class);
        ((ContentWriter)Mockito.verify((Object)cacheWriter)).addListener((ContentStreamListener)arg.capture());
        Mockito.when((Object)quota.afterWritingCacheFile(54321L)).thenReturn((Object)false);
        ((ContentStreamListener)arg.getValue()).contentStreamClosed();
        ((ContentWriter)Mockito.verify((Object)bsWriter)).putContent(readerFromCacheWriter);
        ((QuotaManagerStrategy)Mockito.verify((Object)quota)).afterWritingCacheFile(54321L);
        ((ContentCache)Mockito.verify((Object)this.cache)).deleteFile("url");
        ((ContentCache)Mockito.verify((Object)this.cache)).remove("url");
    }

    @Test(expected=RuntimeException.class)
    public void exceptionRaisedWhenCopyingTempToBackingStoreIsPropogatedCorrectly() throws ContentIOException, IOException {
        this.cachingStore = new CachingContentStore(this.backingStore, this.cache, true);
        ContentContext ctx = ContentContext.NULL_CONTEXT;
        ContentWriter bsWriter = (ContentWriter)Mockito.mock(ContentWriter.class);
        Mockito.when((Object)this.backingStore.getWriter(ctx)).thenReturn((Object)bsWriter);
        Mockito.when((Object)bsWriter.getContentUrl()).thenReturn((Object)"url");
        ContentWriter cacheWriter = (ContentWriter)Mockito.mock(ContentWriter.class);
        Mockito.when((Object)this.cache.getWriter("url")).thenReturn((Object)cacheWriter);
        ContentReader readerFromCacheWriter = (ContentReader)Mockito.mock(ContentReader.class);
        Mockito.when((Object)cacheWriter.getReader()).thenReturn((Object)readerFromCacheWriter);
        ((ContentWriter)Mockito.doThrow((Throwable)new RuntimeException()).when((Object)bsWriter)).putContent((ContentReader)Matchers.any(ContentReader.class));
        this.cachingStore.getWriter(ctx);
        ArgumentCaptor arg = ArgumentCaptor.forClass(ContentStreamListener.class);
        ((ContentWriter)Mockito.verify((Object)cacheWriter)).addListener((ContentStreamListener)arg.capture());
        ((ContentStreamListener)arg.getValue()).contentStreamClosed();
    }

    @Test
    public void encodingAttrsCopiedToBackingStoreWriter() {
        this.cachingStore = new CachingContentStore(this.backingStore, this.cache, true);
        ContentContext ctx = ContentContext.NULL_CONTEXT;
        ContentWriter bsWriter = (ContentWriter)Mockito.mock(ContentWriter.class);
        Mockito.when((Object)this.backingStore.getWriter(ctx)).thenReturn((Object)bsWriter);
        Mockito.when((Object)bsWriter.getContentUrl()).thenReturn((Object)"url");
        ContentWriter cacheWriter = (ContentWriter)Mockito.mock(ContentWriter.class);
        Mockito.when((Object)this.cache.getWriter("url")).thenReturn((Object)cacheWriter);
        ContentReader readerFromCacheWriter = (ContentReader)Mockito.mock(ContentReader.class);
        Mockito.when((Object)cacheWriter.getReader()).thenReturn((Object)readerFromCacheWriter);
        Mockito.when((Object)cacheWriter.getEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)cacheWriter.getLocale()).thenReturn((Object)Locale.UK);
        Mockito.when((Object)cacheWriter.getMimetype()).thenReturn((Object)"not/real/mimetype");
        this.cachingStore.getWriter(ctx);
        ArgumentCaptor arg = ArgumentCaptor.forClass(ContentStreamListener.class);
        ((ContentWriter)Mockito.verify((Object)cacheWriter)).addListener((ContentStreamListener)arg.capture());
        ((ContentStreamListener)arg.getValue()).contentStreamClosed();
        ((ContentWriter)Mockito.verify((Object)bsWriter)).setEncoding("UTF-8");
        ((ContentWriter)Mockito.verify((Object)bsWriter)).setLocale(Locale.UK);
        ((ContentWriter)Mockito.verify((Object)bsWriter)).setMimetype("not/real/mimetype");
    }

    @Test
    public void delegatedIsContentUrlSupported() {
        Mockito.when((Object)this.backingStore.isContentUrlSupported("url")).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cachingStore.isContentUrlSupported("url"));
        Mockito.when((Object)this.backingStore.isContentUrlSupported("url")).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.cachingStore.isContentUrlSupported("url"));
    }

    @Test
    public void delegatedIsWriteSupported() {
        Mockito.when((Object)this.backingStore.isWriteSupported()).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cachingStore.isWriteSupported());
        Mockito.when((Object)this.backingStore.isWriteSupported()).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.cachingStore.isWriteSupported());
    }

    @Test
    public void delegatedGetTotalSize() {
        Mockito.when((Object)this.backingStore.getTotalSize()).thenReturn((Object)234L);
        Assert.assertEquals((long)234L, (long)this.cachingStore.getTotalSize());
    }

    @Test
    public void delegatedGetSpaceUsed() {
        Mockito.when((Object)this.backingStore.getSpaceUsed()).thenReturn((Object)453L);
        Assert.assertEquals((long)453L, (long)this.cachingStore.getSpaceUsed());
    }

    @Test
    public void delegatedGetSpaceFree() {
        Mockito.when((Object)this.backingStore.getSpaceFree()).thenReturn((Object)124L);
        Assert.assertEquals((long)124L, (long)this.cachingStore.getSpaceFree());
    }

    @Test
    public void delegatedGetSpaceTotal() {
        Mockito.when((Object)this.backingStore.getSpaceTotal()).thenReturn((Object)4234L);
        Assert.assertEquals((long)4234L, (long)this.cachingStore.getSpaceTotal());
    }

    @Test
    public void delegatedGetRootLocation() {
        Mockito.when((Object)this.backingStore.getRootLocation()).thenReturn((Object)"/random/root/dir");
        Assert.assertEquals((Object)"/random/root/dir", (Object)this.cachingStore.getRootLocation());
    }

    @Test
    public void delegatedExists() {
        Mockito.when((Object)this.backingStore.exists("url")).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cachingStore.exists("url"));
        Mockito.when((Object)this.backingStore.exists("url")).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.cachingStore.exists("url"));
    }

    @Test
    public void delegatedGetUrls1() {
        ContentStore.ContentUrlHandler handler = this.createDummyUrlHandler();
        this.cachingStore.getUrls(handler);
        ((ContentStore)Mockito.verify((Object)this.backingStore)).getUrls(handler);
    }

    @Test
    public void delegatedGetUrls2() {
        ContentStore.ContentUrlHandler handler = this.createDummyUrlHandler();
        Date after = new Date(123L);
        Date before = new Date(456L);
        this.cachingStore.getUrls(after, before, handler);
        ((ContentStore)Mockito.verify((Object)this.backingStore)).getUrls(after, before, handler);
    }

    @Test
    public void delegatedDelete() {
        Mockito.when((Object)this.backingStore.delete("url")).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.cachingStore.delete("url"));
        Mockito.when((Object)this.backingStore.delete("url")).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.cachingStore.delete("url"));
    }

    private ContentStore.ContentUrlHandler createDummyUrlHandler() {
        ContentStore.ContentUrlHandler handler = new ContentStore.ContentUrlHandler(){

            public void handle(String contentUrl) {
            }
        };
        return handler;
    }
}

