/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching;

import java.io.File;
import java.io.Serializable;

public class Key
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Type type;
    private final String value;

    private Key(Type type, String value) {
        this.type = type;
        this.value = value;
    }

    public static Key forUrl(String url) {
        return new Key(Type.CONTENT_URL, url);
    }

    public static Key forCacheFile(String path) {
        return new Key(Type.CACHE_FILE_PATH, path);
    }

    public static Key forCacheFile(File file) {
        return Key.forCacheFile(file.getAbsolutePath());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Key other = (Key)obj;
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        CONTENT_URL,
        CACHE_FILE_PATH;

    }
}

