/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching.cleanup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.alfresco.repo.content.caching.CacheFileProps;
import org.alfresco.repo.content.caching.CachingContentStore;
import org.alfresco.repo.content.caching.ContentCacheImpl;
import org.alfresco.repo.content.caching.Key;
import org.alfresco.repo.content.caching.cleanup.CachedContentCleaner;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

public class CachedContentCleanupJobTest {
    private static ApplicationContext ctx;
    private CachingContentStore cachingStore;
    private ContentCacheImpl cache;
    private File cacheRoot;
    private CachedContentCleaner cleaner;

    @BeforeClass
    public static void beforeClass() {
        String conf = "classpath:cachingstore/test-context.xml";
        String cleanerConf = "classpath:cachingstore/test-cleaner-context.xml";
        ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{conf, cleanerConf});
    }

    @Before
    public void setUp() throws IOException {
        this.cachingStore = (CachingContentStore)ctx.getBean("cachingContentStore");
        this.cache = (ContentCacheImpl)ctx.getBean("contentCache");
        this.cacheRoot = this.cache.getCacheRoot();
        this.cleaner = (CachedContentCleaner)ctx.getBean("cachedContentCleaner");
        this.cleaner.setMinFileAgeMillis(0L);
        this.cleaner.setMaxDeleteWatchCount(0);
        this.cache.removeAll();
        FileUtils.cleanDirectory((File)this.cacheRoot);
    }

    @Test
    public void filesNotInCacheAreDeleted() throws InterruptedException {
        this.cleaner.setMaxDeleteWatchCount(0);
        int numFiles = 300;
        long totalSize = 0L;
        File[] files = new File[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            File cacheFile;
            UrlSource urlSource = UrlSource.values()[i % UrlSource.values().length];
            files[i] = cacheFile = this.createCacheFile(urlSource, false);
            totalSize += cacheFile.length();
        }
        this.cleaner.execute();
        Thread.sleep(400L);
        while (this.cleaner.isRunning()) {
            Thread.sleep(200L);
        }
        for (File file : files) {
            Assert.assertFalse((String)("File should have been deleted: " + file), (boolean)file.exists());
        }
        Assert.assertEquals((String)"Incorrect number of deleted files", (long)numFiles, (long)this.cleaner.getNumFilesDeleted());
        Assert.assertEquals((String)"Incorrect total size of files deleted", (long)totalSize, (long)this.cleaner.getSizeFilesDeleted());
    }

    @Test
    public void filesNewerThanMinFileAgeMillisAreNotDeleted() throws InterruptedException {
        long minFileAge = 1000L;
        this.cleaner.setMinFileAgeMillis(1000L);
        this.cleaner.setMaxDeleteWatchCount(0);
        int numFiles = 10;
        File[] oldFiles = new File[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            oldFiles[i] = this.createCacheFile(UrlSource.REVERSE_CACHE_LOOKUP, false);
        }
        Thread.sleep(1000L);
        File[] newFiles = new File[numFiles];
        long newFilesTotalSize = 0L;
        for (int i = 0; i < numFiles; ++i) {
            newFiles[i] = this.createCacheFile(UrlSource.REVERSE_CACHE_LOOKUP, false);
            newFilesTotalSize += newFiles[i].length();
        }
        this.cleaner.execute();
        Thread.sleep(400L);
        while (this.cleaner.isRunning()) {
            Thread.sleep(200L);
        }
        for (File file : oldFiles) {
            Assert.assertFalse((String)("File should have been deleted: " + file), (boolean)file.exists());
        }
        for (File file : newFiles) {
            Assert.assertTrue((String)("File should not have been deleted: " + file), (boolean)file.exists());
        }
        Assert.assertEquals((String)"Incorrect number of deleted files", (long)newFiles.length, (long)this.cleaner.getNumFilesDeleted());
        Assert.assertEquals((String)"Incorrect total size of files deleted", (long)newFilesTotalSize, (long)this.cleaner.getSizeFilesDeleted());
    }

    @Test
    public void aggressiveCleanReclaimsTargetSpace() throws InterruptedException {
        int numFiles = 30;
        File[] files = new File[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            files[i] = this.createCacheFile(UrlSource.REVERSE_CACHE_LOOKUP, true);
        }
        long fileSize = files[0].length();
        long sevenFilesSize = 7L * fileSize;
        this.cleaner.executeAggressive("aggressiveCleanReclaimsTargetSpace()", sevenFilesSize);
        Thread.sleep(400L);
        while (this.cleaner.isRunning()) {
            Thread.sleep(200L);
        }
        int numDeleted = 0;
        for (File f : files) {
            if (f.exists()) continue;
            ++numDeleted;
        }
        Assert.assertEquals((String)"Wrong number of files deleted", (long)7L, (long)numDeleted);
        Assert.assertEquals((String)"Incorrect number of deleted files", (long)7L, (long)this.cleaner.getNumFilesDeleted());
        Assert.assertEquals((String)"Incorrect total size of files deleted", (long)sevenFilesSize, (long)this.cleaner.getSizeFilesDeleted());
    }

    @Test
    public void standardCleanAfterAggressiveFinished() throws InterruptedException {
        int numFiles = 30;
        File[] files = new File[30];
        for (int i = 0; i < 30; ++i) {
            GregorianCalendar calendar = new GregorianCalendar(2010, 12, 2, 17, i);
            files[i] = i >= 21 && i <= 24 ? this.createCacheFile(calendar, UrlSource.NOT_PRESENT, false) : this.createCacheFile(calendar, UrlSource.REVERSE_CACHE_LOOKUP, true);
        }
        long fileSize = files[0].length();
        long sevenFilesSize = 7L * fileSize;
        this.cleaner.executeAggressive("standardCleanAfterAggressiveFinished()", sevenFilesSize);
        Thread.sleep(400L);
        while (this.cleaner.isRunning()) {
            Thread.sleep(200L);
        }
        for (int i = 0; i < 30; ++i) {
            if (i < 7) {
                Assert.assertFalse((String)"First 7 files should have been aggressively cleaned", (boolean)files[i].exists());
            }
            if (i < 21 || i > 24) continue;
            Assert.assertFalse((String)"Files with indexes 21-24 should have been deleted", (boolean)files[i].exists());
        }
        Assert.assertEquals((String)"Incorrect number of deleted files", (long)11L, (long)this.cleaner.getNumFilesDeleted());
        Assert.assertEquals((String)"Incorrect total size of files deleted", (long)(11L * fileSize), (long)this.cleaner.getSizeFilesDeleted());
    }

    @Test
    public void emptyParentDirectoriesAreDeleted() throws FileNotFoundException {
        this.cleaner.setMaxDeleteWatchCount(0);
        File file = new File(this.cacheRoot, "243235984/a/b/c/d.bin");
        file.getParentFile().mkdirs();
        PrintWriter writer = new PrintWriter(file);
        writer.println("Content for emptyParentDirectoriesAreDeleted");
        writer.close();
        Assert.assertTrue((String)"Directory should exist", (boolean)new File(this.cacheRoot, "243235984/a/b/c").exists());
        this.cleaner.handle(file);
        Assert.assertFalse((String)"Directory should have been deleted", (boolean)new File(this.cacheRoot, "243235984").exists());
    }

    @Test
    public void markedFilesHaveDeletionDeferredUntilCorrectPassOfCleaner() {
        this.cleaner.setMaxDeleteWatchCount(0);
        File file = this.createCacheFile(UrlSource.NOT_PRESENT, false);
        this.cleaner.handle(file);
        this.checkFilesDeleted(file);
        this.cleaner.setMaxDeleteWatchCount(1);
        file = this.createCacheFile(UrlSource.NOT_PRESENT, false);
        this.cleaner.handle(file);
        this.checkWatchCountForCacheFile(file, 1);
        this.cleaner.handle(file);
        this.checkFilesDeleted(file);
        this.cleaner.setMaxDeleteWatchCount(3);
        file = this.createCacheFile(UrlSource.NOT_PRESENT, false);
        this.cleaner.handle(file);
        this.checkWatchCountForCacheFile(file, 1);
        this.cleaner.handle(file);
        this.checkWatchCountForCacheFile(file, 2);
        this.cleaner.handle(file);
        this.checkWatchCountForCacheFile(file, 3);
        this.cleaner.handle(file);
        this.checkFilesDeleted(file);
    }

    private void checkFilesDeleted(File file) {
        Assert.assertFalse((String)("File should have been deleted: " + file), (boolean)file.exists());
        CacheFileProps props = new CacheFileProps(file);
        Assert.assertFalse((String)("Properties file should have been deleted, cache file: " + file), (boolean)props.exists());
    }

    private void checkWatchCountForCacheFile(File file, Integer expectedWatchCount) {
        Assert.assertTrue((String)("File should still exist: " + file), (boolean)file.exists());
        CacheFileProps props = new CacheFileProps(file);
        props.load();
        Assert.assertEquals((String)"File should contain correct deleteWatchCount", (Object)expectedWatchCount, (Object)props.getDeleteWatchCount());
    }

    @Test
    public void filesInCacheAreNotDeleted() throws InterruptedException {
        int i;
        this.cleaner.setMaxDeleteWatchCount(0);
        String url = this.makeContentUrl();
        int numFiles = 50;
        for (i = 0; i < numFiles; ++i) {
            ContentReader reader = this.cachingStore.getReader(url);
            reader.getContentString();
        }
        this.cleaner.execute();
        Thread.sleep(400L);
        while (this.cleaner.isRunning()) {
            Thread.sleep(200L);
        }
        for (i = 0; i < numFiles; ++i) {
            File cacheFile = new File(this.cache.getCacheFilePath(url));
            Assert.assertTrue((String)"File should exist", (boolean)cacheFile.exists());
        }
    }

    private File createCacheFile(UrlSource urlSource, boolean putInCache) {
        GregorianCalendar calendar = new GregorianCalendar();
        return this.createCacheFile(calendar, urlSource, putInCache);
    }

    private File createCacheFile(Calendar calendar, UrlSource urlSource, boolean putInCache) {
        File file = new File(this.cacheRoot, this.createNewCacheFilePath(calendar));
        file.getParentFile().mkdirs();
        this.writeSampleContent(file);
        String contentUrl = this.makeContentUrl();
        if (putInCache) {
            this.cache.putIntoLookup(Key.forUrl(contentUrl), file.getAbsolutePath());
        }
        switch (urlSource) {
            case NOT_PRESENT: {
                break;
            }
            case PROPS_FILE: {
                CacheFileProps props = new CacheFileProps(file);
                props.setContentUrl(contentUrl);
                props.store();
                break;
            }
            case REVERSE_CACHE_LOOKUP: {
                this.cache.putIntoLookup(Key.forCacheFile(file), contentUrl);
            }
        }
        Assert.assertTrue((String)"File should exist", (boolean)file.exists());
        return file;
    }

    private String createNewCacheFilePath(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        StringBuilder sb = new StringBuilder(20);
        sb.append(year).append('/').append(month).append('/').append(day).append('/').append(hour).append('/').append(minute).append('/').append(GUID.generate()).append(".bin");
        return sb.toString();
    }

    private String makeContentUrl() {
        return "protocol://some/made/up/url/" + GUID.generate();
    }

    private void writeSampleContent(File file) {
        try {
            PrintWriter writer = new PrintWriter(file);
            writer.println("Content for sample file in " + this.getClass().getName());
            writer.close();
        }
        catch (Throwable e) {
            throw new RuntimeException("Couldn't write file: " + file, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UrlSource {
        PROPS_FILE,
        REVERSE_CACHE_LOOKUP,
        NOT_PRESENT;

    }
}

