/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching.quota;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.caching.CachingContentStore;
import org.alfresco.repo.content.caching.ContentCacheImpl;
import org.alfresco.repo.content.caching.cleanup.CachedContentCleaner;
import org.alfresco.repo.content.caching.quota.StandardQuotaStrategy;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.SizeFileComparator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardQuotaStrategyTest {
    private static ApplicationContext ctx;
    private CachingContentStore store;
    private static byte[] aKB;
    private ContentCacheImpl cache;
    private File cacheRoot;
    private StandardQuotaStrategy quota;
    private CachedContentCleaner cleaner;

    @BeforeClass
    public static void beforeClass() {
        ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:cachingstore/test-std-quota-context.xml"});
        aKB = new byte[1024];
        Arrays.fill(aKB, (byte)36);
    }

    @AfterClass
    public static void afterClass() {
        ApplicationContextHelper.closeApplicationContext();
    }

    @Before
    public void setUp() throws Exception {
        this.store = (CachingContentStore)ctx.getBean("cachingContentStore");
        this.store.setCacheOnInbound(true);
        this.cache = (ContentCacheImpl)ctx.getBean("contentCache");
        this.cacheRoot = this.cache.getCacheRoot();
        this.quota = (StandardQuotaStrategy)ctx.getBean("quotaManager");
        this.quota.setCurrentUsageBytes(0L);
        this.cleaner = (CachedContentCleaner)ctx.getBean("cachedContentCleaner");
        this.cache.removeAll();
        FileUtils.cleanDirectory((File)this.cacheRoot);
    }

    @Test
    public void cleanerWillTriggerAtCorrectThreshold() throws IOException, InterruptedException {
        for (int i = 0; i < 15; ++i) {
            this.writeSingleFileInMB(1);
        }
        Assert.assertEquals((long)15L, (long)this.findCacheFiles().size());
        this.writeSingleFileInMB(1);
        Thread.sleep(200L);
        while (this.cleaner.isRunning()) {
            Thread.sleep(50L);
        }
        Assert.assertEquals((long)6L, (long)this.findCacheFiles().size());
    }

    @Test
    public void cachingIsDisabledAtCorrectThreshold() throws IOException {
        for (int i = 0; i < 4; ++i) {
            this.writeSingleFileInMB(6);
        }
        Assert.assertEquals((long)3L, (long)this.findCacheFiles().size());
    }

    @Test
    public void largeContentCacheFilesAreNotKeptOnDisk() throws IOException {
        this.quota.setMaxFileSizeMB(3);
        this.writeSingleFileInMB(1);
        this.writeSingleFileInMB(2);
        this.writeSingleFileInMB(3);
        this.writeSingleFileInMB(4);
        ArrayList<File> files = new ArrayList<File>(this.findCacheFiles());
        Assert.assertEquals((long)3L, (long)files.size());
        Collections.sort(files, SizeFileComparator.SIZE_COMPARATOR);
        Assert.assertEquals((long)1L, (long)(((File)files.get(0)).length() / 0x100000L));
        Assert.assertEquals((long)2L, (long)(((File)files.get(1)).length() / 0x100000L));
        Assert.assertEquals((long)3L, (long)(((File)files.get(2)).length() / 0x100000L));
    }

    private void writeSingleFileInMB(int sizeInMb) throws IOException {
        ContentWriter writer = this.store.getWriter(ContentContext.NULL_CONTEXT);
        File content = this.createFileOfSize(sizeInMb * 1024);
        writer.putContent(content);
    }

    private File createFileOfSize(long sizeInKB) throws IOException {
        File file = new File(TempFileProvider.getSystemTempDir(), GUID.generate() + ".generated");
        file.deleteOnExit();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        for (long i = 0L; i < sizeInKB; ++i) {
            os.write(aKB);
        }
        os.close();
        return file;
    }

    private Collection<File> findCacheFiles() {
        return FileUtils.listFiles((File)this.cacheRoot, (IOFileFilter)new SuffixFileFilter(".bin"), (IOFileFilter)TrueFileFilter.INSTANCE);
    }

    private void concurrencySmokeTest() throws Exception {
        StandardQuotaStrategyTest.beforeClass();
        this.setUp();
        this.cleaner.setMaxDeleteWatchCount(1);
        int numThreads = 100;
        Thread[] writers = new Thread[100];
        for (int i = 0; i < 100; ++i) {
            final String threadName = "WriterThread[" + i + "]";
            Runnable runnable = new Runnable(){

                public void run() {
                    while (true) {
                        this.writeFile();
                        this.pause();
                    }
                }

                private void writeFile() {
                    try {
                        StandardQuotaStrategyTest.this.writeSingleFileInMB(1);
                    }
                    catch (IOException error) {
                        throw new RuntimeException(threadName + " couldn't write file.", error);
                    }
                }

                private void pause() {
                    long pauseTimeMillis = Math.round(Math.random() * 2000.0);
                    try {
                        Thread.sleep(pauseTimeMillis);
                    }
                    catch (InterruptedException error) {
                        System.out.println(threadName + " InterruptedException.");
                    }
                }
            };
            Thread writerThread = new Thread(runnable);
            writerThread.setName(threadName);
            writers[i] = writerThread;
            writerThread.start();
        }
    }

    public static void main(String[] args) throws Exception {
        StandardQuotaStrategyTest test = new StandardQuotaStrategyTest();
        test.concurrencySmokeTest();
    }
}

