/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.io.File;
import java.nio.ByteBuffer;
import org.alfresco.repo.content.AbstractWritableContentStoreTest;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentExistsException;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.TempFileProvider;

public class FileContentStoreTest
extends AbstractWritableContentStoreTest {
    private FileContentStore store;

    public void setUp() throws Exception {
        super.setUp();
        File tempDir = TempFileProvider.getTempDir();
        this.store = new FileContentStore(ctx, tempDir.getAbsolutePath() + File.separatorChar + this.getName());
        this.store.setDeleteEmptyDirs(true);
    }

    protected ContentStore getStore() {
        return this.store;
    }

    public void testConcurrentWriteDetection() throws Exception {
        ByteBuffer buffer = ByteBuffer.wrap("Something".getBytes());
        ContentStore store = this.getStore();
        ContentContext firstContentCtx = ContentStore.NEW_CONTENT_CONTEXT;
        ContentWriter firstWriter = store.getWriter(firstContentCtx);
        String contentUrl = firstWriter.getContentUrl();
        ContentContext secondContentCtx = new ContentContext(null, contentUrl);
        try {
            ContentWriter secondWriter = store.getWriter(secondContentCtx);
            FileContentStoreTest.fail((String)("Store must disallow more than one writer onto the same content URL: " + store));
        }
        catch (ContentExistsException e) {
            // empty catch block
        }
    }

    public void testRootLocation() throws Exception {
        ContentStore store = this.getStore();
        String root = store.getRootLocation();
        FileContentStoreTest.assertNotNull((String)"Root value can't be null", (Object)root);
        File dir = new File(root);
        FileContentStoreTest.assertTrue((String)"Root location for FileContentStore must exist", (boolean)dir.exists());
    }

    public void testSpaceUsed() throws Exception {
        ContentStore store = this.getStore();
        store.getWriter(new ContentContext(null, null)).putContent("Test content");
        long size = store.getSpaceUsed();
        FileContentStoreTest.assertTrue((String)"Size must be positive", (size > 0L ? 1 : 0) != 0);
    }

    public void testSpaceFree() throws Exception {
        ContentStore store = this.getStore();
        long size = store.getSpaceFree();
        FileContentStoreTest.assertTrue((String)"Size must be positive", (size > 0L ? 1 : 0) != 0);
        FileContentStoreTest.assertTrue((String)"Size must not be Long.MAX_VALUE", (size < Long.MAX_VALUE ? 1 : 0) != 0);
    }

    public void testSpaceTotal() throws Exception {
        ContentStore store = this.getStore();
        long size = store.getSpaceTotal();
        FileContentStoreTest.assertTrue((String)"Size must be positive", (size > 0L ? 1 : 0) != 0);
        FileContentStoreTest.assertTrue((String)"Size must not be Long.MAX_VALUE", (size < Long.MAX_VALUE ? 1 : 0) != 0);
    }

    public void testDeleteRemovesEmptyDirs() throws Exception {
        String url;
        ContentStore store = this.getStore();
        if (store.exists(url = "store://1965/12/1/13/12/file.bin")) {
            store.delete(url);
        }
        String content = "Content for test: " + this.getName();
        store.getWriter(new ContentContext(null, url)).putContent(content);
        File root = new File(store.getRootLocation());
        this.assertDirExists(root, "");
        this.assertDirExists(root, "1965/12/1/13/12");
        store.delete(url);
        this.assertDirNotExists(root, "1965");
        this.assertDirExists(root, "");
    }

    public void testDeleteLeavesNonEmptyDirs() {
        String url;
        ContentStore store = this.getStore();
        if (store.exists(url = "store://1965/12/1/13/12/file.bin")) {
            store.delete(url);
        }
        String content = "Content for test: " + this.getName();
        store.getWriter(new ContentContext(null, url)).putContent(content);
        File root = new File(store.getRootLocation());
        this.assertDirExists(root, "");
        this.assertDirExists(root, "1965/12/1/13/12");
        String anotherUrl = "store://1965/12/3/another.bin";
        if (store.exists(anotherUrl)) {
            store.delete(anotherUrl);
        }
        store.getWriter(new ContentContext(null, anotherUrl));
        store.delete(url);
        this.assertDirExists(root, "1965");
        this.assertDirExists(root, "1965/12");
        this.assertDirNotExists(root, "1965/12/1");
        this.assertDirExists(root, "");
    }

    public void testNoParentDirsDeleted() throws Exception {
        this.store.setDeleteEmptyDirs(false);
        FileContentStore store = (FileContentStore)this.getStore();
        String url = "store://1965/12/1/13/12/file.bin";
        if (store.exists(url)) {
            store.delete(url);
        }
        String content = "Content for test: " + this.getName();
        store.getWriter(new ContentContext(null, url)).putContent(content);
        File root = new File(store.getRootLocation());
        store.delete(url);
        this.assertDirExists(root, "1965/12/1/13/12");
        this.assertDirExists(root, "");
    }

    private void assertDirExists(File root, String dir) {
        FileContentStoreTest.assertTrue((String)("Directory [" + dir + "] should exist"), (boolean)new File(root, dir).exists());
    }

    private void assertDirNotExists(File root, String dir) {
        FileContentStoreTest.assertFalse((String)("Directory [" + dir + "] should NOT exist"), (boolean)new File(root, dir).exists());
    }
}

