/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.metadata;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.metadata.AbstractMetadataExtracterTest;
import org.alfresco.repo.content.metadata.MetadataExtracter;
import org.alfresco.repo.content.metadata.TikaAutoMetadataExtracter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.ooxml.OOXMLParser;
import org.apache.tika.parser.mp3.Mp3Parser;
import org.apache.tika.parser.odf.OpenDocumentParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TikaAutoMetadataExtracterTest
extends AbstractMetadataExtracterTest {
    private static Log logger = LogFactory.getLog(TikaAutoMetadataExtracterTest.class);
    private TikaAutoMetadataExtracter extracter;
    private static final QName TIKA_MIMETYPE_TEST_PROPERTY = QName.createQName((String)"TikaMimeTypeTestProp");

    @Override
    public void setUp() throws Exception {
        super.setUp();
        TikaConfig config = (TikaConfig)this.ctx.getBean("tikaConfig");
        this.extracter = new TikaAutoMetadataExtracter(config);
        this.extracter.setDictionaryService(this.dictionaryService);
        this.extracter.register();
        HashMap<String, Set<QName>> newMap = new HashMap<String, Set<QName>>(this.extracter.getMapping());
        HashSet<QName> tlaSet = new HashSet<QName>();
        tlaSet.add(TIKA_MIMETYPE_TEST_PROPERTY);
        newMap.put("Content-Type", tlaSet);
        this.extracter.setMapping(newMap);
    }

    @Override
    protected MetadataExtracter getExtracter() {
        return this.extracter;
    }

    public void testSupports() throws Exception {
        ArrayList<String> mimeTypes = new ArrayList<String>();
        for (Parser p : new Parser[]{new OfficeParser(), new OpenDocumentParser(), new Mp3Parser(), new OOXMLParser()}) {
            Set mts = p.getSupportedTypes(new ParseContext());
            for (MediaType mt : mts) {
                mimeTypes.add(mt.toString());
            }
        }
        for (String mimetype : mimeTypes) {
            boolean supports = this.extracter.isSupported(mimetype);
            TikaAutoMetadataExtracterTest.assertTrue((String)("Mimetype should be supported: " + mimetype), (boolean)supports);
        }
    }

    public void testSupportedMimetypes() throws Exception {
        String[] testFiles = new String[]{".doc", ".docx", ".xls", ".xlsx", ".ppt", ".pptx", "2010.dwg", "2003.mpp", "2007.mpp", ".pdf", ".odt"};
        AutoDetectParser ap = new AutoDetectParser();
        for (String fileBase : testFiles) {
            String filename = "quick" + fileBase;
            URL url = AbstractContentTransformerTest.class.getClassLoader().getResource("quick/" + filename);
            File file = new File(url.getFile());
            Metadata metadata = new Metadata();
            metadata.set("resourceName", filename);
            MediaType mt = ap.getDetector().detect((InputStream)TikaInputStream.get((File)file), metadata);
            String mimetype = mt.toString();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Detected mimetype " + mimetype + " for quick test file " + filename));
            }
            Map<QName, Serializable> properties = this.extractFromFile(file, mimetype);
            TikaAutoMetadataExtracterTest.assertFalse((String)("extractFromMimetype should return at least some properties, none found for " + mimetype + " - " + filename), (boolean)properties.isEmpty());
            this.testCommonMetadata(mimetype, properties);
            this.testFileSpecificMetadata(mimetype, properties);
        }
    }

    @Override
    protected boolean skipAuthorCheck(String mimetype) {
        return true;
    }

    @Override
    protected boolean skipDescriptionCheck(String mimetype) {
        return mimetype.endsWith("/ogg");
    }

    @Override
    protected void testFileSpecificMetadata(String mimetype, Map<QName, Serializable> properties) {
        if (mimetype.indexOf(".oasis.") == -1 && !mimetype.endsWith("/ogg") && !mimetype.endsWith("dwg")) {
            TikaAutoMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_AUTHOR + " not found for mimetype " + mimetype), (String)"Nevin Nollop", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_AUTHOR))));
        }
        TikaAutoMetadataExtracterTest.assertTrue((String)("Test Property " + TIKA_MIMETYPE_TEST_PROPERTY + " not found for mimetype " + mimetype), (boolean)properties.containsKey(TIKA_MIMETYPE_TEST_PROPERTY));
        TikaAutoMetadataExtracterTest.assertEquals((String)("Test Property " + TIKA_MIMETYPE_TEST_PROPERTY + " incorrect for mimetype " + mimetype), (String)mimetype, (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(TIKA_MIMETYPE_TEST_PROPERTY))));
        if (mimetype.startsWith("audio")) {
            TikaAutoMetadataExtracterTest.assertEquals((String)("Property " + ContentModel.PROP_AUTHOR + " not found for mimetype " + mimetype), (String)"Hauskaz", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_AUTHOR))));
            QName artistQ = QName.createQName((String)"http://www.alfresco.org/model/audio/1.0", (String)"artist");
            TikaAutoMetadataExtracterTest.assertEquals((String)("Property " + artistQ + " not found for mimetype " + mimetype), (String)"Hauskaz", (String)((String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(artistQ))));
        }
    }

    public void testImageVideo() throws Throwable {
        Map<String, Serializable> p = this.openAndCheck(".jpg", "image/jpeg");
        TikaAutoMetadataExtracterTest.assertEquals((Object)"409 pixels", (Object)p.get("Image Width"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"92 pixels", (Object)p.get("Image Height"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"8 bits", (Object)p.get("Data Precision"));
        p = this.openAndCheck(".gif", "image/gif");
        TikaAutoMetadataExtracterTest.assertEquals((Object)"409", (Object)p.get("width"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"92", (Object)p.get("height"));
        p = this.openAndCheck(".png", "image/png");
        TikaAutoMetadataExtracterTest.assertEquals((Object)"409", (Object)p.get("width"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"92", (Object)p.get("height"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"8 8 8", (Object)p.get("Data BitsPerSample"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"none", (Object)p.get("Transparency Alpha"));
        p = this.openAndCheck(".bmp", "image/bmp");
        TikaAutoMetadataExtracterTest.assertEquals((Object)"409", (Object)p.get("width"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"92", (Object)p.get("height"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"8 8 8", (Object)p.get("Data BitsPerSample"));
        p = this.openAndCheck("GEO.jpg", "image/jpeg");
        TikaAutoMetadataExtracterTest.assertEquals((Object)"100 pixels", (Object)p.get("Image Width"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"68 pixels", (Object)p.get("Image Height"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"8 bits", (Object)p.get("Data Precision"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)p.get("comment"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"canon-55-250", (Object)p.get("subject"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"12.54321", (Object)p.get("geo:lat"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"-54.1234", (Object)p.get("geo:long"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"100", (Object)p.get("tiff:ImageWidth"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"68", (Object)p.get("tiff:ImageLength"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"Canon", (Object)p.get("tiff:Make"));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"5.6", (Object)p.get("exif:FNumber"));
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        FileContentReader reader = new FileContentReader(this.open("GEO.jpg"));
        reader.setMimetype("image/jpeg");
        this.extracter.extract(reader, properties);
        TikaAutoMetadataExtracterTest.assertEquals((Object)12.54321, properties.get(ContentModel.PROP_LATITUDE));
        TikaAutoMetadataExtracterTest.assertEquals((Object)-54.1234, properties.get(ContentModel.PROP_LONGITUDE));
        TikaAutoMetadataExtracterTest.assertEquals((Object)100, properties.get(QName.createQName((String)"http://www.alfresco.org/model/exif/1.0", (String)"pixelXDimension")));
        TikaAutoMetadataExtracterTest.assertEquals((Object)68, properties.get(QName.createQName((String)"http://www.alfresco.org/model/exif/1.0", (String)"pixelYDimension")));
        TikaAutoMetadataExtracterTest.assertEquals((Object)6.25E-4, properties.get(QName.createQName((String)"http://www.alfresco.org/model/exif/1.0", (String)"exposureTime")));
        TikaAutoMetadataExtracterTest.assertEquals((Object)5.6, properties.get(QName.createQName((String)"http://www.alfresco.org/model/exif/1.0", (String)"fNumber")));
        TikaAutoMetadataExtracterTest.assertEquals((Object)false, properties.get(QName.createQName((String)"http://www.alfresco.org/model/exif/1.0", (String)"flash")));
        TikaAutoMetadataExtracterTest.assertEquals((Object)194.0, properties.get(QName.createQName((String)"http://www.alfresco.org/model/exif/1.0", (String)"focalLength")));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"400", properties.get(QName.createQName((String)"http://www.alfresco.org/model/exif/1.0", (String)"isoSpeedRatings")));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"Canon", properties.get(QName.createQName((String)"http://www.alfresco.org/model/exif/1.0", (String)"manufacturer")));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"Canon EOS 40D", properties.get(QName.createQName((String)"http://www.alfresco.org/model/exif/1.0", (String)"model")));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"Adobe Photoshop CS3 Macintosh", properties.get(QName.createQName((String)"http://www.alfresco.org/model/exif/1.0", (String)"software")));
        TikaAutoMetadataExtracterTest.assertEquals(null, properties.get(QName.createQName((String)"http://www.alfresco.org/model/exif/1.0", (String)"orientation")));
        TikaAutoMetadataExtracterTest.assertEquals((Object)240.0, properties.get(QName.createQName((String)"http://www.alfresco.org/model/exif/1.0", (String)"xResolution")));
        TikaAutoMetadataExtracterTest.assertEquals((Object)240.0, properties.get(QName.createQName((String)"http://www.alfresco.org/model/exif/1.0", (String)"yResolution")));
        TikaAutoMetadataExtracterTest.assertEquals((Object)"Inch", properties.get(QName.createQName((String)"http://www.alfresco.org/model/exif/1.0", (String)"resolutionUnit")));
    }

    private File open(String fileBase) throws Throwable {
        String filename = "quick" + fileBase;
        URL url = AbstractContentTransformerTest.class.getClassLoader().getResource("quick/" + filename);
        File file = new File(url.getFile());
        TikaAutoMetadataExtracterTest.assertTrue((boolean)file.exists());
        return file;
    }

    private Map<String, Serializable> openAndCheck(String fileBase, String expMimeType) throws Throwable {
        File file = this.open(fileBase);
        FileContentReader detectReader = new FileContentReader(file);
        String mimetype = this.mimetypeMap.guessMimetype(fileBase, (ContentReader)detectReader);
        TikaAutoMetadataExtracterTest.assertEquals((String)("Wrong mimetype for " + fileBase), (String)mimetype, (String)expMimeType);
        TikaAutoMetadataExtracterTest.assertTrue((String)("Mimetype should be supported but isn't: " + mimetype), (boolean)this.extracter.isSupported(mimetype));
        FileContentReader sourceReader = new FileContentReader(file);
        sourceReader.setMimetype(mimetype);
        return this.extracter.extractRaw(sourceReader);
    }
}

