/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.lf5.util.StreamUtils;

public class AppleIWorksContentTransformer
extends AbstractContentTransformer2 {
    private static final Log log = LogFactory.getLog(AppleIWorksContentTransformer.class);
    private static final String QUICK_LOOK_PREVIEW_PDF = "QuickLook/Preview.pdf";
    private static final String QUICK_LOOK_THUMBNAIL_JPG = "QuickLook/Thumbnail.jpg";
    private static final List<String> IWORKS_MIMETYPES = Arrays.asList("application/vnd.apple.keynote", "application/vnd.apple.numbers", "application/vnd.apple.pages");
    private static final List<String> TARGET_MIMETYPES = Arrays.asList("image/jpeg", "application/pdf");

    public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return TARGET_MIMETYPES.contains(targetMimetype) && IWORKS_MIMETYPES.contains(sourceMimetype);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
        String sourceMimetype = reader.getMimetype();
        String sourceExtension = this.getMimetypeService().getExtension(sourceMimetype);
        String targetMimetype = writer.getMimetype();
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Transforming from ").append(sourceMimetype).append(" to ").append(targetMimetype);
            log.debug((Object)msg.toString());
        }
        ZipFile iworksZipfile = null;
        try {
            try {
                File iWorksTempFile = TempFileProvider.createTempFile((String)(this.getClass().getSimpleName() + "_iWorks"), (String)sourceExtension);
                reader.getContent(iWorksTempFile);
                iworksZipfile = new ZipFile(iWorksTempFile);
                File tempOutFile = null;
                if ("image/jpeg".equals(targetMimetype)) {
                    tempOutFile = this.copyZipEntryToTempFile(QUICK_LOOK_THUMBNAIL_JPG, iworksZipfile);
                } else {
                    if (!"application/pdf".equals(targetMimetype)) throw new AlfrescoRuntimeException("Unable to transform " + sourceExtension + " file to " + targetMimetype);
                    tempOutFile = this.copyZipEntryToTempFile(QUICK_LOOK_PREVIEW_PDF, iworksZipfile);
                }
                writer.putContent(tempOutFile);
            }
            catch (FileNotFoundException e1) {
                throw new AlfrescoRuntimeException("Unable to transform " + sourceExtension + " file.", (Throwable)e1);
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("Unable to transform " + sourceExtension + " file.", (Throwable)e);
            }
            Object var11_12 = null;
            if (iworksZipfile == null) return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (iworksZipfile == null) throw throwable;
            iworksZipfile.close();
            throw throwable;
        }
        iworksZipfile.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File copyZipEntryToTempFile(String zipEntryName, ZipFile iworksZipfile) throws IOException {
        String extension = zipEntryName.endsWith(".jpg") ? ".jpg" : ".pdf";
        ZipEntry embeddedQuicklookResource = iworksZipfile.getEntry(zipEntryName);
        if (embeddedQuicklookResource == null) {
            throw new AlfrescoRuntimeException("Unable to transform iWorks file as there was no embedded preview.");
        }
        File outputFile = TempFileProvider.createTempFile((String)(this.getClass().getSimpleName() + "_ZipEntry"), (String)extension);
        FilterOutputStream bufOut = null;
        try {
            InputStream zin = iworksZipfile.getInputStream(embeddedQuicklookResource);
            bufOut = new BufferedOutputStream(new FileOutputStream(outputFile));
            StreamUtils.copy((InputStream)zin, (OutputStream)bufOut);
            Object var9_8 = null;
            if (bufOut == null) return outputFile;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (bufOut == null) throw throwable;
            bufOut.close();
            throw throwable;
        }
        bufOut.close();
        return outputFile;
    }
}

