/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentTransformerRegistry {
    private static final Log logger = LogFactory.getLog(ContentTransformerRegistry.class);
    private List<ContentTransformer> transformers = new ArrayList<ContentTransformer>(10);

    public void addTransformer(ContentTransformer transformer) {
        this.transformers.add(transformer);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered general transformer: \n   transformer: " + transformer));
        }
    }

    public ContentTransformer getTransformer(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.getTransformer(sourceMimetype, -1L, targetMimetype, options);
    }

    public ContentTransformer getTransformer(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        List<ContentTransformer> transformers = this.getActiveTransformers(sourceMimetype, sourceSize, targetMimetype, options);
        ContentTransformer bestTransformer = null;
        if (transformers.size() > 0) {
            bestTransformer = transformers.get(0);
        }
        return bestTransformer;
    }

    public List<ContentTransformer> getActiveTransformers(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        List<ContentTransformer> transformers = this.findTransformers(sourceMimetype, sourceSize, targetMimetype, options);
        final HashMap<ContentTransformer, Long> activeTransformers = new HashMap<ContentTransformer, Long>();
        for (ContentTransformer transformer : transformers) {
            if (!transformer.isTransformable(sourceMimetype, sourceSize, targetMimetype, options)) continue;
            long transformationTime = transformer.getTransformationTime();
            activeTransformers.put(transformer, transformationTime);
        }
        ArrayList<ContentTransformer> sorted = new ArrayList<ContentTransformer>(activeTransformers.keySet());
        Collections.sort(sorted, new Comparator<ContentTransformer>(){

            @Override
            public int compare(ContentTransformer a, ContentTransformer b) {
                return ((Long)activeTransformers.get(a)).compareTo((Long)activeTransformers.get(b));
            }
        });
        return sorted;
    }

    private List<ContentTransformer> findTransformers(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        List<ContentTransformer> transformers = this.findDirectTransformers(sourceMimetype, sourceSize, targetMimetype, options);
        List<ContentTransformer> complexTransformers = this.findComplexTransformer(sourceMimetype, targetMimetype, options);
        transformers.addAll(complexTransformers);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searched for transformer: \n   source mimetype: " + sourceMimetype + "\n" + "   target mimetype: " + targetMimetype + "\n" + "   transformers: " + transformers));
        }
        return transformers;
    }

    private List<ContentTransformer> findDirectTransformers(String sourceMimetype, long sourceSize, String targetMimetype, TransformationOptions options) {
        ArrayList<ContentTransformer> transformers = new ArrayList<ContentTransformer>(2);
        boolean foundExplicit = false;
        for (ContentTransformer transformer : this.transformers) {
            if (!transformer.isTransformable(sourceMimetype, sourceSize, targetMimetype, options)) continue;
            if (transformer.isExplicitTransformation(sourceMimetype, targetMimetype, options)) {
                if (!foundExplicit) {
                    transformers.clear();
                    foundExplicit = true;
                }
                transformers.add(transformer);
                continue;
            }
            if (foundExplicit) continue;
            transformers.add(transformer);
        }
        return transformers;
    }

    private List<ContentTransformer> findComplexTransformer(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return Collections.emptyList();
    }

    private void buildTransformer(List<ContentTransformer> transformers, double reliability, List<String> touchedMimetypes, String currentMimetype, String targetMimetype) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static class TransformationKey {
        private final String sourceMimetype;
        private final String targetMimetype;
        private final String key;

        public TransformationKey(String sourceMimetype, String targetMimetype) {
            this.key = sourceMimetype + "_" + targetMimetype;
            this.sourceMimetype = sourceMimetype;
            this.targetMimetype = targetMimetype;
        }

        public String getSourceMimetype() {
            return this.sourceMimetype;
        }

        public String getTargetMimetype() {
            return this.targetMimetype;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TransformationKey)) {
                return false;
            }
            TransformationKey that = (TransformationKey)obj;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

