/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Collections;
import java.util.List;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformer2;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.ContentTransformerRegistry;
import org.alfresco.repo.content.transform.ExplictTransformationDetails;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;

public class ContentTransformerRegistryTest
extends AbstractContentTransformerTest {
    private static final String A = "text/plain";
    private static final String B = "text/xml";
    private static final String C = "application/msword";
    private static final String D = "text/html";
    private static final TransformationOptions OPTIONS = new TransformationOptions();
    private ContentTransformerRegistry registry;
    private ContentTransformerRegistry dummyRegistry;
    private ContentReader reader;
    private ContentWriter writer;

    public void setUp() throws Exception {
        super.setUp();
        this.registry = (ContentTransformerRegistry)this.ctx.getBean("contentTransformerRegistry");
        this.reader = new FileContentReader(TempFileProvider.createTempFile((String)this.getName(), (String)".txt"));
        this.reader.setMimetype(A);
        this.writer = new FileContentWriter(TempFileProvider.createTempFile((String)this.getName(), (String)".txt"));
        this.writer.setMimetype(D);
        byte[] bytes = new byte[256];
        for (int i = 0; i < 256; ++i) {
            bytes[i] = (byte)i;
        }
        this.dummyRegistry = new ContentTransformerRegistry();
        new DummyTransformer(this.mimetypeService, this.transformerDebug, this.dummyRegistry, A, B, 10L);
        new DummyTransformer(this.mimetypeService, this.transformerDebug, this.dummyRegistry, A, B, 10L);
        new DummyTransformer(this.mimetypeService, this.transformerDebug, this.dummyRegistry, A, C, 10L);
        new DummyTransformer(this.mimetypeService, this.transformerDebug, this.dummyRegistry, A, C, 10L);
        new DummyTransformer(this.mimetypeService, this.transformerDebug, this.dummyRegistry, B, C, 10L);
        new DummyTransformer(this.mimetypeService, this.transformerDebug, this.dummyRegistry, A, D, 20L);
        new DummyTransformer(this.mimetypeService, this.transformerDebug, this.dummyRegistry, A, D, 30L);
        new DummyTransformer(this.mimetypeService, this.transformerDebug, this.dummyRegistry, A, D, 10L);
        new DummyTransformer(this.mimetypeService, this.transformerDebug, this.dummyRegistry, A, D, 25L);
        new DummyTransformer(this.mimetypeService, this.transformerDebug, this.dummyRegistry, A, D, 25L);
    }

    public void testSetUp() throws Exception {
        super.testSetUp();
        ContentTransformerRegistryTest.assertNotNull((Object)this.registry);
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        return this.registry.getTransformer(sourceMimetype, -1L, targetMimetype, options);
    }

    public void testNullRetrieval() throws Exception {
        ContentTransformer transformer = null;
        transformer = this.dummyRegistry.getTransformer(C, -1L, B, OPTIONS);
        ContentTransformerRegistryTest.assertNull((String)"No transformer expected", (Object)transformer);
        transformer = this.dummyRegistry.getTransformer(C, -1L, A, OPTIONS);
        ContentTransformerRegistryTest.assertNull((String)"No transformer expected", (Object)transformer);
        transformer = this.dummyRegistry.getTransformer(B, -1L, A, OPTIONS);
        ContentTransformerRegistryTest.assertNull((String)"No transformer expected", (Object)transformer);
    }

    public void testSimpleRetrieval() throws Exception {
        ContentTransformer transformer = null;
        transformer = this.dummyRegistry.getTransformer(B, -1L, C, OPTIONS);
        ContentTransformerRegistryTest.assertNotNull((String)"No transformer found", (Object)transformer);
        ContentTransformerRegistryTest.assertTrue((String)"Incorrect reliability", (boolean)transformer.isTransformable(B, -1L, C, OPTIONS));
        ContentTransformerRegistryTest.assertFalse((String)"Incorrect reliability", (boolean)transformer.isTransformable(C, -1L, B, OPTIONS));
    }

    public void testPerformanceRetrieval() throws Exception {
        ContentTransformer transformer1 = this.dummyRegistry.getTransformer(A, -1L, D, OPTIONS);
        ContentTransformerRegistryTest.assertTrue((String)"Incorrect reliability", (boolean)transformer1.isTransformable(A, -1L, D, OPTIONS));
        ContentTransformerRegistryTest.assertFalse((String)"Incorrect reliability", (boolean)transformer1.isTransformable(D, -1L, A, OPTIONS));
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect transformation time", (long)10L, (long)transformer1.getTransformationTime());
        List<ContentTransformer> activeTransformers = this.dummyRegistry.getActiveTransformers(A, -1L, D, OPTIONS);
        ContentTransformerRegistryTest.assertEquals((String)"Not all found", (int)5, (int)activeTransformers.size());
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect order", (long)10L, (long)activeTransformers.get(0).getTransformationTime());
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect order", (long)20L, (long)activeTransformers.get(1).getTransformationTime());
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect order", (long)25L, (long)activeTransformers.get(2).getTransformationTime());
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect order", (long)25L, (long)activeTransformers.get(3).getTransformationTime());
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect order", (long)30L, (long)activeTransformers.get(4).getTransformationTime());
        ((DummyTransformer)activeTransformers.get(2)).disable();
        ((DummyTransformer)activeTransformers.get(4)).disable();
        activeTransformers = this.dummyRegistry.getActiveTransformers(A, -1L, D, OPTIONS);
        ContentTransformerRegistryTest.assertEquals((String)"Not all found", (int)3, (int)activeTransformers.size());
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect order", (long)10L, (long)activeTransformers.get(0).getTransformationTime());
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect order", (long)20L, (long)activeTransformers.get(1).getTransformationTime());
        ContentTransformerRegistryTest.assertEquals((String)"Incorrect order", (long)25L, (long)activeTransformers.get(2).getTransformationTime());
    }

    public void testScoredRetrieval() throws Exception {
        ContentTransformer transformer = null;
        transformer = this.dummyRegistry.getTransformer(A, -1L, B, OPTIONS);
        ContentTransformerRegistryTest.assertNotNull((String)"No transformer found", (Object)transformer);
        ContentTransformerRegistryTest.assertTrue((String)"Incorrect reliability", (boolean)transformer.isTransformable(A, -1L, B, OPTIONS));
        ContentTransformerRegistryTest.assertFalse((String)"Incorrect reliability", (boolean)transformer.isTransformable(B, -1L, A, OPTIONS));
        transformer = this.dummyRegistry.getTransformer(A, -1L, C, OPTIONS);
        ContentTransformerRegistryTest.assertNotNull((String)"No transformer found", (Object)transformer);
        ContentTransformerRegistryTest.assertTrue((String)"Incorrect reliability", (boolean)transformer.isTransformable(A, -1L, C, OPTIONS));
        ContentTransformerRegistryTest.assertFalse((String)"Incorrect reliability", (boolean)transformer.isTransformable(C, -1L, A, OPTIONS));
    }

    public void testExplicitTransformation() {
        DummyTransformer dummyTransformer = new DummyTransformer(this.mimetypeService, this.transformerDebug, this.dummyRegistry, "application/x-shockwave-flash", "application/vnd.ms-excel", 12345L);
        ExplictTransformationDetails key = new ExplictTransformationDetails("application/x-shockwave-flash", "application/vnd.ms-excel");
        dummyTransformer.setExplicitTransformations(Collections.singletonList(key));
        dummyTransformer.register();
        ContentTransformer checkTransformer = this.dummyRegistry.getTransformer("application/x-shockwave-flash", -1L, "application/vnd.ms-excel", OPTIONS);
        ContentTransformerRegistryTest.assertNotNull((String)"No explicit transformer found", (Object)checkTransformer);
        ContentTransformerRegistryTest.assertTrue((String)"Expected explicit transformer", (dummyTransformer == checkTransformer ? 1 : 0) != 0);
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return null;
    }

    private static class DummyTransformer
    extends AbstractContentTransformer2 {
        private String sourceMimetype;
        private String targetMimetype;
        private long transformationTime;
        private boolean disable = false;

        public DummyTransformer(MimetypeService mimetypeService, TransformerDebug transformerDebug, ContentTransformerRegistry registry, String sourceMimetype, String targetMimetype, long transformationTime) {
            super.setMimetypeService(mimetypeService);
            super.setTransformerDebug(transformerDebug);
            super.setRegistry(registry);
            this.sourceMimetype = sourceMimetype;
            this.targetMimetype = targetMimetype;
            this.transformationTime = transformationTime;
            this.register();
        }

        protected void enable() {
            this.disable = false;
        }

        protected void disable() {
            this.disable = true;
        }

        public boolean isTransformable(String sourceMimetype, String targetMimetype, TransformationOptions options) {
            if (this.disable) {
                return false;
            }
            return this.sourceMimetype.equals(sourceMimetype) && this.targetMimetype.equals(targetMimetype);
        }

        public void transformInternal(ContentReader reader, ContentWriter writer, TransformationOptions options) throws Exception {
            super.recordTime(this.transformationTime);
        }

        public synchronized long getTransformationTime() {
            return this.transformationTime;
        }
    }
}

