/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.PoiContentTransformer;
import org.alfresco.service.cmr.repository.TransformationOptions;

public class PoiContentTransformerTest
extends AbstractContentTransformerTest {
    private PoiContentTransformer transformer;

    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new PoiContentTransformer();
        this.transformer.setMimetypeService(this.mimetypeService);
        this.transformer.setTransformerDebug(this.transformerDebug);
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testIsTransformable() throws Exception {
        PoiContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", -1L, "application/msword", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/msword", -1L, "text/plain", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/msword", -1L, "text/html", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/msword", -1L, "text/xml", new TransformationOptions()));
        PoiContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", -1L, "application/vnd.ms-powerpoint", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-powerpoint", -1L, "text/plain", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-powerpoint", -1L, "text/html", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-powerpoint", -1L, "text/xml", new TransformationOptions()));
        PoiContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", -1L, "application/vnd.ms-outlook", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-outlook", -1L, "text/plain", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-outlook", -1L, "text/html", new TransformationOptions()));
        PoiContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-outlook", -1L, "text/xml", new TransformationOptions()));
        PoiContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("application/vnd.ms-excel", -1L, "text/plain", new TransformationOptions()));
    }
}

