/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.TextToPdfContentTransformer;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.util.TempFileProvider;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.PDFTextStripper;

public class TextToPdfContentTransformerTest
extends AbstractContentTransformerTest {
    private TextToPdfContentTransformer transformer;

    public void setUp() throws Exception {
        super.setUp();
        this.transformer = new TextToPdfContentTransformer();
        this.transformer.setMimetypeService(this.mimetypeService);
        this.transformer.setTransformerDebug(this.transformerDebug);
        this.transformer.setStandardFont("Times-Roman");
        this.transformer.setFontSize(20);
        this.transformer.setPageLimit(-1);
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testReliability() throws Exception {
        boolean reliability = this.transformer.isTransformable("application/pdf", -1L, "text/plain", new TransformationOptions());
        TextToPdfContentTransformerTest.assertEquals((String)"Mimetype should not be supported", (boolean)false, (boolean)reliability);
        reliability = this.transformer.isTransformable("text/plain", -1L, "application/pdf", new TransformationOptions());
        TextToPdfContentTransformerTest.assertEquals((String)"Mimetype should be supported", (boolean)true, (boolean)reliability);
        reliability = this.transformer.isTransformable("text/xml", -1L, "application/pdf", new TransformationOptions());
        TextToPdfContentTransformerTest.assertEquals((String)"Mimetype should be supported", (boolean)true, (boolean)reliability);
    }

    public void DISABLEDtestUnicodeTextAndEncodings() throws Exception {
        String allAscii = "This is a simple set of text\nIt is all nice and dull\n";
        String european = "En fran\u00e7ais o\u00f9 les choses sont accentu\u00e9s\nEn espa\u00f1ol, as\u00ed";
        for (String text : new String[]{allAscii, european}) {
            for (String encoding : new String[]{"ISO-8859-1", "UTF-8", "UTF-16"}) {
                String checkText = this.clean(text);
                this.transformTextAndCheck(text, encoding, checkText);
            }
        }
    }

    public void testUnlimitedPages() throws Exception {
        this.transformTextAndCheckPageLength(-1);
    }

    public void testLimitedTo1Page() throws Exception {
        this.transformTextAndCheckPageLength(1);
    }

    public void testLimitedTo2Pages() throws Exception {
        this.transformTextAndCheckPageLength(2);
    }

    public void testLimitedTo50Pages() throws Exception {
        this.transformTextAndCheckPageLength(50);
    }

    private void transformTextAndCheckPageLength(int pageLimit) throws IOException {
        this.transformer.setPageLimit(pageLimit);
        int pageLength = 32;
        int lines = (pageLength + 10) * (pageLimit > 0 ? pageLimit : 1);
        StringBuilder sb = new StringBuilder();
        String checkText = null;
        int cutoff = pageLimit * pageLength;
        for (int i = 1; i <= lines; ++i) {
            sb.append(i);
            sb.append(" I must not talk in class or feed my homework to my cat.\n");
            if (i != cutoff) continue;
            checkText = sb.toString();
        }
        sb.append("\nBart\n");
        String text = sb.toString();
        checkText = checkText == null ? this.clean(text) : this.clean(checkText);
        this.transformTextAndCheck(text, "UTF-8", checkText);
    }

    private void transformTextAndCheck(String text, String encoding, String checkText) throws IOException {
        ContentReader reader = TextToPdfContentTransformerTest.buildContentReader(text, Charset.forName(encoding));
        File out = TempFileProvider.createTempFile((String)"AlfrescoTest_", (String)".pdf");
        FileContentWriter writer = new FileContentWriter(out);
        writer.setMimetype("application/pdf");
        this.transformer.transform(reader, writer);
        PDDocument doc = PDDocument.load((File)out);
        PDFTextStripper textStripper = new PDFTextStripper();
        StringWriter textWriter = new StringWriter();
        textStripper.writeText(doc, (Writer)textWriter);
        doc.close();
        String roundTrip = this.clean(textWriter.toString());
        TextToPdfContentTransformerTest.assertEquals((String)("Incorrect text in PDF when starting from text in " + encoding), (String)checkText, (String)roundTrip);
    }

    private String clean(String text) {
        text = text.replaceAll("\\s+\\r", "");
        text = text.replaceAll("\\s+\\n", "");
        text = text.replaceAll("\\r", "");
        text = text.replaceAll("\\n", "");
        return text;
    }
}

