/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.TikaAutoContentTransformer;
import org.alfresco.repo.content.transform.TikaPoweredContentTransformerTest;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.tika.config.TikaConfig;

public class TikaAutoContentTransformerTest
extends TikaPoweredContentTransformerTest {
    private TikaAutoContentTransformer transformer;

    public void setUp() throws Exception {
        super.setUp();
        TikaConfig config = (TikaConfig)this.ctx.getBean("tikaConfig");
        this.transformer = new TikaAutoContentTransformer(config);
        this.transformer.setMimetypeService(this.mimetypeService);
        this.transformer.setTransformerDebug(this.transformerDebug);
    }

    protected ContentTransformer getTransformer(String sourceMimetype, String targetMimetype) {
        return this.transformer;
    }

    public void testIsTransformable() throws Exception {
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", -1L, "application/vnd.ms-excel", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-excel", -1L, "text/plain", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-excel", -1L, "text/html", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.ms-excel", -1L, "text/xml", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", -1L, "application/msword", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/msword", -1L, "text/plain", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/msword", -1L, "text/html", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/msword", -1L, "text/xml", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", -1L, "application/pdf", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/pdf", -1L, "text/plain", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/pdf", -1L, "text/html", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/pdf", -1L, "text/xml", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("text/plain", -1L, "application/vnd.oasis.opendocument.presentation", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.oasis.opendocument.presentation", -1L, "text/plain", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.oasis.opendocument.presentation", -1L, "text/html", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertTrue((boolean)this.transformer.isTransformable("application/vnd.oasis.opendocument.presentation", -1L, "text/xml", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("image/jpeg", -1L, "text/plain", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("image/jpeg", -1L, "text/html", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("image/jpeg", -1L, "text/xml", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("audio/mpeg", -1L, "text/plain", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("audio/mpeg", -1L, "text/html", new TransformationOptions()));
        TikaAutoContentTransformerTest.assertFalse((boolean)this.transformer.isTransformable("audio/mpeg", -1L, "text/xml", new TransformationOptions()));
    }
}

