/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.copy;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2Association;
import org.alfresco.repo.dictionary.M2ChildAssociation;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyServiceImplTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private NodeService nodeService;
    private NodeService publicNodeService;
    private CopyService copyService;
    private DictionaryDAO dictionaryDAO;
    private ContentService contentService;
    private RuleService ruleService;
    private ActionService actionService;
    private PermissionService permissionService;
    private PersonService personService;
    private AuthenticationComponent authenticationComponent;
    private MutableAuthenticationService authenticationService;
    private CheckOutCheckInService cociService;
    private UserTransaction txn;
    private StoreRef storeRef;
    private NodeRef sourceNodeRef;
    private NodeRef rootNodeRef;
    private NodeRef targetNodeRef;
    private NodeRef nonPrimaryChildNodeRef;
    private NodeRef childNodeRef;
    private NodeRef destinationNodeRef;
    private static final String TEST_TYPE_NAMESPACE = "testTypeNamespaceURI";
    private static final QName TEST_TYPE_QNAME = QName.createQName((String)"testTypeNamespaceURI", (String)"testType");
    private static final QName PROP1_QNAME_MANDATORY = QName.createQName((String)"testTypeNamespaceURI", (String)"prop1Mandatory");
    private static final QName PROP2_QNAME_OPTIONAL = QName.createQName((String)"testTypeNamespaceURI", (String)"prop2Optional");
    private static final QName TEST_ASPECT_QNAME = QName.createQName((String)"testTypeNamespaceURI", (String)"testAspect");
    private static final QName PROP3_QNAME_MANDATORY = QName.createQName((String)"testTypeNamespaceURI", (String)"prop3Mandatory");
    private static final QName PROP4_QNAME_OPTIONAL = QName.createQName((String)"testTypeNamespaceURI", (String)"prop4Optional");
    private static final QName PROP_QNAME_MY_NODE_REF = QName.createQName((String)"testTypeNamespaceURI", (String)"myNodeRef");
    private static final QName PROP_QNAME_MY_ANY = QName.createQName((String)"testTypeNamespaceURI", (String)"myAny");
    private static final QName PROP_QNAME_RESIDUAL_NODE_REF = QName.createQName((String)"testTypeNamespaceURI", (String)"residualNodeRef");
    private static final QName PROP_QNAME_RESIDUAL_ANY = QName.createQName((String)"testTypeNamespaceURI", (String)"residualAny");
    private static final QName TEST_MANDATORY_ASPECT_QNAME = QName.createQName((String)"testTypeNamespaceURI", (String)"testMandatoryAspect");
    private static final QName PROP5_QNAME_MANDATORY = QName.createQName((String)"testTypeNamespaceURI", (String)"prop5Mandatory");
    private static final String TEST_NAME = "testName";
    private static final String TEST_VALUE_1 = "testValue1";
    private static final String TEST_VALUE_2 = "testValue2";
    private static final String TEST_VALUE_3 = "testValue3";
    private static final QName TEST_CHILD_ASSOC_TYPE_QNAME = QName.createQName((String)"testTypeNamespaceURI", (String)"contains");
    private static final QName TEST_CHILD_ASSOC_QNAME = QName.createQName((String)"testTypeNamespaceURI", (String)"testChildAssocName");
    private static final QName TEST_ASSOC_TYPE_QNAME = QName.createQName((String)"testTypeNamespaceURI", (String)"testAssocName");
    private static final QName TEST_CHILD_ASSOC_QNAME2 = QName.createQName((String)"testTypeNamespaceURI", (String)"testChildAssocName2");
    private static final ContentData CONTENT_DATA_TEXT = new ContentData(null, "text/plain", 0L, "UTF-8");
    private static final String USER_1 = "User1";
    private static final String USER_2 = "User2";
    private static final String SOME_CONTENT = "This is some content ...";

    protected void setUp() throws Exception {
        if (AlfrescoTransactionSupport.isActualTransactionActive()) {
            CopyServiceImplTest.fail((String)"Test started with transaction in progress");
        }
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.nodeService = (NodeService)ctx.getBean("dbNodeService");
        this.publicNodeService = serviceRegistry.getNodeService();
        this.copyService = (CopyService)ctx.getBean("copyService");
        this.contentService = (ContentService)ctx.getBean("contentService");
        this.ruleService = (RuleService)ctx.getBean("ruleService");
        this.actionService = (ActionService)ctx.getBean("actionService");
        this.permissionService = (PermissionService)ctx.getBean("PermissionService");
        this.personService = serviceRegistry.getPersonService();
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("authenticationService");
        this.cociService = (CheckOutCheckInService)ctx.getBean("checkOutCheckInService");
        this.dictionaryDAO = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.txn = this.transactionService.getUserTransaction();
        this.txn.begin();
        this.createTestModel();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}test"), TEST_TYPE_QNAME, this.createTypePropertyBag());
        this.sourceNodeRef = childAssocRef.getChildRef();
        HashMap<QName, String> aspectProperties = new HashMap<QName, String>();
        aspectProperties.put(PROP3_QNAME_MANDATORY, TEST_VALUE_1);
        aspectProperties.put(PROP4_QNAME_OPTIONAL, TEST_VALUE_2);
        this.nodeService.addAspect(this.sourceNodeRef, TEST_ASPECT_QNAME, aspectProperties);
        this.nodeService.addAspect(this.sourceNodeRef, ContentModel.ASPECT_TITLED, null);
        ChildAssociationRef temp3 = this.nodeService.createNode(this.sourceNodeRef, TEST_CHILD_ASSOC_TYPE_QNAME, TEST_CHILD_ASSOC_QNAME, TEST_TYPE_QNAME, this.createTypePropertyBag());
        this.childNodeRef = temp3.getChildRef();
        ChildAssociationRef temp2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testNonPrimaryChild"), TEST_TYPE_QNAME, this.createTypePropertyBag());
        this.nonPrimaryChildNodeRef = temp2.getChildRef();
        this.nodeService.addChild(this.sourceNodeRef, this.nonPrimaryChildNodeRef, TEST_CHILD_ASSOC_TYPE_QNAME, TEST_CHILD_ASSOC_QNAME2);
        ChildAssociationRef temp = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testAssoc"), TEST_TYPE_QNAME, this.createTypePropertyBag());
        this.targetNodeRef = temp.getChildRef();
        this.nodeService.createAssociation(this.sourceNodeRef, this.targetNodeRef, TEST_ASSOC_TYPE_QNAME);
        HashMap<QName, String> destinationProps = new HashMap<QName, String>();
        destinationProps.put(PROP1_QNAME_MANDATORY, TEST_VALUE_1);
        destinationProps.put(PROP5_QNAME_MANDATORY, TEST_VALUE_3);
        destinationProps.put(ContentModel.PROP_CONTENT, (String)CONTENT_DATA_TEXT);
        ChildAssociationRef temp5 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}testDestinationNode"), TEST_TYPE_QNAME, destinationProps);
        this.destinationNodeRef = temp5.getChildRef();
        this.authenticationService.createAuthentication(USER_1, "PWD".toCharArray());
        this.authenticationService.createAuthentication(USER_2, "PWD".toCharArray());
        PropertyMap personProperties = new PropertyMap();
        personProperties.put(ContentModel.PROP_USERNAME, USER_1);
        personProperties.put(ContentModel.PROP_AUTHORITY_DISPLAY_NAME, "titleUser1");
        personProperties.put(ContentModel.PROP_FIRSTNAME, "firstName");
        personProperties.put(ContentModel.PROP_LASTNAME, "lastName");
        personProperties.put(ContentModel.PROP_EMAIL, "User1@example.com");
        personProperties.put(ContentModel.PROP_JOBTITLE, "jobTitle");
        this.personService.createPerson(personProperties);
        personProperties = new PropertyMap();
        personProperties.put(ContentModel.PROP_USERNAME, USER_2);
        personProperties.put(ContentModel.PROP_AUTHORITY_DISPLAY_NAME, "titleUser2");
        personProperties.put(ContentModel.PROP_FIRSTNAME, "firstName");
        personProperties.put(ContentModel.PROP_LASTNAME, "lastName");
        personProperties.put(ContentModel.PROP_EMAIL, "User2@example.com");
        personProperties.put(ContentModel.PROP_JOBTITLE, "jobTitle");
        this.personService.createPerson(personProperties);
    }

    protected void tearDown() throws Exception {
        if (this.txn != null) {
            try {
                this.txn.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    private Map<QName, Serializable> createTypePropertyBag() {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>();
        result.put(ContentModel.PROP_NAME, (Serializable)((Object)TEST_NAME));
        result.put(PROP1_QNAME_MANDATORY, (Serializable)((Object)TEST_VALUE_1));
        result.put(PROP2_QNAME_OPTIONAL, (Serializable)((Object)TEST_VALUE_2));
        result.put(PROP5_QNAME_MANDATORY, (Serializable)((Object)TEST_VALUE_3));
        result.put(ContentModel.PROP_CONTENT, (Serializable)CONTENT_DATA_TEXT);
        return result;
    }

    private void createTestModel() {
        M2Model model = M2Model.createModel((String)"test:nodeoperations");
        model.createNamespace(TEST_TYPE_NAMESPACE, "test");
        model.createImport("http://www.alfresco.org/model/dictionary/1.0", "d");
        model.createImport("http://www.alfresco.org/model/system/1.0", "sys");
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        M2Type testType = model.createType("test:" + TEST_TYPE_QNAME.getLocalName());
        testType.setParentName("cm:" + ContentModel.TYPE_CONTENT.getLocalName());
        M2Property prop1 = testType.createProperty("test:" + PROP1_QNAME_MANDATORY.getLocalName());
        prop1.setMandatory(true);
        prop1.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop1.setMultiValued(false);
        M2Property prop2 = testType.createProperty("test:" + PROP2_QNAME_OPTIONAL.getLocalName());
        prop2.setMandatory(false);
        prop2.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop2.setMandatory(false);
        M2Property propNodeRef = testType.createProperty("test:" + PROP_QNAME_MY_NODE_REF.getLocalName());
        propNodeRef.setMandatory(false);
        propNodeRef.setType("d:" + DataTypeDefinition.NODE_REF.getLocalName());
        propNodeRef.setMandatory(false);
        M2Property propAnyNodeRef = testType.createProperty("test:" + PROP_QNAME_MY_ANY.getLocalName());
        propAnyNodeRef.setMandatory(false);
        propAnyNodeRef.setType("d:" + DataTypeDefinition.ANY.getLocalName());
        propAnyNodeRef.setMandatory(false);
        M2ChildAssociation childAssoc = testType.createChildAssociation("test:" + TEST_CHILD_ASSOC_TYPE_QNAME.getLocalName());
        childAssoc.setTargetClassName("sys:base");
        childAssoc.setTargetMandatory(false);
        M2Association assoc = testType.createAssociation("test:" + TEST_ASSOC_TYPE_QNAME.getLocalName());
        assoc.setTargetClassName("sys:base");
        assoc.setTargetMandatory(false);
        M2Aspect testAspect = model.createAspect("test:" + TEST_ASPECT_QNAME.getLocalName());
        M2Property prop3 = testAspect.createProperty("test:" + PROP3_QNAME_MANDATORY.getLocalName());
        prop3.setMandatory(true);
        prop3.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop3.setMultiValued(false);
        M2Property prop4 = testAspect.createProperty("test:" + PROP4_QNAME_OPTIONAL.getLocalName());
        prop4.setMandatory(false);
        prop4.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop4.setMultiValued(false);
        M2Aspect testMandatoryAspect = model.createAspect("test:" + TEST_MANDATORY_ASPECT_QNAME.getLocalName());
        M2Property prop5 = testMandatoryAspect.createProperty("test:" + PROP5_QNAME_MANDATORY.getLocalName());
        prop5.setType("d:" + DataTypeDefinition.TEXT.getLocalName());
        prop5.setMandatory(true);
        testType.addMandatoryAspect("test:" + TEST_MANDATORY_ASPECT_QNAME.getLocalName());
        this.dictionaryDAO.putModel(model);
    }

    public void testCopyToNewNodeWithPermissions() {
        this.permissionService.setPermission(this.sourceNodeRef, "Test", "ReadPermissions", true);
        this.permissionService.setPermission(this.rootNodeRef, AuthenticationUtil.getGuestUserName(), "Read", true);
        this.permissionService.setPermission(this.rootNodeRef, AuthenticationUtil.getGuestUserName(), "CreateChildren", true);
        CopyServiceImplTest.assertEquals((int)3, (int)this.permissionService.getAllSetPermissions(this.sourceNodeRef).size());
        NodeRef copy = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}aclCopyOne"));
        CopyServiceImplTest.assertEquals((int)3, (int)this.permissionService.getAllSetPermissions(copy).size());
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        copy = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}aclCopyTwo"));
        CopyServiceImplTest.assertEquals((int)3, (int)this.permissionService.getAllSetPermissions(copy).size());
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getGuestUserName());
        copy = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}aclCopyThree"));
        CopyServiceImplTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(copy).size());
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.permissionService.setPermission(this.sourceNodeRef, AuthenticationUtil.getGuestUserName(), "ReadPermissions", true);
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getGuestUserName());
        copy = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}aclCopyFour"));
        CopyServiceImplTest.assertEquals((int)4, (int)this.permissionService.getAllSetPermissions(copy).size());
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.permissionService.setPermission(this.rootNodeRef, AuthenticationUtil.getGuestUserName(), "ChangePermissions", true);
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getGuestUserName());
        copy = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}aclCopyFour"));
        CopyServiceImplTest.assertEquals((int)5, (int)this.permissionService.getAllSetPermissions(copy).size());
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.permissionService.setPermission(this.sourceNodeRef, AuthenticationUtil.getGuestUserName(), "ReadPermissions", false);
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getGuestUserName());
        copy = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}aclCopyFour"));
        CopyServiceImplTest.assertEquals((int)3, (int)this.permissionService.getAllSetPermissions(copy).size());
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        this.permissionService.deletePermission(this.sourceNodeRef, AuthenticationUtil.getGuestUserName(), "ReadPermissions");
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getGuestUserName());
        copy = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}aclCopyFour"));
        CopyServiceImplTest.assertEquals((int)3, (int)this.permissionService.getAllSetPermissions(copy).size());
    }

    public void testCopyToNewNode() {
        PagingRequest pageRequest = new PagingRequest(10);
        PagingResults<CopyService.CopyInfo> copies = null;
        copies = this.copyService.getCopies(this.sourceNodeRef, pageRequest);
        CopyServiceImplTest.assertEquals((String)"Incorrect number of copies", (int)0, (int)copies.getPage().size());
        NodeRef copy = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copyAssoc"));
        this.checkCopiedNode(this.sourceNodeRef, copy, true, true, false);
        copies = this.copyService.getCopies(this.sourceNodeRef, pageRequest);
        CopyServiceImplTest.assertEquals((String)"Incorrect number of copies", (int)1, (int)copies.getPage().size());
        NodeRef copy2 = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copyAssoc2"), true);
        this.checkCopiedNode(this.sourceNodeRef, copy2, true, true, true);
        copies = this.copyService.getCopies(this.sourceNodeRef, pageRequest);
        CopyServiceImplTest.assertEquals((String)"Incorrect number of copies", (int)2, (int)copies.getPage().size());
        NodeRef copyOfCopy = this.copyService.copy(copy, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copyOfCopy"));
        this.checkCopiedNode(copy, copyOfCopy, true, true, false);
        ContentWriter contentWriter = this.contentService.getWriter(this.sourceNodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.putContent(SOME_CONTENT);
        NodeRef copyWithContent = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copyWithContent"));
        this.checkCopiedNode(this.sourceNodeRef, copyWithContent, true, true, false);
        ContentReader contentReader = this.contentService.getReader(copyWithContent, ContentModel.PROP_CONTENT);
        CopyServiceImplTest.assertNotNull((Object)contentReader);
        CopyServiceImplTest.assertEquals((String)SOME_CONTENT, (String)contentReader.getContentString());
    }

    public void testCopiedFromAspect() {
        IntegrityChecker integrityChecker = (IntegrityChecker)ctx.getBean("integrityChecker");
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}test"), TEST_TYPE_QNAME, this.createTypePropertyBag());
        NodeRef nodeRef = childAssocRef.getChildRef();
        PagingRequest pageRequest = new PagingRequest(10);
        pageRequest.setRequestTotalCountMax(200);
        PagingResults<CopyService.CopyInfo> copies = null;
        NodeRef firstCopy = null;
        for (int i = 1; i <= 100; ++i) {
            NodeRef copyNodeRef = this.copyService.copy(nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copyAssoc"));
            if (firstCopy == null) {
                firstCopy = copyNodeRef;
            }
            copies = this.copyService.getCopies(nodeRef, pageRequest);
            CopyServiceImplTest.assertEquals((String)"Total count not correct", (Object)new Pair((Object)i, (Object)i), (Object)copies.getTotalResultCount());
            CopyServiceImplTest.assertEquals((String)"Incorrect number of copies", (int)(i > 10 ? 10 : i), (int)copies.getPage().size());
            boolean found = i > 10;
            for (CopyService.CopyInfo copy : copies.getPage()) {
                if (found) break;
                if (!copy.getNodeRef().equals((Object)copyNodeRef)) continue;
                found = true;
            }
            CopyServiceImplTest.assertTrue((String)"Did not find the copy in the list of copies.", (boolean)found);
            integrityChecker.checkIntegrity();
            copies = this.copyService.getCopies(nodeRef, this.rootNodeRef, pageRequest);
            CopyServiceImplTest.assertEquals((String)"Total count not correct", (Object)new Pair((Object)i, (Object)i), (Object)copies.getTotalResultCount());
            CopyServiceImplTest.assertEquals((String)"Incorrect number of copies", (int)(i > 10 ? 10 : i), (int)copies.getPage().size());
            NodeRef originalCheck = this.copyService.getOriginal(copyNodeRef);
            CopyServiceImplTest.assertEquals((String)"Original is not as expected. ", (Object)nodeRef, (Object)originalCheck);
            copies = this.copyService.getCopies(nodeRef, this.rootNodeRef, pageRequest);
            CopyServiceImplTest.assertEquals((String)"Total count not correct", (Object)new Pair((Object)i, (Object)i), (Object)copies.getTotalResultCount());
            CopyServiceImplTest.assertEquals((String)"Incorrect number of copies", (int)(i > 10 ? 10 : i), (int)copies.getPage().size());
            copies = this.copyService.getCopies(nodeRef, this.sourceNodeRef, pageRequest);
            CopyServiceImplTest.assertEquals((String)"Expected to find no copies", (int)0, (int)copies.getPage().size());
        }
        this.nodeService.deleteNode(nodeRef);
        integrityChecker.checkIntegrity();
        NodeRef originalCheck = this.copyService.getOriginal(firstCopy);
        CopyServiceImplTest.assertNull((String)"Original should not be present. ", (Object)originalCheck);
    }

    public void testCopiedFromAspect_NonObject() {
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}test"), ContentModel.TYPE_BASE, this.createTypePropertyBag());
        NodeRef nodeRef = childAssocRef.getChildRef();
        NodeRef copyNodeRef = this.copyService.copy(nodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copyAssoc"));
        CopyServiceImplTest.assertFalse((String)"cm:copiedfrom should not be present", (boolean)this.nodeService.hasAspect(copyNodeRef, ContentModel.ASPECT_COPIEDFROM));
    }

    public void testCopyNodeWithRules() {
        Rule rule = new Rule();
        rule.setRuleType("inbound");
        HashMap<String, Serializable> props = new HashMap<String, Serializable>(1);
        props.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
        Action action = this.actionService.createAction("add-features", props);
        rule.setAction(action);
        ActionCondition actionCondition = this.actionService.createActionCondition("no-condition");
        action.addActionCondition(actionCondition);
        this.ruleService.saveRule(this.sourceNodeRef, rule);
        CopyServiceImplTest.assertNotNull((Object)rule.getNodeRef());
        CopyServiceImplTest.assertEquals((Object)this.sourceNodeRef, (Object)this.ruleService.getOwningNodeRef(rule));
        NodeRef copy = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}withRulesCopy"), true);
        this.checkCopiedNode(this.sourceNodeRef, copy, true, true, true);
        CopyServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(copy, RuleModel.ASPECT_RULES));
        CopyServiceImplTest.assertTrue((boolean)this.ruleService.hasRules(copy));
        CopyServiceImplTest.assertTrue((boolean)this.ruleService.rulesEnabled(copy));
        List<Rule> copiedRules = this.ruleService.getRules(copy);
        CopyServiceImplTest.assertEquals((int)1, (int)copiedRules.size());
        Rule copiedRule = copiedRules.get(0);
        CopyServiceImplTest.assertNotNull((Object)copiedRule.getNodeRef());
        CopyServiceImplTest.assertFalse((boolean)copiedRule.getNodeRef().equals((Object)rule.getNodeRef()));
        CopyServiceImplTest.assertEquals((String)rule.getTitle(), (String)copiedRule.getTitle());
        CopyServiceImplTest.assertEquals((String)rule.getDescription(), (String)copiedRule.getDescription());
        CopyServiceImplTest.assertEquals((Object)copy, (Object)this.ruleService.getOwningNodeRef(copiedRule));
        CopyServiceImplTest.assertEquals((String)rule.getAction().getActionDefinitionName(), (String)copiedRule.getAction().getActionDefinitionName());
        NodeRef copy2 = this.copyService.copy(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}withRuleCopyNoChildren"), false);
        this.checkCopiedNode(this.sourceNodeRef, copy2, true, true, false);
        CopyServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(copy2, RuleModel.ASPECT_RULES));
        CopyServiceImplTest.assertTrue((boolean)this.ruleService.hasRules(copy2));
        CopyServiceImplTest.assertTrue((boolean)this.ruleService.rulesEnabled(copy2));
        List<Rule> copiedRules2 = this.ruleService.getRules(copy2);
        CopyServiceImplTest.assertEquals((int)1, (int)copiedRules.size());
        Rule copiedRule2 = copiedRules2.get(0);
        CopyServiceImplTest.assertFalse((boolean)rule.getNodeRef().equals((Object)copiedRule2.getNodeRef()));
        CopyServiceImplTest.assertEquals((String)rule.getTitle(), (String)copiedRule2.getTitle());
        CopyServiceImplTest.assertEquals((String)rule.getDescription(), (String)copiedRule2.getDescription());
        CopyServiceImplTest.assertEquals((Object)this.ruleService.getOwningNodeRef(copiedRule2), (Object)copy2);
        CopyServiceImplTest.assertEquals((String)rule.getAction().getActionDefinitionName(), (String)copiedRule2.getAction().getActionDefinitionName());
    }

    public void testCopyToExistingNode() {
        this.copyService.copy(this.sourceNodeRef, this.destinationNodeRef);
        this.checkCopiedNode(this.sourceNodeRef, this.destinationNodeRef, false, true, true);
    }

    public void testRecursiveCopy() {
        PropertyMap props = new PropertyMap();
        props.put(ContentModel.PROP_NODE_UUID, "nodeOne");
        NodeRef nodeOne = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER, (Map)props).getChildRef();
        props.put(ContentModel.PROP_NODE_UUID, "nodeTwo");
        NodeRef nodeTwo = this.nodeService.createNode(nodeOne, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER, (Map)props).getChildRef();
        props.put(ContentModel.PROP_NODE_UUID, "nodeThree");
        NodeRef nodeThree = this.nodeService.createNode(nodeTwo, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER, (Map)props).getChildRef();
        this.copyService.copy(nodeOne, nodeThree, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, true);
    }

    public void testALF11964_part1() {
        IntegrityChecker integrityChecker = (IntegrityChecker)ctx.getBean("integrityChecker");
        PropertyMap props = new PropertyMap();
        props.put(ContentModel.PROP_NODE_UUID, "nodeOne");
        NodeRef nodeOne = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER, (Map)props).getChildRef();
        props.put(ContentModel.PROP_NODE_UUID, "nodeTwo");
        NodeRef nodeTwo = this.nodeService.createNode(nodeOne, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, (Map)props).getChildRef();
        props.put(ContentModel.PROP_NODE_UUID, "nodeThree");
        NodeRef nodeThree = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER, (Map)props).getChildRef();
        this.copyService.copy(nodeTwo, nodeOne, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, true);
        this.copyService.copy(nodeOne, nodeThree, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, true);
        integrityChecker.checkIntegrity();
    }

    public void testALF11964_part2() {
        IntegrityChecker integrityChecker = (IntegrityChecker)ctx.getBean("integrityChecker");
        PropertyMap props = new PropertyMap();
        props.put(ContentModel.PROP_NODE_UUID, "nodeOne");
        NodeRef nodeOne = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER, (Map)props).getChildRef();
        props.put(ContentModel.PROP_NODE_UUID, "nodeTwo");
        NodeRef nodeTwo = this.nodeService.createNode(nodeOne, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, (Map)props).getChildRef();
        props.put(ContentModel.PROP_NODE_UUID, "nodeThree");
        NodeRef nodeThree = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTAINER, (Map)props).getChildRef();
        this.cociService.checkout(nodeTwo);
        this.copyService.copy(nodeOne, nodeThree, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, true);
        integrityChecker.checkIntegrity();
    }

    public void testCopyResidualProperties() throws Exception {
        QName nodeOneAssocName = QName.createQName((String)"{test}nodeOne");
        NodeRef nodeOne = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, nodeOneAssocName, TEST_TYPE_QNAME).getChildRef();
        this.nodeService.setProperty(nodeOne, PROP_QNAME_RESIDUAL_NODE_REF, (Serializable)nodeOne);
        this.nodeService.setProperty(nodeOne, PROP_QNAME_RESIDUAL_ANY, (Serializable)nodeOne);
        NodeRef nodeOneCopy = this.copyService.copy(nodeOne, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copiedNodeOne"));
        Serializable propNodeRef = this.nodeService.getProperty(nodeOneCopy, PROP_QNAME_RESIDUAL_NODE_REF);
        CopyServiceImplTest.assertEquals((String)"Residual d:noderef not copied", (Object)nodeOne, (Object)propNodeRef);
        Serializable propAny = this.nodeService.getProperty(nodeOneCopy, PROP_QNAME_RESIDUAL_ANY);
        CopyServiceImplTest.assertEquals((String)"Residual d:any not copied", (Object)nodeOne, (Object)propAny);
    }

    public void testRelativeLinks() {
        QName nodeOneAssocName = QName.createQName((String)"{test}nodeOne");
        QName nodeTwoAssocName = QName.createQName((String)"{test}nodeTwo");
        QName nodeThreeAssocName = QName.createQName((String)"{test}nodeThree");
        QName nodeFourAssocName = QName.createQName((String)"{test}nodeFour");
        NodeRef nodeNotCopied = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, nodeOneAssocName, TEST_TYPE_QNAME).getChildRef();
        NodeRef nodeOne = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, nodeOneAssocName, TEST_TYPE_QNAME).getChildRef();
        NodeRef nodeTwo = this.nodeService.createNode(nodeOne, TEST_CHILD_ASSOC_TYPE_QNAME, nodeTwoAssocName, TEST_TYPE_QNAME).getChildRef();
        NodeRef nodeThree = this.nodeService.createNode(nodeTwo, TEST_CHILD_ASSOC_TYPE_QNAME, nodeThreeAssocName, TEST_TYPE_QNAME).getChildRef();
        NodeRef nodeFour = this.nodeService.createNode(nodeOne, TEST_CHILD_ASSOC_TYPE_QNAME, nodeFourAssocName, TEST_TYPE_QNAME).getChildRef();
        this.nodeService.addChild(nodeFour, nodeThree, TEST_CHILD_ASSOC_TYPE_QNAME, TEST_CHILD_ASSOC_QNAME);
        this.nodeService.createAssociation(nodeTwo, nodeThree, TEST_ASSOC_TYPE_QNAME);
        this.nodeService.createAssociation(nodeTwo, nodeNotCopied, TEST_ASSOC_TYPE_QNAME);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(1);
        params.put("destination-folder", (Serializable)nodeTwo);
        Rule rule = new Rule();
        rule.setRuleType("inbound");
        Action action = this.actionService.createAction("copy", params);
        ActionCondition condition = this.actionService.createActionCondition("no-condition");
        action.addActionCondition(condition);
        rule.setAction(action);
        this.ruleService.saveRule(nodeOne, rule);
        NodeRef nodeOneCopy = this.copyService.copy(nodeOne, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copiedNodeOne"), true);
        NodeRef nodeTwoCopy = null;
        NodeRef nodeThreeCopy = null;
        NodeRef nodeFourCopy = null;
        List nodeOneCopyChildren = this.nodeService.getChildAssocs(nodeOneCopy);
        CopyServiceImplTest.assertNotNull((Object)nodeOneCopyChildren);
        CopyServiceImplTest.assertEquals((int)3, (int)nodeOneCopyChildren.size());
        for (ChildAssociationRef nodeOneCopyChild : nodeOneCopyChildren) {
            if (nodeOneCopyChild.getQName().equals((Object)nodeTwoAssocName)) {
                nodeTwoCopy = nodeOneCopyChild.getChildRef();
                List nodeTwoCopyChildren = this.nodeService.getChildAssocs(nodeTwoCopy);
                CopyServiceImplTest.assertNotNull((Object)nodeTwoCopyChildren);
                CopyServiceImplTest.assertEquals((int)1, (int)nodeTwoCopyChildren.size());
                for (ChildAssociationRef nodeTwoCopyChild : nodeTwoCopyChildren) {
                    if (!nodeTwoCopyChild.getQName().equals((Object)nodeThreeAssocName)) continue;
                    nodeThreeCopy = nodeTwoCopyChild.getChildRef();
                }
                continue;
            }
            if (!nodeOneCopyChild.getQName().equals((Object)nodeFourAssocName)) continue;
            nodeFourCopy = nodeOneCopyChild.getChildRef();
        }
        CopyServiceImplTest.assertNotNull(nodeTwoCopy);
        CopyServiceImplTest.assertNotNull(nodeThreeCopy);
        CopyServiceImplTest.assertNotNull(nodeFourCopy);
        List children = this.nodeService.getChildAssocs(nodeFourCopy, RegexQNamePattern.MATCH_ALL, (QNamePattern)TEST_CHILD_ASSOC_QNAME);
        CopyServiceImplTest.assertNotNull((Object)children);
        CopyServiceImplTest.assertEquals((int)1, (int)children.size());
        ChildAssociationRef child = (ChildAssociationRef)children.get(0);
        CopyServiceImplTest.assertEquals((Object)child.getChildRef(), (Object)nodeThree);
        List assocs = this.nodeService.getTargetAssocs(nodeTwoCopy, (QNamePattern)TEST_ASSOC_TYPE_QNAME);
        CopyServiceImplTest.assertNotNull((Object)assocs);
        CopyServiceImplTest.assertEquals((int)2, (int)assocs.size());
        AssociationRef assoc0 = (AssociationRef)assocs.get(0);
        CopyServiceImplTest.assertTrue((assoc0.getTargetRef().equals((Object)nodeThreeCopy) || assoc0.getTargetRef().equals((Object)nodeNotCopied) ? 1 : 0) != 0);
        AssociationRef assoc1 = (AssociationRef)assocs.get(1);
        CopyServiceImplTest.assertTrue((assoc1.getTargetRef().equals((Object)nodeThreeCopy) || assoc1.getTargetRef().equals((Object)nodeNotCopied) ? 1 : 0) != 0);
        List<Rule> rules = this.ruleService.getRules(nodeOneCopy);
        CopyServiceImplTest.assertNotNull(rules);
        CopyServiceImplTest.assertEquals((int)1, (int)rules.size());
        Rule copiedRule = rules.get(0);
        CopyServiceImplTest.assertNotNull((Object)copiedRule);
        Action ruleAction = copiedRule.getAction();
        CopyServiceImplTest.assertNotNull((Object)ruleAction);
        NodeRef value = (NodeRef)ruleAction.getParameterValue("destination-folder");
        CopyServiceImplTest.assertNotNull((Object)value);
        CopyServiceImplTest.assertEquals((Object)nodeTwoCopy, (Object)value);
    }

    public void testCopyAndRename() {
        NodeRef copy = this.copyService.copyAndRename(this.sourceNodeRef, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}copyAssoc"), false);
        this.checkCopiedNode(this.sourceNodeRef, copy, true, true, false);
        CopyServiceImplTest.assertTrue((boolean)TEST_NAME.equals(this.nodeService.getProperty(copy, ContentModel.PROP_NAME)));
        HashMap<QName, String> propsFolder = new HashMap<QName, String>(1);
        propsFolder.put(ContentModel.PROP_NAME, "tempFolder");
        NodeRef folderNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{test}tempFolder"), ContentModel.TYPE_FOLDER, propsFolder).getChildRef();
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, TEST_NAME);
        NodeRef contentNode = this.nodeService.createNode(folderNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}renametest"), ContentModel.TYPE_CONTENT, props).getChildRef();
        NodeRef contentCopy = this.copyService.copy(contentNode, folderNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}bobbins"), false);
        CopyServiceImplTest.assertFalse((boolean)TEST_NAME.equals(this.nodeService.getProperty(contentCopy, ContentModel.PROP_NAME)));
    }

    public void testETWOONE_244() {
        HashMap<QName, String> propsFolder = new HashMap<QName, String>(1);
        propsFolder.put(ContentModel.PROP_NAME, "tempFolder");
        NodeRef folderNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"tempFolder"), ContentModel.TYPE_FOLDER, propsFolder).getChildRef();
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, "myDoc.txt");
        NodeRef contentNode = this.nodeService.createNode(folderNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"myDoc.txt"), ContentModel.TYPE_CONTENT, props).getChildRef();
        NodeRef copy = this.copyService.copyAndRename(contentNode, folderNode, ContentModel.ASSOC_CONTAINS, null, false);
        CopyServiceImplTest.assertEquals((Object)"Copy of myDoc.txt", (Object)this.nodeService.getProperty(copy, ContentModel.PROP_NAME));
        QName copyQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Copy of myDoc.txt");
        CopyServiceImplTest.assertEquals((Object)copyQName, (Object)this.nodeService.getPrimaryParent(copy).getQName());
        copy = this.copyService.copyAndRename(contentNode, folderNode, ContentModel.ASSOC_CONTAINS, null, false);
        CopyServiceImplTest.assertEquals((Object)"Copy of Copy of myDoc.txt", (Object)this.nodeService.getProperty(copy, ContentModel.PROP_NAME));
        copyQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Copy of Copy of myDoc.txt");
        CopyServiceImplTest.assertEquals((Object)copyQName, (Object)this.nodeService.getPrimaryParent(copy).getQName());
        copy = this.copyService.copyAndRename(contentNode, folderNode, ContentModel.ASSOC_CONTAINS, null, false);
        CopyServiceImplTest.assertEquals((Object)"Copy of Copy of Copy of myDoc.txt", (Object)this.nodeService.getProperty(copy, ContentModel.PROP_NAME));
        copyQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Copy of Copy of Copy of myDoc.txt");
        CopyServiceImplTest.assertEquals((Object)copyQName, (Object)this.nodeService.getPrimaryParent(copy).getQName());
    }

    public void testCopyMLText() {
        HashMap<QName, String> propsFolder = new HashMap<QName, String>(1);
        propsFolder.put(ContentModel.PROP_NAME, "tempFolder");
        NodeRef folderNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"tempFolder"), ContentModel.TYPE_FOLDER, propsFolder).getChildRef();
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, "myDoc.txt");
        String FRENCH_DESCRIPTION = "french description";
        String GERMAN_DESCRIPTION = "german description";
        String ITALY_DESCRIPTION = "italy description";
        String DEFAULT_DESCRIPTION = "default description";
        MLText description = new MLText();
        description.addValue(Locale.getDefault(), DEFAULT_DESCRIPTION);
        description.addValue(Locale.FRANCE, FRENCH_DESCRIPTION);
        description.addValue(Locale.GERMAN, GERMAN_DESCRIPTION);
        description.addValue(Locale.ITALY, ITALY_DESCRIPTION);
        props.put(ContentModel.PROP_DESCRIPTION, (String)description);
        NodeRef contentNode = this.nodeService.createNode(folderNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"myDoc.txt"), ContentModel.TYPE_CONTENT, props).getChildRef();
        NodeRef copy = this.copyService.copyAndRename(contentNode, folderNode, ContentModel.ASSOC_CONTAINS, null, false);
        CopyServiceImplTest.assertEquals((Object)"Copy of myDoc.txt", (Object)this.nodeService.getProperty(copy, ContentModel.PROP_NAME));
        QName copyQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"Copy of myDoc.txt");
        CopyServiceImplTest.assertEquals((Object)copyQName, (Object)this.nodeService.getPrimaryParent(copy).getQName());
        Serializable desc = this.nodeService.getProperty(copy, ContentModel.PROP_DESCRIPTION);
        if (desc instanceof MLText) {
            MLText value = (MLText)desc;
            CopyServiceImplTest.assertEquals((String)"French description is wrong", (String)FRENCH_DESCRIPTION, (String)((String)value.get((Object)Locale.FRANCE)));
            CopyServiceImplTest.assertEquals((String)"German description is wrong", (String)GERMAN_DESCRIPTION, (String)((String)value.get((Object)Locale.GERMAN)));
        } else {
            I18NUtil.setLocale((Locale)Locale.FRANCE);
            CopyServiceImplTest.assertEquals((String)"French description is wrong", (Object)FRENCH_DESCRIPTION, (Object)this.nodeService.getProperty(copy, ContentModel.PROP_DESCRIPTION));
            I18NUtil.setLocale((Locale)Locale.GERMAN);
            CopyServiceImplTest.assertEquals((String)"German description is wrong", (Object)GERMAN_DESCRIPTION, (Object)this.nodeService.getProperty(copy, ContentModel.PROP_DESCRIPTION));
        }
    }

    public void testCopyUserPermissions() throws Exception {
        String nodeTitle = "Test Title String";
        this.permissionService.setPermission(this.sourceNodeRef, USER_1, "Editor", true);
        this.permissionService.setPermission(this.targetNodeRef, USER_1, "Contributor", true);
        this.permissionService.setPermission(this.targetNodeRef, USER_2, "Contributor", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_1);
        NodeRef toCopy = this.nodeService.createNode(this.sourceNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"content"), ContentModel.TYPE_CONTENT).getChildRef();
        this.nodeService.setProperty(toCopy, ContentModel.PROP_TITLE, (Serializable)((Object)nodeTitle));
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_2);
        try {
            this.copyService.copy(toCopy, this.targetNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"NewCopy"));
        }
        catch (AccessDeniedException e) {
            // empty catch block
        }
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.permissionService.setPermission(this.sourceNodeRef, USER_2, "Contributor", true);
        this.permissionService.setPermission(this.targetNodeRef, USER_2, "Contributor", false);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_2);
        try {
            this.copyService.copy(toCopy, this.targetNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"NewCopy"));
        }
        catch (AccessDeniedException e) {
            // empty catch block
        }
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.permissionService.setPermission(this.targetNodeRef, USER_2, "Contributor", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_2);
        NodeRef copied = this.copyService.copy(toCopy, this.targetNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"NewCopy"));
        CopyServiceImplTest.assertEquals((boolean)true, (boolean)this.nodeService.exists(copied));
        CopyServiceImplTest.assertEquals((String)nodeTitle, (String)((MLText)this.nodeService.getProperty(copied, ContentModel.PROP_TITLE)).getDefaultValue());
        CopyServiceImplTest.assertEquals((Object)USER_1, (Object)this.nodeService.getProperty(toCopy, ContentModel.PROP_CREATOR));
        CopyServiceImplTest.assertEquals((Object)USER_1, (Object)this.nodeService.getProperty(toCopy, ContentModel.PROP_MODIFIER));
        CopyServiceImplTest.assertEquals((Object)USER_2, (Object)this.nodeService.getProperty(copied, ContentModel.PROP_CREATOR));
        CopyServiceImplTest.assertEquals((Object)USER_2, (Object)this.nodeService.getProperty(copied, ContentModel.PROP_MODIFIER));
        Set perms = this.permissionService.getAllSetPermissions(toCopy);
        boolean done1 = false;
        boolean done2 = false;
        for (AccessPermission perm : perms) {
            if (perm.getAuthority().equals(USER_1)) {
                done1 = true;
                CopyServiceImplTest.assertEquals((String)"Editor", (String)perm.getPermission());
            }
            if (!perm.getAuthority().equals(USER_2)) continue;
            done2 = true;
            CopyServiceImplTest.assertEquals((String)"Contributor", (String)perm.getPermission());
        }
        CopyServiceImplTest.assertEquals((boolean)true, (boolean)done1);
        CopyServiceImplTest.assertEquals((boolean)true, (boolean)done2);
        perms = this.permissionService.getAllSetPermissions(copied);
        done1 = false;
        done2 = false;
        for (AccessPermission perm : perms) {
            if (perm.getAuthority().equals(USER_1)) {
                done1 = true;
                CopyServiceImplTest.assertEquals((String)"Contributor", (String)perm.getPermission());
            }
            if (!perm.getAuthority().equals(USER_2)) continue;
            done2 = true;
            CopyServiceImplTest.assertEquals((String)"Contributor", (String)perm.getPermission());
        }
        CopyServiceImplTest.assertEquals((boolean)true, (boolean)done1);
        CopyServiceImplTest.assertEquals((boolean)true, (boolean)done2);
        String titleToFailToSet = "Set Title";
        String description = "Set Description";
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_1);
        try {
            this.publicNodeService.setProperty(copied, ContentModel.PROP_TITLE, (Serializable)((Object)titleToFailToSet));
            CopyServiceImplTest.fail((String)"User 1 should no longer have write permissions");
        }
        catch (AccessDeniedException e) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_2);
        this.publicNodeService.setProperty(copied, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)description));
        CopyServiceImplTest.assertEquals((String)nodeTitle, (String)((MLText)this.nodeService.getProperty(copied, ContentModel.PROP_TITLE)).getDefaultValue());
        CopyServiceImplTest.assertEquals((String)description, (String)((MLText)this.nodeService.getProperty(copied, ContentModel.PROP_DESCRIPTION)).getDefaultValue());
    }

    private void checkCopiedNode(NodeRef sourceNodeRef, NodeRef destinationNodeRef, boolean newCopy, boolean sameStore, boolean copyChildren) {
        int expectedSize;
        if (newCopy) {
            if (sameStore) {
                boolean hasCopyAspect = this.nodeService.hasAspect(destinationNodeRef, ContentModel.ASPECT_COPIEDFROM);
                CopyServiceImplTest.assertTrue((String)("Missing aspect: " + ContentModel.ASPECT_COPIEDFROM), (boolean)hasCopyAspect);
                List assocs = this.nodeService.getTargetAssocs(destinationNodeRef, (QNamePattern)ContentModel.ASSOC_ORIGINAL);
                CopyServiceImplTest.assertEquals((String)"Expectd exactly one reference back to original", (int)1, (int)assocs.size());
                NodeRef checkSourceNodeRef = ((AssociationRef)assocs.get(0)).getTargetRef();
                CopyServiceImplTest.assertEquals((String)"Copy refers to incorrect original source", (Object)sourceNodeRef, (Object)checkSourceNodeRef);
            } else {
                CopyServiceImplTest.assertEquals((String)sourceNodeRef.getId(), (String)destinationNodeRef.getId());
            }
        }
        boolean hasTestAspect = this.nodeService.hasAspect(destinationNodeRef, TEST_ASPECT_QNAME);
        CopyServiceImplTest.assertTrue((boolean)hasTestAspect);
        Map destinationProperties = this.nodeService.getProperties(destinationNodeRef);
        CopyServiceImplTest.assertNotNull((Object)destinationProperties);
        String value1 = (String)destinationProperties.get(PROP1_QNAME_MANDATORY);
        CopyServiceImplTest.assertNotNull((Object)value1);
        CopyServiceImplTest.assertEquals((String)TEST_VALUE_1, (String)value1);
        String value2 = (String)destinationProperties.get(PROP2_QNAME_OPTIONAL);
        CopyServiceImplTest.assertNotNull((Object)value2);
        CopyServiceImplTest.assertEquals((String)TEST_VALUE_2, (String)value2);
        String value3 = (String)destinationProperties.get(PROP3_QNAME_MANDATORY);
        CopyServiceImplTest.assertNotNull((Object)value3);
        CopyServiceImplTest.assertEquals((String)TEST_VALUE_1, (String)value3);
        String value4 = (String)destinationProperties.get(PROP4_QNAME_OPTIONAL);
        CopyServiceImplTest.assertNotNull((Object)value4);
        CopyServiceImplTest.assertEquals((String)TEST_VALUE_2, (String)value4);
        List destinationTargets = this.nodeService.getTargetAssocs(destinationNodeRef, (QNamePattern)TEST_ASSOC_TYPE_QNAME);
        CopyServiceImplTest.assertNotNull((Object)destinationTargets);
        CopyServiceImplTest.assertEquals((int)1, (int)destinationTargets.size());
        AssociationRef nodeAssocRef = (AssociationRef)destinationTargets.get(0);
        CopyServiceImplTest.assertNotNull((Object)nodeAssocRef);
        CopyServiceImplTest.assertEquals((Object)this.targetNodeRef, (Object)nodeAssocRef.getTargetRef());
        List childAssocRefs = this.nodeService.getChildAssocs(destinationNodeRef);
        CopyServiceImplTest.assertNotNull((Object)childAssocRefs);
        int n = expectedSize = copyChildren ? 2 : 0;
        if (this.nodeService.hasAspect(destinationNodeRef, RuleModel.ASPECT_RULES)) {
            ++expectedSize;
        }
        CopyServiceImplTest.assertEquals((int)expectedSize, (int)childAssocRefs.size());
        for (ChildAssociationRef ref : childAssocRefs) {
            if (ref.getQName().equals((Object)TEST_CHILD_ASSOC_QNAME2)) {
                CopyServiceImplTest.assertFalse((boolean)ref.isPrimary());
                CopyServiceImplTest.assertEquals((Object)this.nonPrimaryChildNodeRef, (Object)ref.getChildRef());
                continue;
            }
            if (!copyChildren) {
                if (ref.getTypeQName().equals((Object)RuleModel.ASSOC_RULE_FOLDER)) {
                    CopyServiceImplTest.assertTrue((boolean)ref.isPrimary());
                    CopyServiceImplTest.assertTrue((!this.childNodeRef.equals((Object)ref.getChildRef()) ? 1 : 0) != 0);
                    continue;
                }
                CopyServiceImplTest.assertFalse((boolean)ref.isPrimary());
                CopyServiceImplTest.assertEquals((Object)this.childNodeRef, (Object)ref.getChildRef());
                continue;
            }
            CopyServiceImplTest.assertTrue((boolean)ref.isPrimary());
            CopyServiceImplTest.assertTrue((!this.childNodeRef.equals((Object)ref.getChildRef()) ? 1 : 0) != 0);
        }
    }
}

